/*
 * Decompiled with CFR 0.152.
 */
package dswork.http;

import dswork.http.Cookie;
import dswork.http.HttpCommon;
import dswork.http.NameFile;
import dswork.http.NameValue;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpUtil {
    private static String boundaryContentType = "multipart/form-data; boundary=----WebKitFormBoundaryForDsworkAbcdefg";
    private SSLContext sslContext;
    private HttpURLConnection http = null;
    private boolean connectd = false;
    private Map<String, List<String>> headerMap = new LinkedHashMap<String, List<String>>();
    private int connectTimeout = 10000;
    private String contentType = null;
    private int readTimeout = 30000;
    private int responseCode = 0;
    private String requestMethod = null;
    private String url = "";
    private boolean useCaches = false;
    private String userAgent = "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0";
    private boolean isHostnameVerifier = true;
    private byte[] databody = null;
    private List<NameValue> form = new ArrayList<NameValue>();
    private boolean formdata = false;
    private List<Cookie> cookies = new ArrayList<Cookie>();

    public HttpUtil setConnectTimeout(int n) {
        this.connectTimeout = n;
        return this;
    }

    public HttpUtil setContentType(String string) {
        this.contentType = string;
        return this;
    }

    public HttpUtil setReadTimeout(int n) {
        this.readTimeout = n;
        return this;
    }

    public HttpUtil setRequestMethod(String string) {
        this.requestMethod = string.toUpperCase(Locale.ENGLISH);
        return this;
    }

    public HttpUtil setHeader(String string, String string2) {
        try {
            if ("Content-Type".equalsIgnoreCase(string)) {
                this.setContentType(string2);
            } else if (string2 == null) {
                this.headerMap.remove(string);
            } else {
                List<String> list = this.headerMap.get(string);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.headerMap.put(string, list);
                }
                list.clear();
                list.add(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Deprecated
    public HttpUtil setRequestProperty(String string, String string2) {
        return this.setHeader(string, string2);
    }

    public HttpUtil addHeader(String string, String string2) {
        try {
            if ("Content-Type".equalsIgnoreCase(string)) {
                this.setContentType(string2);
            } else if (string2 != null) {
                List<String> list = this.headerMap.get(string);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.headerMap.put(string, list);
                }
                list.add(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Deprecated
    public HttpUtil addRequestProperty(String string, String string2) {
        return this.addHeader(string, string2);
    }

    public String getHeader(String string) {
        return this.connectd ? this.http.getHeaderField(string) : null;
    }

    @Deprecated
    public String getHeaderField(String string) {
        return this.connectd ? this.http.getHeaderField(string) : null;
    }

    public List<String> getHeaders(String string) {
        return this.connectd ? this.http.getHeaderFields().get(string) : null;
    }

    public Map<String, List<String>> getHeaders() {
        return this.connectd ? this.http.getHeaderFields() : null;
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.getHeaders();
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public HttpUtil setSslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
        return this;
    }

    public void initSslContextForSSL() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, HttpCommon.getTrustManager(), null);
            this.sslContext = sSLContext;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initSslContextForTLS() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, HttpCommon.getTrustManager(), null);
            this.sslContext = sSLContext;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HttpUtil setUseCaches(boolean bl) {
        this.useCaches = bl;
        return this;
    }

    public HttpUtil setUserAgent(String string) {
        this.userAgent = string;
        return this;
    }

    public HttpUtil create(String string) {
        return this.create(string, true);
    }

    public HttpUtil create(String string, boolean bl) {
        this.connectClose();
        this.url = string;
        this.connectd = false;
        this.clearForm();
        this.responseCode = 0;
        this.requestMethod = null;
        this.headerMap.clear();
        this.isHostnameVerifier = bl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectDoing(String string) throws IOException {
        Object object;
        Object object2;
        this.connectd = true;
        boolean bl = false;
        try {
            URL uRL = new URL(this.url);
            bl = uRL.getProtocol().toLowerCase().equals("https");
            this.http = (HttpURLConnection)uRL.openConnection();
            if (bl) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.http;
                if (this.sslContext != null) {
                    httpsURLConnection.setSSLSocketFactory(this.sslContext.getSocketFactory());
                }
                if (this.isHostnameVerifier) {
                    httpsURLConnection.setHostnameVerifier(HttpCommon.HV);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.http.setDoInput(true);
        this.http.setUseCaches(this.useCaches);
        this.http.setConnectTimeout(this.connectTimeout);
        this.http.setReadTimeout(this.readTimeout);
        this.http.setRequestProperty("User-Agent", this.userAgent);
        this.http.setRequestProperty("Accept-Charset", "utf-8");
        this.http.setRequestMethod(this.requestMethod == null ? "GET" : this.requestMethod);
        for (String object32 : this.headerMap.keySet()) {
            object2 = this.headerMap.get(object32);
            this.http.setRequestProperty(object32, object2.get(0));
            int n = object2.size();
            if (n <= 1) continue;
            for (int i = 1; i < n; ++i) {
                this.http.addRequestProperty(object32, object2.get(i));
            }
        }
        if (this.cookies.size() > 0) {
            object = HttpCommon.parse(HttpCommon.getHttpCookies(this.cookies, bl), "; ");
            this.http.setRequestProperty("Cookie", (String)object);
        }
        object = null;
        if (this.form.size() > 0) {
            if (this.formdata) {
                this.contentType = boundaryContentType;
                object = HttpCommon.formatFormdata(this.form, string);
            } else {
                String string2 = HttpCommon.format(this.form, string);
                object = string2.getBytes("ISO-8859-1");
            }
        } else if (this.databody != null) {
            object = this.databody;
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            }
        }
        List<String> list = this.http.getRequestProperties().get("Content-Type");
        if (list != null && list.size() > 0) {
            if (!list.contains(this.contentType)) {
                this.http.addRequestProperty("Content-Type", this.contentType);
            }
        } else {
            this.http.setRequestProperty("Content-Type", this.contentType != null ? this.contentType : "application/x-www-form-urlencoded");
        }
        if (object != null) {
            this.http.setDoOutput(true);
            if (this.http.getRequestMethod().toUpperCase().equals("GET")) {
                this.http.setRequestMethod("POST");
            }
            object2 = null;
            FilterOutputStream filterOutputStream = null;
            try {
                object2 = this.http.getOutputStream();
                filterOutputStream = new DataOutputStream((OutputStream)object2);
                ((DataOutputStream)filterOutputStream).write((byte[])object, 0, ((Object)object).length);
                ((DataOutputStream)filterOutputStream).flush();
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (object2 != null) {
                    try {
                        ((OutputStream)object2).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.responseCode = 0;
        this.http.connect();
        this.responseCode = this.http.getResponseCode();
    }

    private InputStream connectAfter() throws IOException {
        Date date = new Date();
        List<Cookie> list = HttpCommon.getHttpCookies(this.http);
        for (Cookie cookie : list) {
            if (cookie.getExpiryDate() == null) {
                this.addCookie(cookie.getName(), cookie.getValue());
                continue;
            }
            if (cookie.isExpired(date)) continue;
            this.addCookie(cookie.getName(), cookie.getValue());
        }
        String string = this.http.getContentEncoding();
        if ("gzip".equals(string)) {
            return new GZIPInputStream(this.http.getInputStream());
        }
        return this.http.getInputStream();
    }

    public void connectClose() {
        try {
            if (this.connectd && this.http != null) {
                this.http.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String connect() {
        return this.connect("UTF-8", "UTF-8");
    }

    public String connect(String string) {
        return this.connect(string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connect(String string, String string2) {
        String string3 = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string4;
            this.connectDoing(string);
            inputStream = this.connectAfter();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
            StringBuilder stringBuilder = new StringBuilder(256);
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string4);
            }
            string3 = stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        this.connectClose();
        return string3;
    }

    public InputStream connectStream() {
        return this.connectStream("UTF-8");
    }

    public InputStream connectStream(String string) {
        InputStream inputStream = null;
        try {
            this.connectDoing(string);
            inputStream = this.connectAfter();
            return inputStream;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.connectClose();
            return null;
        }
    }

    public HttpUtil setDataBody(byte[] byArray) {
        this.databody = byArray;
        return this;
    }

    public HttpUtil clearForm() {
        this.form.clear();
        this.formdata = false;
        return this;
    }

    public HttpUtil addForm(String string, String string2) {
        NameValue nameValue = new NameValue(string, string2);
        if (nameValue.getName().length() > 0) {
            this.form.add(nameValue);
        }
        return this;
    }

    public HttpUtil addForm(String string, String string2, byte[] byArray) {
        NameFile nameFile = new NameFile(string, string2, byArray);
        if (nameFile.getName().length() > 0) {
            this.form.add(nameFile);
            this.formdata = true;
        }
        return this;
    }

    public HttpUtil addForm(String string, String string2, String string3, byte[] byArray) {
        NameFile nameFile = new NameFile(string, string2, string3, byArray);
        if (nameFile.getName().length() > 0) {
            this.form.add(nameFile);
            this.formdata = true;
        }
        return this;
    }

    public HttpUtil addForms(NameValue[] nameValueArray) {
        for (NameValue nameValue : nameValueArray) {
            if (nameValue.getName().length() <= 0) continue;
            if (nameValue.isFormdata()) {
                this.formdata = true;
            }
            this.form.add(nameValue);
        }
        return this;
    }

    public HttpUtil clearCookies() {
        this.cookies.clear();
        return this;
    }

    public HttpUtil addCookie(String string, String string2) {
        this.cookies.add(new Cookie(string, string2));
        return this;
    }

    public HttpUtil addCookies(Cookie[] cookieArray) {
        for (Cookie cookie : cookieArray) {
            this.cookies.add(cookie);
        }
        return this;
    }

    public List<Cookie> getCloneCookies(Boolean bl) {
        List<Cookie> list = HttpCommon.getHttpCookies(this.cookies, true);
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        if (bl == null) {
            for (Cookie cookie : list) {
                arrayList.add(cookie.clone());
            }
        } else if (bl.booleanValue()) {
            for (Cookie cookie : list) {
                if (cookie.getExpiryDate() != null) continue;
                arrayList.add(cookie.clone());
            }
        } else {
            for (Cookie cookie : list) {
                if (cookie.getExpiryDate() == null) continue;
                arrayList.add(cookie.clone());
            }
        }
        return arrayList;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getUrl() {
        return this.url;
    }
}

