/*
 * Decompiled with CFR 0.152.
 */
package dswork.mvc;

import dswork.core.page.PageRequest;
import dswork.web.MyRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;

public class BaseController {
    protected static String PageSize_SessionName = "dswork_session_pagesize";
    private static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> response = new ThreadLocal();
    private static final ThreadLocal<MyRequest> req = new ThreadLocal();
    protected static Logger log = LoggerFactory.getLogger((String)BaseController.class.getName());
    private static String JSON = "{\"code\":%d,\"data\":%s,\"msg\":\"%s\"}";
    private static String JSON_DATA = "{\"code\":%d,\"data\":%s}";
    private static String JSON_MSG = "{\"code\":%d,\"msg\":\"%s\"}";
    private static String JSON_CODE = "{\"code\":%d}";

    @ModelAttribute
    private void BaseInitialization(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.setCharacterEncoding("UTF-8");
        request.set(httpServletRequest);
        response.set(httpServletResponse);
        req.set(new MyRequest(httpServletRequest));
    }

    protected static HttpServletRequest request() {
        return request.get();
    }

    protected static HttpServletResponse response() {
        return response.get();
    }

    protected static HttpSession session() {
        return BaseController.request().getSession();
    }

    protected static MyRequest req() {
        return req.get();
    }

    protected static String formatJson(int n, String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return String.format(JSON_CODE, n);
            }
            return String.format(JSON_MSG, n, string2.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\""));
        }
        if (string2 == null) {
            return String.format(JSON_DATA, n, string);
        }
        return String.format(JSON, n, string, string2.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\""));
    }

    protected void print(Object object) {
        try {
            BaseController.response().setCharacterEncoding("UTF-8");
            BaseController.response().getWriter().print(object == null ? "" : object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void print(Object object, boolean bl) {
        if (!bl) {
            BaseController.response().setHeader("P3P", "CP=CAO PSA OUR");
            BaseController.response().setHeader("Access-Control-Allow-Origin", "*");
        }
        this.print(object);
    }

    protected void printJson(String string) {
        BaseController.response().setContentType("application/json;charset=UTF-8");
        this.print(string);
    }

    protected void printJson(String string, boolean bl) {
        BaseController.response().setContentType("application/json;charset=UTF-8");
        this.print(string, bl);
    }

    protected void put(String string, Object object) {
        BaseController.request().setAttribute(string, object);
    }

    @Deprecated
    protected void sendRedirect(String string) {
        try {
            BaseController.response().sendRedirect(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected PageRequest getPageRequest(int n, boolean bl) {
        if (n <= 0) {
            n = 10;
        }
        PageRequest pageRequest = new PageRequest();
        pageRequest.setFilters(BaseController.req().getParameterValueMap(false, false));
        pageRequest.setPage(BaseController.req().getInt("page", 1));
        if (bl) {
            try {
                n = Integer.parseInt(String.valueOf(BaseController.session().getAttribute(PageSize_SessionName)).trim());
            }
            catch (Exception exception) {
                n = 10;
            }
            n = BaseController.req().getInt("pagesize", BaseController.req().getInt("pageSize", n));
            BaseController.session().setAttribute(PageSize_SessionName, (Object)n);
        } else {
            n = BaseController.req().getInt("pagesize", BaseController.req().getInt("pageSize", n));
        }
        pageRequest.setPagesize(n);
        return pageRequest;
    }

    protected PageRequest getPageRequest(int n) {
        return this.getPageRequest(n, true);
    }

    protected PageRequest getPageRequest() {
        return this.getPageRequest(10, true);
    }
}

