/*
 * Decompiled with CFR 0.152.
 */
package dswork.springboot;

import dswork.springboot.ApplicationContextRegister;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.util.IntrospectorCleanupListener;

@Configuration
@AutoConfigureBefore(value={DispatcherServletAutoConfiguration.class})
public class DsworkSpringBootWeb {
    private static String[] servletMappings = new String[]{"*.htm"};

    public static void setServletMappings(String[] stringArray) {
        servletMappings = stringArray;
    }

    @Bean
    public ServletRegistrationBean<DispatcherServlet> dispatcherServletBean(DispatcherServlet dispatcherServlet) {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)dispatcherServlet, new String[0]);
        servletRegistrationBean.addUrlMappings(servletMappings);
        return servletRegistrationBean;
    }

    @Bean
    public ServletListenerRegistrationBean<IntrospectorCleanupListener> introspectorCleanupListenerBean() {
        ServletListenerRegistrationBean servletListenerRegistrationBean = new ServletListenerRegistrationBean();
        servletListenerRegistrationBean.setListener((EventListener)new IntrospectorCleanupListener());
        return servletListenerRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<CharacterEncodingFilter> encodingFilterBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new CharacterEncodingFilter());
        filterRegistrationBean.setName("encodingFilter");
        filterRegistrationBean.addInitParameter("encoding", "UTF-8");
        filterRegistrationBean.addInitParameter("forceEncoding", "true");
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.setOrder(1);
        return filterRegistrationBean;
    }

    @Bean
    public ApplicationContextRegister applicationContextRegister() {
        return new ApplicationContextRegister();
    }
}

