/*
 * Decompiled with CFR 0.152.
 */
package dswork.springboot;

import dswork.config.MyRootRegistrar;
import dswork.config.WebMvcScannerController;
import dswork.core.util.EnvironmentUtil;
import dswork.springboot.MyAutoConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.type.AnnotationMetadata;

@org.springframework.context.annotation.Configuration
@AutoConfigureBefore(value={MyAutoConfiguration.class, MyRootRegistrar.class, WebMvcScannerController.class})
@Import(value={MySpringInitializer.class})
public class MySpringInitializer
implements ImportBeanDefinitionRegistrar {
    private static boolean isboot = false;
    private static String JarPath = null;
    private static String[] servletMappings = new String[]{"/"};
    protected final Logger log = LoggerFactory.getLogger((String)"dswork.config");

    public static String[] getServletMappings() {
        return servletMappings;
    }

    public static void setServletMappings(String[] stringArray) {
        servletMappings = stringArray;
    }

    private static boolean checkConfigFileExists(String string) {
        if (isboot && new File(JarPath + string).isFile()) {
            return true;
        }
        return new ClassPathResource(string).exists();
    }

    public MySpringInitializer() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(MySpringInitializer.class.getName());
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        Object object;
        Object object2;
        String string;
        String string2 = EnvironmentUtil.getToString((String)"dswork.active", (String)"");
        String string3 = "/config/log4j2.xml";
        String string4 = "/config/sso.properties";
        if (string2.length() > 0) {
            string = "/config/" + string2 + "/config.properties";
            if (MySpringInitializer.checkConfigFileExists(string)) {
                EnvironmentUtil.setSystemProperties((String)string);
            }
            if (MySpringInitializer.checkConfigFileExists((String)(object2 = "/config/" + string2 + "/log4j2.xml"))) {
                string3 = object2;
            }
            if (MySpringInitializer.checkConfigFileExists((String)(object = "/config/" + string2 + "/sso.properties"))) {
                string4 = object;
            }
        }
        System.setProperty("dsworkSSOConfiguration", string4);
        try {
            string = null;
            object2 = null;
            if (isboot) {
                string = JarPath;
                object2 = new File(string + "/../logs").getCanonicalPath().replaceAll("\\\\", "/");
            } else {
                string = System.getProperty("user.dir").replaceAll("\\\\", "/");
                object2 = new File(string + "/../../logs").getCanonicalPath().replaceAll("\\\\", "/");
            }
            object = string.substring(string.lastIndexOf("/"));
            System.setProperty("rootDir", string);
            System.setProperty("logsDir", (String)object2);
            System.setProperty("contextPath", (String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Class.forName("org.apache.logging.log4j.core.config.ConfigurationFactory");
            if (MySpringInitializer.checkConfigFileExists(string3)) {
                string = XmlConfigurationFactory.getInstance();
                ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)string);
                object2 = null;
                if (isboot) {
                    object2 = new FileInputStream(JarPath + string3);
                } else {
                    object = new ClassPathResource(string3);
                    if (object.exists()) {
                        object2 = object.getInputStream();
                    }
                }
                if (object2 != null) {
                    object = new ConfigurationSource((InputStream)object2);
                    LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
                    Configuration configuration = string.getConfiguration(loggerContext, (ConfigurationSource)object);
                    loggerContext.reconfigure(configuration);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = EnvironmentUtil.getToString((String)"mvc.path", (String)"").replaceAll(" ", "");
            if (string.length() > 0) {
                MySpringInitializer.setServletMappings(string.split(","));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(MySpringInitializer.class.getName() + ".registerBeanDefinitions");
        }
    }

    static {
        JarPath = EnvironmentUtil.getApplicationPath();
        if (JarPath != null) {
            isboot = true;
        }
    }
}

