/*
 * Decompiled with CFR 0.152.
 */
package dswork.springboot;

import dswork.config.MyLog4jUtil;
import dswork.config.MyLogbackListener;
import dswork.config.MyRootRegistrar;
import dswork.config.WebMvcScannerController;
import dswork.core.util.EnvironmentUtil;
import dswork.springboot.MyAutoConfiguration;
import dswork.springboot.MyWebMvcRegistrations;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@AutoConfigureBefore(value={MyAutoConfiguration.class, MyRootRegistrar.class, WebMvcScannerController.class})
@Import(value={MySpringInitializer.class})
public class MySpringInitializer
implements ImportBeanDefinitionRegistrar {
    private static final String JarPath = EnvironmentUtil.getApplicationPath();
    private static final boolean isboot = JarPath != null;
    private static String[] servletMappings = new String[]{"/"};
    private static boolean initMappings = false;
    protected final Logger log = LoggerFactory.getLogger((String)"dswork.config");

    public static String[] getServletMappings() {
        return servletMappings;
    }

    public static void setServletMappings(String[] stringArray) {
        servletMappings = stringArray;
        initMappings = true;
    }

    private static boolean checkConfigFileExists(String string) {
        if (isboot && new File(JarPath + string).isFile()) {
            return true;
        }
        return new ClassPathResource(string).exists();
    }

    public MySpringInitializer() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(MySpringInitializer.class.getName());
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        Object object;
        Object object2;
        String string;
        String string2 = EnvironmentUtil.getToString((String)"dswork.active", (String)"");
        String string3 = "/config/logback.xml";
        Object object3 = "/config/log4j2.xml";
        String string4 = "/config/sso.properties";
        if (string2.length() > 0) {
            String string5;
            string = "/config/" + string2 + "/config.properties";
            if (MySpringInitializer.checkConfigFileExists(string)) {
                EnvironmentUtil.setSystemProperties((String)string);
            }
            if (MySpringInitializer.checkConfigFileExists((String)(object2 = "/config/" + string2 + "/logback.xml"))) {
                string3 = object2;
            }
            if (MySpringInitializer.checkConfigFileExists((String)(object = "/config/" + string2 + "/log4j2.xml"))) {
                object3 = object;
            }
            if (MySpringInitializer.checkConfigFileExists(string5 = "/config/" + string2 + "/sso.properties")) {
                string4 = string5;
            }
        }
        System.setProperty("dsworkSSOConfiguration", string4);
        try {
            string = null;
            object2 = null;
            if (isboot) {
                string = JarPath;
                object2 = new File(string + "/../logs").getCanonicalPath().replaceAll("\\\\", "/");
            } else {
                string = System.getProperty("user.dir").replaceAll("\\\\", "/");
                object2 = new File(string + "/../../logs").getCanonicalPath().replaceAll("\\\\", "/");
            }
            object = string.substring(string.lastIndexOf("/"));
            System.setProperty("rootDir", string);
            System.setProperty("logsDir", (String)object2);
            System.setProperty("contextPath", (String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        try {
            if (MySpringInitializer.checkConfigFileExists(string3)) {
                Class.forName("ch.qos.logback.core.Context");
                object2 = null;
                if (isboot) {
                    object2 = new FileInputStream(JarPath + string3);
                } else {
                    object = new ClassPathResource(string3);
                    if (object.exists()) {
                        object2 = object.getInputStream();
                    }
                }
                if (object2 != null) {
                    MyLogbackListener.resetLogback((InputStream)object2, null);
                    bl = true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!bl && MySpringInitializer.checkConfigFileExists((String)object3)) {
                Class.forName("org.apache.logging.log4j.core.config.ConfigurationFactory");
                object2 = null;
                if (isboot) {
                    object2 = new FileInputStream(JarPath + (String)object3);
                } else {
                    object = new ClassPathResource((String)object3);
                    if (object.exists()) {
                        object2 = object.getInputStream();
                    }
                }
                if (object2 != null) {
                    MyLog4jUtil.resetLog((InputStream)object2);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object2 = EnvironmentUtil.getToString((String)"mvc.path", (String)"").replaceAll(" ", "");
            object = EnvironmentUtil.getToString((String)"mvc.path.suffix", null);
            if (((String)object2).length() > 0) {
                if (this.log.isWarnEnabled() && initMappings) {
                    this.log.warn("Repeat settings dswork.config.MyWebInitializer.setServletMappings()! Use mvc.path");
                }
                MySpringInitializer.setServletMappings(((String)object2).split(","));
            }
            if (servletMappings.length == 1) {
                if (object != null) {
                    if (((String)object).startsWith("*.") && ((String)object).length() > 3) {
                        MyWebMvcRegistrations.SUFFIX = ((String)object).substring(1);
                    } else if (((String)object).startsWith(".") && ((String)object).length() > 2) {
                        MyWebMvcRegistrations.SUFFIX = object;
                    }
                } else if (servletMappings[0].startsWith("*.") && servletMappings[0].length() > 3) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("No mvc.path.suffix found");
                    }
                    MyWebMvcRegistrations.SUFFIX = servletMappings[0].substring(1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("dswork.springboot.MySpringInitializer.registerBeanDefinitions");
        }
    }
}

