/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.rest.spring;

import com.github.skjolber.mockito.rest.spring.MockitoEndpointServerInstance;
import com.github.skjolber.mockito.rest.spring.MockitoEndpointServiceFactory;
import com.github.skjolber.mockito.rest.spring.MockitoEndpointWebMvcConfig;
import com.github.skjolber.mockito.rest.spring.PortReservations;
import com.github.skjolber.mockito.rest.spring.api.MockEndpoint;
import com.github.skjolber.mockito.rest.spring.mockito.MockEndpointFieldHelper;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.mockito.Mockito;

public class MockitoEndpointExtension
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String PORT_NAME = "mockitoRestSpringServerPort";
    protected MockitoEndpointServiceFactory serviceFactory = new MockitoEndpointServiceFactory();
    protected List<Class<?>> defaultContextBeans;
    protected MockitoEndpointServerInstance server;
    protected boolean postProcessed = false;
    protected Map<Field, Object> setters;
    protected PortReservations portReservations;

    public static int getPort() {
        String property = System.getProperty(PORT_NAME);
        if (property == null) {
            throw new IllegalArgumentException("Port not set");
        }
        return Integer.parseInt(property);
    }

    public MockitoEndpointExtension() {
        this(Arrays.asList(MockitoEndpointWebMvcConfig.class));
        ServiceLoader<MockitoEndpointServerInstance> loader = ServiceLoader.load(MockitoEndpointServerInstance.class);
        Iterator<MockitoEndpointServerInstance> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Expected implementation of " + MockitoEndpointServerInstance.class.getName() + ", found none");
        }
        this.server = iterator.next();
    }

    public MockitoEndpointExtension(MockitoEndpointServerInstance server) {
        this(Arrays.asList(MockitoEndpointWebMvcConfig.class));
        this.server = server;
    }

    public MockitoEndpointExtension(List<Class<?>> contextBeans) {
        this.defaultContextBeans = contextBeans;
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
    }

    public void afterEach(ExtensionContext context) throws Exception {
        for (Map.Entry<Field, Object> entry : this.setters.entrySet()) {
            Mockito.reset((Object[])new Object[]{entry.getValue()});
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.server.start();
        for (Map.Entry<Field, Object> entry : this.setters.entrySet()) {
            Mockito.reset((Object[])new Object[]{entry.getValue()});
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        MockEndpointFieldHelper helper = new MockEndpointFieldHelper(testInstance, testInstance.getClass());
        if (!this.postProcessed) {
            this.postProcessed = true;
            HashMap<Class, Field> fields = new HashMap<Class, Field>();
            for (Field field : helper.getFields()) {
                MockEndpoint annotation = field.getAnnotation(MockEndpoint.class);
                if (annotation == null) continue;
                String path = annotation.path();
                if (path.isEmpty()) {
                    path = null;
                }
                Class service = this.serviceFactory.add(field.getType(), path);
                fields.put(service, field);
            }
            String address = String.format("http://localhost:%s", this.portReservations.getPorts().get(PORT_NAME));
            this.portReservations.release();
            Map<Class<?>, Object> mocksByClass = this.mock(address);
            HashMap<Field, Object> setters = new HashMap<Field, Object>();
            for (Map.Entry entry : fields.entrySet()) {
                Object mock = mocksByClass.get(entry.getKey());
                setters.put((Field)entry.getValue(), mock);
            }
            this.setters = setters;
        }
        for (Map.Entry<Field, Object> entry : this.setters.entrySet()) {
            helper.setField(entry.getKey(), entry.getValue());
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.portReservations.release();
        this.server.destroy();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.portReservations = new PortReservations(new String[]{PORT_NAME});
        this.portReservations.start();
    }

    public Map<Class<?>, Object> mock(String address) throws Exception {
        URL url = new URL(address);
        if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1")) {
            throw new IllegalArgumentException("Only local mocking is supported");
        }
        List mockTargetBeans = this.serviceFactory.getBeans();
        return this.server.add(mockTargetBeans, this.defaultContextBeans, url);
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void start() throws Exception {
        this.server.start();
    }
}

