/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.rest.spring;

import com.github.skjolber.mockito.rest.spring.MockitoEndpointServerInstance;
import com.github.skjolber.mockito.rest.spring.MockitoSpringApplicationListener;
import com.github.skjolber.mockito.rest.spring.MockitoSpringWebApplicationContext;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.springframework.context.ApplicationListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class TomcatMockitoEndpointServerInstance
implements MockitoEndpointServerInstance {
    protected boolean started = true;
    protected List<Tomcat> servers = new ArrayList<Tomcat>();
    protected List<Context> contexts = new ArrayList<Context>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        TomcatMockitoEndpointServerInstance tomcatMockitoEndpointServerInstance = this;
        synchronized (tomcatMockitoEndpointServerInstance) {
            if (this.started) {
                this.started = false;
                for (Context context : this.contexts) {
                    this.stop(context);
                }
                for (Tomcat server : this.servers) {
                    this.stop(server);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        TomcatMockitoEndpointServerInstance tomcatMockitoEndpointServerInstance = this;
        synchronized (tomcatMockitoEndpointServerInstance) {
            this.started = false;
            for (Context context : this.contexts) {
                this.stop(context);
            }
            for (Context context : this.contexts) {
                this.destroy(context);
            }
            for (Tomcat server : this.servers) {
                this.stop(server);
            }
            for (Tomcat server : this.servers) {
                this.destroy(server);
            }
            this.contexts.clear();
            this.servers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        TomcatMockitoEndpointServerInstance tomcatMockitoEndpointServerInstance = this;
        synchronized (tomcatMockitoEndpointServerInstance) {
            if (!this.started) {
                this.started = true;
                for (Tomcat server : this.servers) {
                    this.start(server);
                }
            }
        }
    }

    public Map<Class<?>, Object> add(List<Class<?>> mockTargetBeans, List<Class<?>> defaultContextBeans, URL url) throws Exception {
        MockitoSpringApplicationListener configuration = new MockitoSpringApplicationListener();
        configuration.setContextBeans(defaultContextBeans);
        configuration.setMockTargetBeans(mockTargetBeans);
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(url.getPort());
        tomcat.setHostname("localhost");
        tomcat.getServer().setPort(url.getPort());
        MockitoSpringWebApplicationContext dispatcherContext = new MockitoSpringWebApplicationContext(mockTargetBeans);
        for (Class<?> bean : defaultContextBeans) {
            dispatcherContext.register(new Class[]{bean});
        }
        dispatcherContext.addApplicationListener((ApplicationListener)configuration);
        String contextPath = url.getPath();
        String tempDir = System.getProperty("java.io.tmpdir");
        File rootFile = new File(tempDir, "tomcat");
        if (!rootFile.exists() && !rootFile.mkdirs()) {
            throw new RuntimeException("Unable to create directory " + rootFile);
        }
        File baseDir = new File(rootFile, "base");
        if (!baseDir.exists() && !baseDir.mkdir()) {
            throw new RuntimeException("Unable to create directory " + baseDir);
        }
        File docBase = new File(rootFile, "doc");
        if (!docBase.exists() && !docBase.mkdir()) {
            throw new RuntimeException("Unable to create directory " + docBase);
        }
        tomcat.setBaseDir(baseDir.getAbsolutePath());
        Context context = tomcat.addContext(contextPath, docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        DispatcherServlet servlet = new DispatcherServlet((WebApplicationContext)dispatcherContext);
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        defaultServlet.setServlet((Servlet)servlet);
        context.addChild((Container)defaultServlet);
        context.addServletMappingDecoded("/", defaultServlet.getName());
        Connector connector = new Connector();
        connector.setThrowOnFailure(true);
        connector.setPort(url.getPort());
        tomcat.getService().addConnector(connector);
        tomcat.setConnector(connector);
        this.servers.add(tomcat);
        this.start(tomcat);
        this.contexts.add(context);
        if (tomcat.getServer().getState() == LifecycleState.STARTED) {
            return configuration.getAll();
        }
        throw new IllegalStateException("Unable to start server");
    }

    private void start(Tomcat tomcat) throws InterruptedException, LifecycleException {
        tomcat.init();
        tomcat.start();
        long deadline = System.currentTimeMillis() + 10000L;
        block3: do {
            switch (tomcat.getServer().getState()) {
                case NEW: 
                case INITIALIZING: 
                case INITIALIZED: 
                case STARTING_PREP: 
                case STARTING: {
                    Thread.sleep(10L);
                    break;
                }
                default: {
                    break block3;
                }
            }
        } while (deadline > System.currentTimeMillis());
    }

    private void stop(Tomcat tomcat) throws LifecycleException, InterruptedException {
        tomcat.stop();
        long deadline = System.currentTimeMillis() + 10000L;
        do {
            switch (tomcat.getServer().getState()) {
                case STOPPED: 
                case DESTROYING: 
                case DESTROYED: 
                case FAILED: {
                    return;
                }
            }
            Thread.sleep(10L);
        } while (deadline > System.currentTimeMillis());
    }

    private void stop(Context context) throws LifecycleException, InterruptedException {
        context.stop();
        long deadline = System.currentTimeMillis() + 10000L;
        do {
            switch (context.getState()) {
                case STOPPED: 
                case DESTROYING: 
                case DESTROYED: 
                case FAILED: {
                    return;
                }
            }
            Thread.sleep(10L);
        } while (deadline > System.currentTimeMillis());
    }

    private void destroy(Tomcat tomcat) throws LifecycleException, InterruptedException {
        tomcat.destroy();
        long deadline = System.currentTimeMillis() + 10000L;
        do {
            switch (tomcat.getServer().getState()) {
                case DESTROYED: 
                case FAILED: {
                    return;
                }
            }
            Thread.sleep(10L);
        } while (deadline > System.currentTimeMillis());
    }

    private void destroy(Context context) throws LifecycleException, InterruptedException {
        context.destroy();
        long deadline = System.currentTimeMillis() + 10000L;
        do {
            switch (context.getState()) {
                case DESTROYED: 
                case FAILED: {
                    return;
                }
            }
            Thread.sleep(10L);
        } while (deadline > System.currentTimeMillis());
    }
}

