/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.rest.spring;

import com.github.skjolber.mockito.rest.spring.MockitoEndpointServerInstance;
import com.github.skjolber.mockito.rest.spring.MockitoSpringApplicationListener;
import com.github.skjolber.mockito.rest.spring.MockitoSpringWebApplicationContext;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import jakarta.servlet.ServletException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationListener;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class UndertowMockitoEndpointServerInstance
implements MockitoEndpointServerInstance {
    private static final String SPRING_DISPATCHER_MAPPING_URL = "/*";
    private static final String CONTEXT_PATH = "/";
    protected boolean started = true;
    protected List<Undertow> servers = new ArrayList<Undertow>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        UndertowMockitoEndpointServerInstance undertowMockitoEndpointServerInstance = this;
        synchronized (undertowMockitoEndpointServerInstance) {
            this.started = false;
            for (Undertow server : this.servers) {
                server.stop();
            }
            this.servers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        UndertowMockitoEndpointServerInstance undertowMockitoEndpointServerInstance = this;
        synchronized (undertowMockitoEndpointServerInstance) {
            if (this.started) {
                this.started = false;
                for (Undertow server : this.servers) {
                    server.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        UndertowMockitoEndpointServerInstance undertowMockitoEndpointServerInstance = this;
        synchronized (undertowMockitoEndpointServerInstance) {
            if (!this.started) {
                this.started = true;
                for (Undertow server : this.servers) {
                    server.start();
                }
            }
        }
    }

    public Map<Class<?>, Object> add(List<Class<?>> mockTargetBeans, List<Class<?>> defaultContextBeans, URL url) throws Exception {
        MockitoSpringApplicationListener configuration = new MockitoSpringApplicationListener();
        configuration.setContextBeans(defaultContextBeans);
        configuration.setMockTargetBeans(mockTargetBeans);
        MockitoSpringWebApplicationContext dispatcherContext = new MockitoSpringWebApplicationContext(mockTargetBeans);
        for (Class<?> bean : defaultContextBeans) {
            dispatcherContext.register(new Class[]{bean});
        }
        dispatcherContext.addApplicationListener((ApplicationListener)configuration);
        Undertow undertow = this.configureUndertow(dispatcherContext, url);
        this.servers.add(undertow);
        undertow.start();
        return configuration.getAll();
    }

    private Undertow configureUndertow(MockitoSpringWebApplicationContext context, URL url) throws ServletException {
        DeploymentInfo servletBuilder = Servlets.deployment().setClassLoader(Undertow.class.getClassLoader()).setContextPath(url.getPath()).setDeploymentName("mock").addServlet(UndertowMockitoEndpointServerInstance.createDispatcherServlet((WebApplicationContext)context)).addListener(UndertowMockitoEndpointServerInstance.createContextLoaderListener((WebApplicationContext)context));
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(servletBuilder);
        manager.deploy();
        PathHandler path = Handlers.path((HttpHandler)Handlers.redirect((String)CONTEXT_PATH)).addPrefixPath(CONTEXT_PATH, manager.start());
        return Undertow.builder().addHttpListener(url.getPort(), url.getHost()).setHandler((HttpHandler)path).build();
    }

    private static ListenerInfo createContextLoaderListener(WebApplicationContext context) {
        ImmediateInstanceFactory factory = new ImmediateInstanceFactory((Object)new ContextLoaderListener(context));
        return new ListenerInfo(ContextLoaderListener.class, (InstanceFactory)factory);
    }

    private static ServletInfo createDispatcherServlet(WebApplicationContext context) {
        ImmediateInstanceFactory factory = new ImmediateInstanceFactory((Object)new DispatcherServlet(context));
        return Servlets.servlet((String)"DispatcherServlet", DispatcherServlet.class, (InstanceFactory)factory).addMapping(SPRING_DISPATCHER_MAPPING_URL).setLoadOnStartup(Integer.valueOf(1));
    }
}

