/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls;

import com.soartech.soarls.tcl.TclAstNode;
import com.soartech.soarls.tcl.TclParser;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;

public class SoarFile {
    public final URI uri;
    public final String contents;
    public final List<Diagnostic> diagnostics;
    public final TclAstNode ast;

    public SoarFile(URI uri, String contents) {
        this.uri = uri;
        this.contents = this.fixLineEndings(contents);
        TclParser parser = new TclParser();
        parser.setInput(this.contents.toCharArray(), 0, this.contents.length());
        this.ast = parser.parse();
        this.diagnostics = parser.getErrors().stream().map(e -> {
            int start = this.position(e.getStart()).getLine();
            return new Diagnostic(new Range(new Position(start, 0), this.getEndOfLinePosition(start)), e.getMessage(), DiagnosticSeverity.Error, "soar");
        }).collect(Collectors.toList());
    }

    SoarFile withChanges(List<TextDocumentContentChangeEvent> changes) {
        BiFunction<StringBuffer, TextDocumentContentChangeEvent, StringBuffer> applyChange = (buffer, change) -> {
            if (change.getRange() == null) {
                return new StringBuffer(change.getText());
            }
            int start = this.offset(change.getRange().getStart());
            int end = this.offset(change.getRange().getEnd());
            return buffer.replace(start, end, change.getText());
        };
        String newContents = changes.stream().reduce(new StringBuffer(this.contents), applyChange, (u, v) -> v).toString();
        return new SoarFile(this.uri, newContents);
    }

    SoarFile withChange(TextDocumentContentChangeEvent change) {
        return this.withChanges(Arrays.asList(change));
    }

    public void traverseAst(Consumer<TclAstNode> implementation) {
        this.traverseAstHelper(implementation, this.ast);
    }

    private void traverseAstHelper(Consumer<TclAstNode> implementation, TclAstNode currentNode) {
        implementation.accept(currentNode);
        for (TclAstNode child : currentNode.getChildren()) {
            this.traverseAstHelper(implementation, child);
        }
    }

    public String getNodeInternalText(TclAstNode node) {
        return node.getInternalText(this.contents.toCharArray());
    }

    public TclAstNode tclNode(Position position) {
        return this.tclNode(this.offset(position));
    }

    public TclAstNode tclNode(int offset) {
        TclAstNode child;
        TclAstNode node = this.ast;
        while ((child = (TclAstNode)node.getChildren().stream().filter(c -> c.getStart() <= offset).filter(c -> offset < c.getEnd()).findFirst().orElse(null)) != null) {
            node = child;
        }
        return node;
    }

    String line(int lineNumber) {
        int start = this.offset(new Position(lineNumber, 0));
        int end = this.offset(new Position(lineNumber + 1, 0));
        return this.contents.substring(start, end);
    }

    public int offset(Position position) {
        int offset = 0;
        int lines = position.getLine();
        for (char ch : this.contents.toCharArray()) {
            if (lines == 0) {
                return offset + position.getCharacter();
            }
            if (ch == '\n') {
                --lines;
            }
            ++offset;
        }
        return this.contents.length();
    }

    public Position position(int offset) {
        int line = 0;
        int character = 0;
        for (int i = 0; i != offset; ++i) {
            if (this.contents.charAt(i) == '\n') {
                ++line;
                character = 0;
                continue;
            }
            ++character;
        }
        return new Position(line, character);
    }

    private String fixLineEndings(String contents) {
        contents = contents.replace("\r\n", "\n");
        contents = contents.replace("\r", "\n");
        return contents;
    }

    private Position getEndOfLinePosition(int line) {
        String[] lines = this.contents.split("\n");
        return new Position(line, lines[line].length());
    }

    List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public Range rangeForNode(TclAstNode node) {
        return new Range(this.position(node.getStart()), this.position(node.getEnd()));
    }
}

