/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls.analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.soartech.soarls.analysis.FileAnalysis;
import com.soartech.soarls.analysis.ProcedureCall;
import com.soartech.soarls.analysis.ProcedureDefinition;
import com.soartech.soarls.analysis.VariableDefinition;
import com.soartech.soarls.analysis.VariableRetrieval;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ProjectAnalysis {
    public final URI entryPointUri;
    public final ImmutableMap<URI, FileAnalysis> files;
    public final ImmutableMap<String, ProcedureDefinition> procedureDefinitions;
    public final ImmutableMap<ProcedureDefinition, ImmutableList<ProcedureCall>> procedureCalls;
    public final ImmutableMap<String, VariableDefinition> variableDefinitions;
    public final ImmutableMap<VariableDefinition, ImmutableList<VariableRetrieval>> variableRetrievals;

    ProjectAnalysis(URI entryPointUri, Map<URI, FileAnalysis> files, Map<String, ProcedureDefinition> procedureDefinitions, Map<ProcedureDefinition, List<ProcedureCall>> procedureCalls, Map<String, VariableDefinition> variableDefinitions, Map<VariableDefinition, List<VariableRetrieval>> variableRetrievals) {
        this.entryPointUri = entryPointUri;
        this.files = ImmutableMap.copyOf(files);
        this.procedureDefinitions = ImmutableMap.copyOf(procedureDefinitions);
        this.procedureCalls = (ImmutableMap)procedureCalls.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (ProcedureDefinition)e.getKey(), e -> ImmutableList.copyOf((Collection)((Collection)e.getValue()))));
        this.variableDefinitions = ImmutableMap.copyOf(variableDefinitions);
        this.variableRetrievals = (ImmutableMap)variableRetrievals.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (VariableDefinition)e.getKey(), e -> ImmutableList.copyOf((Collection)((Collection)e.getValue()))));
    }

    public Optional<FileAnalysis> file(URI uri) {
        return Optional.ofNullable(this.files.get((Object)uri));
    }
}

