/*
 * Decompiled with CFR 0.152.
 */
package com.soartech.soarls.tcl;

import com.soartech.soarls.tcl.TclParserError;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class TclAstNode {
    public static final int ROOT = 0;
    public static final int COMMENT = 1;
    public static final int COMMAND = 2;
    public static final int NORMAL_WORD = 3;
    public static final int QUOTED_WORD = 4;
    public static final int BRACED_WORD = 5;
    public static final int COMMAND_WORD = 6;
    public static final int VARIABLE = 7;
    public static final int VARIABLE_NAME = 8;
    private static final String[] TYPES = new String[]{"ROOT", "COMMENT", "COMMAND", "NORMAL_WORD", "QUOTED_WORD", "BRACED_WORD", "COMMAND_WORD", "VARIABLE", "VARIABLE_NAME"};
    private int type;
    private int start;
    private int length;
    private TclAstNode parent = null;
    private List<TclAstNode> children;
    private TclParserError error;

    public TclAstNode(int type, int start) {
        this.type = type;
        this.start = start;
    }

    public List<TclAstNode> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<TclAstNode>();
        }
        return this.children;
    }

    public TclAstNode getParent() {
        return this.parent;
    }

    public void addChild(TclAstNode node) {
        List<TclAstNode> kids = this.getChildren();
        node.parent = this;
        kids.add(node);
    }

    public int getLength() {
        return this.length;
    }

    public void setEnd(int end) {
        this.length = end - this.start;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.start + this.length;
    }

    public boolean containsOffset(int offset) {
        int end = this.start + this.length;
        return offset >= this.start && offset <= end;
    }

    public int getType() {
        return this.type;
    }

    public TclParserError getError() {
        return this.error;
    }

    public void setError(TclParserError error) {
        this.error = error;
    }

    public boolean isWord() {
        return this.type == 3 || this.type == 4 || this.type == 5 || this.type == 6;
    }

    public boolean isExpandable() {
        return this.type == 4 || this.type == 6;
    }

    public String getInternalText(char[] buffer) {
        int internalStart = this.start;
        int internalLength = this.length;
        if (this.type == 5 || this.type == 4) {
            ++internalStart;
            internalLength -= 2;
        }
        if (internalLength <= 0 || internalStart + internalLength > buffer.length) {
            return "";
        }
        return new String(buffer, internalStart, internalLength);
    }

    public TclAstNode getChild(int type) {
        for (TclAstNode child : this.getChildren()) {
            if (child.getType() != type) continue;
            return child;
        }
        return null;
    }

    public List<TclAstNode> getWordChildren() {
        ArrayList<TclAstNode> words = new ArrayList<TclAstNode>();
        if (this.children != null) {
            for (TclAstNode child : this.getChildren()) {
                if (!child.isWord()) continue;
                words.add(child);
            }
        }
        return words;
    }

    public void printTree(PrintStream stream, char[] input, int depth) {
        for (int i = 0; i < depth; ++i) {
            stream.print("   ");
        }
        stream.print(this);
        if (this.children == null || this.children.isEmpty()) {
            stream.println(": " + new String(input, this.start, this.length));
        } else {
            stream.println();
        }
        for (TclAstNode node : this.getChildren()) {
            node.printTree(stream, input, depth + 1);
        }
    }

    public List<TclAstNode> flatten() {
        ArrayList<TclAstNode> output = new ArrayList<TclAstNode>();
        output.add(this);
        if (this.children != null) {
            for (TclAstNode child : this.children) {
                output.addAll(child.flatten());
            }
        }
        return output;
    }

    public List<TclAstNode> leafNodes() {
        ArrayList<TclAstNode> output = new ArrayList<TclAstNode>();
        if (this.children != null && this.children.size() != 0) {
            for (TclAstNode child : this.children) {
                output.addAll(child.leafNodes());
            }
        } else {
            output.add(this);
        }
        return output;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(TYPES[this.type]);
        b.append(" [" + this.start + ", " + this.length + ")");
        return b.toString();
    }

    public boolean containsChild(TclAstNode child) {
        return this == child || this.getChildren().stream().filter(n -> n.getStart() <= child.getStart()).filter(n -> n.getEnd() >= child.getEnd()).anyMatch(n -> n.containsChild(child));
    }

    public boolean containsType(int type) {
        if (this.type == type) {
            return true;
        }
        for (TclAstNode child : this.getChildren()) {
            if (!child.containsType(type)) continue;
            return true;
        }
        return false;
    }
}

