/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.HashMap;
import tcl.lang.AbsFunction;
import tcl.lang.AcosFunction;
import tcl.lang.AsinFunction;
import tcl.lang.Atan2Function;
import tcl.lang.AtanFunction;
import tcl.lang.CeilFunction;
import tcl.lang.CosFunction;
import tcl.lang.CoshFunction;
import tcl.lang.DoubleFunction;
import tcl.lang.ExpFunction;
import tcl.lang.ExprValue;
import tcl.lang.FloorFunction;
import tcl.lang.FmodFunction;
import tcl.lang.HypotFunction;
import tcl.lang.IntFunction;
import tcl.lang.Interp;
import tcl.lang.Log10Function;
import tcl.lang.LogFunction;
import tcl.lang.MathFunction;
import tcl.lang.NoArgMathFunction;
import tcl.lang.ParseAdaptor;
import tcl.lang.ParseResult;
import tcl.lang.PowFunction;
import tcl.lang.RandFunction;
import tcl.lang.RoundFunction;
import tcl.lang.SinFunction;
import tcl.lang.SinhFunction;
import tcl.lang.SqrtFunction;
import tcl.lang.SrandFunction;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TanFunction;
import tcl.lang.TanhFunction;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.WideFunction;

public class Expression {
    public static final int VALUE = 0;
    public static final int OPEN_PAREN = 1;
    public static final int CLOSE_PAREN = 2;
    public static final int COMMA = 3;
    public static final int END = 4;
    public static final int UNKNOWN = 5;
    public static final int MULT = 8;
    public static final int DIVIDE = 9;
    public static final int MOD = 10;
    public static final int PLUS = 11;
    public static final int MINUS = 12;
    public static final int LEFT_SHIFT = 13;
    public static final int RIGHT_SHIFT = 14;
    public static final int LESS = 15;
    public static final int GREATER = 16;
    public static final int LEQ = 17;
    public static final int GEQ = 18;
    public static final int EQUAL = 19;
    public static final int NEQ = 20;
    public static final int BIT_AND = 21;
    public static final int BIT_XOR = 22;
    public static final int BIT_OR = 23;
    public static final int AND = 24;
    public static final int OR = 25;
    public static final int QUESTY = 26;
    public static final int COLON = 27;
    public static final int STREQ = 28;
    public static final int STRNEQ = 29;
    public static final int UNARY_MINUS = 30;
    public static final int UNARY_PLUS = 31;
    public static final int NOT = 32;
    public static final int BIT_NOT = 33;
    public static int[] precTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 12, 12, 12, 11, 11, 10, 10, 9, 9, 9, 9, 8, 8, 7, 6, 5, 4, 3, 2, 1, 8, 8, 13, 13, 13, 13};
    public static String[] operatorStrings = new String[]{"VALUE", "(", ")", ",", "END", "UNKNOWN", "6", "7", "*", "/", "%", "+", "-", "<<", ">>", "<", ">", "<=", ">=", "==", "!=", "&", "^", "|", "&&", "||", "?", ":", "eq", "ne", "-", "+", "!", "~"};
    public HashMap<String, MathFunction> mathFuncTable = new HashMap();
    private String m_expr;
    private int m_len;
    int m_token;
    private int m_ind;
    private ExprValue[] cachedExprValue;
    private int cachedExprIndex = 0;
    private static final int cachedExprLength = 50;

    public void evalSetResult(Interp interp, String string) throws TclException {
        ExprValue exprValue = this.ExprTopLevel(interp, string);
        switch (exprValue.getType()) {
            case 0: {
                interp.setResult(exprValue.getIntValue());
                break;
            }
            case 1: {
                interp.setResult(exprValue.getDoubleValue());
                break;
            }
            case 2: {
                interp.setResult(exprValue.getStringValue());
                break;
            }
            default: {
                throw new TclRuntimeError("internal error: expression, unknown");
            }
        }
        this.releaseExprValue(exprValue);
    }

    public boolean evalBoolean(Interp interp, String string) throws TclException {
        ExprValue exprValue = this.ExprTopLevel(interp, string);
        boolean bl = exprValue.getBooleanValue(interp);
        this.releaseExprValue(exprValue);
        return bl;
    }

    public Expression() {
        this.registerMathFunction("atan2", new Atan2Function());
        this.registerMathFunction("pow", new PowFunction());
        this.registerMathFunction("acos", new AcosFunction());
        this.registerMathFunction("asin", new AsinFunction());
        this.registerMathFunction("atan", new AtanFunction());
        this.registerMathFunction("ceil", new CeilFunction());
        this.registerMathFunction("cos", new CosFunction());
        this.registerMathFunction("cosh", new CoshFunction());
        this.registerMathFunction("exp", new ExpFunction());
        this.registerMathFunction("floor", new FloorFunction());
        this.registerMathFunction("fmod", new FmodFunction());
        this.registerMathFunction("hypot", new HypotFunction());
        this.registerMathFunction("log", new LogFunction());
        this.registerMathFunction("log10", new Log10Function());
        this.registerMathFunction("rand", new RandFunction());
        this.registerMathFunction("sin", new SinFunction());
        this.registerMathFunction("sinh", new SinhFunction());
        this.registerMathFunction("sqrt", new SqrtFunction());
        this.registerMathFunction("srand", new SrandFunction());
        this.registerMathFunction("tan", new TanFunction());
        this.registerMathFunction("tanh", new TanhFunction());
        this.registerMathFunction("abs", new AbsFunction());
        this.registerMathFunction("double", new DoubleFunction());
        this.registerMathFunction("int", new IntFunction());
        this.registerMathFunction("wide", new WideFunction());
        this.registerMathFunction("round", new RoundFunction());
        this.m_expr = null;
        this.m_ind = 0;
        this.m_len = 0;
        this.m_token = 5;
        this.cachedExprValue = new ExprValue[50];
        for (int i = 0; i < 50; ++i) {
            this.cachedExprValue[i] = new ExprValue(0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExprValue ExprTopLevel(Interp interp, String string) throws TclException {
        String string2 = this.m_expr;
        int n = this.m_len;
        int n2 = this.m_token;
        int n3 = this.m_ind;
        try {
            this.m_expr = string;
            this.m_ind = 0;
            this.m_len = string.length();
            this.m_token = 5;
            ExprValue exprValue = this.ExprGetValue(interp, -1);
            if (this.m_token != 4) {
                this.SyntaxError(interp);
            }
            ExprValue exprValue2 = exprValue;
            return exprValue2;
        }
        finally {
            this.m_expr = string2;
            this.m_len = n;
            this.m_token = n2;
            this.m_ind = n3;
        }
    }

    static void IllegalType(Interp interp, int n, int n2) throws TclException {
        throw new TclException(interp, "can't use " + (n == 1 ? "floating-point value" : "non-numeric string") + " as operand of \"" + operatorStrings[n2] + "\"");
    }

    void SyntaxError(Interp interp) throws TclException {
        throw new TclException(interp, "syntax error in expression \"" + this.m_expr + "\"");
    }

    void SyntaxError(Interp interp, String string) throws TclException {
        throw new TclException(interp, "syntax error in expression \"" + this.m_expr + "\": " + string);
    }

    static void DivideByZero(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH DIVZERO {divide by zero}"));
        throw new TclException(interp, "divide by zero");
    }

    public static void IntegerTooLarge(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
        throw new TclException(interp, "integer value too large to represent");
    }

    static void DoubleTooLarge(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
        throw new TclException(interp, "floating-point value too large to represent");
    }

    static void DoubleTooSmall(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH UNDERFLOW {floating-point value too small to represent}"));
        throw new TclException(interp, "floating-point value too small to represent");
    }

    static void DomainError(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH DOMAIN {domain error: argument not in valid range}"));
        throw new TclException(interp, "domain error: argument not in valid range");
    }

    static void EmptyStringOperandError(Interp interp, int n) throws TclException {
        throw new TclException(interp, "can't use empty string as operand of \"" + operatorStrings[n] + "\"");
    }

    public static void ExprParseObject(Interp interp, TclObject tclObject, ExprValue exprValue) throws TclException {
        if (tclObject.isIntType()) {
            exprValue.setIntValue(tclObject.ivalue, tclObject.hasNoStringRep() ? null : tclObject.toString());
            return;
        }
        if (tclObject.isDoubleType()) {
            exprValue.setDoubleValue(((TclDouble)tclObject.getInternalRep()).value, tclObject.hasNoStringRep() ? null : tclObject.toString());
            return;
        }
        Expression.ExprParseString(interp, tclObject, exprValue);
    }

    public static void ExprParseString(Interp interp, TclObject tclObject, ExprValue exprValue) {
        char c;
        String string = tclObject.toString();
        int n = string.length();
        switch (n) {
            case 0: {
                exprValue.setStringValue("");
                return;
            }
            case 1: {
                char c2 = string.charAt(0);
                switch (c2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        long l = c2 - 48;
                        exprValue.setIntValue(l, string);
                        TclInteger.exprSetInternalRep(tclObject, l);
                        return;
                    }
                }
                exprValue.setStringValue(string);
                return;
            }
            case 2: {
                c = string.charAt(0);
                if (c != '-') break;
                c = string.charAt(1);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        long l = -(c - 48);
                        exprValue.setIntValue(l, string);
                        TclInteger.exprSetInternalRep(tclObject, l);
                        return;
                    }
                }
                break;
            }
            case 3: {
                c = string.charAt(1);
                if (c != '.') break;
                if (string.equals("0.0")) {
                    double d = 0.0;
                    exprValue.setDoubleValue(d, string);
                    TclDouble.exprSetInternalRep(tclObject, d);
                    return;
                }
                if (string.equals("0.5")) {
                    double d = 0.5;
                    exprValue.setDoubleValue(d, string);
                    TclDouble.exprSetInternalRep(tclObject, d);
                    return;
                }
                if (string.equals("1.0")) {
                    double d = 1.0;
                    exprValue.setDoubleValue(d, string);
                    TclDouble.exprSetInternalRep(tclObject, d);
                    return;
                }
                if (!string.equals("2.0")) break;
                double d = 2.0;
                exprValue.setDoubleValue(d, string);
                TclDouble.exprSetInternalRep(tclObject, d);
                return;
            }
            case 4: {
                if (!string.equals("true")) break;
                exprValue.setStringValue(string);
                return;
            }
            case 5: {
                if (!string.equals("false")) break;
                exprValue.setStringValue(string);
                return;
            }
        }
        if (Expression.looksLikeInt(string, n, 0, false)) {
            StrtoulResult strtoulResult = interp.strtoulResult;
            Util.strtoul(string, 0, 0, strtoulResult);
            if (strtoulResult.errno == 0) {
                boolean bl = true;
                for (int i = strtoulResult.index; i < n; ++i) {
                    c = string.charAt(i);
                    if (c == ' ' || Character.isWhitespace(c)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    long l = strtoulResult.value;
                    exprValue.setIntValue(l, string);
                    TclInteger.exprSetInternalRep(tclObject, l);
                    return;
                }
            }
        } else {
            StrtodResult strtodResult = interp.strtodResult;
            Util.strtod(string, 0, n, strtodResult);
            if (strtodResult.errno == 0) {
                boolean bl = true;
                for (int i = strtodResult.index; i < n; ++i) {
                    c = string.charAt(i);
                    if (c == ' ' || Character.isWhitespace(c)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    double d = strtodResult.value;
                    exprValue.setDoubleValue(d, string);
                    TclDouble.exprSetInternalRep(tclObject, d);
                    return;
                }
            }
        }
        exprValue.setStringValue(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExprValue ExprGetValue(Interp interp, int n) throws TclException {
        int n2;
        boolean bl = false;
        ExprValue exprValue = null;
        ExprValue exprValue2 = this.ExprLex(interp);
        if (this.m_token == 1) {
            exprValue2 = this.ExprGetValue(interp, -1);
            if (this.m_token != 2) {
                this.SyntaxError(interp, "looking for close parenthesis");
            }
        } else {
            if (this.m_token == 12) {
                this.m_token = 30;
            }
            if (this.m_token == 11) {
                this.m_token = 31;
            }
            if (this.m_token >= 30) {
                n2 = this.m_token;
                exprValue2 = this.ExprGetValue(interp, precTable[this.m_token]);
                if (interp.noEval == 0) {
                    Expression.evalUnaryOperator(interp, n2, exprValue2);
                }
                bl = true;
            } else {
                if (this.m_token == 2) {
                    return null;
                }
                if (this.m_token != 0) {
                    if (this.m_token >= 8) {
                        this.SyntaxError(interp, "unexpected operator " + operatorStrings[this.m_token]);
                    } else if (this.m_token == 5) {
                        this.SyntaxError(interp, "character not legal in expressions");
                    } else {
                        this.SyntaxError(interp, "premature end of expression");
                    }
                }
            }
        }
        if (exprValue2 == null) {
            this.SyntaxError(interp);
        }
        if (!bl) {
            exprValue = this.ExprLex(interp);
        }
        while (true) {
            if ((n2 = this.m_token) < 8 || n2 >= 30) {
                if (n2 == 4 || n2 == 2 || n2 == 3) {
                    return exprValue2;
                }
                this.SyntaxError(interp, "extra tokens at end of expression");
            }
            if (precTable[n2] <= n) {
                return exprValue2;
            }
            if (n2 == 24 || n2 == 25 || n2 == 26) {
                if (exprValue2.isDoubleType()) {
                    exprValue2.setIntValue(exprValue2.getDoubleValue() != 0.0);
                } else if (exprValue2.isStringType()) {
                    try {
                        boolean bl2 = Util.getBoolean(interp, exprValue2.getStringValue());
                        exprValue2.setIntValue(bl2);
                    }
                    catch (TclException tclException) {
                        if (interp.noEval == 0) {
                            throw tclException;
                        }
                        exprValue2.setIntValue(0L);
                    }
                }
                if (n2 == 24 && exprValue2.getIntValue() == 0L || n2 == 25 && exprValue2.getIntValue() != 0L) {
                    ++interp.noEval;
                    try {
                        exprValue = this.ExprGetValue(interp, precTable[n2]);
                    }
                    finally {
                        --interp.noEval;
                    }
                    if (n2 != 25) continue;
                    exprValue2.setIntValue(1L);
                    continue;
                }
                if (n2 == 26) {
                    if (exprValue2.getIntValue() != 0L) {
                        exprValue2 = this.ExprGetValue(interp, precTable[26] - 1);
                        if (this.m_token != 27) {
                            this.SyntaxError(interp);
                        }
                        ++interp.noEval;
                        try {
                            exprValue = this.ExprGetValue(interp, precTable[26] - 1);
                        }
                        finally {
                            --interp.noEval;
                        }
                        continue;
                    }
                    ++interp.noEval;
                    try {
                        exprValue = this.ExprGetValue(interp, precTable[26] - 1);
                    }
                    finally {
                        --interp.noEval;
                    }
                    if (this.m_token != 27) {
                        this.SyntaxError(interp);
                    }
                    exprValue2 = this.ExprGetValue(interp, precTable[26] - 1);
                    continue;
                }
                exprValue = this.ExprGetValue(interp, precTable[n2]);
            } else {
                exprValue = this.ExprGetValue(interp, precTable[n2]);
            }
            if (exprValue == null) {
                this.SyntaxError(interp);
            }
            if (this.m_token < 8 && this.m_token != 0 && this.m_token != 4 && this.m_token != 3 && this.m_token != 2) {
                this.SyntaxError(interp);
            }
            if (interp.noEval != 0) continue;
            if (n2 == 27) {
                this.SyntaxError(interp);
            }
            Expression.evalBinaryOperator(interp, n2, exprValue2, exprValue);
            this.releaseExprValue(exprValue);
        }
    }

    public static void evalUnaryOperator(Interp interp, int n, ExprValue exprValue) throws TclException {
        switch (n) {
            case 30: {
                if (exprValue.isIntType()) {
                    exprValue.setIntValue(exprValue.getIntValue() * -1L);
                    break;
                }
                if (exprValue.isDoubleType()) {
                    exprValue.setDoubleValue(exprValue.getDoubleValue() * -1.0);
                    break;
                }
                Expression.IllegalType(interp, exprValue.getType(), n);
                break;
            }
            case 31: {
                if (exprValue.isIntOrDoubleType()) {
                    exprValue.nullStringValue();
                    break;
                }
                Expression.IllegalType(interp, exprValue.getType(), n);
                break;
            }
            case 32: {
                if (exprValue.isIntType()) {
                    exprValue.optIntUnaryNot();
                    break;
                }
                if (exprValue.isDoubleType()) {
                    exprValue.setIntValue(exprValue.getDoubleValue() == 0.0);
                    break;
                }
                if (exprValue.isStringType()) {
                    String string;
                    String string2 = exprValue.getStringValue();
                    int n2 = string2.length();
                    if (n2 == 0) {
                        Expression.EmptyStringOperandError(interp, n);
                    }
                    if ((string = Expression.getBooleanToken(string2)) != null && string.length() == n2) {
                        if ("true".startsWith(string) || "on".startsWith(string) || "yes".startsWith(string)) {
                            exprValue.setIntValue(0L);
                            break;
                        }
                        exprValue.setIntValue(1L);
                        break;
                    }
                    Expression.IllegalType(interp, exprValue.getType(), n);
                    break;
                }
                Expression.IllegalType(interp, exprValue.getType(), n);
                break;
            }
            case 33: {
                if (exprValue.isIntType()) {
                    exprValue.setIntValue(exprValue.getIntValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                Expression.IllegalType(interp, exprValue.getType(), n);
                break;
            }
            default: {
                throw new TclException(interp, "unknown operator in expression");
            }
        }
    }

    public static void evalBinaryOperator(Interp interp, int n, ExprValue exprValue, ExprValue exprValue2) throws TclException {
        int n2 = exprValue.getType();
        int n3 = exprValue2.getType();
        switch (n) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                if (n2 == 2 || n3 == 2) {
                    if (exprValue.getStringValue().length() == 0 || exprValue2.getStringValue().length() == 0) {
                        Expression.EmptyStringOperandError(interp, n);
                    }
                    Expression.IllegalType(interp, 2, n);
                    break;
                }
                if (n2 == 1) {
                    if (n3 != 0) break;
                    exprValue2.setDoubleValue(exprValue2.getIntValue());
                    n3 = 1;
                    break;
                }
                if (n3 != 1 || n2 != 0) break;
                exprValue.setDoubleValue(exprValue.getIntValue());
                n2 = 1;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: {
                if (n2 != 0) {
                    if (exprValue.getStringValue().length() == 0) {
                        Expression.EmptyStringOperandError(interp, n);
                    }
                    Expression.IllegalType(interp, exprValue.getType(), n);
                    break;
                }
                if (n3 == 0) break;
                if (exprValue2.getStringValue().length() == 0) {
                    Expression.EmptyStringOperandError(interp, n);
                }
                Expression.IllegalType(interp, exprValue2.getType(), n);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                if (n2 == n3) break;
                if (n2 == 2) {
                    if (n3 == 2) break;
                    exprValue2.toStringType();
                    n3 = 2;
                    break;
                }
                if (n3 == 2) {
                    if (n2 == 2) break;
                    exprValue.toStringType();
                    n2 = 2;
                    break;
                }
                if (n2 == 1) {
                    if (n3 != 0) break;
                    exprValue2.setDoubleValue(exprValue2.getIntValue());
                    n3 = 1;
                    break;
                }
                if (n3 != 1 || n2 != 0) break;
                exprValue.setDoubleValue(exprValue.getIntValue());
                n2 = 1;
                break;
            }
            case 28: {
                exprValue.setIntValue(exprValue.getStringValue().equals(exprValue2.getStringValue()));
                return;
            }
            case 29: {
                exprValue.setIntValue(!exprValue.getStringValue().equals(exprValue2.getStringValue()));
                return;
            }
            case 24: 
            case 25: {
                if (n2 == 2) {
                    Expression.IllegalType(interp, 2, n);
                }
                if (n3 != 2) break;
                boolean bl = Util.getBoolean(interp, exprValue2.getStringValue());
                exprValue2.setIntValue(bl);
                break;
            }
            case 26: 
            case 27: {
                break;
            }
            default: {
                throw new TclException(interp, "unknown operator in expression");
            }
        }
        switch (n) {
            case 8: {
                if (n2 == 0) {
                    exprValue.optIntMult(exprValue2);
                    break;
                }
                exprValue.optDoubleMult(exprValue2);
                break;
            }
            case 9: {
                if (n2 == 0) {
                    long l;
                    if (exprValue2.getIntValue() == 0L) {
                        Expression.DivideByZero(interp);
                    }
                    long l2 = exprValue.getIntValue();
                    long l3 = exprValue2.getIntValue();
                    if (l2 == Long.MIN_VALUE && l3 == -1L) {
                        l = Long.MIN_VALUE;
                    } else {
                        l = l2 / l3;
                        if ((l < 0L || l == 0L && (l2 < 0L && l3 > 0L || l2 > 0L && l3 < 0L)) && l * l3 != l2) {
                            --l;
                        }
                    }
                    exprValue.setIntValue(l);
                    break;
                }
                double d = exprValue2.getDoubleValue();
                if (d == 0.0) {
                    Expression.DivideByZero(interp);
                }
                exprValue.setDoubleValue(exprValue.getDoubleValue() / d);
                break;
            }
            case 10: {
                long l;
                boolean bl = false;
                if (exprValue2.getIntValue() == 0L) {
                    Expression.DivideByZero(interp);
                }
                long l4 = exprValue.getIntValue();
                long l5 = exprValue2.getIntValue();
                if (l4 == Long.MIN_VALUE && l5 == -1L) {
                    l = 0L;
                } else {
                    if (l5 < 0L) {
                        l5 = -l5;
                        l4 = -l4;
                        bl = true;
                    }
                    if (!((l = l4 % l5) >= 0L || bl && l4 == Long.MIN_VALUE)) {
                        l += l5;
                    }
                }
                if (bl && l > 0L || !bl && l < 0L) {
                    l = -l;
                }
                exprValue.setIntValue(l);
                break;
            }
            case 11: {
                if (n2 == 0) {
                    exprValue.optIntPlus(exprValue2);
                    break;
                }
                exprValue.optDoublePlus(exprValue2);
                break;
            }
            case 12: {
                if (n2 == 0) {
                    exprValue.optIntMinus(exprValue2);
                    break;
                }
                exprValue.optDoubleMinus(exprValue2);
                break;
            }
            case 13: {
                long l = exprValue.getIntValue();
                long l6 = exprValue2.getIntValue();
                l = l6 >= 64L ? 0L : (l <<= (int)l6);
                exprValue.setIntValue(l);
                break;
            }
            case 14: {
                long l = exprValue.getIntValue();
                long l7 = exprValue2.getIntValue();
                l = l7 >= 64L ? (l < 0L ? -1L : 0L) : (l >>= (int)l7);
                exprValue.setIntValue(l);
                break;
            }
            case 15: {
                if (n2 == 0) {
                    exprValue.optIntLess(exprValue2);
                    break;
                }
                if (n2 == 1) {
                    exprValue.optDoubleLess(exprValue2);
                    break;
                }
                exprValue.setIntValue(exprValue.getStringValue().compareTo(exprValue2.getStringValue()) < 0);
                break;
            }
            case 16: {
                if (n2 == 0) {
                    exprValue.optIntGreater(exprValue2);
                    break;
                }
                if (n2 == 1) {
                    exprValue.optDoubleGreater(exprValue2);
                    break;
                }
                exprValue.setIntValue(exprValue.getStringValue().compareTo(exprValue2.getStringValue()) > 0);
                break;
            }
            case 17: {
                if (n2 == 0) {
                    exprValue.optIntLessEq(exprValue2);
                    break;
                }
                if (n2 == 1) {
                    exprValue.optDoubleLessEq(exprValue2);
                    break;
                }
                exprValue.setIntValue(exprValue.getStringValue().compareTo(exprValue2.getStringValue()) <= 0);
                break;
            }
            case 18: {
                if (n2 == 0) {
                    exprValue.optIntGreaterEq(exprValue2);
                    break;
                }
                if (n2 == 1) {
                    exprValue.optDoubleGreaterEq(exprValue2);
                    break;
                }
                exprValue.setIntValue(exprValue.getStringValue().compareTo(exprValue2.getStringValue()) >= 0);
                break;
            }
            case 19: {
                if (n2 == 0) {
                    exprValue.optIntEq(exprValue2);
                    break;
                }
                if (n2 == 1) {
                    exprValue.optDoubleEq(exprValue2);
                    break;
                }
                exprValue.setIntValue(exprValue.getStringValue().equals(exprValue2.getStringValue()));
                break;
            }
            case 20: {
                if (n2 == 0) {
                    exprValue.optIntNotEq(exprValue2);
                    break;
                }
                if (n2 == 1) {
                    exprValue.optDoubleNotEq(exprValue2);
                    break;
                }
                exprValue.setIntValue(!exprValue.getStringValue().equals(exprValue2.getStringValue()));
                break;
            }
            case 21: {
                exprValue.setIntValue(exprValue.getIntValue() & exprValue2.getIntValue());
                break;
            }
            case 22: {
                exprValue.setIntValue(exprValue.getIntValue() ^ exprValue2.getIntValue());
                break;
            }
            case 23: {
                exprValue.setIntValue(exprValue.getIntValue() | exprValue2.getIntValue());
                break;
            }
            case 24: {
                if (n3 == 1) {
                    exprValue2.setIntValue(exprValue2.getDoubleValue() != 0.0);
                }
                exprValue.setIntValue(exprValue.getIntValue() != 0L && exprValue2.getIntValue() != 0L);
                break;
            }
            case 25: {
                if (n3 == 1) {
                    exprValue2.setIntValue(exprValue2.getDoubleValue() != 0.0);
                }
                exprValue.setIntValue(exprValue.getIntValue() != 0L || exprValue2.getIntValue() != 0L);
            }
        }
    }

    private ExprValue ExprLex(Interp interp) throws TclException {
        Object object;
        char c;
        while (this.m_ind < this.m_len && ((c = this.m_expr.charAt(this.m_ind)) == ' ' || Character.isWhitespace(c))) {
            ++this.m_ind;
        }
        if (this.m_ind >= this.m_len) {
            this.m_token = 4;
            return null;
        }
        c = this.m_expr.charAt(this.m_ind);
        char c2 = this.m_ind < this.m_len - 1 ? this.m_expr.charAt(this.m_ind + 1) : (char)'\u0000';
        if (c != '+' && c != '-') {
            boolean bl;
            if (this.m_ind == this.m_len - 1) {
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ++this.m_ind;
                        this.m_token = 0;
                        ExprValue exprValue = this.grabExprValue();
                        exprValue.setIntValue(c - 48, String.valueOf(c));
                        return exprValue;
                    }
                }
            }
            if ((bl = Character.isDigit(c)) && Expression.looksLikeInt(this.m_expr, this.m_len, this.m_ind, false)) {
                object = interp.strtoulResult;
                Util.strtoul(this.m_expr, this.m_ind, 0, (StrtoulResult)object);
                if (((StrtoulResult)object).errno == 0) {
                    String string = this.m_expr.substring(this.m_ind, ((StrtoulResult)object).index);
                    this.m_ind = ((StrtoulResult)object).index;
                    this.m_token = 0;
                    ExprValue exprValue = this.grabExprValue();
                    exprValue.setIntValue(((StrtoulResult)object).value, string);
                    return exprValue;
                }
                if (((StrtoulResult)object).errno == -2) {
                    Expression.IntegerTooLarge(interp);
                }
            } else if (bl || c == '.' || c == 'n' || c == 'N') {
                object = interp.strtodResult;
                Util.strtod(this.m_expr, this.m_ind, -1, (StrtodResult)object);
                if (((StrtodResult)object).errno == 0) {
                    String string = this.m_expr.substring(this.m_ind, ((StrtodResult)object).index);
                    this.m_ind = ((StrtodResult)object).index;
                    this.m_token = 0;
                    ExprValue exprValue = this.grabExprValue();
                    exprValue.setDoubleValue(((StrtodResult)object).value, string);
                    return exprValue;
                }
                if (((StrtodResult)object).errno == -4) {
                    if (((StrtodResult)object).value != 0.0) {
                        Expression.DoubleTooLarge(interp);
                    } else {
                        Expression.DoubleTooSmall(interp);
                    }
                }
            }
        }
        ++this.m_ind;
        switch (c) {
            case '$': {
                this.m_token = 0;
                ParseResult parseResult = ParseAdaptor.parseVar(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = parseResult.nextIndex;
                if (interp.noEval != 0) {
                    object = this.grabExprValue();
                    ((ExprValue)object).setIntValue(0L);
                } else {
                    object = this.grabExprValue();
                    Expression.ExprParseObject(interp, parseResult.value, (ExprValue)object);
                }
                parseResult.release();
                return object;
            }
            case '[': {
                this.m_token = 0;
                ParseResult parseResult = ParseAdaptor.parseNestedCmd(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = parseResult.nextIndex;
                if (interp.noEval != 0) {
                    object = this.grabExprValue();
                    ((ExprValue)object).setIntValue(0L);
                } else {
                    object = this.grabExprValue();
                    Expression.ExprParseObject(interp, parseResult.value, (ExprValue)object);
                }
                parseResult.release();
                return object;
            }
            case '\"': {
                this.m_token = 0;
                ParseResult parseResult = ParseAdaptor.parseQuotes(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = parseResult.nextIndex;
                if (interp.noEval != 0) {
                    object = this.grabExprValue();
                    ((ExprValue)object).setIntValue(0L);
                } else {
                    object = this.grabExprValue();
                    Expression.ExprParseObject(interp, parseResult.value, (ExprValue)object);
                }
                parseResult.release();
                return object;
            }
            case '{': {
                this.m_token = 0;
                ParseResult parseResult = ParseAdaptor.parseBraces(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = parseResult.nextIndex;
                if (interp.noEval != 0) {
                    object = this.grabExprValue();
                    ((ExprValue)object).setIntValue(0L);
                } else {
                    object = this.grabExprValue();
                    Expression.ExprParseObject(interp, parseResult.value, (ExprValue)object);
                }
                parseResult.release();
                return object;
            }
            case '(': {
                this.m_token = 1;
                return null;
            }
            case ')': {
                this.m_token = 2;
                return null;
            }
            case ',': {
                this.m_token = 3;
                return null;
            }
            case '*': {
                this.m_token = 8;
                return null;
            }
            case '/': {
                this.m_token = 9;
                return null;
            }
            case '%': {
                this.m_token = 10;
                return null;
            }
            case '+': {
                this.m_token = 11;
                return null;
            }
            case '-': {
                this.m_token = 12;
                return null;
            }
            case '?': {
                this.m_token = 26;
                return null;
            }
            case ':': {
                this.m_token = 27;
                return null;
            }
            case '<': {
                switch (c2) {
                    case '<': {
                        ++this.m_ind;
                        this.m_token = 13;
                        break;
                    }
                    case '=': {
                        ++this.m_ind;
                        this.m_token = 17;
                        break;
                    }
                    default: {
                        this.m_token = 15;
                    }
                }
                return null;
            }
            case '>': {
                switch (c2) {
                    case '>': {
                        ++this.m_ind;
                        this.m_token = 14;
                        break;
                    }
                    case '=': {
                        ++this.m_ind;
                        this.m_token = 18;
                        break;
                    }
                    default: {
                        this.m_token = 16;
                    }
                }
                return null;
            }
            case '=': {
                if (c2 == '=') {
                    ++this.m_ind;
                    this.m_token = 19;
                } else {
                    this.m_token = 5;
                }
                return null;
            }
            case '!': {
                if (c2 == '=') {
                    ++this.m_ind;
                    this.m_token = 20;
                } else {
                    this.m_token = 32;
                }
                return null;
            }
            case '&': {
                if (c2 == '&') {
                    ++this.m_ind;
                    this.m_token = 24;
                } else {
                    this.m_token = 21;
                }
                return null;
            }
            case '^': {
                this.m_token = 22;
                return null;
            }
            case '|': {
                if (c2 == '|') {
                    ++this.m_ind;
                    this.m_token = 25;
                } else {
                    this.m_token = 23;
                }
                return null;
            }
            case '~': {
                this.m_token = 33;
                return null;
            }
            case 'e': 
            case 'n': {
                if (c == 'e' && c2 == 'q') {
                    ++this.m_ind;
                    this.m_token = 28;
                    return null;
                }
                if (c != 'n' || c2 != 'e') break;
                ++this.m_ind;
                this.m_token = 29;
                return null;
            }
        }
        if (Character.isLetter(c)) {
            String string;
            int n;
            --this.m_ind;
            String string2 = this.m_expr.substring(this.m_ind);
            boolean bl = false;
            int n2 = string2.length();
            for (n = 0; n < n2 && (Character.isLetterOrDigit(c = string2.charAt(n)) || c == '_'); ++n) {
            }
            while (n < n2 && ((c = string2.charAt(n)) == ' ' || Character.isWhitespace(c))) {
                ++n;
            }
            if (n < n2 && string2.charAt(n) == '(') {
                bl = true;
            }
            if (!bl && (string = Expression.getBooleanToken(string2)) != null) {
                this.m_ind += string.length();
                this.m_token = 0;
                ExprValue exprValue = this.grabExprValue();
                exprValue.setStringValue(string);
                return exprValue;
            }
            return this.mathFunction(interp);
        }
        this.m_token = 5;
        return null;
    }

    ExprValue mathFunction(Interp interp) throws TclException {
        int n = this.m_ind;
        ExprValue[] exprValueArray = null;
        while (this.m_ind < this.m_len && (Character.isLetterOrDigit(this.m_expr.charAt(this.m_ind)) || this.m_expr.charAt(this.m_ind) == '_')) {
            ++this.m_ind;
        }
        String string = this.m_expr.substring(n, this.m_ind);
        MathFunction mathFunction = this.mathFuncTable.get(string);
        this.ExprLex(interp);
        if (this.m_token != 1) {
            if (mathFunction == null) {
                this.SyntaxError(interp, "variable references require preceding $");
            } else {
                this.SyntaxError(interp, "expected parenthesis enclosing function arguments");
            }
        }
        if (mathFunction == null) {
            throw new TclException(interp, "unknown math function \"" + string + "\"");
        }
        int n2 = mathFunction.argTypes.length;
        if (n2 == 0) {
            this.ExprLex(interp);
            if (this.m_token != 2) {
                this.SyntaxError(interp, "missing close parenthesis at end of function call");
            }
        } else {
            exprValueArray = new ExprValue[n2];
            int n3 = 0;
            while (true) {
                ExprValue exprValue;
                if ((exprValue = this.ExprGetValue(interp, -1)) == null && this.m_token == 2) {
                    if (n3 == n2) break;
                    throw new TclException(interp, "too few arguments for math function");
                }
                exprValueArray[n3] = exprValue;
                if (n3 == n2 - 1) {
                    if (this.m_token == 2) break;
                    if (this.m_token == 3) {
                        throw new TclException(interp, "too many arguments for math function");
                    }
                    this.SyntaxError(interp, "missing close parenthesis at end of function call");
                }
                if (this.m_token != 3) {
                    if (this.m_token == 2) {
                        throw new TclException(interp, "too few arguments for math function");
                    }
                    this.SyntaxError(interp);
                }
                ++n3;
            }
        }
        this.m_token = 0;
        if (interp.noEval != 0) {
            ExprValue exprValue = this.grabExprValue();
            exprValue.setIntValue(0L);
            return exprValue;
        }
        ExprValue exprValue = this.grabExprValue();
        this.evalMathFunction(interp, string, mathFunction, exprValueArray, true, exprValue);
        return exprValue;
    }

    public void evalMathFunction(Interp interp, String string, ExprValue[] exprValueArray, boolean bl, ExprValue exprValue) throws TclException {
        MathFunction mathFunction = this.mathFuncTable.get(string);
        if (mathFunction == null) {
            throw new TclException(interp, "unknown math function \"" + string + "\"");
        }
        this.evalMathFunction(interp, string, mathFunction, exprValueArray, bl, exprValue);
    }

    void evalMathFunction(Interp interp, String string, MathFunction mathFunction, ExprValue[] exprValueArray, boolean bl, ExprValue exprValue) throws TclException {
        int n;
        if (mathFunction.argTypes == null) {
            throw new TclRuntimeError("math function \"" + string + "\" has null argTypes");
        }
        int n2 = mathFunction.argTypes.length;
        int n3 = 0;
        if (exprValueArray != null) {
            n3 = exprValueArray.length;
        }
        if (n2 != n3) {
            if (n3 > 0 && n3 < n2) {
                throw new TclException(interp, "too few arguments for math function");
            }
            throw new TclException(interp, "too many arguments for math function");
        }
        if (exprValueArray != null) {
            for (n = 0; n < exprValueArray.length; ++n) {
                ExprValue exprValue2 = exprValueArray[n];
                if (exprValue2.isStringType()) {
                    throw new TclException(interp, "argument to math function didn't have numeric value");
                }
                if (exprValue2.isIntType()) {
                    if (mathFunction.argTypes[n] != 1) continue;
                    exprValue2.setDoubleValue(exprValue2.getIntValue());
                    continue;
                }
                if (mathFunction.argTypes[n] != 0) continue;
                exprValue2.setIntValue((long)exprValue2.getDoubleValue());
            }
        }
        if (mathFunction instanceof NoArgMathFunction) {
            ((NoArgMathFunction)mathFunction).apply(interp, exprValue);
        } else {
            mathFunction.apply(interp, exprValueArray);
            if (exprValue != null) {
                exprValue.setValue(exprValueArray[0]);
            }
        }
        if (bl && exprValueArray != null) {
            for (n = 0; n < exprValueArray.length; ++n) {
                this.releaseExprValue(exprValueArray[n]);
            }
        }
    }

    void registerMathFunction(String string, MathFunction mathFunction) {
        this.mathFuncTable.put(string, mathFunction);
    }

    public static boolean looksLikeInt(String string, int n, int n2, boolean bl) {
        char c = '\u0000';
        while (n2 < n && ((c = string.charAt(n2)) == ' ' || Character.isWhitespace(c))) {
            ++n2;
        }
        if (n2 >= n) {
            return false;
        }
        if (c == '+' || c == '-') {
            if (++n2 >= n) {
                return false;
            }
            c = string.charAt(n2);
        }
        if (c >= '0' && c <= '9' || Character.isDigit(c)) {
            ++n2;
        } else {
            return false;
        }
        while (n2 < n && ((c = string.charAt(n2)) >= '0' && c <= '9' || Character.isDigit(c))) {
            ++n2;
        }
        if (n2 >= n) {
            return true;
        }
        if (!bl && c != '.' && c != 'E' && c != 'e') {
            return true;
        }
        if (c == 'e' || c == 'E') {
            if (bl) {
                return false;
            }
            if (n2 + 1 >= n) {
                return true;
            }
            c = string.charAt(n2 + 1);
            if (c != '+' && c != '-' && !Character.isDigit(c)) {
                return true;
            }
        }
        if (bl) {
            while (n2 < n && ((c = string.charAt(n2)) == ' ' || Character.isWhitespace(c))) {
                ++n2;
            }
            if (n2 >= n) {
                return true;
            }
        }
        return false;
    }

    static void checkIntegerRange(Interp interp, double d) throws TclException {
        if (d < 0.0) {
            if (d < -9.223372036854776E18) {
                Expression.IntegerTooLarge(interp);
            }
        } else if (d > 9.223372036854776E18) {
            Expression.IntegerTooLarge(interp);
        }
    }

    static void checkDoubleRange(Interp interp, double d) throws TclException {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            Expression.DoubleTooLarge(interp);
        }
    }

    static String getBooleanToken(String string) {
        int n = string.length();
        if (n == 0) {
            return null;
        }
        char c = string.charAt(0);
        switch (c) {
            case 'f': {
                if (string.startsWith("false")) {
                    return "false";
                }
                if (string.startsWith("fals")) {
                    return "fals";
                }
                if (string.startsWith("fal")) {
                    return "fal";
                }
                if (string.startsWith("fa")) {
                    return "fa";
                }
                if (string.startsWith("f")) {
                    return "f";
                }
            }
            case 'n': {
                if (string.startsWith("no")) {
                    return "no";
                }
                if (string.startsWith("n")) {
                    return "n";
                }
            }
            case 'o': {
                if (string.startsWith("off")) {
                    return "off";
                }
                if (string.startsWith("of")) {
                    return "of";
                }
                if (string.startsWith("on")) {
                    return "on";
                }
            }
            case 't': {
                if (string.startsWith("true")) {
                    return "true";
                }
                if (string.startsWith("tru")) {
                    return "tru";
                }
                if (string.startsWith("tr")) {
                    return "tr";
                }
                if (string.startsWith("t")) {
                    return "t";
                }
            }
            case 'y': {
                if (string.startsWith("yes")) {
                    return "yes";
                }
                if (string.startsWith("ye")) {
                    return "ye";
                }
                if (!string.startsWith("y")) break;
                return "y";
            }
        }
        return null;
    }

    public final ExprValue grabExprValue() {
        if (this.cachedExprIndex == 50) {
            return new ExprValue(0L, null);
        }
        return this.cachedExprValue[this.cachedExprIndex++];
    }

    public final void releaseExprValue(ExprValue exprValue) {
        if (this.cachedExprIndex > 0) {
            this.cachedExprValue[--this.cachedExprIndex] = exprValue;
        }
    }
}

