/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Notifier;

public abstract class IdleHandler {
    Notifier notifier;
    boolean isCancelled;
    int generation;

    public IdleHandler() {
        this.isCancelled = false;
        this.generation = 0;
        this.notifier = null;
    }

    public IdleHandler(Notifier notifier) {
        this.register(notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Notifier notifier) {
        this.notifier = notifier;
        this.isCancelled = false;
        Notifier notifier2 = this.notifier;
        synchronized (notifier2) {
            this.notifier.idleList.add(this);
            this.generation = this.notifier.idleGeneration;
            if (Thread.currentThread() != this.notifier.primaryThread) {
                this.notifier.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            for (int i = 0; i < this.notifier.idleList.size(); ++i) {
                if (this.notifier.idleList.get(i) != this) continue;
                this.notifier.idleList.remove(i);
                return;
            }
        }
    }

    final synchronized int invoke() {
        if (!this.isCancelled) {
            this.processIdleEvent();
            return 1;
        }
        return 0;
    }

    public abstract void processIdleEvent();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("IdleHandler.generation is " + this.generation + "\n");
        return stringBuffer.toString();
    }
}

