/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import tcl.lang.AssocData;
import tcl.lang.BackSlashResult;
import tcl.lang.BgErrorMgr;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandTrace;
import tcl.lang.CommandWithDispose;
import tcl.lang.DebugInfo;
import tcl.lang.Env;
import tcl.lang.EventuallyFreed;
import tcl.lang.ExecutionTrace;
import tcl.lang.Expression;
import tcl.lang.Extension;
import tcl.lang.FileUtil;
import tcl.lang.ImportRef;
import tcl.lang.ImportedCmdData;
import tcl.lang.ManagedSystemInStream;
import tcl.lang.Namespace;
import tcl.lang.Notifier;
import tcl.lang.PackageNameException;
import tcl.lang.Parser;
import tcl.lang.Procedure;
import tcl.lang.Resolver;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclClassLoader;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclInterruptedException;
import tcl.lang.TclInterruptedExceptionEvent;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.VarTrace;
import tcl.lang.WrappedCommand;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileChannel;
import tcl.lang.channel.ReadInputStreamChannel;
import tcl.lang.cmd.EncodingCmd;
import tcl.lang.cmd.InterpAliasCmd;
import tcl.lang.cmd.InterpSlaveCmd;
import tcl.lang.cmd.PackageCmd;
import tcl.lang.cmd.RegexpCmd;

public class Interp
extends EventuallyFreed {
    public HashMap reflectObjTable = new HashMap();
    public long reflectObjCount = 0L;
    public HashMap reflectConflictTable = new HashMap();
    private static final int MAX_ERR_LENGTH = 200;
    public static final String TCL_VERSION = "8.4";
    public static final String TCL_PATCH_LEVEL = "8.4.0";
    public int cmdCount;
    public HashMap<String, Channel> interpChanTable;
    public boolean systemEncodingChangesStdoutStderr = true;
    private Notifier notifier;
    HashMap<String, AssocData> assocData;
    private File workingDir;
    public CallFrame frame;
    public CallFrame varFrame;
    Namespace globalNs;
    public HashMap hiddenCmdTable;
    public HashMap slaveTable;
    public HashMap targetTable;
    public InterpSlaveCmd slave;
    public HashMap aliasTable;
    public String scriptFile;
    public int nestLevel;
    private int maxNestingDepth = 1000;
    public int evalFlags;
    int flags;
    public boolean isSafe;
    public int termOffset;
    ArrayList resolvers;
    public Expression expr;
    int noEval;
    boolean randSeedInit;
    long randSeed;
    public String errorInfo;
    public String errorCode;
    public int returnCode;
    protected boolean deleted;
    public boolean errInProgress;
    public boolean errAlreadyLogged;
    protected boolean errCodeSet;
    public int errorLine = 0;
    private TclObject m_result;
    private final TclObject m_nullResult;
    private final TclObject m_falseBooleanResult;
    private final TclObject m_trueBooleanResult;
    private final TclObject m_minusoneIntegerResult;
    private final TclObject m_zeroIntegerResult;
    private final TclObject m_oneIntegerResult;
    private final TclObject m_twoIntegerResult;
    private final TclObject m_zeroDoubleResult;
    private final TclObject m_onehalfDoubleResult;
    private final TclObject m_oneDoubleResult;
    private final TclObject m_twoDoubleResult;
    private static final boolean VALIDATE_SHARED_RESULTS = false;
    private TclObject recycledI;
    private TclObject recycledD;
    private final TclObject[] m_charCommon;
    private final int m_charCommonMax = 128;
    private Thread cThread;
    private String cThreadName;
    public HashMap packageTable;
    public String packageUnknown;
    TclObject[][][] parserObjv;
    int[] parserObjvUsed;
    TclToken[] parserTokens;
    int parserTokensUsed;
    public HashMap[] importTable = new HashMap[]{new HashMap(), new HashMap(), new HashMap()};
    public StrtoulResult strtoulResult = new StrtoulResult();
    public StrtodResult strtodResult = new StrtodResult();
    public Namespace.GetNamespaceForQualNameResult getnfqnResult = new Namespace.GetNamespaceForQualNameResult();
    Var[] lookupVarResult = new Var[2];
    static final String[] unsafeCmds = new String[]{"encoding", "exit", "load", "cd", "fconfigure", "file", "glob", "open", "pwd", "socket", "beep", "echo", "ls", "resource", "source", "exec", "jaclloadjava", "jaclloadtjc", "auto_execok", "auto_import", "auto_load", "auto_load_index", "auto_qualify"};
    public static final int INVOKE_HIDDEN = 1;
    public static final int INVOKE_NO_UNKNOWN = 2;
    public static final int INVOKE_NO_TRACEBACK = 4;
    TclClassLoader classLoader = null;
    static HashMap tclLibraryScripts = new HashMap();
    private TclInterruptedExceptionEvent interruptedEvent = null;
    ArrayList<WrappedCommand> activeExecutionStepTraces = null;
    boolean stepTracingEnabled = true;
    public static ManagedSystemInStream systemIn = new ManagedSystemInStream();
    private String nameOfExecutable = null;
    private String shellClassName;
    protected DebugInfo dbg;

    public Interp() {
        StackTraceElement[] stackTraceElementArray;
        this.m_nullResult = TclString.newInstance("");
        this.m_nullResult.preserve();
        this.m_nullResult.preserve();
        this.m_result = this.m_nullResult;
        this.m_minusoneIntegerResult = TclInteger.newInstance(-1L);
        this.m_minusoneIntegerResult.preserve();
        this.m_minusoneIntegerResult.preserve();
        this.m_zeroIntegerResult = TclInteger.newInstance(0L);
        this.m_zeroIntegerResult.preserve();
        this.m_zeroIntegerResult.preserve();
        this.m_oneIntegerResult = TclInteger.newInstance(1L);
        this.m_oneIntegerResult.preserve();
        this.m_oneIntegerResult.preserve();
        this.m_falseBooleanResult = this.m_zeroIntegerResult;
        this.m_trueBooleanResult = this.m_oneIntegerResult;
        this.m_twoIntegerResult = TclInteger.newInstance(2L);
        this.m_twoIntegerResult.preserve();
        this.m_twoIntegerResult.preserve();
        this.m_zeroDoubleResult = TclDouble.newInstance(0.0);
        this.m_zeroDoubleResult.preserve();
        this.m_zeroDoubleResult.preserve();
        this.m_onehalfDoubleResult = TclDouble.newInstance(0.5);
        this.m_onehalfDoubleResult.preserve();
        this.m_onehalfDoubleResult.preserve();
        this.m_oneDoubleResult = TclDouble.newInstance(1.0);
        this.m_oneDoubleResult.preserve();
        this.m_oneDoubleResult.preserve();
        this.m_twoDoubleResult = TclDouble.newInstance(2.0);
        this.m_twoDoubleResult.preserve();
        this.m_twoDoubleResult.preserve();
        this.m_charCommon = new TclObject[128];
        for (int i = 0; i < 128; ++i) {
            stackTraceElementArray = null;
            if (i < 32 && (i == 9 || i == 13 || i == 10) || i >= 32 && i <= 126) {
                String string = "" + (char)i;
                string = string.intern();
                stackTraceElementArray = TclString.newInstance(string);
            }
            this.m_charCommon[i] = stackTraceElementArray;
            if (stackTraceElementArray == null) continue;
            stackTraceElementArray.preserve();
            stackTraceElementArray.preserve();
        }
        this.recycledI = TclInteger.newInstance(0L);
        this.recycledI.preserve();
        this.recycledD = TclDouble.newInstance(0.0);
        this.recycledD.preserve();
        this.expr = new Expression();
        this.nestLevel = 0;
        this.frame = null;
        this.varFrame = null;
        this.returnCode = 0;
        this.errorInfo = null;
        this.errorCode = null;
        this.packageTable = new HashMap();
        this.packageUnknown = null;
        this.cmdCount = 0;
        this.termOffset = 0;
        this.resolvers = null;
        this.evalFlags = 0;
        this.scriptFile = null;
        this.flags = 0;
        this.isSafe = false;
        this.assocData = null;
        this.globalNs = null;
        this.globalNs = Namespace.createNamespace(this, null, null);
        if (this.globalNs == null) {
            throw new TclRuntimeError("Interp(): can't create global namespace");
        }
        this.workingDir = new File(Util.tryGetSystemProperty("user.dir", "."));
        this.noEval = 0;
        this.cThread = Thread.currentThread();
        this.cThreadName = this.cThread.getName();
        this.notifier = Notifier.getNotifierForThread(this.cThread);
        this.notifier.preserve();
        this.randSeedInit = false;
        this.deleted = false;
        this.errInProgress = false;
        this.errAlreadyLogged = false;
        this.errCodeSet = false;
        this.dbg = this.initDebugInfo();
        this.slaveTable = new HashMap();
        this.targetTable = new HashMap();
        this.aliasTable = new HashMap();
        Throwable throwable = new Throwable();
        stackTraceElementArray = throwable.getStackTrace();
        this.shellClassName = stackTraceElementArray[stackTraceElementArray.length - 1].getClassName();
        Parser.init(this);
        TclParse.init(this);
        this.interpChanTable = TclIO.getInterpChanTable(this);
        Util.setupPrecisionTrace(this);
        this.createCommands();
        try {
            this.setVar("tcl_platform", "engine", "JTcl", 1);
            this.setVar("tcl_platform", "platform", "java", 1);
            this.setVar("tcl_platform", "byteOrder", "bigEndian", 1);
            this.setVar("tcl_platform", "user", Util.tryGetSystemProperty("user.name", "unknown"), 1);
            this.setVar("tcl_platform", "os", Util.tryGetSystemProperty("os.name", "?"), 1);
            this.setVar("tcl_platform", "osVersion", Util.tryGetSystemProperty("os.version", "?"), 1);
            this.setVar("tcl_platform", "machine", Util.tryGetSystemProperty("os.arch", "?"), 1);
            this.setVar("tcl_version", TCL_VERSION, 1);
            this.setVar("tcl_patchLevel", TCL_PATCH_LEVEL, 1);
            this.setVar("tcl_library", "resource:/tcl/lang/library", 1);
            if (Util.isWindows()) {
                this.setVar("tcl_platform", "host_platform", "windows", 1);
            } else if (Util.isMac()) {
                this.setVar("tcl_platform", "host_platform", "macintosh", 1);
            } else {
                this.setVar("tcl_platform", "host_platform", "unix", 1);
            }
            Env.initialize(this);
            this.pkgProvide("Tcl", TCL_VERSION);
            this.evalResource("/tcl/lang/library/init.tcl");
        }
        catch (TclException tclException) {
            System.out.println(this.getResult());
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    @Override
    public void dispose() {
        if (Thread.currentThread() != this.cThread) {
            throw new TclRuntimeError("Interp.dispose() invoked in thread other than the one it was created in");
        }
        if (!this.deleted) {
            this.deleted = true;
        }
        super.dispose();
    }

    @Override
    public void eventuallyDispose() {
        Object object;
        if (!this.deleted) {
            throw new TclRuntimeError("eventuallyDispose called on interpreter not marked deleted");
        }
        if (this.nestLevel > 0) {
            throw new TclRuntimeError("dispose() called with active evals");
        }
        if (this.notifier == null) {
            throw new TclRuntimeError("eventuallyDispose() already invoked for " + this);
        }
        this.notifier.release();
        this.notifier = null;
        Namespace.teardownNamespace(this.globalNs);
        TclObject tclObject = null;
        TclObject tclObject2 = null;
        try {
            tclObject = this.getVar("errorInfo", null, 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        if (tclObject != null) {
            tclObject.preserve();
        }
        try {
            tclObject2 = this.getVar("errorCode", null, 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        if (tclObject2 != null) {
            tclObject2.preserve();
        }
        this.frame = null;
        this.varFrame = null;
        try {
            if (tclObject != null) {
                this.setVar("errorInfo", null, tclObject, 1);
                tclObject.release();
            }
            if (tclObject2 != null) {
                this.setVar("errorCode", null, tclObject2, 1);
                tclObject2.release();
            }
        }
        catch (TclException tclException) {
            // empty catch block
        }
        this.expr = null;
        while (this.assocData != null) {
            HashMap<String, AssocData> hashMap = this.assocData;
            this.assocData = null;
            Iterator object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                AssocData assocData = (AssocData)object.getValue();
                assocData.disposeAssocData(this);
                object2.remove();
            }
        }
        for (Map.Entry entry : this.interpChanTable.entrySet()) {
            object = (Channel)entry.getValue();
            try {
                ((Channel)object).close();
            }
            catch (IOException iOException) {}
        }
        this.interpChanTable.clear();
        this.interpChanTable = null;
        Namespace.deleteNamespace(this.globalNs);
        this.globalNs = null;
        this.frame = null;
        this.varFrame = null;
        this.resolvers = null;
        if (this.classLoader != null) {
            this.classLoader.dispose();
            this.classLoader = null;
        }
        systemIn.dispose();
        this.resetResult();
    }

    public void ready() throws TclException {
        this.resetResult();
        if (this.deleted) {
            this.setResult("attempt to call eval in deleted interpreter");
            this.setErrorCode(TclString.newInstance("CORE IDELETE {attempt to call eval in deleted interpreter}"));
            throw new TclException(1);
        }
        if (this.nestLevel >= this.maxNestingDepth) {
            Parser.infiniteLoopException(this);
        }
    }

    protected void createCommands() {
        Extension.loadOnDemand(this, "after", "tcl.lang.cmd.AfterCmd");
        Extension.loadOnDemand(this, "append", "tcl.lang.cmd.AppendCmd");
        Extension.loadOnDemand(this, "apply", "tcl.lang.cmd.ApplyCmd");
        Extension.loadOnDemand(this, "array", "tcl.lang.cmd.ArrayCmd");
        Extension.loadOnDemand(this, "binary", "tcl.lang.cmd.BinaryCmd");
        Extension.loadOnDemand(this, "break", "tcl.lang.cmd.BreakCmd");
        Extension.loadOnDemand(this, "case", "tcl.lang.cmd.CaseCmd");
        Extension.loadOnDemand(this, "catch", "tcl.lang.cmd.CatchCmd");
        Extension.loadOnDemand(this, "cd", "tcl.lang.cmd.CdCmd");
        Extension.loadOnDemand(this, "clock", "tcl.lang.cmd.ClockCmd");
        Extension.loadOnDemand(this, "close", "tcl.lang.cmd.CloseCmd");
        Extension.loadOnDemand(this, "continue", "tcl.lang.cmd.ContinueCmd");
        Extension.loadOnDemand(this, "concat", "tcl.lang.cmd.ConcatCmd");
        Extension.loadOnDemand(this, "dict", "tcl.lang.cmd.DictCmd");
        Extension.loadOnDemand(this, "encoding", "tcl.lang.cmd.EncodingCmd");
        Extension.loadOnDemand(this, "eof", "tcl.lang.cmd.EofCmd");
        Extension.loadOnDemand(this, "eval", "tcl.lang.cmd.EvalCmd");
        Extension.loadOnDemand(this, "error", "tcl.lang.cmd.ErrorCmd");
        if (!Util.isMac()) {
            Extension.loadOnDemand(this, "exec", "tcl.lang.cmd.ExecCmd");
        }
        Extension.loadOnDemand(this, "exit", "tcl.lang.cmd.ExitCmd");
        Extension.loadOnDemand(this, "expr", "tcl.lang.cmd.ExprCmd");
        Extension.loadOnDemand(this, "fblocked", "tcl.lang.cmd.FblockedCmd");
        Extension.loadOnDemand(this, "fconfigure", "tcl.lang.cmd.FconfigureCmd");
        Extension.loadOnDemand(this, "fcopy", "tcl.lang.cmd.FcopyCmd");
        Extension.loadOnDemand(this, "file", "tcl.lang.cmd.FileCmd");
        Extension.loadOnDemand(this, "fileevent", "tcl.lang.cmd.FileeventCmd");
        Extension.loadOnDemand(this, "flush", "tcl.lang.cmd.FlushCmd");
        Extension.loadOnDemand(this, "for", "tcl.lang.cmd.ForCmd");
        Extension.loadOnDemand(this, "foreach", "tcl.lang.cmd.ForeachCmd");
        Extension.loadOnDemand(this, "format", "tcl.lang.cmd.FormatCmd");
        Extension.loadOnDemand(this, "gets", "tcl.lang.cmd.GetsCmd");
        Extension.loadOnDemand(this, "global", "tcl.lang.cmd.GlobalCmd");
        Extension.loadOnDemand(this, "glob", "tcl.lang.cmd.GlobCmd");
        Extension.loadOnDemand(this, "if", "tcl.lang.cmd.IfCmd");
        Extension.loadOnDemand(this, "incr", "tcl.lang.cmd.IncrCmd");
        Extension.loadOnDemand(this, "info", "tcl.lang.cmd.InfoCmd");
        Extension.loadOnDemand(this, "interp", "tcl.lang.cmd.InterpCmd");
        Extension.loadOnDemand(this, "list", "tcl.lang.cmd.ListCmd");
        Extension.loadOnDemand(this, "join", "tcl.lang.cmd.JoinCmd");
        Extension.loadOnDemand(this, "lappend", "tcl.lang.cmd.LappendCmd");
        Extension.loadOnDemand(this, "lassign", "tcl.lang.cmd.LassignCmd");
        Extension.loadOnDemand(this, "lindex", "tcl.lang.cmd.LindexCmd");
        Extension.loadOnDemand(this, "linsert", "tcl.lang.cmd.LinsertCmd");
        Extension.loadOnDemand(this, "llength", "tcl.lang.cmd.LlengthCmd");
        Extension.loadOnDemand(this, "lrange", "tcl.lang.cmd.LrangeCmd");
        Extension.loadOnDemand(this, "lrepeat", "tcl.lang.cmd.LrepeatCmd");
        Extension.loadOnDemand(this, "lreplace", "tcl.lang.cmd.LreplaceCmd");
        Extension.loadOnDemand(this, "lreverse", "tcl.lang.cmd.LreverseCmd");
        Extension.loadOnDemand(this, "lsearch", "tcl.lang.cmd.LsearchCmd");
        Extension.loadOnDemand(this, "lset", "tcl.lang.cmd.LsetCmd");
        Extension.loadOnDemand(this, "lsort", "tcl.lang.cmd.LsortCmd");
        Extension.loadOnDemand(this, "namespace", "tcl.lang.cmd.NamespaceCmd");
        Extension.loadOnDemand(this, "open", "tcl.lang.cmd.OpenCmd");
        Extension.loadOnDemand(this, "package", "tcl.lang.cmd.PackageCmd");
        Extension.loadOnDemand(this, "pid", "tcl.lang.cmd.PidCmd");
        Extension.loadOnDemand(this, "proc", "tcl.lang.cmd.ProcCmd");
        Extension.loadOnDemand(this, "puts", "tcl.lang.cmd.PutsCmd");
        Extension.loadOnDemand(this, "pwd", "tcl.lang.cmd.PwdCmd");
        Extension.loadOnDemand(this, "read", "tcl.lang.cmd.ReadCmd");
        Extension.loadOnDemand(this, "regsub", "tcl.lang.cmd.RegsubCmd");
        Extension.loadOnDemand(this, "rename", "tcl.lang.cmd.RenameCmd");
        Extension.loadOnDemand(this, "return", "tcl.lang.cmd.ReturnCmd");
        Extension.loadOnDemand(this, "scan", "tcl.lang.cmd.ScanCmd");
        Extension.loadOnDemand(this, "seek", "tcl.lang.cmd.SeekCmd");
        Extension.loadOnDemand(this, "set", "tcl.lang.cmd.SetCmd");
        Extension.loadOnDemand(this, "socket", "tcl.lang.cmd.SocketCmd");
        Extension.loadOnDemand(this, "source", "tcl.lang.cmd.SourceCmd");
        Extension.loadOnDemand(this, "split", "tcl.lang.cmd.SplitCmd");
        Extension.loadOnDemand(this, "string", "tcl.lang.cmd.StringCmd");
        Extension.loadOnDemand(this, "subst", "tcl.lang.cmd.SubstCmd");
        Extension.loadOnDemand(this, "switch", "tcl.lang.cmd.SwitchCmd");
        Extension.loadOnDemand(this, "tell", "tcl.lang.cmd.TellCmd");
        Extension.loadOnDemand(this, "time", "tcl.lang.cmd.TimeCmd");
        Extension.loadOnDemand(this, "trace", "tcl.lang.cmd.TraceCmd");
        Extension.loadOnDemand(this, "unset", "tcl.lang.cmd.UnsetCmd");
        Extension.loadOnDemand(this, "update", "tcl.lang.cmd.UpdateCmd");
        Extension.loadOnDemand(this, "uplevel", "tcl.lang.cmd.UplevelCmd");
        Extension.loadOnDemand(this, "upvar", "tcl.lang.cmd.UpvarCmd");
        Extension.loadOnDemand(this, "variable", "tcl.lang.cmd.VariableCmd");
        Extension.loadOnDemand(this, "vwait", "tcl.lang.cmd.VwaitCmd");
        Extension.loadOnDemand(this, "while", "tcl.lang.cmd.WhileCmd");
        RegexpCmd.init(this);
        try {
            this.eval("package ifneeded tcltest 1.0 {source resource:/tcl/lang/library/tcltest/tcltest.tcl}");
        }
        catch (TclException tclException) {
            System.out.println(this.getResult());
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        Extension.loadOnDemand(this, "jaclloadjava", "tcl.pkg.java.JaclLoadJavaCmd");
        try {
            this.eval("package ifneeded java 1.4.1 jaclloadjava");
        }
        catch (TclException tclException) {
            System.out.println(this.getResult());
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        Extension.loadOnDemand(this, "jaclloaditcl", "tcl.pkg.itcl.ItclExtension");
        try {
            this.eval("package ifneeded Itcl 3.3 {jaclloaditcl ; package provide Itcl 3.3}");
        }
        catch (TclException tclException) {
            System.out.println(this.getResult());
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        Extension.loadOnDemand(this, "jaclloadparser", "tcl.lang.TclParserExtension");
        try {
            this.eval("package ifneeded parser 1.4 {jaclloadparser}");
        }
        catch (TclException tclException) {
            System.out.println(this.getResult());
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        Extension.loadOnDemand(this, "jaclloadtjc", "tcl.pkg.tjc.JaclLoadTJCCmd");
        try {
            this.eval("package ifneeded TJC 1.0 {jaclloadtjc ; package provide TJC 1.0}");
        }
        catch (TclException tclException) {
            System.out.println(this.getResult());
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    public void setAssocData(String string, AssocData assocData) {
        if (this.assocData == null) {
            this.assocData = new HashMap();
        }
        this.assocData.put(string, assocData);
    }

    public synchronized void deleteAssocData(String string) {
        if (this.assocData == null) {
            return;
        }
        AssocData assocData = this.assocData.remove(string);
        if (assocData != null) {
            assocData.disposeAssocData(this);
        }
    }

    public AssocData getAssocData(String string) {
        if (this.assocData == null) {
            return null;
        }
        return this.assocData.get(string);
    }

    public void backgroundError() {
        BgErrorMgr bgErrorMgr = (BgErrorMgr)this.getAssocData("tclBgError");
        if (bgErrorMgr == null) {
            bgErrorMgr = new BgErrorMgr(this);
            this.setAssocData("tclBgError", bgErrorMgr);
        }
        bgErrorMgr.addBgError();
    }

    public final HashSet<String> listVars() {
        HashSet<String> hashSet;
        block5: {
            block4: {
                Var var;
                String string;
                Namespace namespace = Namespace.getGlobalNamespace(this);
                Namespace namespace2 = Namespace.getCurrentNamespace(this);
                boolean bl = false;
                Object var3_4 = null;
                Namespace namespace3 = namespace2;
                bl = false;
                if (namespace3 == null) {
                    return new HashSet<String>();
                }
                TclObject tclObject = TclList.newInstance();
                hashSet = new HashSet<String>();
                if (this.varFrame != null && this.varFrame.isProcCallFrame) break block4;
                for (Map.Entry<String, Var> entry : namespace3.varTable.entrySet()) {
                    string = entry.getKey();
                    var = entry.getValue();
                    if (var.isVarUndefined() && !var.isVarNamespace()) continue;
                    hashSet.add(Var.getVariableFullName(this, var));
                }
                if (namespace3 == namespace) break block5;
                for (Map.Entry<String, Var> entry : namespace.varTable.entrySet()) {
                    string = entry.getKey();
                    var = entry.getValue();
                    if (var.isVarUndefined() && !var.isVarNamespace() || namespace3.varTable.get(string) != null) continue;
                    hashSet.add(string);
                }
                break block5;
            }
            for (Object e : this.varFrame.getVarNames()) {
                hashSet.add(e.toString());
            }
        }
        return hashSet;
    }

    public final TclObject setVar(TclObject tclObject, TclObject tclObject2, int n) throws TclException {
        return Var.setVar(this, tclObject.toString(), null, tclObject2, n | 0x200);
    }

    public final TclObject setVar(String string, TclObject tclObject, int n) throws TclException {
        return Var.setVar(this, string, null, tclObject, n | 0x200);
    }

    public final TclObject setVar(String string, String string2, TclObject tclObject, int n) throws TclException {
        return Var.setVar(this, string, string2, tclObject, n | 0x200);
    }

    public final TclObject setVar(String string, String string2, int n) throws TclException {
        return Var.setVar(this, string, null, this.checkCommonString(string2), n | 0x200);
    }

    public final TclObject setVar(String string, String string2, String string3, int n) throws TclException {
        return Var.setVar(this, string, string2, this.checkCommonString(string3), n | 0x200);
    }

    public final TclObject setVar(String string, String string2, long l, int n) throws TclException {
        return Var.setVar(this, string, string2, this.checkCommonInteger(l), n | 0x200);
    }

    public final TclObject setVar(String string, String string2, double d, int n) throws TclException {
        return Var.setVar(this, string, string2, this.checkCommonDouble(d), n | 0x200);
    }

    public final TclObject setVar(String string, String string2, boolean bl, int n) throws TclException {
        return Var.setVar(this, string, string2, this.checkCommonBoolean(bl), n | 0x200);
    }

    public final TclObject getVar(TclObject tclObject, int n) throws TclException {
        return Var.getVar(this, tclObject.toString(), null, n | 0x200);
    }

    public final TclObject getVar(String string, int n) throws TclException {
        return Var.getVar(this, string, null, n | 0x200);
    }

    public final TclObject getVar(String string, String string2, int n) throws TclException {
        return Var.getVar(this, string, string2, n | 0x200);
    }

    public Map<String, String> getenv() {
        return Env.getenv(this);
    }

    public final void unsetVar(TclObject tclObject, int n) throws TclException {
        Var.unsetVar(this, tclObject.toString(), null, n | 0x200);
    }

    public final void unsetVar(String string, int n) throws TclException {
        Var.unsetVar(this, string, null, n | 0x200);
    }

    public final void unsetVar(String string, String string2, int n) throws TclException {
        Var.unsetVar(this, string, string2, n | 0x200);
    }

    void traceVar(TclObject tclObject, VarTrace varTrace, int n) throws TclException {
        Var.traceVar(this, tclObject.toString(), null, n, varTrace);
    }

    public void traceVar(String string, VarTrace varTrace, int n) throws TclException {
        Var.traceVar(this, string, null, n, varTrace);
    }

    public void traceVar(String string, String string2, VarTrace varTrace, int n) throws TclException {
        Var.traceVar(this, string, string2, n, varTrace);
    }

    void untraceVar(TclObject tclObject, VarTrace varTrace, int n) {
        Var.untraceVar(this, tclObject.toString(), null, n, varTrace);
    }

    public void untraceVar(String string, VarTrace varTrace, int n) {
        Var.untraceVar(this, string, null, n, varTrace);
    }

    public void untraceVar(String string, String string2, VarTrace varTrace, int n) {
        Var.untraceVar(this, string, string2, n, varTrace);
    }

    public void createCommand(String string, Command command) {
        WrappedCommand wrappedCommand;
        String string2;
        Namespace namespace;
        ImportRef importRef = null;
        if (this.deleted) {
            return;
        }
        if (string.indexOf("::") != -1) {
            Namespace.GetNamespaceForQualNameResult getNamespaceForQualNameResult = this.getnfqnResult;
            Namespace.getNamespaceForQualName(this, string, null, 2048, getNamespaceForQualNameResult);
            namespace = getNamespaceForQualNameResult.ns;
            string2 = getNamespaceForQualNameResult.simpleName;
            if (namespace == null || string2 == null) {
                return;
            }
        } else {
            namespace = this.globalNs;
            string2 = string;
        }
        if ((wrappedCommand = namespace.cmdTable.get(string2)) != null) {
            importRef = wrappedCommand.importRef;
            wrappedCommand.importRef = null;
            this.deleteCommandFromToken(wrappedCommand);
            wrappedCommand = namespace.cmdTable.get(string2);
            if (wrappedCommand != null) {
                wrappedCommand.table.remove(wrappedCommand.hashKey);
            }
        }
        wrappedCommand = new WrappedCommand();
        namespace.cmdTable.put(string2, wrappedCommand);
        wrappedCommand.table = namespace.cmdTable;
        wrappedCommand.hashKey = string2;
        wrappedCommand.ns = namespace;
        wrappedCommand.cmd = command;
        wrappedCommand.deleted = false;
        wrappedCommand.importRef = null;
        wrappedCommand.cmdEpoch = 1;
        if (importRef != null) {
            wrappedCommand.importRef = importRef;
            while (importRef != null) {
                WrappedCommand wrappedCommand2 = importRef.importedCmd;
                ImportedCmdData importedCmdData = (ImportedCmdData)wrappedCommand2.cmd;
                importedCmdData.realCmd = wrappedCommand;
                importRef = importRef.next;
            }
        }
        Namespace.resetShadowedCmdRefs(this, wrappedCommand);
    }

    public String getCommandFullName(WrappedCommand wrappedCommand) {
        Interp interp = this;
        StringBuffer stringBuffer = new StringBuffer();
        if (wrappedCommand != null) {
            if (wrappedCommand.ns != null) {
                stringBuffer.append(wrappedCommand.ns.fullName);
                if (wrappedCommand.ns != interp.globalNs) {
                    stringBuffer.append("::");
                }
            }
            if (wrappedCommand.table != null) {
                stringBuffer.append(wrappedCommand.hashKey);
            }
        }
        return stringBuffer.toString();
    }

    public String getCommandName(WrappedCommand wrappedCommand) {
        if (wrappedCommand == null || wrappedCommand.table == null) {
            return "";
        }
        return wrappedCommand.hashKey;
    }

    public int deleteCommand(String string) {
        WrappedCommand wrappedCommand;
        try {
            wrappedCommand = Namespace.findCommand(this, string, null, 0);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        if (wrappedCommand == null) {
            return -1;
        }
        return this.deleteCommandFromToken(wrappedCommand);
    }

    public int deleteCommandFromToken(WrappedCommand wrappedCommand) {
        if (wrappedCommand == null) {
            return -1;
        }
        wrappedCommand.callCommandTraces(0, "");
        if (wrappedCommand.deleted) {
            if (wrappedCommand.hashKey != null && wrappedCommand.table != null) {
                wrappedCommand.table.remove(wrappedCommand.hashKey);
                wrappedCommand.table = null;
                wrappedCommand.hashKey = null;
            }
            return 0;
        }
        wrappedCommand.deleted = true;
        if (wrappedCommand.cmd instanceof CommandWithDispose) {
            ((CommandWithDispose)wrappedCommand.cmd).disposeCmd();
        }
        wrappedCommand.incrEpoch();
        ImportRef importRef = wrappedCommand.importRef;
        while (importRef != null) {
            ImportRef importRef2 = importRef.next;
            WrappedCommand wrappedCommand2 = importRef.importedCmd;
            this.deleteCommandFromToken(wrappedCommand2);
            importRef = importRef2;
        }
        if (wrappedCommand.table != null) {
            wrappedCommand.table.remove(wrappedCommand.hashKey);
            wrappedCommand.table = null;
            wrappedCommand.hashKey = null;
        }
        wrappedCommand.cmd = null;
        return 0;
    }

    public void renameCommand(String string, String string2) throws TclException {
        Interp interp = this;
        WrappedCommand wrappedCommand = Namespace.findCommand(interp, string, null, 0);
        if (wrappedCommand == null) {
            throw new TclException(interp, "can't " + (string2 == null || string2.length() == 0 ? "delete" : "rename") + " \"" + string + "\": command doesn't exist");
        }
        Namespace namespace = wrappedCommand.ns;
        if (string2 == null || string2.length() == 0) {
            this.deleteCommandFromToken(wrappedCommand);
            return;
        }
        Namespace.GetNamespaceForQualNameResult getNamespaceForQualNameResult = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string2, null, 2048, getNamespaceForQualNameResult);
        Namespace namespace2 = getNamespaceForQualNameResult.ns;
        String string3 = getNamespaceForQualNameResult.simpleName;
        if (namespace2 == null || string3 == null) {
            throw new TclException(interp, "can't rename to \"" + string2 + "\": bad command name");
        }
        if (namespace2.cmdTable.get(string3) != null) {
            throw new TclException(interp, "can't rename to \"" + string2 + "\": command already exists");
        }
        String string4 = namespace2.fullName + (namespace2.fullName.endsWith("::") ? "" : "::") + string3;
        wrappedCommand.callCommandTraces(1, string4);
        wrappedCommand = Namespace.findCommand(interp, string, null, 0);
        if (wrappedCommand == null) {
            return;
        }
        HashMap<String, WrappedCommand> hashMap = wrappedCommand.table;
        String string5 = wrappedCommand.hashKey;
        namespace2.cmdTable.put(string3, wrappedCommand);
        wrappedCommand.table = namespace2.cmdTable;
        wrappedCommand.hashKey = string3;
        wrappedCommand.ns = namespace2;
        Namespace.resetShadowedCmdRefs(this, wrappedCommand);
        try {
            interp.preventAliasLoop(interp, wrappedCommand);
        }
        catch (TclException tclException) {
            namespace2.cmdTable.remove(string3);
            wrappedCommand.table = hashMap;
            wrappedCommand.hashKey = string5;
            wrappedCommand.ns = namespace;
            throw tclException;
        }
        hashMap.remove(string5);
        wrappedCommand.incrEpoch();
    }

    public void preventAliasLoop(Interp interp, WrappedCommand wrappedCommand) throws TclException {
        InterpAliasCmd interpAliasCmd;
        if (!(wrappedCommand.cmd instanceof InterpAliasCmd)) {
            return;
        }
        InterpAliasCmd interpAliasCmd2 = interpAliasCmd = (InterpAliasCmd)wrappedCommand.cmd;
        WrappedCommand wrappedCommand2;
        while ((wrappedCommand2 = interpAliasCmd2.getTargetCmd(this)) != null) {
            if (wrappedCommand2.cmd == wrappedCommand.cmd) {
                throw new TclException(this, "cannot define or rename alias \"" + interpAliasCmd.name + "\": would create a loop");
            }
            if (!(wrappedCommand2.cmd instanceof InterpAliasCmd)) {
                return;
            }
            interpAliasCmd2 = (InterpAliasCmd)wrappedCommand2.cmd;
        }
        return;
    }

    public Command getCommand(String string) {
        WrappedCommand wrappedCommand;
        try {
            wrappedCommand = Namespace.findCommand(this, string, null, 0);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        return wrappedCommand == null ? null : wrappedCommand.cmd;
    }

    public WrappedCommand getWrappedCommand(String string) {
        try {
            return Namespace.findCommand(this, string, null, 0);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    public static boolean commandComplete(String string) {
        return Parser.commandComplete(string, string.length());
    }

    public void traceCommand(String string, CommandTrace commandTrace) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, string, null, 512);
        wrappedCommand.traceCommand(commandTrace);
    }

    public void untraceCommand(String string, int n, TclObject tclObject) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, string, null, 512);
        wrappedCommand.untraceCommand(n, tclObject.toString());
    }

    public TclObject traceCommandInfo(String string) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, string, null, 512);
        return wrappedCommand.traceCommandInfo(this);
    }

    public void traceExecution(String string, ExecutionTrace executionTrace) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, string, null, 512);
        wrappedCommand.traceExecution(executionTrace);
    }

    public void untraceExecution(String string, int n, TclObject tclObject) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, string, null, 512);
        wrappedCommand.untraceExecution(n, tclObject.toString());
        this.deactivateExecutionStepTrace(wrappedCommand);
    }

    public TclObject traceExecutionInfo(String string) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, string, null, 512);
        return wrappedCommand.traceExecutionInfo(this);
    }

    boolean activateExecutionStepTrace(WrappedCommand wrappedCommand) {
        if (this.activeExecutionStepTraces == null) {
            this.activeExecutionStepTraces = new ArrayList();
        }
        if (this.activeExecutionStepTraces.contains(wrappedCommand)) {
            return false;
        }
        this.activeExecutionStepTraces.add(wrappedCommand);
        return true;
    }

    void deactivateExecutionStepTrace(WrappedCommand wrappedCommand) {
        if (this.activeExecutionStepTraces == null) {
            return;
        }
        this.activeExecutionStepTraces.remove(wrappedCommand);
        if (this.activeExecutionStepTraces.size() == 0) {
            this.activeExecutionStepTraces = null;
        }
    }

    final boolean hasActiveExecutionStepTraces() {
        return this.stepTracingEnabled && this.activeExecutionStepTraces != null;
    }

    WrappedCommand[] getCopyOfActiveExecutionStepTraces() {
        WrappedCommand[] wrappedCommandArray = new WrappedCommand[]{};
        if (this.activeExecutionStepTraces == null) {
            return wrappedCommandArray;
        }
        wrappedCommandArray = this.activeExecutionStepTraces.toArray(wrappedCommandArray);
        return wrappedCommandArray;
    }

    void enableExecutionStepTracing(boolean bl) {
        this.stepTracingEnabled = bl;
    }

    public final TclObject getResult() {
        return this.m_result;
    }

    public final void setResult(TclObject tclObject) {
        if (tclObject == this.m_result) {
            return;
        }
        if (tclObject != this.m_nullResult) {
            tclObject.preserve();
        }
        TclObject tclObject2 = this.m_result;
        this.m_result = tclObject;
        if (tclObject2 != this.m_nullResult) {
            tclObject2.release();
        }
    }

    public final void setResult(String string) {
        this.setResult(this.checkCommonString(string));
    }

    public final void setResult(long l) {
        this.setResult(this.checkCommonInteger(l));
    }

    public final void setResult(double d) {
        this.setResult(this.checkCommonDouble(d));
    }

    public final void setResult(boolean bl) {
        this.setResult(bl ? this.m_trueBooleanResult : this.m_falseBooleanResult);
    }

    public final void resetResult() {
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
            this.m_result = this.m_nullResult;
        }
        this.errAlreadyLogged = false;
        this.errInProgress = false;
        this.errCodeSet = false;
        this.returnCode = 0;
    }

    public void appendElement(String string) throws TclException {
        TclObject tclObject = this.getResult();
        if (tclObject.isShared()) {
            tclObject = tclObject.duplicate();
        }
        TclList.append(this, tclObject, TclString.newInstance(string));
        this.setResult(tclObject);
    }

    public void eval(String string) throws TclException {
        this.eval(string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(String string, int n) throws TclException {
        if (string == null) {
            throw new NullPointerException("passed null String to eval()");
        }
        int n2 = this.evalFlags;
        this.evalFlags &= 0xFFFFFFFB;
        CharPointer charPointer = new CharPointer(string);
        try {
            Parser.eval2(this, charPointer.array, charPointer.index, charPointer.length(), n);
        }
        catch (TclException tclException) {
            if (this.nestLevel != 0) {
                throw tclException;
            }
            int n3 = tclException.getCompletionCode();
            if (n3 == 2) {
                n3 = this.updateReturnInfo();
            }
            if (n3 != 0 && n3 != 1 && (n2 & 4) == 0) {
                int n4;
                this.errorLine = 1;
                int n5 = 0;
                for (n4 = 0; n4 < this.termOffset - 1; ++n4) {
                    if (charPointer.charAt(n4) != '\n') continue;
                    ++this.errorLine;
                    n5 = n4 + 1;
                }
                while (Character.isWhitespace(charPointer.charAt(n5)) && n5 < n4) {
                    ++n5;
                }
                try {
                    this.processUnexpectedResult(n3);
                }
                catch (TclException tclException2) {
                    this.addErrorInfo("\n    while executing\n\"" + charPointer.toString().substring(n5, n4) + "\"");
                    throw tclException2;
                }
            }
            if (n3 != 0) {
                tclException.setCompletionCode(n3);
                throw tclException;
            }
        }
        finally {
            this.checkInterrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(TclObject tclObject, int n) throws TclException {
        boolean bl = false;
        if (tclObject.hasNoStringRep() && tclObject.isListType()) {
            bl = true;
        }
        if (!bl) {
            tclObject.preserve();
            try {
                this.eval(tclObject.toString(), n);
            }
            finally {
                tclObject.release();
                this.checkInterrupted();
            }
            return;
        }
        int n2 = this.evalFlags;
        this.evalFlags &= 0xFFFFFFFB;
        TclObject[] tclObjectArray = null;
        boolean bl2 = false;
        tclObject.preserve();
        try {
            int n3 = TclList.getLength(this, tclObject);
            tclObjectArray = Parser.grabObjv(this, n3);
            for (int i = 0; i < n3; ++i) {
                tclObjectArray[i] = TclList.index(this, tclObject, i);
                tclObjectArray[i].preserve();
            }
            bl2 = true;
            Parser.evalObjv(this, tclObjectArray, -1, n);
        }
        catch (StackOverflowError stackOverflowError) {
            Parser.infiniteLoopException(this);
        }
        catch (TclException tclException) {
            int n4 = tclException.getCompletionCode();
            if (bl2 && n4 == 1 && !this.errAlreadyLogged) {
                StringBuffer stringBuffer = new StringBuffer(64);
                for (int i = 0; i < tclObjectArray.length; ++i) {
                    Util.appendElement(this, stringBuffer, tclObjectArray[i].toString());
                }
                String string = stringBuffer.toString();
                char[] cArray = string.toCharArray();
                int n5 = 0;
                int n6 = 0;
                int n7 = string.length();
                Parser.logCommandInfo(this, cArray, n5, n6, n7, tclException);
            }
            if (this.nestLevel != 0) {
                throw tclException;
            }
            if (n4 == 2) {
                n4 = this.updateReturnInfo();
            }
            if (n4 != 0 && n4 != 1 && (n2 & 4) == 0) {
                this.processUnexpectedResult(n4);
            }
            if (n4 != 0) {
                tclException.setCompletionCode(n4);
                throw tclException;
            }
        }
        finally {
            if (tclObjectArray != null) {
                for (int i = 0; i < tclObjectArray.length; ++i) {
                    TclObject tclObject2 = tclObjectArray[i];
                    if (tclObject2 == null) continue;
                    tclObject2.release();
                }
                Parser.releaseObjv(this, tclObjectArray, tclObjectArray.length);
            }
            tclObject.release();
            this.checkInterrupted();
        }
    }

    public void recordAndEval(TclObject tclObject, int n) throws TclException {
        TclObject tclObject2 = null;
        try {
            tclObject2 = TclList.newInstance();
            TclList.append(this, tclObject2, TclString.newInstance("history"));
            TclList.append(this, tclObject2, TclString.newInstance("add"));
            TclList.append(this, tclObject2, tclObject);
            this.eval(tclObject2, 131072);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((n & 0x10000) == 0) {
            this.eval(tclObject, n & 0x20000);
        }
    }

    public void evalFile(String string) throws TclException {
        this.evalFile(string, EncodingCmd.systemJavaEncoding);
    }

    public void evalFile(String string, String string2) throws TclException {
        String string3 = this.readScriptFromFile(string, string2);
        if (string3 == null) {
            throw new TclException(this, "couldn't read file \"" + string + "\"");
        }
        String string4 = this.scriptFile;
        this.scriptFile = string;
        try {
            this.pushDebugStack(string, 1);
            this.eval(string3, 0);
        }
        catch (TclException tclException) {
            if (tclException.getCompletionCode() == 1) {
                this.addErrorInfo("\n    (file \"" + string + "\" line " + this.errorLine + ")");
            }
            throw tclException;
        }
        finally {
            this.scriptFile = string4;
            this.popDebugStack();
        }
    }

    public void evalURL(URL uRL, String string) throws TclException {
        this.evalURL(uRL, string, EncodingCmd.systemJavaEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evalURL(URL uRL, String string, String string2) throws TclException {
        String string3 = this.readScriptFromURL(uRL, string, string2);
        if (string3 == null) {
            throw new TclException(this, "cannot read URL \"" + string + "\"");
        }
        String string4 = this.scriptFile;
        this.scriptFile = string;
        try {
            this.eval(string3, 0);
        }
        finally {
            this.scriptFile = string4;
        }
    }

    private String readScriptFromFile(String string, String string2) throws TclException {
        FileChannel fileChannel = new FileChannel();
        fileChannel.setEncoding(string2);
        boolean bl = false;
        TclObject tclObject = TclString.newInstance(new StringBuffer(64));
        try {
            File file = FileUtil.getNewFileObj(this, string);
            fileChannel.open(this, file.getPath(), 1);
            bl = true;
            fileChannel.read(this, tclObject, 1, 0);
            String string3 = this.trimToCtrlZ(tclObject.toString());
            return string3;
        }
        catch (TclPosixException tclPosixException) {
            throw new TclPosixException(this, tclPosixException.getErrorNo(), true, "couldn't read file \"" + string + "\"");
        }
        catch (IOException iOException) {
            throw new TclPosixException(this, iOException, true, "couldn't read file \"" + string + "\"");
        }
        catch (SecurityException securityException) {
            throw new TclException(this, securityException.getMessage());
        }
        finally {
            if (bl) {
                this.closeChannel(fileChannel);
            }
        }
    }

    private String trimToCtrlZ(String string) {
        int n = 26;
        int n2 = string.indexOf(n);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    private String readScriptFromURL(URL uRL, String string, String string2) {
        URL uRL2;
        Object object = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        try {
            object = uRL2.getContent();
        }
        catch (UnknownServiceException unknownServiceException) {
            URLConnection uRLConnection;
            Class<?> clazz;
            try {
                clazz = Class.forName("java.net.JarURLConnection");
            }
            catch (Exception exception) {
                return null;
            }
            try {
                uRLConnection = uRL2.openConnection();
            }
            catch (IOException iOException) {
                return null;
            }
            if (uRLConnection == null) {
                return null;
            }
            try {
                Method method = clazz.getMethod("openConnection", null);
                object = method.invoke((Object)uRLConnection, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (object instanceof String) {
            return this.trimToCtrlZ(this.convertStringCRLF((String)object));
        }
        if (object instanceof InputStream) {
            return this.trimToCtrlZ(this.readScriptFromInputStream((InputStream)object, string2));
        }
        return null;
    }

    String convertStringCRLF(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        int n = 10;
        boolean bl = false;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c == '\n' && n == 13) {
                stringBuffer.setCharAt(stringBuffer.length() - 1, '\n');
                n = 10;
                bl = true;
                continue;
            }
            stringBuffer.append(c);
            n = c;
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScriptFromInputStream(InputStream inputStream, String string) {
        TclObject tclObject = TclString.newInstance(new StringBuffer(64));
        ReadInputStreamChannel readInputStreamChannel = new ReadInputStreamChannel(this, inputStream);
        readInputStreamChannel.setEncoding(string);
        try {
            readInputStreamChannel.read(this, tclObject, 1, 0);
            String string2 = tclObject.toString();
            return string2;
        }
        catch (TclException tclException) {
            this.resetResult();
            String string3 = null;
            return string3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = null;
            return string4;
        }
        catch (IOException iOException) {
            String string5 = null;
            return string5;
        }
        catch (SecurityException securityException) {
            String string6 = null;
            return string6;
        }
        finally {
            this.closeChannel(readInputStreamChannel);
            this.closeInputStream(inputStream);
        }
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeChannel(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void evalResource(String string) throws TclException {
        this.evalResource(string, EncodingCmd.systemJavaEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evalResource(String string, String string2) throws TclException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        if (string.startsWith("/tcl/lang/library/") && (string.equals("/tcl/lang/library/tclIndex") || string.endsWith(".tcl"))) {
            bl = true;
        }
        if (bl) {
            object = tclLibraryScripts;
            synchronized (object) {
                string3 = (String)tclLibraryScripts.get(string);
                bl2 = string3 != null;
                if (!bl2) {
                    InputStream inputStream = this.getResourceAsStream(string);
                    if (inputStream == null) {
                        throw new TclException(this, "cannot read resource \"" + string + "\"");
                    }
                    string3 = this.readScriptFromInputStream(inputStream, string2);
                    if (string3 == null) {
                        throw new TclException(this, "cannot read resource \"" + string + "\"");
                    }
                    tclLibraryScripts.put(string, string3);
                }
            }
        } else {
            InputStream inputStream = this.getResourceAsStream(string);
            if (inputStream == null) {
                throw new TclException(this, "cannot read resource \"" + string + "\"");
            }
            string3 = this.readScriptFromInputStream(inputStream, string2);
            if (string3 == null) {
                throw new TclException(this, "cannot read resource \"" + string + "\"");
            }
        }
        object = this.scriptFile;
        this.scriptFile = "resource:" + string;
        try {
            this.eval(string3, 0);
        }
        finally {
            this.scriptFile = object;
        }
    }

    public static BackSlashResult backslash(String string, int n, int n2) {
        CharPointer charPointer = new CharPointer(string.substring(0, n2));
        charPointer.index = n;
        return Parser.backslash(charPointer.array, charPointer.index);
    }

    public void setErrorCode(TclObject tclObject) {
        try {
            this.setVar("errorCode", null, tclObject, 1);
            this.errCodeSet = true;
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    public void addErrorInfo(String string) {
        if (!this.errInProgress) {
            this.errInProgress = true;
            try {
                this.setVar("::errorInfo", null, this.getResult().toString(), 1);
            }
            catch (TclException tclException) {
                // empty catch block
            }
            if (!this.errCodeSet) {
                try {
                    this.setVar("errorCode", null, "NONE", 1);
                }
                catch (TclException tclException) {
                    // empty catch block
                }
            }
        }
        try {
            this.setVar("::errorInfo", null, string, 5);
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    public void processUnexpectedResult(int n) throws TclException {
        this.resetResult();
        if (n == 3) {
            throw new TclException(this, "invoked \"break\" outside of a loop");
        }
        if (n == 4) {
            throw new TclException(this, "invoked \"continue\" outside of a loop");
        }
        throw new TclException(this, "command returned bad code: " + n);
    }

    public int updateReturnInfo() {
        int n = this.returnCode;
        this.returnCode = 0;
        if (n == 1) {
            try {
                this.setVar("errorCode", null, this.errorCode != null ? this.errorCode : "NONE", 1);
            }
            catch (TclException tclException) {
                // empty catch block
            }
            this.errCodeSet = true;
            if (this.errorInfo != null) {
                try {
                    this.setVar("::errorInfo", null, this.errorInfo, 1);
                }
                catch (TclException tclException) {
                    // empty catch block
                }
                this.errInProgress = true;
            }
        }
        return n;
    }

    protected CallFrame newCallFrame(Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        return new CallFrame(this, procedure, tclObjectArray);
    }

    public CallFrame newCallFrame() {
        return new CallFrame(this);
    }

    public File getWorkingDir() {
        if (this.workingDir == null) {
            try {
                String string = this.getVar("env", "HOME", 0).toString();
                this.workingDir = FileUtil.getNewFileObj(this, string);
            }
            catch (TclException tclException) {
                this.resetResult();
            }
            this.workingDir = new File(Util.tryGetSystemProperty("user.home", "."));
        }
        return this.workingDir;
    }

    public void setWorkingDir(String string) throws TclException {
        File file = FileUtil.getNewFileObj(this, string);
        try {
            file = new File(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.isDirectory() || string.length() <= 0) {
            String string2 = FileUtil.translateFileName(this, string);
            string2 = FileUtil.getPathType(string2) == 0 ? string : file.getPath();
            throw new TclException(this, "couldn't change working directory to \"" + string2 + "\": no such file or directory");
        }
        this.workingDir = file;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public final void pkgProvide(String string, String string2) throws TclException {
        PackageCmd.pkgProvide(this, string, string2);
    }

    public final String pkgRequire(String string, String string2, boolean bl) throws TclException {
        return PackageCmd.pkgRequire(this, string, string2, bl);
    }

    protected DebugInfo initDebugInfo() {
        return new DebugInfo(null, 1);
    }

    void pushDebugStack(String string, int n) {
    }

    void popDebugStack() throws TclRuntimeError {
    }

    public String getScriptFile() {
        return this.dbg.fileName;
    }

    public int getArgLineNumber(int n) {
        return 0;
    }

    public void transferResult(Interp interp, int n) throws TclException {
        if (interp == this) {
            if (n != 0) {
                throw new TclException(this, this.getResult().toString(), n);
            }
            return;
        }
        if (n == 1) {
            if (!interp.errAlreadyLogged) {
                interp.addErrorInfo("");
            }
            interp.errAlreadyLogged = true;
            this.resetResult();
            TclObject tclObject = interp.getVar("errorInfo", 1);
            this.setVar("errorInfo", tclObject, 1);
            tclObject = interp.getVar("errorCode", 1);
            this.setVar("errorCode", tclObject, 1);
            this.errInProgress = true;
            this.errCodeSet = true;
        }
        this.returnCode = n;
        this.setResult(interp.getResult());
        interp.resetResult();
        if (n != 0) {
            throw new TclException(this, this.getResult().toString(), n);
        }
    }

    public void hideCommand(String string, String string2) throws TclException {
        if (this.deleted) {
            return;
        }
        if (string2.indexOf("::") >= 0) {
            throw new TclException(this, "cannot use namespace qualifiers in hidden command token (rename)");
        }
        WrappedCommand wrappedCommand = Namespace.findCommand(this, string, null, 513);
        if (wrappedCommand.ns != this.globalNs) {
            throw new TclException(this, "can only hide global namespace commands (use rename then hide)");
        }
        if (this.hiddenCmdTable == null) {
            this.hiddenCmdTable = new HashMap();
        }
        if (this.hiddenCmdTable.containsKey(string2)) {
            throw new TclException(this, "hidden command named \"" + string2 + "\" already exists");
        }
        if (wrappedCommand.table.containsKey(wrappedCommand.hashKey)) {
            wrappedCommand.table.remove(wrappedCommand.hashKey);
            wrappedCommand.incrEpoch();
        }
        wrappedCommand.table = this.hiddenCmdTable;
        wrappedCommand.hashKey = string2;
        this.hiddenCmdTable.put(string2, wrappedCommand);
    }

    public void exposeCommand(String string, String string2) throws TclException {
        if (this.deleted) {
            return;
        }
        if (string2.indexOf("::") >= 0) {
            throw new TclException(this, "can not expose to a namespace (use expose to toplevel, then rename)");
        }
        if (this.hiddenCmdTable == null || !this.hiddenCmdTable.containsKey(string)) {
            throw new TclException(this, "unknown hidden command \"" + string + "\"");
        }
        WrappedCommand wrappedCommand = (WrappedCommand)this.hiddenCmdTable.get(string);
        if (wrappedCommand.ns != this.globalNs) {
            throw new TclException(this, "trying to expose a non global command name space command");
        }
        Namespace namespace = wrappedCommand.ns;
        if (namespace.cmdTable.containsKey(string2)) {
            throw new TclException(this, "exposed command \"" + string2 + "\" already exists");
        }
        if (wrappedCommand.hashKey != null) {
            wrappedCommand.table.remove(wrappedCommand.hashKey);
            wrappedCommand.table = namespace.cmdTable;
            wrappedCommand.hashKey = string2;
        }
        namespace.cmdTable.put(string2, wrappedCommand);
    }

    public void hideUnsafeCommands() throws TclException {
        for (int i = 0; i < unsafeCmds.length; ++i) {
            try {
                this.hideCommand(unsafeCmds[i], unsafeCmds[i]);
                continue;
            }
            catch (TclException tclException) {
                if (tclException.getMessage().startsWith("unknown command")) continue;
                throw tclException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invokeGlobal(TclObject[] tclObjectArray, int n) throws TclException {
        CallFrame callFrame = this.varFrame;
        try {
            this.varFrame = null;
            int n2 = this.invoke(tclObjectArray, n);
            return n2;
        }
        finally {
            this.varFrame = callFrame;
        }
    }

    public int invoke(TclObject[] tclObjectArray, int n) throws TclException {
        int n2;
        WrappedCommand wrappedCommand;
        if (tclObjectArray.length < 1 || tclObjectArray == null) {
            throw new TclException(this, "illegal argument vector");
        }
        this.ready();
        String string = tclObjectArray[0].toString();
        TclObject[] tclObjectArray2 = null;
        if ((n & 1) != 0) {
            if (this.hiddenCmdTable == null || !this.hiddenCmdTable.containsKey(string)) {
                throw new TclException(this, "invalid hidden command name \"" + string + "\"");
            }
            wrappedCommand = (WrappedCommand)this.hiddenCmdTable.get(string);
        } else {
            wrappedCommand = Namespace.findCommand(this, string, null, 1);
            if (wrappedCommand == null) {
                if ((n & 2) == 0 && (wrappedCommand = Namespace.findCommand(this, "unknown", null, 1)) != null) {
                    tclObjectArray2 = new TclObject[tclObjectArray.length + 1];
                    tclObjectArray2[0] = TclString.newInstance("unknown");
                    tclObjectArray2[0].preserve();
                    for (n2 = 0; n2 < tclObjectArray.length; ++n2) {
                        tclObjectArray2[n2 + 1] = tclObjectArray[n2];
                    }
                    tclObjectArray = tclObjectArray2;
                }
                if (wrappedCommand == null) {
                    throw new TclException(this, "invalid command name \"" + string + "\"");
                }
            }
        }
        this.resetResult();
        ++this.cmdCount;
        n2 = 0;
        try {
            if (wrappedCommand.mustCallInvoke(this)) {
                wrappedCommand.invoke(this, tclObjectArray);
            } else {
                wrappedCommand.cmd.cmdProc(this, tclObjectArray);
            }
        }
        catch (TclException tclException) {
            n2 = tclException.getCompletionCode();
        }
        if ((n & 1) != 0 && (wrappedCommand = Namespace.findCommand(this, string, null, 1)) != null) {
            wrappedCommand.table.remove(wrappedCommand.hashKey);
            wrappedCommand.table = this.hiddenCmdTable;
            wrappedCommand.hashKey = string;
            this.hiddenCmdTable.put(string, wrappedCommand);
        }
        if (n2 == 1 && (n & 4) == 0 && !this.errAlreadyLogged) {
            StringBuffer stringBuffer = this.errInProgress ? new StringBuffer("\n    while invoking\n\"") : new StringBuffer("\n    invoked from within\n\"");
            for (int i = 0; i < tclObjectArray.length; ++i) {
                stringBuffer.append(tclObjectArray[i].toString());
                if (i < tclObjectArray.length - 1) {
                    stringBuffer.append(" ");
                    continue;
                }
                if (stringBuffer.length() <= 100) continue;
                stringBuffer.append("...");
                break;
            }
            stringBuffer.append("\"");
            this.addErrorInfo(stringBuffer.toString());
            this.errInProgress = true;
        }
        if (tclObjectArray2 != null) {
            tclObjectArray2[0].release();
        }
        return n2;
    }

    public void allowExceptions() {
        this.evalFlags |= 4;
    }

    public void addInterpResolver(String string, Resolver resolver) {
        ResolverScheme resolverScheme;
        if (this.resolvers != null) {
            ListIterator listIterator = this.resolvers.listIterator();
            while (listIterator.hasNext()) {
                resolverScheme = (ResolverScheme)listIterator.next();
                if (!string.equals(resolverScheme.name)) continue;
                resolverScheme.resolver = resolver;
                return;
            }
        }
        if (this.resolvers == null) {
            this.resolvers = new ArrayList();
        }
        resolverScheme = new ResolverScheme(string, resolver);
        this.resolvers.add(0, resolverScheme);
    }

    public Resolver getInterpResolver(String string) {
        if (this.resolvers != null) {
            ListIterator listIterator = this.resolvers.listIterator();
            while (listIterator.hasNext()) {
                ResolverScheme resolverScheme = (ResolverScheme)listIterator.next();
                if (!string.equals(resolverScheme.name)) continue;
                return resolverScheme.resolver;
            }
        }
        return null;
    }

    public boolean removeInterpResolver(String string) {
        boolean bl = false;
        if (this.resolvers != null) {
            ListIterator listIterator = this.resolvers.listIterator();
            while (listIterator.hasNext()) {
                ResolverScheme resolverScheme = (ResolverScheme)listIterator.next();
                if (!string.equals(resolverScheme.name)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            int n = this.resolvers.indexOf(string);
            if (n == -1) {
                throw new TclRuntimeError("name " + string + " not found in resolvers");
            }
            this.resolvers.remove(n);
        }
        return bl;
    }

    public final TclObject checkCommonInteger(long l) {
        if (l == -1L) {
            return this.m_minusoneIntegerResult;
        }
        if (l == 0L) {
            return this.m_zeroIntegerResult;
        }
        if (l == 1L) {
            return this.m_oneIntegerResult;
        }
        if (l == 2L) {
            return this.m_twoIntegerResult;
        }
        if (this.recycledI.getRefCount() == 1 || this.recycledI.getRefCount() == 2 && this.recycledI == this.m_result) {
            this.recycledI.setRecycledIntValue(l);
        } else {
            this.recycledI.release();
            this.recycledI = TclInteger.newInstance(l);
            this.recycledI.preserve();
        }
        return this.recycledI;
    }

    final TclObject checkCommonDouble(double d) {
        if (d == 0.0) {
            return this.m_zeroDoubleResult;
        }
        if (d == 0.5) {
            return this.m_onehalfDoubleResult;
        }
        if (d == 1.0) {
            return this.m_oneDoubleResult;
        }
        if (d == 2.0) {
            return this.m_twoDoubleResult;
        }
        if (this.recycledD.getRefCount() == 1 || this.recycledD.getRefCount() == 2 && this.recycledD == this.m_result) {
            this.recycledD.setRecycledDoubleValue(d);
        } else {
            this.recycledD.release();
            this.recycledD = TclDouble.newInstance(d);
            this.recycledD.preserve();
        }
        return this.recycledD;
    }

    final TclObject checkCommonBoolean(boolean bl) {
        return bl ? this.m_trueBooleanResult : this.m_falseBooleanResult;
    }

    public final TclObject checkCommonString(String string) {
        if (string == null || "".equals(string) || string.length() == 0) {
            return this.m_nullResult;
        }
        return TclString.newInstance(string);
    }

    public final TclObject checkCommonCharacter(int n) {
        if (n <= 0 || n >= 128) {
            return null;
        }
        return this.m_charCommon[n];
    }

    public int getErrorLine() {
        return this.errorLine;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new TclClassLoader(this, null, Thread.currentThread().getContextClassLoader());
        }
        return this.classLoader;
    }

    InputStream getResourceAsStream(String string) {
        if (this.classLoader == null) {
            this.getClassLoader();
        }
        try {
            return this.classLoader.getResourceAsStream(string);
        }
        catch (PackageNameException packageNameException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public void setInterrupted() {
        TclInterruptedExceptionEvent tclInterruptedExceptionEvent;
        if (this.deleted || this.interruptedEvent != null) {
            return;
        }
        this.interruptedEvent = tclInterruptedExceptionEvent = new TclInterruptedExceptionEvent(this);
        if (this.interruptedEvent != tclInterruptedExceptionEvent) {
            return;
        }
        this.getNotifier().queueEvent(this.interruptedEvent, 0);
    }

    public final void checkInterrupted() {
        if (this.interruptedEvent != null && !this.interruptedEvent.exceptionRaised) {
            this.interruptedEvent.exceptionRaised = true;
            throw new TclInterruptedException(this);
        }
    }

    final void disposeInterrupted() {
        if (this.deleted) {
            throw new TclRuntimeError("Interp.disposeInterrupted() invoked for a deleted interp");
        }
        if (this.interruptedEvent == null) {
            throw new TclRuntimeError("Interp.disposeInterrupted() invoked for an interp that was not interrupted via setInterrupted()");
        }
        if (this.interruptedEvent != null && !this.interruptedEvent.wasProcessed) {
            this.getNotifier().deleteEvents(this.interruptedEvent);
        }
        try {
            this.eval("after info", 0);
            TclObject tclObject = this.getResult();
            tclObject.preserve();
            int n = TclList.getLength(this, tclObject);
            for (int i = 0; i < n; ++i) {
                TclObject tclObject2 = TclList.index(this, tclObject, i);
                String string = "after cancel " + tclObject2;
                this.eval(string, 0);
            }
            tclObject.release();
        }
        catch (TclException tclException) {
            // empty catch block
        }
        this.dispose();
    }

    public int setMaxNestingDepth(int n) {
        int n2 = this.maxNestingDepth;
        if (n > 0) {
            this.maxNestingDepth = n;
        }
        return n2;
    }

    public int getMaxNestingDepth() {
        return this.maxNestingDepth;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.toString();
        if (string.startsWith("tcl.lang.Interp")) {
            string = string.substring(9);
        }
        stringBuffer.append(string);
        stringBuffer.append(' ');
        stringBuffer.append("allocated in \"" + this.cThreadName + "\"");
        return stringBuffer.toString();
    }

    public String getNameOfExecutable() {
        return this.nameOfExecutable;
    }

    public void setNameOfExecutable(String string) {
        this.nameOfExecutable = string;
    }

    public String getShellClassName() {
        return this.shellClassName == null ? "tcl.lang.NonInteractiveShell" : this.shellClassName;
    }

    public void setShellClassName(String string) {
        this.shellClassName = string;
    }

    class ResolverScheme {
        String name;
        Resolver resolver;

        ResolverScheme(String string, Resolver resolver) {
            this.name = string;
            this.resolver = resolver;
        }
    }
}

