/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tcl.lang.AutoloadStub;
import tcl.lang.CallFrame;
import tcl.lang.ImportRef;
import tcl.lang.ImportedCmdData;
import tcl.lang.Interp;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class Namespace {
    public String name;
    public String fullName;
    public DeleteProc deleteProc;
    public Namespace parent;
    public HashMap<String, Namespace> childTable;
    public long nsId;
    public Interp interp;
    public int flags;
    public int activationCount;
    public int refCount;
    public HashMap<String, WrappedCommand> cmdTable;
    public HashMap<String, Var> varTable;
    public String[] exportArray;
    public int numExportPatterns;
    public int maxExportPatterns;
    public Resolver resolver;
    public static final int FIND_ONLY_NS = 4096;
    private static final int NUM_TRAIL_ELEMS = 5;
    private static long numNsCreated = 0L;
    private static Object nsMutex = new Object();
    static final int NS_DYING = 1;
    public static final int NS_DEAD = 2;
    public static final int CREATE_NS_IF_UNKNOWN = 2048;

    public String toString() {
        return this.fullName;
    }

    public static Namespace getCurrentNamespace(Interp interp) {
        if (interp.varFrame != null) {
            return interp.varFrame.ns;
        }
        return interp.globalNs;
    }

    public static Namespace getGlobalNamespace(Interp interp) {
        return interp.globalNs;
    }

    public static void pushCallFrame(Interp interp, CallFrame callFrame, Namespace namespace, boolean bl) {
        Namespace namespace2;
        if (namespace == null) {
            namespace2 = Namespace.getCurrentNamespace(interp);
        } else {
            namespace2 = namespace;
            if ((namespace2.flags & 2) != 0) {
                throw new TclRuntimeError("Trying to push call frame for dead namespace");
            }
        }
        ++namespace2.activationCount;
        callFrame.ns = namespace2;
        callFrame.isProcCallFrame = bl;
        if (bl) {
            callFrame.objv = null;
        }
        callFrame.caller = interp.frame;
        callFrame.callerVar = interp.varFrame;
        callFrame.level = interp.varFrame != null ? interp.varFrame.level + 1 : 1;
        callFrame.varTable = null;
        interp.frame = callFrame;
        interp.varFrame = callFrame;
    }

    public static void popCallFrame(Interp interp) {
        CallFrame callFrame = interp.frame;
        interp.frame = callFrame.caller;
        interp.varFrame = callFrame.callerVar;
        int n = interp.flags & 2;
        if (callFrame.varTable != null) {
            Var.deleteVars(interp, callFrame.varTable);
            callFrame.varTable = null;
        }
        interp.flags |= n;
        Namespace namespace = callFrame.ns;
        --namespace.activationCount;
        if ((namespace.flags & 1) != 0 && namespace.activationCount == 0) {
            Namespace.deleteNamespace(namespace);
        }
        callFrame.ns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace createNamespace(Interp interp, String string, DeleteProc deleteProc) {
        Object object;
        String string2;
        Namespace namespace;
        Namespace namespace2 = Namespace.getGlobalNamespace(interp);
        if (namespace2 == null && interp.varFrame == null) {
            namespace = null;
            string2 = "";
        } else {
            if (string.length() == 0) {
                interp.setResult("can't create namespace \"\": only global namespace can have empty name");
                return null;
            }
            object = interp.getnfqnResult;
            Namespace.getNamespaceForQualName(interp, string, null, 2560, (GetNamespaceForQualNameResult)object);
            namespace = ((GetNamespaceForQualNameResult)object).ns;
            string2 = ((GetNamespaceForQualNameResult)object).simpleName;
            if (string2.length() == 0) {
                return namespace;
            }
            if (namespace.childTable.get(string2) != null) {
                interp.setResult("can't create namespace \"" + string + "\": already exists");
                return null;
            }
        }
        Namespace namespace3 = new Namespace();
        namespace3.name = string2;
        namespace3.fullName = null;
        namespace3.deleteProc = deleteProc;
        namespace3.parent = namespace;
        namespace3.childTable = new HashMap();
        object = nsMutex;
        synchronized (object) {
            namespace3.nsId = ++numNsCreated;
        }
        namespace3.interp = interp;
        namespace3.flags = 0;
        namespace3.activationCount = 0;
        namespace3.refCount = 1;
        namespace3.cmdTable = new HashMap();
        namespace3.varTable = new HashMap();
        namespace3.exportArray = null;
        namespace3.numExportPatterns = 0;
        namespace3.maxExportPatterns = 0;
        namespace3.resolver = null;
        if (namespace != null) {
            namespace.childTable.put(string2, namespace3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Namespace namespace4 = namespace3;
        while (namespace4 != null) {
            if (namespace4 != namespace2) {
                stringBuffer.append("::");
                stringBuffer.append(namespace4.name);
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer2.setLength(0);
            stringBuffer2.append(stringBuffer);
            stringBuffer.setLength(0);
            namespace4 = namespace4.parent;
        }
        namespace3.fullName = string = stringBuffer2.toString();
        return namespace3;
    }

    public static void deleteNamespace(Namespace namespace) {
        Namespace namespace2 = namespace;
        Interp interp = namespace2.interp;
        Namespace namespace3 = Namespace.getGlobalNamespace(interp);
        if (namespace2.activationCount > 0) {
            namespace2.flags |= 1;
            if (namespace2.parent != null) {
                namespace2.parent.childTable.remove(namespace2.name);
            }
            namespace2.parent = null;
        } else {
            Namespace.teardownNamespace(namespace2);
            if (namespace2 != namespace3 || (interp.flags & 1) != 0) {
                Var.deleteVars(namespace2.interp, namespace2.varTable);
                namespace2.childTable.clear();
                namespace2.cmdTable.clear();
                if (namespace2.refCount == 0) {
                    Namespace.free(namespace2);
                } else {
                    namespace2.flags |= 2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static void teardownNamespace(Namespace namespace) {
        Namespace namespace2;
        WrappedCommand wrappedCommand;
        Interp interp = namespace.interp;
        Namespace namespace3 = Namespace.getGlobalNamespace(interp);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, WrappedCommand> object2 : namespace.cmdTable.entrySet()) {
            if (!object2.getValue().hasCommandTraces()) continue;
            arrayList.add(object2.getKey());
        }
        for (String string : arrayList) {
            wrappedCommand = namespace.cmdTable.get(string);
            if (wrappedCommand == null) continue;
            wrappedCommand.callCommandTraces(0, "");
            wrappedCommand.removeAllCommandTraces();
        }
        arrayList = null;
        if (namespace == namespace3) {
            void var8_10;
            Object object;
            try {
                object = interp.getVar("errorInfo", 1).toString();
            }
            catch (TclException tclException) {
                object = null;
            }
            try {
                String string = interp.getVar("errorCode", 1).toString();
            }
            catch (TclException tclException) {
                Object var8_9 = null;
            }
            Var.deleteVars(interp, namespace.varTable);
            if (object != null) {
                try {
                    interp.setVar("errorInfo", (String)object, 1);
                }
                catch (TclException tclException) {
                    // empty catch block
                }
            }
            if (var8_10 != null) {
                try {
                    interp.setVar("errorCode", (String)var8_10, 1);
                }
                catch (TclException tclException) {}
            }
        } else {
            Var.deleteVars(interp, namespace.varTable);
        }
        if (namespace.parent != null) {
            namespace.parent.childTable.remove(namespace.name);
        }
        namespace.parent = null;
        while ((namespace2 = (Namespace)Namespace.FirstHashEntry(namespace.childTable)) != null) {
            Namespace.deleteNamespace(namespace2);
        }
        while ((wrappedCommand = (WrappedCommand)Namespace.FirstHashEntry(namespace.cmdTable)) != null) {
            interp.deleteCommandFromToken(wrappedCommand);
        }
        if (namespace.exportArray != null) {
            namespace.exportArray = null;
            namespace.numExportPatterns = 0;
            namespace.maxExportPatterns = 0;
        }
        if (namespace.deleteProc != null) {
            namespace.deleteProc.delete();
        }
        namespace.deleteProc = null;
        namespace.nsId = 0L;
    }

    public static void free(Namespace namespace) {
        namespace.name = null;
        namespace.fullName = null;
    }

    public static void exportList(Interp interp, Namespace namespace, String string, boolean bl) throws TclException {
        Namespace namespace2 = Namespace.getCurrentNamespace(interp);
        Namespace namespace3 = namespace == null ? namespace2 : namespace;
        if (bl && namespace3.exportArray != null) {
            for (int i = 0; i < namespace3.numExportPatterns; ++i) {
                namespace3.exportArray[i] = null;
            }
            namespace3.exportArray = null;
            namespace3.numExportPatterns = 0;
            namespace3.maxExportPatterns = 0;
        }
        GetNamespaceForQualNameResult getNamespaceForQualNameResult = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string, namespace3, 512, getNamespaceForQualNameResult);
        Namespace namespace4 = getNamespaceForQualNameResult.ns;
        String string2 = getNamespaceForQualNameResult.simpleName;
        if (namespace4 != namespace3 || string.compareTo(string2) != 0) {
            throw new TclException(interp, "invalid export pattern \"" + string + "\": pattern can't specify a namespace");
        }
        int n = namespace3.numExportPatterns + 1;
        if (namespace3.exportArray == null) {
            namespace3.exportArray = new String[5];
            namespace3.numExportPatterns = 0;
            namespace3.maxExportPatterns = 5;
        } else if (n > namespace3.maxExportPatterns) {
            int n2 = 2 * namespace3.maxExportPatterns;
            String[] stringArray = new String[n2];
            System.arraycopy(namespace3.exportArray, 0, stringArray, 0, namespace3.numExportPatterns);
            namespace3.exportArray = stringArray;
            namespace3.maxExportPatterns = n2;
        }
        namespace3.exportArray[namespace3.numExportPatterns] = string;
        ++namespace3.numExportPatterns;
    }

    public static void appendExportList(Interp interp, Namespace namespace, TclObject tclObject) throws TclException {
        Namespace namespace2 = namespace == null ? Namespace.getCurrentNamespace(interp) : namespace;
        if (namespace2.exportArray == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(namespace2.exportArray.length);
        for (int i = 0; i < namespace2.numExportPatterns; ++i) {
            hashSet.add(namespace2.exportArray[i]);
        }
        for (String string : hashSet) {
            TclList.append(interp, tclObject, TclString.newInstance(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importList(Interp interp, Namespace namespace, String string, boolean bl) throws TclException {
        Object object;
        String string2;
        WrappedCommand wrappedCommand;
        TclObject[] tclObjectArray;
        Namespace namespace2 = Namespace.getCurrentNamespace(interp);
        Namespace namespace3 = namespace == null ? namespace2 : namespace;
        WrappedCommand wrappedCommand2 = Namespace.findCommand(interp, "auto_import", null, 1);
        if (wrappedCommand2 != null) {
            tclObjectArray = new TclObject[2];
            tclObjectArray[0] = TclString.newInstance("auto_import");
            tclObjectArray[0].preserve();
            tclObjectArray[1] = TclString.newInstance(string);
            tclObjectArray[1].preserve();
            wrappedCommand = wrappedCommand2;
            try {
                if (wrappedCommand.mustCallInvoke(interp)) {
                    wrappedCommand.invoke(interp, tclObjectArray);
                } else {
                    wrappedCommand.cmd.cmdProc(interp, tclObjectArray);
                }
            }
            finally {
                tclObjectArray[0].release();
                tclObjectArray[1].release();
            }
            interp.setResult("");
        }
        if (string.length() == 0) {
            throw new TclException(interp, "empty import pattern");
        }
        tclObjectArray = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string, namespace3, 512, (GetNamespaceForQualNameResult)tclObjectArray);
        Namespace namespace4 = tclObjectArray.ns;
        String string3 = tclObjectArray.simpleName;
        if (namespace4 == null) {
            throw new TclException(interp, "unknown namespace in import pattern \"" + string + "\"");
        }
        if (namespace4 == namespace3) {
            if (string.equals(string3)) {
                throw new TclException(interp, "no namespace specified in import pattern \"" + string + "\"");
            }
            throw new TclException(interp, "import pattern \"" + string + "\" tries to import from namespace \"" + namespace4.name + "\" into itself");
        }
        HashMap<String, AutoloadStub> hashMap = new HashMap<String, AutoloadStub>();
        for (Map.Entry<String, WrappedCommand> entry : namespace4.cmdTable.entrySet()) {
            string2 = entry.getKey();
            if (!Util.stringMatch(string2, string3)) continue;
            wrappedCommand = namespace4.cmdTable.get(string2);
            if (!(wrappedCommand.cmd instanceof AutoloadStub)) continue;
            object = (AutoloadStub)wrappedCommand.cmd;
            hashMap.put(string2, (AutoloadStub)object);
        }
        for (Map.Entry<String, WrappedCommand> entry : hashMap.entrySet()) {
            string2 = entry.getKey();
            object = (AutoloadStub)((Object)entry.getValue());
            ((AutoloadStub)object).load(interp, string2);
        }
        for (Map.Entry<String, WrappedCommand> entry : namespace4.cmdTable.entrySet()) {
            Object object2;
            string2 = entry.getKey();
            if (!Util.stringMatch(string2, string3)) continue;
            boolean bl2 = false;
            for (int i = 0; i < namespace4.numExportPatterns; ++i) {
                if (!Util.stringMatch(string2, namespace4.exportArray[i])) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            object = namespace3.cmdTable.get(string2);
            if (object == null || bl) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(namespace3.fullName);
                if (namespace3 != interp.globalNs) {
                    stringBuffer.append("::");
                }
                stringBuffer.append(string2);
                WrappedCommand wrappedCommand3 = wrappedCommand = namespace4.cmdTable.get(string2);
                object2 = new ArrayList();
                ((ArrayList)object2).add(namespace3.fullName + "::" + string2);
                while (wrappedCommand3.cmd instanceof ImportedCmdData) {
                    wrappedCommand3 = ((ImportedCmdData)wrappedCommand3.cmd).realCmd;
                    String string4 = "";
                    WrappedCommand wrappedCommand4 = wrappedCommand3.ns.cmdTable.get(string2);
                    if (wrappedCommand4 != wrappedCommand3) {
                        for (Map.Entry<String, WrappedCommand> entry2 : wrappedCommand3.ns.cmdTable.entrySet()) {
                            if (entry2.getValue() != wrappedCommand3) continue;
                            string4 = wrappedCommand3.ns.fullName + "::" + entry2.getKey();
                            break;
                        }
                    } else {
                        string4 = wrappedCommand3.ns.fullName + "::" + string2;
                    }
                    if (((ArrayList)object2).contains(string4)) {
                        throw new TclException(interp, "import pattern \"" + string + "\" would create a loop containing command \"" + string4 + "\"");
                    }
                    ((ArrayList)object2).add(string4);
                }
                ImportedCmdData importedCmdData = new ImportedCmdData();
                interp.createCommand(stringBuffer.toString(), importedCmdData);
                WrappedCommand wrappedCommand5 = Namespace.findCommand(interp, stringBuffer.toString(), namespace3, 514);
                importedCmdData.realCmd = wrappedCommand;
                importedCmdData.self = wrappedCommand5;
                ImportRef importRef = new ImportRef();
                importRef.importedCmd = wrappedCommand5;
                importRef.next = wrappedCommand.importRef;
                wrappedCommand.importRef = importRef;
                continue;
            }
            boolean bl3 = true;
            if (((WrappedCommand)object).cmd instanceof ImportedCmdData && (object2 = Namespace.getOriginalCommand((WrappedCommand)object)) == (wrappedCommand = namespace4.cmdTable.get(string2))) {
                bl3 = false;
            }
            if (!bl3) continue;
            throw new TclException(interp, "can't import command \"" + string2 + "\": already exists");
        }
    }

    public static void forgetImport(Interp interp, Namespace namespace, String string) throws TclException {
        WrappedCommand wrappedCommand;
        Namespace namespace2 = namespace == null ? Namespace.getCurrentNamespace(interp) : namespace;
        GetNamespaceForQualNameResult getNamespaceForQualNameResult = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string, namespace2, 512, getNamespaceForQualNameResult);
        Namespace namespace3 = getNamespaceForQualNameResult.ns;
        String string2 = getNamespaceForQualNameResult.simpleName;
        if (namespace3 == null) {
            throw new TclException(interp, "unknown namespace in namespace forget pattern \"" + string + "\"");
        }
        ArrayList<WrappedCommand> arrayList = new ArrayList<WrappedCommand>();
        for (Map.Entry<String, WrappedCommand> iterator : namespace3.cmdTable.entrySet()) {
            String string3 = iterator.getKey();
            wrappedCommand = iterator.getValue();
            if (!Util.stringMatch(string3, string2) || wrappedCommand == null) continue;
            arrayList.add(wrappedCommand);
        }
        if (namespace2 == namespace3) {
            for (WrappedCommand wrappedCommand2 : arrayList) {
                interp.deleteCommandFromToken(wrappedCommand2);
            }
        } else {
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            for (Map.Entry<String, WrappedCommand> entry : namespace2.cmdTable.entrySet()) {
                wrappedCommand = entry.getValue();
                if (!(wrappedCommand.cmd instanceof ImportedCmdData)) continue;
                ImportedCmdData importedCmdData = (ImportedCmdData)wrappedCommand.cmd;
                WrappedCommand wrappedCommand3 = Namespace.getOriginalCommand(wrappedCommand);
                if ((importedCmdData.realCmd.ns != namespace3 || !arrayList.contains(importedCmdData.realCmd)) && (wrappedCommand3.ns != namespace3 || !arrayList.contains(wrappedCommand3))) continue;
                arrayList2.add(wrappedCommand);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                WrappedCommand wrappedCommand4 = (WrappedCommand)iterator.next();
                interp.deleteCommandFromToken(wrappedCommand4);
            }
        }
    }

    public static WrappedCommand getOriginalCommand(WrappedCommand wrappedCommand) {
        WrappedCommand wrappedCommand2 = wrappedCommand;
        if (!(wrappedCommand2.cmd instanceof ImportedCmdData)) {
            return null;
        }
        while (wrappedCommand2.cmd instanceof ImportedCmdData) {
            ImportedCmdData importedCmdData = (ImportedCmdData)wrappedCommand2.cmd;
            wrappedCommand2 = importedCmdData.realCmd;
        }
        return wrappedCommand2;
    }

    static void invokeImportedCmd(Interp interp, ImportedCmdData importedCmdData, TclObject[] tclObjectArray) throws TclException {
        WrappedCommand wrappedCommand = importedCmdData.realCmd;
        if (wrappedCommand.mustCallInvoke(interp)) {
            wrappedCommand.invoke(interp, tclObjectArray);
        } else {
            wrappedCommand.cmd.cmdProc(interp, tclObjectArray);
        }
    }

    static void deleteImportedCmd(ImportedCmdData importedCmdData) {
        WrappedCommand wrappedCommand = importedCmdData.realCmd;
        WrappedCommand wrappedCommand2 = importedCmdData.self;
        ImportRef importRef = null;
        ImportRef importRef2 = wrappedCommand.importRef;
        while (importRef2 != null) {
            if (importRef2.importedCmd == wrappedCommand2) {
                if (importRef == null) {
                    wrappedCommand.importRef = importRef2.next;
                } else {
                    importRef.next = importRef2.next;
                }
                importRef2 = null;
                importedCmdData = null;
                return;
            }
            importRef = importRef2;
            importRef2 = importRef2.next;
        }
        throw new TclRuntimeError("DeleteImportedCmd: did not find cmd in real cmd's list of import references");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void getNamespaceForQualName(Interp interp, String string, Namespace namespace, int n, GetNamespaceForQualNameResult getNamespaceForQualNameResult) {
        getNamespaceForQualNameResult.ns = null;
        getNamespaceForQualNameResult.altNs = null;
        getNamespaceForQualNameResult.actualCxt = null;
        getNamespaceForQualNameResult.simpleName = null;
        Namespace namespace2 = namespace;
        Namespace namespace3 = Namespace.getGlobalNamespace(interp);
        if ((n & 1) != 0) {
            namespace2 = namespace3;
        } else if (namespace2 == null) {
            namespace2 = interp.varFrame != null ? interp.varFrame.ns : interp.globalNs;
        }
        int n2 = 0;
        int n3 = string.length();
        if (n3 >= 2 && string.charAt(0) == ':' && string.charAt(1) == ':') {
            for (n2 = 2; n2 < n3 && string.charAt(n2) == ':'; ++n2) {
            }
            namespace2 = namespace3;
            if (n2 >= n3) {
                getNamespaceForQualNameResult.ns = namespace3;
                getNamespaceForQualNameResult.altNs = null;
                getNamespaceForQualNameResult.actualCxt = namespace3;
                getNamespaceForQualNameResult.simpleName = "";
                return;
            }
        }
        getNamespaceForQualNameResult.actualCxt = namespace2;
        Namespace namespace4 = namespace3;
        if (namespace2 == namespace3 || (n & 0x1002) != 0) {
            namespace4 = null;
        }
        int n4 = n2;
        while (true) {
            String string2;
            int n5;
            if (n2 < n3) {
                n5 = 0;
            } else {
                getNamespaceForQualNameResult.simpleName = (n & 0x1000) != 0 || n4 > n2 && string.charAt(n4 - 1) != ':' ? null : string.substring(n4);
                if ((n & 0x1000) != 0 && n3 == 0 && namespace2 != namespace3) {
                    namespace2 = null;
                }
                getNamespaceForQualNameResult.ns = namespace2;
                getNamespaceForQualNameResult.altNs = namespace4;
                return;
            }
            for (n4 = n2; n4 < n3; ++n5, ++n4) {
                if (n3 - n4 <= 1 || string.charAt(n4) != ':' || string.charAt(n4 + 1) != ':') continue;
                n4 += 2;
                while (n4 < n3 && string.charAt(n4) == ':') {
                    ++n4;
                }
                break;
            }
            if (n4 == n3 && (n4 - n2 < 2 || string.charAt(n4 - 1) != ':' || string.charAt(n4 - 2) != ':')) {
                if ((n & 0x1000) == 0) {
                    getNamespaceForQualNameResult.ns = namespace2;
                    getNamespaceForQualNameResult.altNs = namespace4;
                    getNamespaceForQualNameResult.simpleName = string.substring(n2);
                    return;
                }
                string2 = string.substring(n2);
            } else {
                string2 = string.substring(n2, n2 + n5);
            }
            if (namespace2 != null) {
                Namespace namespace5 = namespace2.childTable.get(string2);
                if (namespace5 != null) {
                    namespace2 = namespace5;
                } else if ((n & 0x800) != 0) {
                    CallFrame callFrame = interp.newCallFrame();
                    Namespace.pushCallFrame(interp, callFrame, namespace2, false);
                    namespace2 = Namespace.createNamespace(interp, string2, null);
                    Namespace.popCallFrame(interp);
                    if (namespace2 == null) {
                        throw new RuntimeException("Could not create namespace " + string2);
                    }
                } else {
                    namespace2 = null;
                }
            }
            if (namespace4 != null) {
                namespace4 = namespace4.childTable.get(string2);
            }
            if (namespace2 == null && namespace4 == null) {
                getNamespaceForQualNameResult.ns = null;
                getNamespaceForQualNameResult.altNs = null;
                getNamespaceForQualNameResult.simpleName = null;
                return;
            }
            n2 = n4;
        }
    }

    public static Namespace findNamespace(Interp interp, String string, Namespace namespace, int n) {
        GetNamespaceForQualNameResult getNamespaceForQualNameResult = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string, namespace, n | 0x1000, getNamespaceForQualNameResult);
        Namespace namespace2 = getNamespaceForQualNameResult.ns;
        if (namespace2 != null) {
            return namespace2;
        }
        if ((n & 0x200) != 0) {
            if (string.startsWith("::")) {
                interp.setResult("namespace \"" + string + "\" not found");
            } else {
                Namespace namespace3 = Namespace.getCurrentNamespace(interp);
                interp.setResult("namespace \"" + string + "\" not found in \"" + namespace3.fullName + "\"");
            }
        }
        return null;
    }

    public static WrappedCommand findCommand(Interp interp, String string, Namespace namespace, int n) throws TclException {
        Object object;
        WrappedCommand wrappedCommand;
        Namespace namespace2 = (n & 1) != 0 ? Namespace.getGlobalNamespace(interp) : (namespace != null ? namespace : Namespace.getCurrentNamespace(interp));
        if (namespace2.resolver != null || interp.resolvers != null) {
            try {
                wrappedCommand = namespace2.resolver != null ? namespace2.resolver.resolveCmd(interp, string, namespace2, n) : null;
                if (wrappedCommand == null && interp.resolvers != null) {
                    object = interp.resolvers.listIterator();
                    while (wrappedCommand == null && object.hasNext()) {
                        Interp.ResolverScheme resolverScheme = (Interp.ResolverScheme)object.next();
                        wrappedCommand = resolverScheme.resolver.resolveCmd(interp, string, namespace2, n);
                    }
                }
                if (wrappedCommand != null) {
                    return wrappedCommand;
                }
            }
            catch (TclException tclException) {
                return null;
            }
        }
        object = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string, namespace, n, (GetNamespaceForQualNameResult)object);
        Namespace namespace3 = ((GetNamespaceForQualNameResult)object).ns;
        Namespace namespace4 = ((GetNamespaceForQualNameResult)object).altNs;
        namespace2 = ((GetNamespaceForQualNameResult)object).actualCxt;
        String string2 = ((GetNamespaceForQualNameResult)object).simpleName;
        wrappedCommand = null;
        for (int i = 0; i < 2 && wrappedCommand == null; ++i) {
            Namespace namespace5;
            if (i == 0) {
                namespace5 = namespace3;
            } else if (i == 1) {
                namespace5 = namespace4;
            } else {
                throw new TclRuntimeError("bad search value" + i);
            }
            if (namespace5 == null || string2 == null) continue;
            wrappedCommand = namespace5.cmdTable.get(string2);
        }
        if (wrappedCommand != null) {
            return wrappedCommand;
        }
        if ((n & 0x200) != 0) {
            throw new TclException(interp, "unknown command \"" + string + "\"");
        }
        return null;
    }

    public static Var findNamespaceVar(Interp interp, String string, Namespace namespace, int n) throws TclException {
        Object object;
        Var var;
        Namespace namespace2 = (n & 1) != 0 ? Namespace.getGlobalNamespace(interp) : (namespace != null ? namespace : Namespace.getCurrentNamespace(interp));
        if (namespace2.resolver != null || interp.resolvers != null) {
            try {
                var = namespace2.resolver != null ? namespace2.resolver.resolveVar(interp, string, namespace2, n) : null;
                if (var == null && interp.resolvers != null) {
                    object = interp.resolvers.listIterator();
                    while (var == null && object.hasNext()) {
                        Interp.ResolverScheme resolverScheme = (Interp.ResolverScheme)object.next();
                        var = resolverScheme.resolver.resolveVar(interp, string, namespace2, n);
                    }
                }
                if (var != null) {
                    return var;
                }
            }
            catch (TclException tclException) {
                return null;
            }
        }
        object = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string, namespace, n, (GetNamespaceForQualNameResult)object);
        Namespace namespace3 = ((GetNamespaceForQualNameResult)object).ns;
        Namespace namespace4 = ((GetNamespaceForQualNameResult)object).altNs;
        namespace2 = ((GetNamespaceForQualNameResult)object).actualCxt;
        String string2 = ((GetNamespaceForQualNameResult)object).simpleName;
        var = null;
        for (int i = 0; i < 2 && var == null; ++i) {
            Namespace namespace5;
            if (i == 0) {
                namespace5 = namespace3;
            } else if (i == 1) {
                namespace5 = namespace4;
            } else {
                throw new TclRuntimeError("bad search value" + i);
            }
            if (namespace5 == null || string2 == null) continue;
            var = namespace5.varTable.get(string2);
        }
        if (var != null) {
            return var;
        }
        if ((n & 0x200) != 0) {
            interp.setResult("unknown variable \"" + string + "\"");
        }
        return null;
    }

    static void resetShadowedCmdRefs(Interp interp, WrappedCommand wrappedCommand) {
        Namespace namespace = Namespace.getGlobalNamespace(interp);
        Namespace[] object = null;
        int n = -1;
        int n2 = 5;
        String string = wrappedCommand.hashKey;
        Namespace namespace2 = wrappedCommand.ns;
        while (namespace2 != null && namespace2 != namespace) {
            WrappedCommand wrappedCommand2;
            boolean bl = true;
            Namespace namespace3 = namespace;
            for (int i = n; i >= 0; --i) {
                void var5_9 = object[i];
                Namespace namespace4 = namespace3.childTable.get(var5_9.name);
                if (namespace4 == null) {
                    bl = false;
                    break;
                }
                namespace3 = namespace4;
            }
            if (bl && (wrappedCommand2 = namespace3.cmdTable.get(string)) != null) {
                for (Map.Entry<String, WrappedCommand> entry : namespace2.cmdTable.entrySet()) {
                    wrappedCommand2 = entry.getValue();
                    wrappedCommand2.incrEpoch();
                }
            }
            if (object == null) {
                object = new Namespace[5];
            }
            if (++n == n2) {
                int n3 = n2 * 2;
                Namespace[] namespaceArray = new Namespace[n3];
                System.arraycopy(object, 0, namespaceArray, 0, object.length);
                object = namespaceArray;
                n2 = n3;
            }
            object[n] = namespace2;
            namespace2 = namespace2.parent;
        }
    }

    public static void setNamespaceResolver(Namespace namespace, Resolver resolver) {
        namespace.resolver = resolver;
    }

    static Resolver getNamespaceResolver(Namespace namespace) {
        return namespace.resolver;
    }

    public static Object FirstHashEntry(HashMap hashMap) {
        Set set = hashMap.entrySet();
        if (set.size() == 0) {
            return null;
        }
        Iterator iterator = set.iterator();
        if (!iterator.hasNext()) {
            throw new TclRuntimeError("no next() object but set size was " + set.size());
        }
        Map.Entry entry = iterator.next();
        Object v = entry.getValue();
        if (v == null) {
            throw new TclRuntimeError("entry value should not be null");
        }
        return v;
    }

    public static class GetNamespaceForQualNameResult {
        public Namespace ns;
        public Namespace altNs;
        public Namespace actualCxt;
        public String simpleName;
    }

    public static class ResolvedNsName {
        public Namespace ns;
        public long nsId;
        public Namespace refNs;
        public int refCount;
    }

    public static interface DeleteProc {
        public void delete();
    }
}

