/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import tcl.lang.EventDeleter;
import tcl.lang.IdleHandler;
import tcl.lang.TclEvent;
import tcl.lang.TclInterruptedException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TimerEvent;
import tcl.lang.TimerHandler;

public class Notifier
implements EventDeleter {
    private static final long PAUSE_WAIT = 100L;
    private TclEvent firstEvent;
    private TclEvent lastEvent;
    private TclEvent markerEvent;
    private TclEvent servicedEvent = null;
    Thread primaryThread;
    private static HashMap<Thread, Notifier> notifierTable = new HashMap();
    ArrayList<TimerHandler> timerList;
    int timerGeneration;
    boolean timerPending;
    ArrayList<IdleHandler> idleList;
    int idleGeneration;
    int refCount;

    private Notifier(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("primaryThread");
        }
        this.primaryThread = thread;
        this.firstEvent = null;
        this.lastEvent = null;
        this.markerEvent = null;
        this.timerList = new ArrayList();
        this.timerGeneration = 0;
        this.idleList = new ArrayList();
        this.idleGeneration = 0;
        this.timerPending = false;
        this.refCount = 0;
    }

    public static synchronized Notifier getNotifierForThread(Thread thread) {
        Notifier notifier = notifierTable.get(thread);
        if (notifier == null) {
            notifier = new Notifier(thread);
            notifierTable.put(thread, notifier);
        }
        return notifier;
    }

    public synchronized void preserve() {
        if (this.refCount < 0) {
            throw new TclRuntimeError("Attempting to preserve a freed Notifier");
        }
        ++this.refCount;
    }

    public synchronized void release() {
        if (this.refCount == 0 && this.primaryThread != null) {
            throw new TclRuntimeError("Attempting to release a Notifier before it's preserved");
        }
        if (this.refCount <= 0) {
            throw new TclRuntimeError("Attempting to release a freed Notifier");
        }
        --this.refCount;
        if (this.refCount == 0) {
            notifierTable.remove(this.primaryThread);
            this.primaryThread = null;
        }
    }

    public synchronized void queueEvent(TclEvent tclEvent, int n) {
        if (this.primaryThread == null) {
            throw new TclRuntimeError("Notifier.queueEvent() with no Interp() objects in the current thread");
        }
        tclEvent.notifier = this;
        if (n == 0) {
            tclEvent.next = null;
            if (this.firstEvent == null) {
                this.firstEvent = tclEvent;
            } else {
                this.lastEvent.next = tclEvent;
            }
            this.lastEvent = tclEvent;
        } else if (n == 1) {
            tclEvent.next = this.firstEvent;
            if (this.firstEvent == null) {
                this.lastEvent = tclEvent;
            }
            this.firstEvent = tclEvent;
        } else if (n == 2) {
            if (this.markerEvent == null) {
                tclEvent.next = this.firstEvent;
                this.firstEvent = tclEvent;
            } else {
                tclEvent.next = this.markerEvent.next;
                this.markerEvent.next = tclEvent;
            }
            this.markerEvent = tclEvent;
            if (tclEvent.next == null) {
                this.lastEvent = tclEvent;
            }
        } else {
            throw new TclRuntimeError("wrong position \"" + n + "\", must be TCL.QUEUE_HEAD, TCL.QUEUE_TAIL or TCL.QUEUE_MARK");
        }
        if (Thread.currentThread() != this.primaryThread) {
            this.notifyAll();
        }
    }

    public synchronized void deleteEvents(EventDeleter eventDeleter) {
        TclEvent tclEvent = null;
        if (eventDeleter == this) {
            tclEvent = this.servicedEvent;
            if (tclEvent == null) {
                throw new TclRuntimeError("servicedEvent was not set by serviceEvent()");
            }
            this.servicedEvent = null;
        }
        TclEvent tclEvent2 = null;
        TclEvent tclEvent3 = this.firstEvent;
        while (tclEvent3 != null) {
            if (tclEvent == null && eventDeleter.deleteEvent(tclEvent3) == 1 || tclEvent3 == tclEvent) {
                if (tclEvent3 == this.firstEvent) {
                    this.firstEvent = tclEvent3.next;
                } else {
                    tclEvent2.next = tclEvent3.next;
                }
                if (tclEvent3.next == null) {
                    this.lastEvent = tclEvent2;
                }
                if (tclEvent3 == this.markerEvent) {
                    this.markerEvent = tclEvent2;
                }
                if (tclEvent3 == tclEvent) {
                    tclEvent = null;
                    break;
                }
            } else {
                tclEvent2 = tclEvent3;
            }
            tclEvent3 = tclEvent3.next;
        }
        if (tclEvent != null) {
            throw new TclRuntimeError("servicedEvent was not removed from the queue");
        }
    }

    @Override
    @Deprecated
    public int deleteEvent(TclEvent tclEvent) {
        throw new TclRuntimeError("The Notifier.deleteEvent() method should not be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int serviceEvent(int n) {
        if ((n & 0xFFFFFFFD) == 0) {
            n |= 0xFFFFFFFD;
        }
        TclEvent tclEvent = null;
        while ((tclEvent = this.getAvailableEvent(tclEvent)) != null) {
            tclEvent.isProcessing = true;
            if (tclEvent.processEvent(n) != 0) {
                tclEvent.isProcessed = true;
                if (tclEvent.needsNotify) {
                    TclEvent tclEvent2 = tclEvent;
                    synchronized (tclEvent2) {
                        tclEvent.notifyAll();
                    }
                }
                this.servicedEvent = tclEvent;
                this.deleteEvents(this);
                return 1;
            }
            tclEvent.isProcessing = false;
        }
        return 0;
    }

    private synchronized TclEvent getAvailableEvent(TclEvent tclEvent) {
        TclEvent tclEvent2 = this.firstEvent;
        while (tclEvent2 != null) {
            if (!tclEvent2.isProcessing && !tclEvent2.isProcessed && tclEvent2 != tclEvent) {
                return tclEvent2;
            }
            tclEvent2 = tclEvent2.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doOneEvent(int n) {
        int n2 = 0;
        if (this.primaryThread == null) {
            throw new TclRuntimeError("Notifier.doOneEvent() with no Interp() objects in the current thread");
        }
        if ((n & 0xFFFFFFFD) == 0) {
            n |= 0xFFFFFFFD;
        }
        while (true) {
            Object object;
            Object object2;
            if ((n & 0xFFFFFFFD) == 32) {
                return this.serviceIdle();
            }
            long l = System.currentTimeMillis();
            if (!this.timerPending && this.timerList.size() > 0) {
                object2 = this.timerList.get(0);
                if (((TimerHandler)object2).atTime <= l) {
                    object = new TimerEvent();
                    ((TimerEvent)object).notifier = this;
                    this.queueEvent((TclEvent)object, 0);
                    this.timerPending = true;
                }
            }
            if (this.serviceEvent(n) != 0) {
                n2 = 1;
                if ((n & 0x20) == 0) break;
                this.serviceIdle();
                break;
            }
            if ((n & 0x20) != 0 && this.serviceIdle() != 0) {
                n2 = 1;
                break;
            }
            if ((n & 2) != 0) break;
            try {
                object2 = this;
                synchronized (object2) {
                    if (this.timerList.size() > 0) {
                        object = this.timerList.get(0);
                        long l2 = ((TimerHandler)object).atTime - l;
                        if (l2 > 0L) {
                            this.wait(l2 < 100L ? l2 : 100L);
                        }
                    } else {
                        this.wait(100L);
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return n2;
    }

    private int serviceIdle() {
        int n = 0;
        int n2 = this.idleGeneration++;
        while (this.idleList.size() > 0) {
            IdleHandler idleHandler = this.idleList.get(0);
            if (idleHandler.generation > n2) break;
            this.idleList.remove(0);
            if (idleHandler.invoke() == 0) continue;
            n = 1;
        }
        return n;
    }

    public synchronized boolean hasActiveInterps() {
        return this.primaryThread != null;
    }

    public static void processTclEvents(Notifier notifier) {
        while (notifier.hasActiveInterps()) {
            try {
                notifier.doOneEvent(-3);
            }
            catch (TclInterruptedException tclInterruptedException) {
                tclInterruptedException.disposeInterruptedInterp();
            }
        }
    }
}

