/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclObjectBase;
import tcl.lang.Util;
import tcl.lang.VarTrace;

final class PrecTraceProc
implements VarTrace {
    static final int TCL_MAX_PREC = 17;

    PrecTraceProc() {
    }

    @Override
    public void traceProc(Interp interp, String string, String string2, int n) throws TclException {
        if ((n & 0x40) != 0) {
            if ((n & 0x80) != 0 && (n & 0x100) == 0) {
                interp.traceVar(string, string2, new PrecTraceProc(), 113);
            }
            return;
        }
        if ((n & 0x10) != 0) {
            interp.setVar(string, string2, Util.precision, n & 1);
            return;
        }
        if (interp.isSafe) {
            throw new TclException(interp, "can't modify precision from a safe interpreter");
        }
        TclObjectBase tclObjectBase = null;
        try {
            tclObjectBase = interp.getVar(string, string2, n & 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        String string3 = tclObjectBase != null ? tclObjectBase.toString() : "";
        StrtoulResult strtoulResult = interp.strtoulResult;
        Util.strtoul(string3, 0, 10, strtoulResult);
        if (strtoulResult.value <= 0L || strtoulResult.value > 17L || strtoulResult.value > 100L || strtoulResult.index == 0 || strtoulResult.index != string3.length()) {
            interp.setVar(string, string2, Util.precision, 1);
            throw new TclException(interp, "improper value for precision");
        }
        Util.precision = (int)strtoulResult.value;
    }
}

