/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class Procedure
implements Command,
CommandWithDispose {
    public TclObject[][] argList;
    public boolean isVarArgs;
    public CharPointer body;
    int body_length;
    public WrappedCommand wcmd;
    String srcFileName;
    int srcLineNumber;

    public Procedure(Interp interp, Namespace namespace, String string, TclObject tclObject, TclObject tclObject2, String string2, int n) throws TclException {
        this.srcFileName = string2;
        this.srcLineNumber = n;
        int n2 = TclList.getLength(interp, tclObject);
        this.argList = new TclObject[n2][2];
        for (int i = 0; i < n2; ++i) {
            TclObject tclObject3 = TclList.index(interp, tclObject, i);
            int n3 = TclList.getLength(interp, tclObject3);
            if (n3 == 0) {
                throw new TclException(interp, "argument with no name");
            }
            if (n3 > 2) {
                throw new TclException(interp, "too many fields in argument specifier \"" + tclObject3 + "\"");
            }
            TclObject tclObject4 = TclList.index(interp, tclObject3, 0);
            String string3 = tclObject4.toString();
            if (string3.indexOf("::") != -1) {
                throw new TclException(interp, "formal parameter \"" + tclObject3 + "\" is not a simple name");
            }
            if (Var.isArrayVarname(string3)) {
                throw new TclException(interp, "formal parameter \"" + tclObject3 + "\" is an array element");
            }
            this.argList[i][0] = tclObject4;
            this.argList[i][0].preserve();
            if (n3 == 2) {
                this.argList[i][1] = TclList.index(interp, tclObject3, 1);
                this.argList[i][1].preserve();
                continue;
            }
            this.argList[i][1] = null;
        }
        this.isVarArgs = n2 > 0 && this.argList[n2 - 1][0].toString().equals("args");
        this.body = new CharPointer(tclObject2.toString());
        this.body_length = this.body.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        block14: {
            CallFrame callFrame = interp.newCallFrame(this, tclObjectArray);
            interp.pushDebugStack(this.srcFileName, this.srcLineNumber);
            try {
                Parser.eval2(interp, this.body.array, this.body.index, this.body_length, 0);
            }
            catch (TclException tclException) {
                int n = tclException.getCompletionCode();
                if (n == 2) {
                    int n2 = interp.updateReturnInfo();
                    if (n2 != 0) {
                        tclException.setCompletionCode(n2);
                        throw tclException;
                    }
                    break block14;
                }
                if (n == 1) {
                    if (this.isLambda()) {
                        TclObject tclObject = TclList.newInstance();
                        TclList.append(interp, tclObject, tclObjectArray, 0, 2);
                        interp.addErrorInfo("\n    (lambda term \"" + tclObject.toString() + "\" line " + interp.errorLine + ")");
                    } else {
                        interp.addErrorInfo("\n    (procedure \"" + tclObjectArray[0] + "\" line " + interp.errorLine + ")");
                    }
                    throw tclException;
                }
                if (n == 3) {
                    throw new TclException(interp, "invoked \"break\" outside of a loop");
                }
                if (n == 4) {
                    throw new TclException(interp, "invoked \"continue\" outside of a loop");
                }
                throw tclException;
            }
            finally {
                interp.popDebugStack();
                if (interp.errInProgress) {
                    callFrame.dispose();
                    interp.errInProgress = true;
                } else {
                    callFrame.dispose();
                }
            }
        }
    }

    @Override
    public void disposeCmd() {
        this.body = null;
        for (int i = 0; i < this.argList.length; ++i) {
            this.argList[i][0].release();
            this.argList[i][0] = null;
            if (this.argList[i][1] == null) continue;
            this.argList[i][1].release();
            this.argList[i][1] = null;
        }
        this.argList = null;
    }

    public boolean isLambda() {
        return this.wcmd.hashKey == null;
    }

    public static boolean isProc(WrappedCommand wrappedCommand) {
        return wrappedCommand.cmd instanceof Procedure;
    }

    public static Procedure findProc(Interp interp, String string) {
        WrappedCommand wrappedCommand;
        try {
            wrappedCommand = Namespace.findCommand(interp, string, null, 0);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        if (wrappedCommand == null) {
            return null;
        }
        WrappedCommand wrappedCommand2 = Namespace.getOriginalCommand(wrappedCommand);
        if (wrappedCommand2 != null) {
            wrappedCommand = wrappedCommand2;
        }
        if (!(wrappedCommand.cmd instanceof Procedure)) {
            return null;
        }
        return (Procedure)wrappedCommand.cmd;
    }
}

