/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class Regex {
    public static final int TCL_REG_BASIC = 0;
    public static final int TCL_REG_EXTENDED = 1;
    public static final int TCL_REG_ADVF = 2;
    public static final int TCL_REG_ADVANCED = 3;
    public static final int TCL_REG_QUOTE = 4;
    public static final int TCL_REG_NOCASE = 8;
    public static final int TCL_REG_NOSUB = 16;
    public static final int TCL_REG_EXPANDED = 32;
    public static final int TCL_REG_NLSTOP = 64;
    public static final int TCL_REG_NLANCH = 128;
    public static final int TCL_REG_NEWLINE = 192;
    public static final int TCL_REG_CANMATCH = 512;
    private Pattern pattern;
    private Matcher matcher;
    private int flags;
    private String regexp;
    private String string;
    private int count;
    private int offset;
    private boolean matchCalled = false;
    private static final Map bracketMap;

    public Regex(String string, String string2, int n, int n2) throws PatternSyntaxException {
        this.initialize(string, string2, n, n2 | 3);
    }

    public Regex(String string, String string2, int n) throws PatternSyntaxException {
        this.initialize(string, string2, n, 3);
    }

    public Regex(String string, String string2, int n, int n2, String string3) throws PatternSyntaxException {
        this.flags = 3 | n2;
        this.parseFlagString(string3, false);
        this.initialize(string, string2, n, this.flags);
    }

    private void initialize(String string, String string2, int n, int n2) throws PatternSyntaxException {
        this.flags = n2;
        this.regexp = string;
        this.string = string2;
        this.count = 0;
        this.offset = n;
        this.pattern = this.compile(string);
        this.matcher = this.pattern.matcher(this.string);
    }

    public boolean match() {
        boolean bl;
        if (this.matchCalled) {
            bl = this.matcher.find();
        } else {
            this.matchCalled = true;
            int n = this.offset;
            if (n > this.string.length()) {
                n = this.string.length();
            }
            bl = this.matcher.find(n);
        }
        if (bl) {
            ++this.count;
        }
        return bl;
    }

    public String replace(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.string.length());
        boolean bl2 = this.match();
        String string2 = null;
        if (bl2) {
            string2 = Regex.parseSubSpec(string);
        }
        while (bl2) {
            this.matcher.appendReplacement(stringBuffer, string2);
            bl2 = bl && this.match();
        }
        this.matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public TclObject getInfo(Interp interp) throws TclException {
        TclObject tclObject = TclList.newInstance();
        String string = String.valueOf(this.matcher.groupCount());
        int n = this.pattern.flags();
        TclList.append(interp, tclObject, TclString.newInstance(string));
        TclList.append(interp, tclObject, TclString.newInstance(""));
        return tclObject;
    }

    protected static String parseSubSpec(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                if (bl) {
                    stringBuffer.append(c);
                    bl = false;
                    continue;
                }
                stringBuffer.append("$0");
                continue;
            }
            if (bl && c == '0') {
                bl = false;
                stringBuffer.append("$0");
                continue;
            }
            if (bl && c >= '1' && c <= '9') {
                bl = false;
                stringBuffer.append('$');
                stringBuffer.append(c);
                continue;
            }
            if (c == '$') {
                if (bl) {
                    stringBuffer.append("\\\\");
                    bl = false;
                }
                stringBuffer.append("\\$");
                continue;
            }
            if (c == '\\') {
                if (bl) {
                    stringBuffer.append("\\\\");
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append("\\\\");
                bl = false;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append("\\\\");
        }
        return stringBuffer.toString();
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public int start() {
        return this.matcher.start();
    }

    public int start(int n) {
        return this.matcher.start(n);
    }

    public int end() {
        return this.matcher.end();
    }

    public int end(int n) {
        return this.matcher.end(n);
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int n) {
        return this.matcher.group(n);
    }

    String getRegexp() {
        return this.regexp;
    }

    String getString() {
        return this.string;
    }

    public int getCount() {
        return this.count;
    }

    public int getOffset() {
        return this.offset;
    }

    private static int endOfDigits(StringBuffer stringBuffer, int n, boolean bl) {
        block4: for (int i = n; i < stringBuffer.length(); ++i) {
            switch (stringBuffer.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    continue block4;
                }
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (bl) continue block4;
                    return i;
                }
                default: {
                    return i;
                }
            }
        }
        return stringBuffer.length();
    }

    public static String getPatternSyntaxMessage(PatternSyntaxException patternSyntaxException) {
        String string = "couldn't compile regular expression pattern: ";
        String string2 = null;
        String string3 = patternSyntaxException.getMessage();
        int n = patternSyntaxException.getIndex();
        String string4 = patternSyntaxException.getPattern();
        if (string3.indexOf("Unclosed group near") != -1) {
            string2 = "parentheses () not balanced";
        } else if (string3.indexOf("Unclosed character class near") != -1) {
            string2 = "brackets [] not balanced";
        } else if (string3.indexOf("Dangling meta character") != -1) {
            string2 = "quantifier operand invalid";
        } else if (string3.indexOf("Unclosed counted closure") != -1) {
            string2 = "braces {} not balanced";
        }
        if (string2 == null) {
            string2 = patternSyntaxException.getMessage();
        }
        return string + string2;
    }

    protected int getJavaFlags() {
        int n = 0;
        n = (this.flags & 8) == 8 ? (n |= 2) : (n &= 0xFFFFFFFD);
        n = (this.flags & 0x40) == 64 ? (n &= 0xFFFFFFDF) : (n |= 0x20);
        return n;
    }

    protected int parseFlagString(String string, boolean bl) throws PatternSyntaxException {
        int n = string.length();
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl) {
            if (n < 3) {
                return 0;
            }
            if ((this.flags & 4) != 0) {
                return 0;
            }
        } else {
            if ((this.flags & 0x20) != 0) {
                bl4 = true;
            }
            if ((this.flags & 0xC0) == 192) {
                bl4 = true;
            }
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (i == 0 && c != '(') {
                    return 0;
                }
                if (i == 1 && c != '?') {
                    return 0;
                }
                if (i == 2 && c == ':') {
                    return 0;
                }
                if (i == 2 && c == '=') {
                    return 0;
                }
                if (i > 1 && c == ')') {
                    return i + 1;
                }
                if (i < 2) continue;
            }
            switch (c) {
                case 'a': {
                    if (bl) {
                        bl2 = false;
                        break;
                    }
                    this.flags |= 2;
                    bl4 = true;
                    break;
                }
                case 'b': {
                    this.flags &= 0xFFFFFFFC;
                    break;
                }
                case 'c': {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 'e': {
                    this.flags &= 0xFFFFFFFC;
                    this.flags |= 1;
                    bl4 = true;
                    break;
                }
                case 'i': {
                    this.flags |= 8;
                    break;
                }
                case 'n': {
                    bl4 = true;
                }
                case 'm': {
                    this.flags |= 0xC0;
                    break;
                }
                case 'p': {
                    this.flags |= 0x40;
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 'q': {
                    this.flags |= 4;
                    bl3 = true;
                    break;
                }
                case 's': {
                    if (!bl) break;
                    this.flags &= 0xFFFFFF3F;
                    break;
                }
                case 't': {
                    if (bl) {
                        this.flags &= 0xFFFFFFDF;
                        break;
                    }
                    this.flags |= 0x200;
                    break;
                }
                case 'w': {
                    this.flags &= 0xFFFFFFBF;
                    this.flags |= 0x80;
                    break;
                }
                case 'x': {
                    this.flags |= 0x20;
                    bl4 = true;
                    break;
                }
                case '$': 
                case '+': 
                case '^': {
                    if (bl) {
                        bl2 = false;
                        break;
                    }
                    throw new PatternSyntaxException("Unsupported xflag " + c, string, 0);
                }
                default: {
                    if (!bl) break;
                    bl2 = false;
                }
            }
            if (bl2) continue;
            throw new PatternSyntaxException("Unknown flag " + c, string, i);
        }
        if (!bl && bl3 && bl4) {
            throw new PatternSyntaxException("Incompatible xflags: q with e, a, x or n", string, 0);
        }
        return n;
    }

    protected void testForUnsupportedFlags() throws PatternSyntaxException {
        if ((this.flags & 3) == 0) {
            throw new PatternSyntaxException("BREs not supported", this.regexp, 0);
        }
        if ((this.flags & 3) == 1) {
            throw new PatternSyntaxException("EREs not supported", this.regexp, 0);
        }
        if ((this.flags & 3) == 2) {
            throw new PatternSyntaxException("RREs not supported", this.regexp, 0);
        }
        if ((this.flags & 0x200) != 0) {
            throw new PatternSyntaxException("TCL_REG_CANMATCH not supported", this.regexp, 0);
        }
    }

    private static boolean isCommentWhitespace(StringBuffer stringBuffer, int n, boolean bl, int n2) {
        if ((n2 & 0x20) == 0) {
            return false;
        }
        if (bl) {
            return false;
        }
        if (n >= stringBuffer.length()) {
            return false;
        }
        return Character.isWhitespace(stringBuffer.charAt(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Pattern compile(String string) throws PatternSyntaxException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        Stack<Boolean> stack = new Stack<Boolean>();
        Stack<Integer> stack2 = new Stack<Integer>();
        Vector<Boolean> vector = new Vector<Boolean>();
        if (stringBuffer.length() >= 4 && '*' == stringBuffer.charAt(0) && (this.flags & 4) != 4) {
            String string2 = stringBuffer.substring(0, 4);
            if ("***:".equals(string2)) {
                stringBuffer.delete(0, 4);
                this.flags |= 3;
            } else if ("***=".equals(string2)) {
                stringBuffer.delete(0, 4);
                this.flags |= 4;
            }
        }
        if ((n = this.parseFlagString(stringBuffer.toString(), true)) > 0) {
            stringBuffer.delete(0, n);
        }
        this.testForUnsupportedFlags();
        if (stringBuffer.length() == 0) {
            stringBuffer.insert(0, "^|(?!$)");
            n2 = stringBuffer.length();
        }
        while (n2 < stringBuffer.length() && (this.flags & 4) != 4) {
            int n4;
            int n5;
            if (!bl && stringBuffer.charAt(n2) == '(' && n2 + 3 < stringBuffer.length() && stringBuffer.charAt(n2 + 1) == '?' && stringBuffer.charAt(n2 + 2) == '#') {
                int n6;
                for (n6 = n2 + 3; n6 < stringBuffer.length() && stringBuffer.charAt(n6) != ')'; ++n6) {
                }
                stringBuffer.delete(n2, n6 + 1);
                ++n2;
                continue;
            }
            if (!bl && (this.flags & 0x20) != 0) {
                int n7 = n2;
                while (Regex.isCommentWhitespace(stringBuffer, n7, bl, this.flags)) {
                    ++n7;
                }
                if (n7 < stringBuffer.length() && stringBuffer.charAt(n7) == '#') {
                    ++n7;
                    while (n7 < stringBuffer.length() && stringBuffer.charAt(n7) != '\n') {
                        ++n7;
                    }
                    if (n7 < stringBuffer.length()) {
                        ++n7;
                    }
                }
                if (n7 > n2) {
                    stringBuffer.delete(n2, n7);
                    continue;
                }
            }
            if (!bl && stringBuffer.charAt(n2) == '(') {
                boolean bl2;
                if (n2 + 1 < stringBuffer.length() && stringBuffer.charAt(n2 + 1) != '?') {
                    bl2 = true;
                    stack2.push(new Integer(vector.size()));
                    vector.add(new Boolean(false));
                } else {
                    bl2 = false;
                }
                stack.push(new Boolean(bl2));
                ++n2;
                continue;
            }
            if (!bl && stringBuffer.charAt(n2) == ')') {
                if (stack.empty()) {
                    throw new PatternSyntaxException("Unbalanced parentheses", stringBuffer.toString(), n2);
                }
                boolean bl3 = (Boolean)stack.pop();
                if (bl3) {
                    n5 = (Integer)stack2.pop();
                    vector.set(n5, new Boolean(true));
                }
                ++n2;
                continue;
            }
            if (!bl && '[' == stringBuffer.charAt(n2)) {
                n3 = 0;
                bl = true;
                ++n2;
                continue;
            }
            if (bl) {
                ++n3;
                if (stringBuffer.charAt(n2) == ']') {
                    if (n3 > 2) {
                        n3 = -1;
                        bl = false;
                    } else if (n3 == 2 && stringBuffer.charAt(n2 - 1) != '^') {
                        n3 = -1;
                        bl = false;
                    }
                    ++n2;
                    continue;
                }
            }
            if (n3 == 1 && (this.flags & 0x40) != 0 && stringBuffer.charAt(n2) == '^') {
                stringBuffer.insert(n2 + 1, "\\n");
                n2 += 3;
                continue;
            }
            if (!bl && (this.flags & 0x80) == 128) {
                String string3 = null;
                if ('^' == stringBuffer.charAt(n2)) {
                    string3 = this.offset == 0 ? "(?:^|(?<=\\n))" : "(?<=\\n)";
                }
                if ('$' == stringBuffer.charAt(n2)) {
                    string3 = "(?:$|(?=\\n))";
                }
                if (string3 != null) {
                    stringBuffer.replace(n2, n2 + 1, string3);
                    n2 += string3.length();
                    continue;
                }
            }
            if (this.offset > 0 && !bl && stringBuffer.charAt(n2) == '^' && (this.flags & 0x80) == 0) {
                String string4 = "(?=_)(?!_)";
                stringBuffer.replace(n2, n2 + 1, string4);
                n2 += string4.length();
                continue;
            }
            if ('[' == stringBuffer.charAt(n2)) {
                char c = n2 + 1 < stringBuffer.length() ? (char)stringBuffer.charAt(n2 + 1) : (char)'?';
                if (c == ':' || c == '.' || c == '=') {
                    String string5;
                    if (!bl) {
                        throw new PatternSyntaxException(" [::] [..] [==] not allowed outside of a bracket expression", stringBuffer.toString(), n2);
                    }
                    StringBuffer stringBuffer2 = new StringBuffer("[");
                    stringBuffer2.append(c);
                    for (n4 = n2 + 2; n4 < stringBuffer.length(); ++n4) {
                        char c2 = stringBuffer.charAt(n4);
                        stringBuffer2.append(c2);
                        if (c2 == ']') break;
                    }
                    if ((string5 = (String)bracketMap.get(stringBuffer2.toString())) == null && (c == '.' || c == '=') && stringBuffer2.length() == 5) {
                        string5 = stringBuffer2.substring(2, 3);
                    }
                    if (string5 == null) throw new PatternSyntaxException(stringBuffer2.toString() + " not supported", stringBuffer.toString(), n2);
                    if (c == ':' && (stringBuffer.charAt(n2 + 2) == '>' || stringBuffer.charAt(n2 + 2) == '<')) {
                        stringBuffer.replace(--n2, n2 + 7, string5);
                    } else {
                        stringBuffer.replace(n2, n2 + stringBuffer2.length(), string5);
                    }
                    n2 += string5.length();
                    continue;
                }
                stringBuffer.insert(n2, '\\');
                n2 += 2;
                continue;
            }
            if ('{' == stringBuffer.charAt(n2)) {
                ++n2;
                while (Regex.isCommentWhitespace(stringBuffer, n2, bl, this.flags)) {
                    stringBuffer.delete(n2, n2 + 1);
                }
                if (n2 < stringBuffer.length() && Character.isDigit(stringBuffer.charAt(n2))) continue;
                stringBuffer.insert(n2 - 1, "\\");
                ++n2;
                continue;
            }
            if ('\\' == stringBuffer.charAt(n2)) {
                String string6 = null;
                switch (stringBuffer.charAt(++n2)) {
                    case '0': {
                        string6 = "00";
                        break;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int n8;
                        n5 = Regex.endOfDigits(stringBuffer, n2, false);
                        n4 = n5 - n2;
                        string6 = null;
                        int n9 = Integer.parseInt(stringBuffer.substring(n2, n5), 8);
                        if (n9 > vector.size()) {
                            if (n4 < 2) throw new PatternSyntaxException("invalid backreference number", stringBuffer.toString(), n2);
                            string6 = "0" + stringBuffer.substring(n2, n2 + 1);
                        } else {
                            n8 = ((Boolean)vector.get(n9 - 1)).booleanValue() ? 1 : 0;
                            if (n8 == 0) {
                                throw new PatternSyntaxException("invalid backreference number", stringBuffer.toString(), n2);
                            }
                        }
                        if (string6 != null) break;
                        n2 += n4;
                        break;
                    }
                    case 'A': {
                        string6 = "G";
                        break;
                    }
                    case 'B': {
                        string6 = "\\";
                        break;
                    }
                    case 'b': {
                        string6 = "x08";
                        break;
                    }
                    case 'c': {
                        if (++n2 < stringBuffer.length()) {
                            stringBuffer.setCharAt(n2, Character.toUpperCase(stringBuffer.charAt(n2)));
                            ++n2;
                            break;
                        }
                        string6 = null;
                        break;
                    }
                    case 'M': {
                        if (bl) {
                            throw new PatternSyntaxException("\\M illegal within a bracket expression", stringBuffer.toString(), n2);
                        }
                        string6 = (String)bracketMap.get("[:>:]");
                        stringBuffer.delete(--n2, n2 + 1);
                        break;
                    }
                    case 'm': {
                        if (bl) {
                            throw new PatternSyntaxException("\\m illegal within a bracket expression", stringBuffer.toString(), n2);
                        }
                        string6 = (String)bracketMap.get("[:<:]");
                        stringBuffer.delete(--n2, n2 + 1);
                        break;
                    }
                    case 'U': {
                        if (!"0000".equals(stringBuffer.substring(n2 + 1, n2 + 5))) throw new PatternSyntaxException("32-bit unicode value not supported", stringBuffer.toString(), n2);
                        stringBuffer.setCharAt(n2, 'u');
                        stringBuffer.delete(n2 + 1, n2 + 5);
                        n2 += 4;
                        string6 = null;
                        break;
                    }
                    case 'v': {
                        string6 = "x0b";
                        break;
                    }
                    case 'x': {
                        int n8 = Regex.endOfDigits(stringBuffer, ++n2, true);
                        int n10 = n8 - n2;
                        if (n10 == 0 || n10 == 2) {
                            n2 += n10;
                        } else if (n10 == 1) {
                            stringBuffer.insert(n2, '0');
                            n2 += 2;
                        } else {
                            stringBuffer.delete(n2, n8 - 2);
                            n2 += 2;
                        }
                        string6 = null;
                        break;
                    }
                    case 'Y': {
                        if (bl) {
                            throw new PatternSyntaxException("\\Y illegal within a bracket expression", stringBuffer.toString(), n2);
                        }
                        string6 = "B";
                        break;
                    }
                    case 'y': {
                        if (bl) {
                            throw new PatternSyntaxException("\\y illegal within a bracket expression", stringBuffer.toString(), n2);
                        }
                        string6 = "b";
                        break;
                    }
                    case 'Z': {
                        string6 = "z";
                        break;
                    }
                    case 'E': 
                    case 'G': 
                    case 'Q': 
                    case 'p': 
                    case 'z': {
                        throw new PatternSyntaxException("Illegal escape", stringBuffer.toString(), n2);
                    }
                    default: {
                        string6 = null;
                        ++n2;
                    }
                }
                if (string6 == null) continue;
                stringBuffer.replace(n2, n2 + 1, string6);
                n2 += string6.length();
                continue;
            }
            ++n2;
        }
        if ((this.flags & 4) != 4) return Pattern.compile(stringBuffer.toString(), this.getJavaFlags());
        stringBuffer.insert(0, "\\Q");
        stringBuffer.append("\\E");
        return Pattern.compile(stringBuffer.toString(), this.getJavaFlags());
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("[:alnum:]", "\\p{Alnum}");
        hashMap.put("[:alpha:]", "\\p{Alpha}");
        hashMap.put("[:ascii:]", "\\p{ASCII}");
        hashMap.put("[:blank:]", "\\p{Blank}");
        hashMap.put("[:cntrl:]", "\\p{Cntrl}");
        hashMap.put("[:digit:]", "\\d");
        hashMap.put("[:graph:]", "\\p{Graph}");
        hashMap.put("[:lower:]", "\\p{Lower}");
        hashMap.put("[:print:]", "\\p{Print}");
        hashMap.put("[:punct:]", "\\p{Punct}");
        hashMap.put("[:space:]", "\\s");
        hashMap.put("[:upper:]", "\\p{Upper}");
        hashMap.put("[:word:]", "\\w");
        hashMap.put("[:xdigit:]", "\\p{XDigit}");
        hashMap.put("[:<:]", "(?=\\w)(?<=\\W|^)");
        hashMap.put("[:>:]", "(?=\\W|$)(?<=\\w)");
        hashMap.put("[.\\.]", "\\\\");
        hashMap.put("[.-.]", "\\-");
        hashMap.put("[.].]", "\\]");
        hashMap.put("[.^.]", "\\^");
        hashMap.put("[.NUL.]", "\\00");
        hashMap.put("[.SOH.]", "\\001");
        hashMap.put("[.STX.]", "\\002");
        hashMap.put("[.ETX.]", "\\003");
        hashMap.put("[.EOT.]", "\\004");
        hashMap.put("[.ENQ.]", "\\005");
        hashMap.put("[.ACK.]", "\\006");
        hashMap.put("[.BEL.]", "\\007");
        hashMap.put("[.alert.]", "\\007");
        hashMap.put("[.BS.]", "\\010");
        hashMap.put("[.backspace.]", "\\b");
        hashMap.put("[.HT.]", "\\011");
        hashMap.put("[.tab.]", "\\t");
        hashMap.put("[.LF.]", "\\012");
        hashMap.put("[.newline.]", "\\n");
        hashMap.put("[.VT.]", "\\013");
        hashMap.put("[.vertical-tab.]", "\\013");
        hashMap.put("[.FF.]", "\\014");
        hashMap.put("[.form-feed.]", "\\f");
        hashMap.put("[.CR.]", "\\015");
        hashMap.put("[.carriage-return.]", "\\r");
        hashMap.put("[.SO.]", "\\016");
        hashMap.put("[.SI.]", "\\017");
        hashMap.put("[.DLE.]", "\\020");
        hashMap.put("[.DC1.]", "\\021");
        hashMap.put("[.DC2.]", "\\022");
        hashMap.put("[.DC3.]", "\\023");
        hashMap.put("[.DC4.]", "\\024");
        hashMap.put("[.NAK.]", "\\025");
        hashMap.put("[.SYN.]", "\\026");
        hashMap.put("[.ETB.]", "\\027");
        hashMap.put("[.CAN.]", "\\030");
        hashMap.put("[.EM.]", "\\031");
        hashMap.put("[.SUB.]", "\\032");
        hashMap.put("[.ESC.]", "\\033");
        hashMap.put("[.IS4.]", "\\034");
        hashMap.put("[.FS.]", "\\034");
        hashMap.put("[.IS3.]", "\\035");
        hashMap.put("[.GS.]", "\\035");
        hashMap.put("[.IS2.]", "\\036");
        hashMap.put("[.RS.]", "\\036");
        hashMap.put("[.IS1.]", "\\037");
        hashMap.put("[.US.]", "\\037");
        hashMap.put("[.space.]", "\\ ");
        hashMap.put("[.exclamation-mark.]", "!");
        hashMap.put("[.quotation-mark.]", "\"");
        hashMap.put("[.number-sign.]", "\\#");
        hashMap.put("[.dollar-sign.]", "\\$");
        hashMap.put("[.percent-sign.]", "\\%");
        hashMap.put("[.ampersand.]", "&");
        hashMap.put("[.apostrophe.]", "\\'");
        hashMap.put("[.left-parenthesis.]", "\\(");
        hashMap.put("[.right-parenthesis.]", "\\)");
        hashMap.put("[.asterisk.]", "\\*");
        hashMap.put("[.plus-sign.]", "\\+");
        hashMap.put("[.comma.]", ",");
        hashMap.put("[.hyphen.]", "\\-");
        hashMap.put("[.hyphen-minus.]", "\\-");
        hashMap.put("[.period.]", "\\.");
        hashMap.put("[.full-stop.]", "\\.");
        hashMap.put("[.slash.]", "/");
        hashMap.put("[.solidus.]", "/");
        hashMap.put("[.zero.]", "0");
        hashMap.put("[.one.]", "1");
        hashMap.put("[.two.]", "2");
        hashMap.put("[.three.]", "3");
        hashMap.put("[.four.]", "4");
        hashMap.put("[.five.]", "5");
        hashMap.put("[.six.]", "6");
        hashMap.put("[.seven.]", "7");
        hashMap.put("[.eight.]", "8");
        hashMap.put("[.nine.]", "9");
        hashMap.put("[.colon.]", "\\:");
        hashMap.put("[.semicolon.]", ";");
        hashMap.put("[.less-than-sign.]", "<");
        hashMap.put("[.equals-sign.]", "=");
        hashMap.put("[.greater-than-sign.]", ">");
        hashMap.put("[.question-mark.]", "\\?");
        hashMap.put("[.commercial-at.]", "@");
        hashMap.put("[.left-square-bracket.]", "\\[");
        hashMap.put("[.backslash.]", "\\\\");
        hashMap.put("[.reverse-solidus.]", "\\\\");
        hashMap.put("[.right-square-bracket.]", "\\]");
        hashMap.put("[.circumflex.]", "\\^");
        hashMap.put("[.circumflex-accent.]", "\\^");
        hashMap.put("[.underscore.]", "_");
        hashMap.put("[.low-line.]", "_");
        hashMap.put("[.grave-accent.]", "`");
        hashMap.put("[.left-brace.]", "\\{");
        hashMap.put("[.left-curly-bracket.]", "\\{");
        hashMap.put("[.vertical-line.]", "|");
        hashMap.put("[.right-brace.]", "\\}");
        hashMap.put("[.right-curly-bracket.]", "\\}");
        hashMap.put("[.tilde.]", "~");
        hashMap.put("[.DEL.]", "\\0177");
        bracketMap = Collections.unmodifiableMap(hashMap);
    }
}

