/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.MathFunction;
import tcl.lang.TclException;

class RoundFunction
extends MathFunction {
    RoundFunction() {
        this.argTypes = new int[1];
        this.argTypes[0] = 2;
    }

    @Override
    void apply(Interp interp, ExprValue[] exprValueArray) throws TclException {
        ExprValue exprValue = exprValueArray[0];
        if (exprValue.isDoubleType()) {
            double d = exprValue.getDoubleValue();
            double d2 = d < 0.0 ? Math.ceil(d) : Math.floor(d);
            double d3 = d - d2;
            if (d < 0.0) {
                if (d3 <= -0.5) {
                    d2 += -1.0;
                }
                Expression.checkIntegerRange(interp, d2);
                exprValue.setIntValue((long)d2);
            } else {
                if (d3 >= 0.5) {
                    d2 += 1.0;
                }
                Expression.checkIntegerRange(interp, d2);
                exprValue.setIntValue((long)d2);
            }
        }
    }
}

