/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ConsoleThread;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.cmd.EncodingCmd;

public class Shell {
    public static boolean forceNonInteractive = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        int n;
        String string = null;
        String string2 = EncodingCmd.systemTclEncoding;
        Interp interp = new Interp();
        int n2 = 0;
        if (stringArray.length > n2 && stringArray[n2].equals("-encoding") && stringArray.length > ++n2) {
            string2 = stringArray[n2++];
        }
        if (stringArray.length > n2 && !stringArray[n2].startsWith("-")) {
            string = stringArray[n2++];
        }
        TclObject tclObject = TclList.newInstance();
        tclObject.preserve();
        try {
            n = 0;
            if (string == null) {
                interp.setVar("argv0", "tcl.lang.Shell", 1);
                interp.setVar("tcl_interactive", forceNonInteractive ? "0" : "1", 1);
            } else {
                interp.setVar("argv0", string, 1);
                interp.setVar("tcl_interactive", "0", 1);
            }
            while (n2 < stringArray.length) {
                TclList.append(interp, tclObject, TclString.newInstance(stringArray[n2]));
                ++n;
                ++n2;
            }
            interp.setVar("argv", tclObject, 1);
            interp.setVar("argc", Integer.toString(n), 1);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        finally {
            tclObject.release();
        }
        if (string != null) {
            n = 0;
            try {
                object = EncodingCmd.getJavaName(string2);
                if (object == null) {
                    System.err.println("unknown encoding \"" + string2 + "\"");
                    n = 2;
                } else {
                    interp.evalFile(string, (String)object);
                }
            }
            catch (TclException tclException) {
                int n3 = tclException.getCompletionCode();
                if (n3 == 2) {
                    n3 = interp.updateReturnInfo();
                    if (n3 != 0) {
                        System.err.println("command returned bad code: " + n3);
                        n = 2;
                    }
                }
                if (n3 == 1) {
                    try {
                        TclObject tclObject2 = interp.getVar("errorInfo", 1);
                        System.err.println(tclObject2.toString());
                    }
                    catch (TclException tclException2) {
                        System.err.println(interp.getResult().toString());
                    }
                    n = 1;
                }
                System.err.println("command returned bad code: " + n3);
                n = 2;
            }
            interp.dispose();
            System.exit(n);
        }
        if (string == null) {
            ConsoleThread consoleThread = new ConsoleThread(interp);
            consoleThread.setDaemon(true);
            consoleThread.start();
            object = interp.getNotifier();
            try {
                Notifier.processTclEvents((Notifier)object);
            }
            finally {
                interp.dispose();
            }
        }
    }
}

