/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.cmd.EncodingCmd;

public class TclByteArray
implements InternalRep {
    private int used;
    private byte[] bytes;

    private TclByteArray() {
        this.used = 0;
        this.bytes = new byte[0];
    }

    private TclByteArray(byte[] byArray) {
        this.used = byArray.length;
        this.bytes = new byte[this.used];
        System.arraycopy(byArray, 0, this.bytes, 0, this.used);
    }

    private TclByteArray(byte[] byArray, int n, int n2) {
        this.used = n2;
        this.bytes = new byte[this.used];
        System.arraycopy(byArray, n, this.bytes, 0, this.used);
    }

    private TclByteArray(char[] cArray) {
        this.used = cArray.length;
        this.bytes = new byte[this.used];
        for (int i = 0; i < this.used; ++i) {
            this.bytes[i] = (byte)cArray[i];
        }
    }

    @Override
    public InternalRep duplicate() {
        return new TclByteArray(this.bytes, 0, this.used);
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        char[] cArray = new char[this.used];
        for (int i = 0; i < this.used; ++i) {
            cArray[i] = (char)(this.bytes[i] & 0xFF);
        }
        return new String(cArray);
    }

    public static TclObject newInstance(byte[] byArray, int n, int n2) {
        return new TclObject(new TclByteArray(byArray, n, n2));
    }

    public static TclObject newInstance(byte[] byArray) {
        return new TclObject(new TclByteArray(byArray));
    }

    public static TclObject newInstance() {
        return new TclObject(new TclByteArray());
    }

    static void setByteArrayFromAny(Interp interp, TclObject tclObject) {
        InternalRep internalRep = tclObject.getInternalRep();
        if (!(internalRep instanceof TclByteArray)) {
            char[] cArray = tclObject.toString().toCharArray();
            tclObject.setInternalRep(new TclByteArray(cArray));
        }
    }

    public static byte[] setLength(Interp interp, TclObject tclObject, int n) {
        if (tclObject.isShared()) {
            throw new TclRuntimeError("TclByteArray.setLength() called with shared object");
        }
        TclByteArray.setByteArrayFromAny(interp, tclObject);
        TclByteArray tclByteArray = (TclByteArray)tclObject.getInternalRep();
        if (n > tclByteArray.bytes.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(tclByteArray.bytes, 0, byArray, 0, tclByteArray.used);
            tclByteArray.bytes = byArray;
        }
        tclObject.invalidateStringRep();
        tclByteArray.used = n;
        return tclByteArray.bytes;
    }

    public static final int getLength(Interp interp, TclObject tclObject) {
        TclByteArray.setByteArrayFromAny(interp, tclObject);
        TclByteArray tclByteArray = (TclByteArray)tclObject.getInternalRep();
        return tclByteArray.used;
    }

    public static byte[] getBytes(Interp interp, TclObject tclObject) {
        TclByteArray.setByteArrayFromAny(interp, tclObject);
        TclByteArray tclByteArray = (TclByteArray)tclObject.getInternalRep();
        return tclByteArray.bytes;
    }

    public static String decodeToString(Interp interp, TclObject tclObject, String string) {
        TclByteArray.setByteArrayFromAny(interp, tclObject);
        TclByteArray tclByteArray = (TclByteArray)tclObject.getInternalRep();
        if (string == null || string.equals("identity") || string.equals("binary")) {
            return tclObject.toString();
        }
        String string2 = EncodingCmd.getJavaName(string);
        CharsetDecoder charsetDecoder = Charset.forName(string2).newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.IGNORE);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer charBuffer = null;
        try {
            charBuffer = charsetDecoder.decode(ByteBuffer.wrap(tclByteArray.bytes, 0, tclByteArray.used));
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        if (charBuffer == null) {
            return "";
        }
        return charBuffer.toString();
    }
}

