/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import tcl.lang.Interp;
import tcl.lang.JarFilenameFilter;
import tcl.lang.PackageNameException;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

public class TclClassLoader
extends ClassLoader {
    private HashMap class_cache = new HashMap();
    private String[] classpath = null;
    private String[] loadpath = null;
    private String cached_tclclasspath = null;
    private String lastSearchedClassFile = null;
    private String lastSearchedJarFile = null;
    private ClassLoader parent;
    private Interp interp = null;

    public TclClassLoader(Interp interp, TclObject tclObject, ClassLoader classLoader) {
        super(classLoader);
        if (classLoader == null) {
            throw new TclRuntimeError("parent ClassLoader can't be null");
        }
        this.parent = classLoader;
        this.interp = interp;
        this.init(interp, tclObject);
    }

    private void init(Interp interp, TclObject tclObject) {
        try {
            boolean bl = true;
            if (this.parent instanceof TclClassLoader) {
                if (tclObject == null) {
                    throw new TclRuntimeError("TclClassLoader is a child of the interp class loader but it does not have a -classpath to search");
                }
                bl = false;
            }
            if (tclObject != null) {
                TclObject[] tclObjectArray = TclList.getElements(interp, tclObject);
                this.classpath = new String[tclObjectArray.length];
                for (int i = 0; i < tclObjectArray.length; ++i) {
                    this.classpath[i] = TclClassLoader.absolutePath(interp, tclObjectArray[i].toString());
                }
            }
            if (bl) {
                this.checkTclClasspath();
            }
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }

    public void dispose() {
        this.parent = null;
        this.interp = null;
        this.class_cache = null;
    }

    private void checkTclClasspath() {
        TclObject[] tclObjectArray = null;
        try {
            TclObject tclObject = this.interp.getVar("env", "TCL_CLASSPATH", 1);
            String string = tclObject.toString();
            if (string.length() == 0) {
                this.cached_tclclasspath = "";
                this.loadpath = null;
                return;
            }
            if (this.cached_tclclasspath == null || !string.equals(this.cached_tclclasspath)) {
                this.cached_tclclasspath = string;
                tclObjectArray = TclList.getElements(this.interp, tclObject);
            }
        }
        catch (TclException tclException) {
            this.interp.resetResult();
            this.cached_tclclasspath = null;
            this.loadpath = null;
            return;
        }
        if (tclObjectArray == null) {
            return;
        }
        this.loadpath = new String[tclObjectArray.length];
        for (int i = 0; i < tclObjectArray.length; ++i) {
            this.loadpath[i] = TclClassLoader.absolutePath(this.interp, tclObjectArray[i].toString());
        }
    }

    public Class loadClass(String string) throws ClassNotFoundException, PackageNameException {
        return this.loadClass(string, true);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException, PackageNameException, SecurityException {
        byte[] byArray = null;
        Class<?> clazz = (Class<?>)this.class_cache.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(string, bl, this.parent);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
        if (!string.startsWith("tcl.lang.library.") && (string.startsWith("java.") || string.startsWith("tcl.lang."))) {
            throw new PackageNameException("Java loader failed to load the class and the TclClassLoader is not permitted to load classes in the tcl or java package at runtime, check your CLASSPATH.", string);
        }
        if (this.classpath != null) {
            byArray = this.getClassFromPath(this.classpath, string);
        }
        if (byArray == null) {
            this.checkTclClasspath();
            if (this.loadpath != null) {
                byArray = this.getClassFromPath(this.loadpath, string);
            }
        }
        if (byArray == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassFormatError();
        }
        catch (ClassFormatError classFormatError) {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append(classFormatError.getMessage());
            stringBuffer.append(". ");
            if (this.lastSearchedClassFile != null) {
                stringBuffer.append(this.lastSearchedClassFile);
            } else {
                stringBuffer.append(string);
            }
            if (this.lastSearchedJarFile != null) {
                stringBuffer.append(" loaded from ");
                stringBuffer.append(this.lastSearchedJarFile);
            }
            stringBuffer.append(": class name does not match");
            stringBuffer.append(" the name defined in the classfile");
            throw new ClassFormatError(stringBuffer.toString());
        }
        if (clazz == null) {
            throw new ClassFormatError();
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        this.class_cache.put(string, clazz);
        return clazz;
    }

    @Override
    protected URL findResource(String string) throws PackageNameException {
        URL uRL = null;
        if (string.length() == 0 || string.charAt(0) != '/') {
            return null;
        }
        if (!(string = string.substring(1)).startsWith("tcl/lang/library/") && (string.startsWith("java/") || string.startsWith("tcl/lang/"))) {
            throw new PackageNameException("Can't load resource \"" + string + "\" with java or tcl prefix via TCL_CLASSPATH", string);
        }
        if (this.classpath != null) {
            uRL = this.getURLFromPath(this.classpath, string);
        }
        if (uRL == null) {
            this.checkTclClasspath();
            if (this.loadpath != null) {
                uRL = this.getURLFromPath(this.loadpath, string);
            }
        }
        return uRL;
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        if (uRL == null) {
            uRL = Interp.class.getResource(string);
        }
        if (uRL == null) {
            uRL = this.parent.getResource(string);
        }
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public Class defineClass(String string, byte[] byArray) {
        Class<?> clazz = null;
        try {
            clazz = this.defineClass(null, byArray, 0, byArray.length);
        }
        catch (ClassFormatError classFormatError) {
            System.err.println("TclClassLoader.defineClass():");
            System.err.println(classFormatError.getClass().getName() + ": " + classFormatError.getMessage());
        }
        catch (LinkageError linkageError) {
            System.err.println("TclClassLoader.defineClass():");
            System.err.println(linkageError.getClass().getName() + ": " + linkageError.getMessage());
        }
        if (clazz != null) {
            if (string == null) {
                string = clazz.getName();
            }
            this.class_cache.put(string, clazz);
        }
        return clazz;
    }

    private byte[] getClassFromPath(String[] stringArray, String string) {
        int n = 0;
        byte[] byArray = null;
        this.lastSearchedClassFile = null;
        this.lastSearchedJarFile = null;
        if (stringArray != null) {
            String string2;
            string = string.replace('.', '/') + ".class";
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].toString();
                try {
                    if (string2.endsWith(".jar") || string2.endsWith(".zip")) {
                        byArray = this.extractClassFromJar(string2, string);
                        if (byArray == null) continue;
                        return byArray;
                    }
                    File file = new File(string2, string);
                    if (!file.exists()) continue;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byArray = new byte[fileInputStream.available()];
                    for (int i = fileInputStream.read(byArray); i != byArray.length; i += fileInputStream.read(byArray, i, byArray.length - i)) {
                    }
                    this.lastSearchedClassFile = file.toString();
                    return byArray;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].toString();
                try {
                    byArray = this.getClassFromJar(string2, string);
                    if (byArray == null) continue;
                    return byArray;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private byte[] getClassFromJar(String string, String string2) throws IOException {
        byte[] byArray = null;
        File file = new File(string);
        if (!file.isDirectory()) {
            return null;
        }
        JarFilenameFilter jarFilenameFilter = new JarFilenameFilter();
        String[] stringArray = file.list(jarFilenameFilter);
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length && (byArray = this.extractClassFromJar(string + File.separatorChar + stringArray[i], string2)) == null; ++i) {
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] extractClassFromJar(String string, String string2) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string2.equals(zipEntry.getName())) continue;
                int n = this.getEntrySize(string, string2);
                byte[] byArray = new byte[n];
                for (int i = zipInputStream.read(byArray); i != n; i += zipInputStream.read(byArray, i, n - i)) {
                }
                this.lastSearchedClassFile = string2;
                this.lastSearchedJarFile = string;
                byte[] byArray2 = byArray;
                return byArray2;
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    private int getEntrySize(String string, String string2) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!string2.equals(zipEntry.getName())) continue;
            zipFile.close();
            return (int)zipEntry.getSize();
        }
        return -1;
    }

    private static String absolutePath(Interp interp, String string) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            String string2 = interp.getWorkingDir().toString() + System.getProperty("file.separator") + string;
            file = new File(string2);
        }
        return file.toString();
    }

    public void removeCache(String string) {
        this.class_cache.remove(string);
    }

    private URL getURLFromPath(String[] stringArray, String string) {
        int n = 0;
        URL uRL = null;
        this.lastSearchedClassFile = null;
        this.lastSearchedJarFile = null;
        if (stringArray != null) {
            String string2;
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].toString();
                try {
                    if (string2.endsWith(".jar") || string2.endsWith(".zip")) {
                        uRL = this.extractURLFromJar(string2, string);
                        if (uRL == null) continue;
                        return uRL;
                    }
                    File file = new File(string2, string);
                    if (!file.exists()) continue;
                    uRL = file.toURL();
                    return uRL;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].toString();
                try {
                    uRL = this.getURLFromJar(string2, string);
                    if (uRL == null) continue;
                    return uRL;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private URL getURLFromJar(String string, String string2) throws IOException {
        URL uRL = null;
        JarFilenameFilter jarFilenameFilter = new JarFilenameFilter();
        String[] stringArray = new File(string).list(jarFilenameFilter);
        for (int i = 0; i < stringArray.length && (uRL = this.extractURLFromJar(string + File.separatorChar + stringArray[i], string2)) == null; ++i) {
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL extractURLFromJar(String string, String string2) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                URL uRL;
                if (!string2.equals(zipEntry.getName())) continue;
                File file = new File(string);
                URL uRL2 = file.toURL();
                URL uRL3 = uRL = new URL("jar:" + uRL2.toString() + "!/" + string2);
                return uRL3;
            }
            URL uRL = null;
            return uRL;
        }
    }
}

