/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class TclInteger
implements InternalRep {
    static final TclInteger dummy = new TclInteger();
    private static final boolean validate = false;

    private TclInteger() {
    }

    @Override
    public InternalRep duplicate() {
        throw new TclRuntimeError("TclInteger.duplicate() should not be invoked");
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        throw new TclRuntimeError("TclInteger.toString() should not be invoked");
    }

    public static TclObject newInstance(long l) {
        return new TclObject(l);
    }

    private static void setIntegerFromAny(Interp interp, TclObject tclObject) throws TclException {
        long l = Util.getInt(interp, tclObject.toString());
        tclObject.setInternalRep(dummy);
        tclObject.ivalue = l;
    }

    @Deprecated
    public static int get(Interp interp, TclObject tclObject) throws TclException {
        return (int)TclInteger.getLong(interp, tclObject);
    }

    public static long getLong(Interp interp, TclObject tclObject) throws TclException {
        if (!tclObject.isIntType()) {
            TclInteger.setIntegerFromAny(interp, tclObject);
        }
        return tclObject.ivalue;
    }

    public static int getInt(Interp interp, TclObject tclObject) throws TclException {
        long l = TclInteger.getLong(interp, tclObject);
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new TclException(interp, "integer value too large to represent");
        }
        return (int)l;
    }

    public static boolean isWithinLongRange(Interp interp, TclObject tclObject) {
        if (!tclObject.isIntType()) {
            try {
                TclInteger.setIntegerFromAny(null, tclObject);
            }
            catch (TclException tclException) {
                return false;
            }
        }
        return true;
    }

    public static boolean isWithinIntRange(Interp interp, TclObject tclObject) {
        return TclInteger.isWithinLongRange(interp, tclObject) && tclObject.ivalue >= Integer.MIN_VALUE && tclObject.ivalue <= Integer.MAX_VALUE;
    }

    public static void set(TclObject tclObject, long l) {
        if (!tclObject.isIntType()) {
            tclObject.setInternalRep(dummy);
        }
        tclObject.invalidateStringRep();
        tclObject.ivalue = l;
    }

    public static void incr(Interp interp, TclObject tclObject, long l) throws TclException {
        if (!tclObject.isIntType()) {
            TclInteger.setIntegerFromAny(interp, tclObject);
        }
        tclObject.invalidateStringRep();
        tclObject.ivalue += l;
    }

    static void exprSetInternalRep(TclObject tclObject, long l) {
        tclObject.setInternalRep(dummy);
        tclObject.ivalue = l;
    }
}

