/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.WrappedCommand;

public class TclLambda
implements InternalRep {
    private final Procedure procedure;
    private final String namespaceName;

    private TclLambda(Procedure procedure, String string) {
        this.procedure = procedure;
        this.namespaceName = string;
    }

    @Override
    public void dispose() {
    }

    @Override
    public InternalRep duplicate() {
        return new TclLambda(this.procedure, this.namespaceName);
    }

    public static void apply(Interp interp, TclObject tclObject, TclObject[] tclObjectArray) throws TclException {
        if (!(tclObject.getInternalRep() instanceof TclLambda)) {
            TclLambda.setLambdaFromAny(interp, tclObject);
        }
        TclLambda tclLambda = (TclLambda)tclObject.getInternalRep();
        Procedure procedure = tclLambda.procedure;
        Namespace namespace = Namespace.findNamespace(interp, tclLambda.namespaceName, null, 513);
        if (namespace == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        procedure.wcmd.ns = namespace;
        procedure.cmdProc(interp, tclObjectArray);
    }

    private static void setLambdaFromAny(Interp interp, TclObject tclObject) throws TclException {
        if (tclObject.getInternalRep() instanceof TclLambda) {
            return;
        }
        TclLambda tclLambda = TclLambda.parseLambda(interp, tclObject);
        tclObject.setInternalRep(tclLambda);
    }

    private static TclLambda parseLambda(Interp interp, TclObject tclObject) throws TclException {
        String string;
        TclObject[] tclObjectArray = TclList.getElements(interp, tclObject);
        if (tclObjectArray.length < 2 || tclObjectArray.length > 3) {
            throw new TclException(interp, "can't interpret \"" + tclObject.toString() + "\" as a lambda expression");
        }
        TclObject tclObject2 = tclObjectArray[0];
        TclObject tclObject3 = tclObjectArray[1];
        String string2 = string = tclObjectArray.length == 3 ? tclObjectArray[2].toString() : "::";
        if (!string.startsWith("::")) {
            string = "::" + string;
        }
        String string3 = tclObject.toString();
        Procedure procedure = null;
        try {
            procedure = new Procedure(interp, null, string3, tclObject2, tclObject3, interp.getScriptFile(), interp.getArgLineNumber(1));
        }
        catch (TclException tclException) {
            interp.addErrorInfo("\n    (parsing lambda expression \"" + tclObject.toString() + "\")");
            throw tclException;
        }
        procedure.wcmd = new WrappedCommand();
        procedure.wcmd.cmd = procedure;
        procedure.wcmd.cmdEpoch = 1;
        procedure.wcmd.deleted = false;
        procedure.wcmd.hashKey = null;
        procedure.wcmd.ns = null;
        TclLambda tclLambda = new TclLambda(procedure, string);
        return tclLambda;
    }

    public String toString() {
        throw new TclRuntimeError("string rep of lambda expression is inexplicably null!");
    }
}

