/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TclToken;

class TclParse {
    char[] string;
    int endIndex;
    int commentStart;
    int commentSize;
    int commandStart;
    int commandSize;
    int numWords;
    TclToken[] tokenList;
    int numTokens;
    int tokensAvailable;
    int errorType;
    Interp interp;
    String fileName;
    int lineNum;
    int termIndex;
    boolean incomplete;
    int result;
    int extra;
    private static final int INITIAL_NUM_TOKENS = 20;
    private static final boolean USE_TOKEN_CACHE = true;
    private static final int MAX_CACHED_TOKENS = 50;

    TclParse(Interp interp, char[] cArray, int n, String string, int n2) {
        this.interp = interp;
        this.string = cArray;
        this.endIndex = n;
        this.fileName = string;
        this.lineNum = n2;
        this.tokenList = new TclToken[20];
        this.tokensAvailable = 20;
        this.numTokens = 0;
        this.numWords = 0;
        this.commentStart = -1;
        this.commentSize = 0;
        this.commandStart = -1;
        this.commandSize = 0;
        this.termIndex = n;
        this.incomplete = false;
        this.errorType = 0;
        this.result = 0;
    }

    final TclToken getToken(int n) {
        if (n >= this.tokensAvailable) {
            this.expandTokenArray(n);
        }
        if (this.tokenList[n] == null) {
            this.tokenList[n] = this.grabToken();
        }
        return this.tokenList[n];
    }

    void release() {
        for (int i = this.tokensAvailable - 1; i >= 0; --i) {
            if (this.tokenList[i] == null) continue;
            this.releaseToken(this.tokenList[i]);
            this.tokenList[i] = null;
        }
    }

    static void init(Interp interp) {
        TclToken[] tclTokenArray = new TclToken[50];
        for (int i = 0; i < 50; ++i) {
            tclTokenArray[i] = new TclToken();
        }
        interp.parserTokens = tclTokenArray;
        interp.parserTokensUsed = 0;
    }

    private final TclToken grabToken() {
        if (this.interp == null || this.interp.parserTokensUsed == 50) {
            return new TclToken();
        }
        return this.interp.parserTokens[this.interp.parserTokensUsed++];
    }

    private final void releaseToken(TclToken tclToken) {
        if (this.interp != null && this.interp.parserTokensUsed > 0) {
            this.interp.parserTokens[--this.interp.parserTokensUsed] = tclToken;
        }
    }

    void expandTokenArray(int n) {
        while (n >= this.tokensAvailable) {
            this.tokensAvailable *= 2;
        }
        TclToken[] tclTokenArray = new TclToken[this.tokensAvailable];
        System.arraycopy(this.tokenList, 0, tclTokenArray, 0, this.tokenList.length);
        this.tokenList = tclTokenArray;
    }

    void insertInTokenArray(int n, int n2) {
        int n3 = this.numTokens + n2;
        if (n3 > this.tokensAvailable) {
            this.expandTokenArray(n3);
        }
        System.arraycopy(this.tokenList, n, this.tokenList, n + n2, this.tokenList.length - n - n2);
        for (int i = 0; i < n2; ++i) {
            this.tokenList[n + i] = this.grabToken();
        }
    }

    public String toString() {
        return this.get().toString();
    }

    TclObject get() {
        TclObject tclObject = TclList.newInstance();
        try {
            if (this.commentSize > 0) {
                TclList.append(this.interp, tclObject, TclString.newInstance(new String(this.string, this.commentStart, this.commentSize)));
            } else {
                TclList.append(this.interp, tclObject, TclString.newInstance("-"));
            }
            if (this.commandStart >= this.endIndex + 1) {
                this.commandStart = this.endIndex;
            }
            String string = new String(this.string, this.commandStart, this.commandSize);
            TclList.append(this.interp, tclObject, TclString.newInstance(string));
            TclList.append(this.interp, tclObject, TclInteger.newInstance(this.numWords));
            for (int i = 0; i < this.numTokens; ++i) {
                String string2;
                TclToken tclToken = this.tokenList[i];
                switch (tclToken.type) {
                    case 1: {
                        string2 = "word";
                        break;
                    }
                    case 2: {
                        string2 = "simple";
                        break;
                    }
                    case 4: {
                        string2 = "text";
                        break;
                    }
                    case 8: {
                        string2 = "backslash";
                        break;
                    }
                    case 16: {
                        string2 = "command";
                        break;
                    }
                    case 32: {
                        string2 = "variable";
                        break;
                    }
                    default: {
                        string2 = "??";
                    }
                }
                TclList.append(this.interp, tclObject, TclString.newInstance(string2));
                TclList.append(this.interp, tclObject, TclString.newInstance(tclToken.getTokenString()));
                TclList.append(this.interp, tclObject, TclInteger.newInstance(tclToken.numComponents));
            }
            int n = this.commandStart + this.commandSize;
            TclList.append(this.interp, tclObject, TclString.newInstance(new String(this.string, n, this.endIndex - n)));
        }
        catch (TclException tclException) {
            // empty catch block
        }
        return tclObject;
    }
}

