/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.Expression;
import tcl.lang.FindElemResult;
import tcl.lang.Interp;
import tcl.lang.PrecTraceProc;
import tcl.lang.Regex;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRegexp;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.VarTrace;
import tcl.lang.cmd.FormatCmd;

public class Util {
    static final int TCL_DONT_USE_BRACES = 1;
    static final int USE_BRACES = 2;
    static final int BRACES_UNMATCHED = 4;
    static final String intTooBigCode = "ARITH IOVERFLOW {integer value too large to represent}";
    static final String fpTooBigCode = "ARITH OVERFLOW {floating-point value too large to represent}";
    static char[] cvtIn = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', 'd', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#'};
    static final int maxExponent = 511;
    static final double[] powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    static final int DEFAULT_PRECISION = 12;
    static int precision = 12;

    private Util() {
    }

    public static void strtoul(String string, int n, int n2, StrtoulResult strtoulResult) {
        int n3;
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = string.length();
        char c = '\u0000';
        for (n3 = n; n3 < n4 && ((c = string.charAt(n3)) == ' ' || Character.isWhitespace(c)); ++n3) {
        }
        if (n3 >= n4) {
            strtoulResult.update(0L, 0, -1);
            return;
        }
        if (c == '-') {
            bl2 = true;
        }
        if (c == '-' || c == '+') {
            if (++n3 >= n4) {
                strtoulResult.update(0L, 0, -1);
                return;
            }
            c = string.charAt(n3);
        }
        if (n2 == 0) {
            if (c == '0') {
                if (n3 < n4 - 2 && ((c = string.charAt(++n3)) == 'x' || c == 'X')) {
                    ++n3;
                    n2 = 16;
                }
                if (n2 == 0) {
                    bl = true;
                    n2 = 8;
                }
            } else {
                n2 = 10;
            }
        } else if (n2 == 16 && n3 < n4 - 2 && c == '0' && string.charAt(n3 + 1) == 'x') {
            n3 += 2;
        }
        boolean bl3 = false;
        long l2 = 0L;
        int n5 = 0;
        while (n3 < n4) {
            ++n5;
            int n6 = string.charAt(n3) - 48;
            if (n6 < 0 || n6 > 74 || (n6 = cvtIn[n6]) >= n2) break;
            switch (n2) {
                case 2: {
                    l = l << 1 | (long)n6;
                    bl3 = n5 > 64;
                    break;
                }
                case 8: {
                    l = l << 3 | (long)n6;
                    bl3 = n5 == 22 && n6 > 1 || n5 > 22;
                    break;
                }
                case 16: {
                    l = l << 4 | (long)n6;
                    bl3 = n5 > 16;
                    break;
                }
                default: {
                    l = l * (long)n2 + (long)n6;
                    if (l < l2) {
                        bl3 = true;
                    }
                    l2 = l;
                }
            }
            bl = true;
            ++n3;
        }
        if (bl2) {
            l = -l;
        }
        if (!bl) {
            strtoulResult.update(0L, 0, -1);
        } else if (bl3) {
            strtoulResult.update(l, n3, -2);
        } else {
            strtoulResult.update(l, n3, 0);
        }
    }

    public static long getInt(Interp interp, String string) throws TclException {
        int n = string.length();
        int n2 = 0;
        StrtoulResult strtoulResult = interp == null ? new StrtoulResult() : interp.strtoulResult;
        Util.strtoul(string, n2, 0, strtoulResult);
        if (strtoulResult.errno < 0) {
            if (strtoulResult.errno == -2) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance(intTooBigCode));
                }
                throw new TclException(interp, "integer value too large to represent");
            }
            throw new TclException(interp, "expected integer but got \"" + string + "\"" + Util.checkBadOctal(interp, string));
        }
        if (strtoulResult.index < n) {
            for (n2 = strtoulResult.index; n2 < n; ++n2) {
                char c = string.charAt(n2);
                if (c == ' ' || Character.isWhitespace(c)) continue;
                throw new TclException(interp, "expected integer but got \"" + string + "\"" + Util.checkBadOctal(interp, string));
            }
        }
        return strtoulResult.value;
    }

    public static long getWideInt(Interp interp, String string) throws TclException {
        return Util.getInt(interp, string);
    }

    public static final int getIntForIndex(Interp interp, TclObject tclObject, int n) throws TclException {
        if (tclObject.isIntType()) {
            return (int)TclInteger.getLong(interp, tclObject);
        }
        String string = tclObject.toString();
        int n2 = string.length();
        if (n2 == 0 || !"end".regionMatches(0, string, 0, n2 > 3 ? 3 : n2)) {
            int n3;
            for (int i = 0; i < n2; ++i) {
                if (Character.isDigit(string.charAt(i)) || string.charAt(i) == '-') continue;
                throw new TclException(interp, "bad index \"" + string + "\": must be integer or end?-integer?");
            }
            try {
                n3 = (int)TclInteger.getLong(null, tclObject);
            }
            catch (TclException tclException) {
                throw new TclException(interp, "bad index \"" + string + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, string));
            }
            return n3;
        }
        if (n2 <= 3) {
            return n;
        }
        if (n2 > 4 && string.charAt(3) == '-') {
            String string2 = string.substring(4);
            for (int i = 0; i < string2.length(); ++i) {
                if (Character.isDigit(string2.charAt(i)) || string2.charAt(i) == '-') continue;
                throw new TclException(interp, "bad index \"" + string + "\": must be integer or end?-integer?");
            }
            try {
                int n4 = (int)Util.getInt(interp, string2);
                n4 = -n4;
                return n + n4;
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
        throw new TclException(interp, "bad index \"" + string + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, string.substring(3)));
    }

    public static final String checkBadOctal(Interp interp, String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n < n2 && (string.charAt(n) == '+' || string.charAt(n) == '-')) {
            ++n;
        }
        if (n < n2 && string.charAt(n) == '0') {
            while (n < n2 && Character.isDigit(string.charAt(n))) {
                ++n;
            }
            while (n < n2 && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            if (n >= n2 && interp != null) {
                return " (looks like invalid octal number)";
            }
        }
        return "";
    }

    public static void strtod(String string, int n, int n2, StrtodResult strtodResult) {
        int n3;
        String string2;
        int n4 = -1;
        int n5 = n < 0 ? 0 : n;
        boolean bl = false;
        char c = '\u0000';
        if (n2 < 0) {
            n2 = string.length();
        }
        while (n5 < n2 && ((c = string.charAt(n5)) == ' ' || Character.isWhitespace(c))) {
            ++n5;
        }
        if (n5 >= n2) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        if (c == 'N' || c == 'n') {
            String string3 = string2 = n5 == 0 ? string : string.substring(n5);
            if (string2.toLowerCase().startsWith("nan")) {
                strtodResult.update(Double.NaN, n5 + 3, 0);
                return;
            }
        }
        if (c == '-') {
            bl = true;
        }
        if (c == '-' || c == '+') {
            if (++n5 >= n2) {
                strtodResult.update(0.0, 0, -3);
                return;
            }
            c = string.charAt(n5);
        }
        if (c == 'I') {
            n3 = 0;
            String string4 = string2 = n5 == 0 ? string : string.substring(n5);
            if (string2.startsWith("Infinity")) {
                n3 = "Infinity".length();
            } else if (string2.startsWith("Inf")) {
                n3 = "Inf".length();
            }
            if (n3 > 0) {
                strtodResult.update(bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY, n5 + n3, 0);
                return;
            }
        }
        int n6 = n5;
        n3 = 1;
        int n7 = 0;
        while (true) {
            if (!(c >= '0' && c <= '9' || Character.isDigit(c))) {
                if (c != '.' || n4 >= 0) break;
                n4 = n7;
            }
            if (c != '0' && c != '.') {
                n3 = 0;
            }
            if (++n5 >= n2) break;
            c = string.charAt(n5);
            ++n7;
        }
        if (n5 < n2) {
            if (n6 != n5) {
                c = string.charAt(n5);
            }
            if ((c == 'E' || c == 'e') && n5 < n2 - 1 && ++n5 < n2) {
                c = string.charAt(n5);
                if (c == '-') {
                    ++n5;
                } else if (c == '+') {
                    ++n5;
                }
                n7 = 0;
                if (!(n5 >= n2 || (c = string.charAt(n5)) >= '0' && c <= '9' || Character.isDigit(c))) {
                    n7 = 1;
                }
                if (n5 >= n2 || n7 != 0) {
                    if (c == '-' || c == '+') {
                        --n5;
                    }
                    --n5;
                } else {
                    while (n5 < n2 && ((c = string.charAt(n5)) >= '0' && c <= '9' || Character.isDigit(c))) {
                        ++n5;
                    }
                }
            }
        }
        if (n6 == n5) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        string = string.substring(n6, n5);
        double d = 0.0;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || d == 0.0 && n3 == 0) {
            strtodResult.update(d, n5, -4);
            return;
        }
        if (Double.isNaN(d)) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        strtodResult.update(bl ? -d : d, n5, 0);
    }

    public static double getDouble(Interp interp, String string) throws TclException {
        int n = string.length();
        int n2 = 0;
        StrtodResult strtodResult = interp == null ? new StrtodResult() : interp.strtodResult;
        Util.strtod(string, n2, n, strtodResult);
        if (strtodResult.errno != 0) {
            if (strtodResult.errno == -4) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance(fpTooBigCode));
                }
                throw new TclException(interp, "floating-point value too large to represent");
            }
            throw new TclException(interp, "expected floating-point number but got \"" + string + "\"");
        }
        if (strtodResult.index < n) {
            for (n2 = strtodResult.index; n2 < n; ++n2) {
                char c = string.charAt(n2);
                if (c == ' ' || Character.isWhitespace(c)) continue;
                throw new TclException(interp, "expected floating-point number but got \"" + string + "\"");
            }
        }
        return strtodResult.value;
    }

    public static TclObject concat(int n, int n2, TclObject[] tclObjectArray) throws TclException {
        int n3;
        String string;
        TclObject tclObject;
        int n4;
        if (n > tclObjectArray.length) {
            return TclString.newInstance("");
        }
        if (n2 <= tclObjectArray.length) {
            n2 = tclObjectArray.length - 1;
        }
        boolean bl = true;
        for (n4 = n; n4 <= n2; ++n4) {
            tclObject = tclObjectArray[n4];
            if (tclObject.hasNoStringRep() && tclObject.isListType()) continue;
            bl = false;
            break;
        }
        if (bl) {
            TclObject tclObject2 = TclList.newInstance();
            for (n4 = n; n4 <= n2; ++n4) {
                tclObject = tclObjectArray[n4];
                TclObject[] tclObjectArray2 = TclList.getElements(null, tclObject);
                TclList.replace(null, tclObject2, Integer.MAX_VALUE, 0, tclObjectArray2, 0, tclObjectArray2.length - 1);
            }
            return tclObject2;
        }
        int n5 = 0;
        for (n4 = n; n4 <= n2; ++n4) {
            tclObject = tclObjectArray[n4];
            string = tclObject.toString();
            n3 = string.length();
            if (string == null || n3 <= 0) continue;
            n5 += n3 + 1;
        }
        if (n5 == 0) {
            n5 = 1;
        }
        StringBuffer stringBuffer = new StringBuffer(n5);
        for (n4 = n; n4 <= n2; ++n4) {
            char c;
            int n6;
            tclObject = tclObjectArray[n4];
            string = tclObject.toString();
            string = Util.TrimLeft(string, " ");
            n3 = string.length();
            for (n6 = n3 - 1; !(n6 < 0 || (c = string.charAt(n6)) != ' ' && !Character.isWhitespace(c) || n6 > 0 && string.charAt(n6 - 1) == '\\'); --n6) {
            }
            if (n6 != n3 - 1) {
                string = string.substring(0, n6 + 1);
            }
            if (string.length() == 0) {
                if (n4 != n2 || stringBuffer.length() <= 0) continue;
                stringBuffer.setLength(stringBuffer.length() - 1);
                continue;
            }
            stringBuffer.append(string);
            if (n4 >= n2) continue;
            stringBuffer.append(' ');
        }
        return TclString.newInstance(stringBuffer);
    }

    public static final boolean stringMatch(String string, String string2) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        while (true) {
            if (bl) {
                ++n3;
                ++n4;
                bl = false;
            }
            if (n3 == n2) {
                return n4 == n;
            }
            if (n4 == n && cArray2[n3] != '*') {
                return false;
            }
            if (cArray2[n3] == '*') {
                if (++n3 == n2) {
                    return true;
                }
                while (true) {
                    if (Util.stringMatch(string.substring(n4), string2.substring(n3))) {
                        return true;
                    }
                    if (n4 == n) {
                        return false;
                    }
                    ++n4;
                }
            }
            if (cArray2[n3] == '?') {
                bl = true;
                continue;
            }
            if (cArray2[n3] == '[') {
                ++n3;
                while (true) {
                    if (n3 == n2 || cArray2[n3] == ']') {
                        return false;
                    }
                    if (n4 == n) {
                        return false;
                    }
                    char c = cArray2[n3];
                    char c2 = cArray[n4];
                    if (n3 + 1 != n2 && cArray2[n3 + 1] == '-') {
                        if ((n3 += 2) == n2) {
                            return false;
                        }
                        char c3 = cArray2[n3];
                        if (c <= c2 && c3 >= c2 || c >= c2 && c3 <= c2) {
                            break;
                        }
                    } else if (c == c2) break;
                    ++n3;
                }
                ++n3;
                while (n3 != n2 && cArray2[n3] != ']') {
                    ++n3;
                }
                if (n3 == n2) {
                    --n3;
                }
                bl = true;
                continue;
            }
            if (cArray2[n3] == '\\' && ++n3 == n2) {
                return false;
            }
            if (n4 == n || cArray2[n3] != cArray[n4]) {
                return false;
            }
            bl = true;
        }
    }

    public static String toTitle(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(Character.toTitleCase(string.charAt(0)));
        stringBuffer.append(string.substring(1).toLowerCase());
        return stringBuffer.toString();
    }

    public static final boolean regExpMatch(Interp interp, String string, TclObject tclObject) throws TclException {
        Regex regex = TclRegexp.compile(interp, tclObject, string);
        return regex.match();
    }

    public static final void appendElement(Interp interp, StringBuffer stringBuffer, String string) throws TclException {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        int n = Util.scanElement(interp, string);
        Util.convertElement(string, n, stringBuffer);
    }

    public static final boolean findElement(Interp interp, String string, int n, int n2, FindElemResult findElemResult) throws TclException {
        int n3 = 0;
        boolean bl = false;
        char c = '\u0000';
        int n4 = 0;
        while (n < n2 && ((c = string.charAt(n)) == ' ' || Character.isWhitespace(c))) {
            ++n;
        }
        if (n >= n2) {
            return false;
        }
        if (c == '{') {
            n3 = 1;
            ++n;
        } else if (c == '\"') {
            bl = true;
            ++n;
        }
        StringBuffer stringBuffer = null;
        int n5 = n;
        int n6 = n;
        block8: while (true) {
            if (n >= n2) {
                String string2;
                int n7 = n;
                n4 = n7 - n5;
                if (n3 != 0) {
                    throw new TclException(interp, "unmatched open brace in list");
                }
                if (bl) {
                    throw new TclException(interp, "unmatched open quote in list");
                }
                if (stringBuffer == null) {
                    string2 = string.substring(n5, n7);
                } else {
                    stringBuffer.append(string.substring(n6, n7));
                    string2 = stringBuffer.toString();
                }
                findElemResult.update(n5, n7, string2, n4);
                return true;
            }
            c = string.charAt(n);
            switch (c) {
                case '{': {
                    if (n3 != 0) {
                        ++n3;
                    }
                    ++n;
                    continue block8;
                }
                case '}': {
                    if (n3 == 1) {
                        int n8;
                        int n9 = n;
                        n4 = n9 - n5;
                        if (n == n2 - 1 || Character.isWhitespace(string.charAt(n + 1))) {
                            String string3;
                            if (stringBuffer == null) {
                                string3 = string.substring(n5, n9);
                            } else {
                                stringBuffer.append(string.substring(n6, n9));
                                string3 = stringBuffer.toString();
                            }
                            findElemResult.update(n5, n9 + 1, string3, n4);
                            return true;
                        }
                        for (n8 = n + 1; n8 < n2 && !Character.isWhitespace(string.charAt(n8)); ++n8) {
                        }
                        throw new TclException(interp, "list element in braces followed by \"" + string.substring(n + 1, n8) + "\" instead of space");
                    }
                    if (n3 != 0) {
                        --n3;
                    }
                    ++n;
                    continue block8;
                }
                case '\\': {
                    BackSlashResult backSlashResult = Interp.backslash(string, n, n2);
                    if (n3 <= 0) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append(string.substring(n6, n));
                        stringBuffer.append(backSlashResult.c);
                        n6 = backSlashResult.nextIndex;
                    }
                    n = backSlashResult.nextIndex;
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (n3 == 0 && !bl) {
                        String string4;
                        int n10 = n;
                        n4 = n10 - n5;
                        if (stringBuffer == null) {
                            string4 = string.substring(n5, n10);
                        } else {
                            stringBuffer.append(string.substring(n6, n10));
                            string4 = stringBuffer.toString();
                        }
                        findElemResult.update(n5, n10, string4, n4);
                        return true;
                    }
                    ++n;
                    continue block8;
                }
                case '\"': {
                    if (bl) {
                        int n11;
                        int n12 = n;
                        n4 = n12 - n5;
                        if (n == n2 - 1 || Character.isWhitespace(string.charAt(n + 1))) {
                            String string5;
                            if (stringBuffer == null) {
                                string5 = string.substring(n5, n12);
                            } else {
                                stringBuffer.append(string.substring(n6, n12));
                                string5 = stringBuffer.toString();
                            }
                            findElemResult.update(n5, n12 + 1, string5, n4);
                            return true;
                        }
                        for (n11 = n + 1; n11 < n2 && !Character.isWhitespace(string.charAt(n11)); ++n11) {
                        }
                        throw new TclException(interp, "list element in quotes followed by \"" + string.substring(n + 1, n11) + "\" instead of space");
                    }
                    ++n;
                    continue block8;
                }
            }
            ++n;
        }
    }

    public static int scanElement(Interp interp, String string) throws TclException {
        char c;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (string == null) {
            string = "";
        }
        if (n4 == (n = string.length())) {
            n3 |= 2;
        } else {
            c = string.charAt(n4);
            if (c == '{' || c == '\"') {
                n3 |= 2;
            }
        }
        while (n4 < n) {
            c = string.charAt(n4);
            switch (c) {
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    if (--n2 >= 0) break;
                    n3 |= 5;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case ';': 
                case '[': {
                    n3 |= 2;
                    break;
                }
                case '\\': {
                    if (n4 >= n - 1 || string.charAt(n4 + 1) == '\n') {
                        n3 = 5;
                        break;
                    }
                    BackSlashResult backSlashResult = Interp.backslash(string, n4, n);
                    n4 = backSlashResult.nextIndex - 1;
                    n3 |= 2;
                }
            }
            ++n4;
        }
        if (n2 != 0) {
            n3 = 5;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void convertElement(String string, int n, StringBuffer stringBuffer) {
        int n2;
        int n3 = 0;
        int n4 = n2 = string == null ? 0 : string.length();
        if (n2 == 0) {
            stringBuffer.append("{}");
            return;
        }
        if ((n & 2) != 0 && (n & 1) == 0) {
            stringBuffer.append('{');
            stringBuffer.append(string);
            stringBuffer.append('}');
            return;
        }
        char c = string.charAt(0);
        if (c == '{') {
            stringBuffer.append('\\');
            stringBuffer.append('{');
            ++n3;
            n |= 4;
        }
        while (n3 < n2) {
            block13: {
                c = string.charAt(n3);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '$': 
                    case ';': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case '{': 
                    case '}': {
                        if ((n & 4) == 0) break;
                        stringBuffer.append('\\');
                        break;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        break block13;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        break block13;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        break block13;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        break block13;
                    }
                    case '\u000b': {
                        stringBuffer.append('\\');
                        stringBuffer.append('v');
                        break block13;
                    }
                }
                stringBuffer.append(c);
            }
            ++n3;
        }
    }

    public static String TrimLeft(String string, String string2) {
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = cArray.length;
        int n3 = cArray2.length;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            boolean bl = true;
            for (int i = 0; i < n3; ++i) {
                char c2 = string2.charAt(i);
                if (c != c2 && (c2 != ' ' || !Character.isWhitespace(c))) continue;
                bl = false;
                break;
            }
            if (bl) break;
        }
        return string.substring(n, n2);
    }

    public static String TrimLeft(String string) {
        return Util.TrimLeft(string, " \n\t\r");
    }

    public static String TrimRight(String string, String string2) {
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = cArray2.length;
        for (n = cArray.length - 1; n >= 0; --n) {
            char c = cArray[n];
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                char c2 = cArray2[i];
                if (c != c2 && (c2 != ' ' || !Character.isWhitespace(c))) continue;
                bl = false;
                break;
            }
            if (bl) break;
        }
        return string.substring(0, n + 1);
    }

    public static String TrimRight(String string) {
        return Util.TrimRight(string, " \n\t\r");
    }

    public static boolean getBoolean(Interp interp, String string) throws TclException {
        String string2 = string.toLowerCase();
        int n = string2.length();
        if (n > 0) {
            char c = string2.charAt(0);
            switch (c) {
                case '0': {
                    if (n != 1) break;
                    return false;
                }
                case '1': {
                    if (n != 1) break;
                    return true;
                }
                case 'f': {
                    if (!"false".startsWith(string2)) break;
                    return false;
                }
                case 'o': {
                    if (n > 1 && "on".startsWith(string2)) {
                        return true;
                    }
                    if (n <= 1 || !"off".startsWith(string2)) break;
                    return false;
                }
                case 'n': {
                    if (!"no".startsWith(string2)) break;
                    return false;
                }
                case 't': {
                    if (!"true".startsWith(string2)) break;
                    return true;
                }
                case 'y': {
                    if (!"yes".startsWith(string2)) break;
                    return true;
                }
            }
        }
        throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
    }

    public static final int getActualPlatform() {
        if (Util.isWindows()) {
            return 1;
        }
        if (Util.isMac()) {
            return 2;
        }
        return 0;
    }

    public static final boolean isUnix() {
        return !Util.isMac() && !Util.isWindows();
    }

    public static final boolean isMac() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.startsWith("mac") && !string.endsWith("x");
    }

    public static final boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("win");
    }

    static boolean isJacl() {
        return true;
    }

    public static boolean looksLikeInt(String string) {
        return Expression.looksLikeInt(string, string.length(), 0, true);
    }

    static void setupPrecisionTrace(Interp interp) {
        try {
            interp.traceVar("tcl_precision", (VarTrace)new PrecTraceProc(), 113);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    public static String printDouble(double d) {
        String string = FormatCmd.toString(d, precision, 10);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '.' && !Character.isLetter(string.charAt(i))) continue;
            return string;
        }
        return string + ".0";
    }

    static String tryGetSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }
}

