/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.channel.Channel;

public class Fcopy {
    Channel source;
    Channel destination;
    long size;
    long bytesWritten = 0L;
    String callback;
    boolean sourceBlocking;
    boolean destinationBlocking;
    int sourceBuffering;
    int destinationBuffering;
    boolean transferBytes;
    boolean doUtf8OutputEncoding = false;
    boolean doUtf8InputEncoding = false;
    char[] cbuf = null;
    byte[] bbuf = null;
    Thread backgroundCopy = null;
    Interp interp;

    public Fcopy(Interp interp, Channel channel, Channel channel2, long l, String string) throws TclException {
        channel.checkRead(interp);
        channel2.checkWrite(interp);
        this.source = channel;
        this.destination = channel2;
        this.size = l;
        this.callback = string;
        this.interp = interp;
    }

    public long getWrittenByteCount() {
        return this.bytesWritten;
    }

    public long start() throws TclException {
        if (this.callback == null) {
            this.getChannelOwnership(Thread.currentThread().getId());
            try {
                this.setup();
                this.doCopy();
            }
            catch (IOException iOException) {
                throw new TclException(this.interp, iOException.getMessage());
            }
            finally {
                this.tearDown();
            }
            return this.bytesWritten;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = null;
                try {
                    Fcopy.this.setup();
                    Fcopy.this.doCopy();
                }
                catch (Exception exception) {
                    string = exception.getMessage();
                }
                finally {
                    Fcopy.this.tearDown();
                }
                if (Fcopy.this.source.isClosed() || Fcopy.this.destination.isClosed()) {
                    return;
                }
                final String string2 = Fcopy.this.callback + " " + Fcopy.this.bytesWritten + (string == null ? "" : " {" + string + "}");
                TclEvent tclEvent = new TclEvent(){

                    @Override
                    public int processEvent(int n) {
                        try {
                            Fcopy.this.interp.eval(string2);
                        }
                        catch (TclException tclException) {
                            Fcopy.this.interp.addErrorInfo("\n    (\"fcopy\" script)");
                            Fcopy.this.interp.backgroundError();
                        }
                        return 1;
                    }
                };
                Fcopy.this.interp.getNotifier().queueEvent(tclEvent, 0);
            }
        };
        this.backgroundCopy = new Thread(runnable);
        this.getChannelOwnership(this.backgroundCopy.getId());
        this.backgroundCopy.setDaemon(true);
        this.backgroundCopy.setName("Fcopy (" + this.interp.toString() + "): " + this.source.getChanName() + " -> " + this.destination.getChanName());
        this.backgroundCopy.start();
        return 0L;
    }

    private void getChannelOwnership(long l) throws TclException {
        if (!this.source.setOwnership(true, 1, l)) {
            throw new TclException(this.interp, "channel \"" + this.source.getChanName() + "\" is busy");
        }
        if (!this.destination.setOwnership(true, 2, l)) {
            this.source.setOwnership(false, 1);
            throw new TclException(this.interp, "channel \"" + this.destination.getChanName() + "\" is busy");
        }
    }

    private void setup() throws TclException, IOException {
        this.source.initInput();
        this.destination.initOutput();
        this.sourceBlocking = this.source.getBlocking();
        this.destinationBlocking = this.destination.getBlocking();
        this.source.setBlocking(true);
        this.destination.setBlocking(true);
        this.sourceBuffering = this.source.getBuffering();
        this.destinationBuffering = this.destination.getBuffering();
        if (this.sourceBuffering == 0) {
            this.source.setBuffering(2);
        }
        if (this.destinationBuffering == 0) {
            this.destination.setBuffering(2);
        }
        String string = this.source.getEncoding() == null ? "binary" : this.source.getEncoding();
        String string2 = this.destination.getEncoding() == null ? "binary" : this.destination.getEncoding();
        boolean bl = this.transferBytes = string.equals(string2) && this.source.getInputTranslation() == this.destination.getOutputTranslation();
        if (this.source.getEncoding() != null && this.destination.getEncoding() == null) {
            this.doUtf8OutputEncoding = true;
            this.destination.setEncoding("utf-8");
        } else if (this.source.getEncoding() == null && this.destination.getEncoding() != null) {
            this.doUtf8InputEncoding = true;
            this.source.setEncoding("utf-8");
        }
        int n = this.source.getBufferSize();
        if (n == 0 || this.sourceBuffering == 2) {
            n = 1;
        }
        if (this.transferBytes) {
            this.bbuf = new byte[n];
        } else {
            this.cbuf = new char[n];
        }
    }

    private void tearDown() {
        this.source.setBlocking(this.sourceBlocking);
        this.destination.setBlocking(this.destinationBlocking);
        this.source.setBuffering(this.sourceBuffering);
        this.destination.setBuffering(this.destinationBuffering);
        this.source.setOwnership(false, 1);
        this.destination.setOwnership(false, 2);
        if (this.doUtf8OutputEncoding) {
            this.destination.setEncoding(null);
        }
        if (this.doUtf8InputEncoding) {
            this.source.setEncoding(null);
        }
    }

    private long doCopy() throws IOException {
        long l = this.destination.outputBuffer.getReceivedByteCount();
        while (!this.source.eof()) {
            int n;
            int n2 = n = this.transferBytes ? this.bbuf.length : this.cbuf.length;
            if (this.size >= 0L) {
                long l2 = this.size - this.bytesWritten;
                if (l2 <= 0L) break;
                if (!this.transferBytes && l2 <= 16L) {
                    l2 = 1L;
                }
                int n3 = n = l2 < (long)n ? (int)l2 : n;
            }
            if (this.source.isClosed()) break;
            int n4 = this.transferBytes ? this.source.finalInputStream.read(this.bbuf, 0, n) : this.source.finalReader.read(this.cbuf, 0, n);
            if (n4 == -1) {
                this.source.eofSeen = true;
                break;
            }
            if (this.destination.isClosed()) break;
            if (this.transferBytes) {
                this.destination.firstOutputStream.write(this.bbuf, 0, n4);
            } else {
                this.destination.firstWriter.write(this.cbuf, 0, n4);
            }
            this.bytesWritten = this.destination.outputBuffer.getReceivedByteCount() - l;
        }
        if (!this.destination.isClosed()) {
            this.destination.firstWriter.flush();
        }
        return this.bytesWritten;
    }
}

