/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterInputStream;
import java.io.IOException;
import tcl.lang.TclIO;
import tcl.lang.channel.Channel;
import tcl.lang.channel.EofInputFilter;

class InputBuffer
extends FilterInputStream {
    private byte[] buffer = null;
    private int requestedBufferSize;
    private volatile int buffering;
    private int position = 0;
    private int limit = 0;
    boolean eofSeen = false;
    private static final int eolChar = TclIO.TRANS_PLATFORM == 3 ? 13 : 10;
    private volatile boolean blockingMode;
    private boolean lastReadWouldHaveBlocked = false;
    private volatile boolean refillInProgress = false;
    private EofInputFilter eofInputFilter = null;
    boolean requestRefill = false;
    Refiller refiller = null;
    boolean closed = false;

    InputBuffer(EofInputFilter eofInputFilter, int n, int n2, boolean bl, Channel channel) {
        super(eofInputFilter);
        this.eofInputFilter = eofInputFilter;
        this.setBuffering(n2);
        this.setBlockingMode(true);
        this.setBufferSize(n);
        this.setBlockingMode(bl);
        this.refiller = new Refiller();
        this.resizeBuffer();
        this.refiller.setDaemon(true);
        this.refiller.setName("InputBuffer Refiller: " + channel.getChanName());
        this.refiller.start();
    }

    void setBlockingMode(boolean bl) {
        this.blockingMode = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeBuffer() {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            int n;
            if (this.refillInProgress) {
                return;
            }
            int n2 = n = this.buffering == 2 ? 1 : this.requestedBufferSize;
            if (this.remaining() > 0 || this.buffer != null && this.buffer.length == n) {
                return;
            }
            this.buffer = new byte[n];
            this.limit = 0;
            this.position = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBufferSize(int n) {
        if (this.refiller == null) {
            this.requestedBufferSize = n;
        } else {
            Object object = this.getRefillerNotifier();
            synchronized (object) {
                this.requestedBufferSize = n;
                this.resizeBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBuffering(int n) {
        if (this.refiller == null) {
            this.buffering = n;
        } else {
            Object object = this.getRefillerNotifier();
            synchronized (object) {
                this.buffering = n;
                this.resizeBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void seekReset() {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            this.position = 0;
            this.limit = 0;
            this.cancelEof();
        }
    }

    boolean lastReadWouldHaveBlocked() {
        return this.lastReadWouldHaveBlocked;
    }

    boolean eof() {
        return this.eofSeen;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.refiller != null) {
            this.refiller.interrupt();
        }
        super.close();
    }

    void cancelEof() {
        this.eofSeen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int remaining() {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            return this.limit - this.position;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.isRefillInProgress()) {
            return 0;
        }
        return this.remaining() + this.eofInputFilter.available();
    }

    final Object getRefillerNotifier() {
        return this.refiller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isRefillInProgress() throws IOException {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            if (this.requestRefill || this.refillInProgress) {
                return true;
            }
            this.refiller.throwIOExceptionIfCaught();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestRefill(boolean bl) throws IOException {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            this.requestRefill = true;
            this.refiller.notifyAll();
            if (bl) {
                while (this.isRefillInProgress()) {
                    try {
                        this.getRefillerNotifier().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            while (this.isRefillInProgress()) {
                try {
                    this.getRefillerNotifier().wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.remaining() == 0) {
                this.requestRefill(true);
            } else {
                this.refiller.throwIOExceptionIfCaught();
            }
            if (this.eofSeen) {
                return -1;
            }
            if (this.buffer.length == 0) {
                int n = super.read();
                if (n == -1) {
                    this.eofSeen = true;
                }
                return n;
            }
            return this.buffer[this.position++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            this.lastReadWouldHaveBlocked = false;
            if (this.refillInProgress) {
                this.lastReadWouldHaveBlocked = true;
                return 0;
            }
            if (this.eofSeen) {
                return -1;
            }
            this.refiller.throwIOExceptionIfCaught();
            if (this.remaining() == 0) {
                if (this.buffering != 1 && super.available() > 0) {
                    int n3;
                    int n4 = Math.min(n2, super.available());
                    if (this.requestedBufferSize > 0 && n4 > this.requestedBufferSize) {
                        n4 = this.requestedBufferSize;
                    }
                    if ((n3 = super.read(byArray, n, n4)) == -1) {
                        this.eofSeen = true;
                    }
                    this.lastReadWouldHaveBlocked = !this.blockingMode && n3 < n2 && !this.eofSeen;
                    return n3;
                }
                if (this.blockingMode) {
                    this.requestRefill(true);
                } else {
                    this.requestRefill(false);
                    this.lastReadWouldHaveBlocked = true;
                    return 0;
                }
            }
            if (this.remaining() == 0 && this.eofSeen) {
                return -1;
            }
            int n5 = Math.min(n2, this.remaining());
            System.arraycopy(this.buffer, this.position, byArray, n, n5);
            this.position += n5;
            this.lastReadWouldHaveBlocked = !this.blockingMode && n5 < n2 && !this.eofSeen;
            return n5;
        }
    }

    private class Refiller
    extends Thread {
        IOException ioException = null;

        private Refiller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void throwIOExceptionIfCaught() throws IOException {
            Object object = InputBuffer.this.getRefillerNotifier();
            synchronized (object) {
                if (this.ioException != null) {
                    IOException iOException = this.ioException;
                    this.ioException = null;
                    throw iOException;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refill() throws IOException {
            if (InputBuffer.this.eofSeen) {
                return;
            }
            if (InputBuffer.this.remaining() > 0) {
                return;
            }
            if (InputBuffer.this.buffering == 0 || InputBuffer.this.buffering == 2) {
                int n = Math.min(InputBuffer.this.buffer.length, InputBuffer.this.eofInputFilter.available());
                if (n < 1) {
                    n = 1;
                }
                int n2 = InputBuffer.this.eofInputFilter.read(InputBuffer.this.buffer, 0, n);
                Object object = InputBuffer.this.getRefillerNotifier();
                synchronized (object) {
                    if (n2 == -1) {
                        InputBuffer.this.eofSeen = true;
                        InputBuffer.this.position = 0;
                        InputBuffer.this.limit = 0;
                        return;
                    }
                    InputBuffer.this.position = 0;
                    InputBuffer.this.limit = n2;
                    return;
                }
            }
            Object object = InputBuffer.this.getRefillerNotifier();
            synchronized (object) {
                InputBuffer.this.limit = 0;
                InputBuffer.this.position = 0;
            }
            while (true) {
                int n = InputBuffer.this.eofInputFilter.read();
                Object object2 = InputBuffer.this.getRefillerNotifier();
                synchronized (object2) {
                    if (n == -1) {
                        if (InputBuffer.this.limit == 0) {
                            InputBuffer.this.eofSeen = true;
                        }
                        return;
                    }
                    ((InputBuffer)InputBuffer.this).buffer[((InputBuffer)InputBuffer.this).limit++] = (byte)(n & 0xFF);
                    if (n == eolChar || InputBuffer.this.limit >= InputBuffer.this.buffer.length) {
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.ioException = null;
            while (!InputBuffer.this.closed) {
                Object object = InputBuffer.this.getRefillerNotifier();
                synchronized (object) {
                    while (!InputBuffer.this.closed && !InputBuffer.this.requestRefill) {
                        try {
                            InputBuffer.this.getRefillerNotifier().wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    this.ioException = null;
                    InputBuffer.this.resizeBuffer();
                    InputBuffer.this.refillInProgress = true;
                }
                try {
                    this.refill();
                }
                catch (IOException iOException) {
                    Object object2 = InputBuffer.this.getRefillerNotifier();
                    synchronized (object2) {
                        this.ioException = iOException;
                    }
                }
                object = InputBuffer.this.getRefillerNotifier();
                synchronized (object) {
                    InputBuffer.this.refillInProgress = false;
                    InputBuffer.this.requestRefill = false;
                    InputBuffer.this.getRefillerNotifier().notifyAll();
                }
            }
        }
    }
}

