/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class MarkableInputStream
extends FilterInputStream {
    protected boolean marked = false;
    private byte[] buf = new byte[0];
    int readPos = 0;
    int writePos = 0;
    int markPos = 0;
    static final int GrowSize = 512;

    public MarkableInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private void saveBytes(byte[] byArray, int n, int n2) {
        int n3 = n2 - (this.buf.length - this.writePos);
        if (n3 > 0) {
            int n4 = (n3 / 512 + 1) * 512 + this.buf.length;
            byte[] byArray2 = new byte[n4];
            System.arraycopy(this.buf, 0, byArray2, 0, this.writePos);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.writePos, n2);
        this.writePos += n2;
        this.readPos += n2;
    }

    private void trimBuf() {
        if (!this.marked && this.readPos == this.writePos && this.buf.length > 0) {
            this.buf = new byte[0];
            this.readPos = 0;
            this.writePos = 0;
        }
    }

    @Override
    public synchronized void mark(int n) {
        this.marked = n > 0;
        this.trimBuf();
        this.markPos = this.readPos;
    }

    public void seekReset() {
        this.readPos = 0;
        this.writePos = 0;
        this.mark(0);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public void unread(int n) {
        if (n != -1) {
            byte[] byArray = new byte[]{(byte)(n & 0xFF)};
            if (!this.marked) {
                this.saveBytes(byArray, 0, 1);
            }
            --this.readPos;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.readPos == this.writePos) {
            int n = super.read();
            if (this.marked && n != -1) {
                byte[] byArray = new byte[]{(byte)(n & 0xFF)};
                this.saveBytes(byArray, 0, 1);
            }
            return n;
        }
        byte by = this.buf[this.readPos++];
        this.trimBuf();
        return by;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = this.writePos - this.readPos;
        if (n5 > 0) {
            n3 = Math.min(n5, n2);
            System.arraycopy(this.buf, this.readPos, byArray, n, n3);
            this.readPos += n3;
            n4 = n3;
            n += n3;
            n2 -= n3;
        }
        this.trimBuf();
        if (n2 > 0) {
            n3 = super.read(byArray, n, n2);
            if (n3 == -1 && n4 == 0) {
                n4 = -1;
            } else {
                if (this.writePos == this.readPos && this.marked) {
                    this.saveBytes(byArray, n, n3);
                }
                n4 += n3;
            }
        }
        return n4;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.marked) {
            throw new IOException("Stream was not marked prior to reset()");
        }
        this.readPos = this.markPos;
    }

    @Override
    public int available() throws IOException {
        return this.writePos - this.readPos + super.available();
    }

    @Override
    public void close() throws IOException {
        this.seekReset();
        super.close();
    }
}

