/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;
import tcl.lang.cmd.EncodingCmd;

public class TclByteArrayChannel
extends Channel {
    Interp interp;
    ByteArrayOutputStream ostream = null;
    ByteArrayInputStream istream = null;

    public TclByteArrayChannel(Interp interp, TclObject tclObject) {
        this.mode = 1;
        this.setEncoding(null);
        if (tclObject.getInternalRep() instanceof TclByteArray) {
            this.istream = new ByteArrayInputStream(TclByteArray.getBytes(interp, tclObject));
        } else {
            String string = tclObject.toString();
            ByteBuffer byteBuffer = Charset.forName(EncodingCmd.systemJavaEncoding).encode(string);
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            this.istream = new ByteArrayInputStream(byArray);
        }
        this.setChanName(TclIO.getNextDescriptor(interp, "bytearray"));
    }

    public TclByteArrayChannel(Interp interp) {
        this.setEncoding(null);
        this.mode = 2;
        this.ostream = new ByteArrayOutputStream();
        this.setChanName(TclIO.getNextDescriptor(interp, "bytearray"));
    }

    public TclObject getTclByteArray() {
        if (this.ostream == null) {
            return TclString.newInstance("");
        }
        TclObject tclObject = TclByteArray.newInstance(this.ostream.toByteArray());
        return tclObject;
    }

    public TclObject getTclString() {
        if (this.ostream == null) {
            return TclString.newInstance("");
        }
        try {
            return TclString.newInstance(this.ostream.toString(EncodingCmd.systemJavaEncoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.getTclByteArray();
        }
    }

    @Override
    String getChanType() {
        return "bytearray";
    }

    @Override
    void implClose() throws IOException {
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.istream == null) {
            throw new RuntimeException("should not be called");
        }
        return this.istream;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        if (this.ostream == null) {
            throw new RuntimeException("should not be called");
        }
        return this.ostream;
    }
}

