/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import tcl.lang.cmd.EncodingCmd;

class UnicodeEncoder
extends Writer {
    private String encoding = null;
    private String requestedEncoding = null;
    private OutputStream out;
    private CharsetEncoder cse = null;

    UnicodeEncoder(OutputStream outputStream, String string) {
        this.out = outputStream;
        this.setEncoding(string);
    }

    void setEncoding(String string) {
        this.requestedEncoding = string;
    }

    private void setEncoding() {
        if (this.encoding == null && this.requestedEncoding == null) {
            return;
        }
        if (this.encoding != null && this.encoding.equals(this.requestedEncoding)) {
            return;
        }
        this.encoding = this.requestedEncoding;
        if (this.encoding == null || "symbol".equals(this.encoding)) {
            this.cse = null;
        } else {
            this.cse = Charset.forName(this.encoding).newEncoder();
            this.cse.onMalformedInput(CodingErrorAction.REPLACE);
            this.cse.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cse != null) {
            CharBuffer charBuffer = CharBuffer.allocate(0);
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            this.cse.encode(charBuffer, byteBuffer, true);
            this.cse.flush(byteBuffer);
            byteBuffer.flip();
            this.out.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        }
        this.out.close();
        this.out = null;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.setEncoding();
        if (this.cse != null) {
            int n3 = Math.max(256, (int)Math.ceil((float)n2 * this.cse.averageBytesPerChar()));
            byte[] byArray = new byte[n3];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            CoderResult coderResult = CoderResult.OVERFLOW;
            while (coderResult == CoderResult.OVERFLOW) {
                coderResult = this.cse.encode(charBuffer, byteBuffer, false);
                byteBuffer.flip();
                this.out.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
                byteBuffer.clear();
            }
            if (charBuffer.remaining() > 0) {
                throw new RuntimeException("Unicode Encoder did not consume all of the input, this is unexpected: pos=" + byteBuffer.position() + " limit=" + byteBuffer.limit() + " result=" + coderResult);
            }
        } else {
            byte[] byArray;
            if (this.encoding == null) {
                byArray = new byte[n2];
                for (int i = 0; i < n2; ++i) {
                    byArray[i] = (byte)(cArray[i + n] & 0xFF);
                }
            } else {
                byArray = EncodingCmd.encodeSymbol(cArray, n, n2);
            }
            this.out.write(byArray, 0, n2);
        }
    }
}

