/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Pipeline;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.TclByteArrayChannel;
import tcl.lang.process.Redirect;

public class ExecCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Object object;
        int n;
        boolean bl = false;
        for (n = 1; n < tclObjectArray.length && ((String)(object = tclObjectArray[n].toString())).length() > 0 && ((String)object).charAt(0) == '-'; ++n) {
            if (!((String)object).equals("-keepnewline")) {
                if (((String)object).equals("--")) {
                    ++n;
                    break;
                }
                throw new TclException(interp, "bad switch \"" + (String)object + "\": must be -keepnewline or --");
            }
            bl = true;
        }
        if (tclObjectArray.length <= n) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? arg ?arg ...?");
        }
        object = new Pipeline(interp, tclObjectArray, n);
        if (((Pipeline)object).getStdinRedirect() == null) {
            ((Pipeline)object).setStdinRedirect(Redirect.inherit());
        }
        TclByteArrayChannel tclByteArrayChannel = null;
        if (((Pipeline)object).getStdoutRedirect() == null && !((Pipeline)object).isExecInBackground()) {
            tclByteArrayChannel = new TclByteArrayChannel(interp);
            ((Pipeline)object).setStdoutRedirect(new Redirect(tclByteArrayChannel, false));
        }
        TclByteArrayChannel tclByteArrayChannel2 = null;
        if (((Pipeline)object).getStderrRedirect() == null && !((Pipeline)object).isExecInBackground()) {
            tclByteArrayChannel2 = new TclByteArrayChannel(interp);
            ((Pipeline)object).setStderrRedirect(new Redirect(tclByteArrayChannel2, false));
        }
        ((Pipeline)object).exec();
        if (((Pipeline)object).isExecInBackground()) {
            TclObject tclObject = TclList.newInstance();
            int[] nArray = ((Pipeline)object).getProcessIdentifiers();
            for (int n2 : nArray) {
                TclList.append(interp, tclObject, TclInteger.newInstance(n2));
            }
            interp.setResult(tclObject);
            Object object2 = new Thread((Runnable)object);
            ((Thread)object2).setDaemon(true);
            ((Thread)object2).setName("ExecCmd background pipeline (" + interp.toString() + ")");
            ((Thread)object2).start();
            ((Pipeline)object).throwAnyExceptions();
            return;
        }
        ((Pipeline)object).waitForExitAndCleanup(false);
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        if (tclByteArrayChannel2 != null) {
            try {
                tclByteArrayChannel2.close();
            }
            catch (IOException iOException) {
                throw new TclException(interp, iOException.getMessage());
            }
            string = tclByteArrayChannel2.getTclString().toString();
            boolean bl3 = bl2 = string.length() > 0 && !((Pipeline)object).isErrorRedirectedToResult();
        }
        if (tclByteArrayChannel != null) {
            try {
                tclByteArrayChannel.close();
            }
            catch (IOException iOException) {
                throw new TclException(interp, iOException.getMessage());
            }
            string2 = tclByteArrayChannel.getTclString().toString();
        }
        int[] nArray = ((Pipeline)object).getProcessIdentifiers();
        int[] nArray2 = ((Pipeline)object).getExitValues();
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 0) continue;
            bl2 = true;
            interp.setErrorCode(TclString.newInstance("CHILDSTATUS " + nArray[i] + " " + nArray2[i]));
        }
        if (bl2) {
            if (string.length() == 0) {
                string = "child process exited abnormally";
            }
            if (!bl && string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            throw new TclException(interp, string2 + string);
        }
        if (!bl && string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (!bl && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if (((Pipeline)object).isErrorRedirectedToResult()) {
            interp.setResult(string + string2);
        } else {
            interp.setResult(string2);
        }
        ((Pipeline)object).throwAnyExceptions();
    }
}

