/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.Map;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.WrappedCommand;

public class InterpAliasCmd
implements CommandWithDispose {
    public TclObject name;
    private Interp targetInterp;
    private TclObject prefix;
    private WrappedCommand slaveCmd;
    private String aliasEntry;
    private Interp slaveInterp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        this.targetInterp.preserve();
        try {
            ++this.targetInterp.nestLevel;
            this.targetInterp.resetResult();
            this.targetInterp.allowExceptions();
            TclObject[] tclObjectArray2 = TclList.getElements(interp, this.prefix);
            TclObject tclObject = TclList.newInstance();
            tclObject.preserve();
            TclList.replace(interp, tclObject, 0, 0, tclObjectArray2, 0, tclObjectArray2.length - 1);
            TclList.replace(interp, tclObject, tclObjectArray2.length, 0, tclObjectArray, 1, tclObjectArray.length - 1);
            TclObject[] tclObjectArray3 = TclList.getElements(interp, tclObject);
            int n = this.targetInterp.invoke(tclObjectArray3, 4);
            tclObject.release();
            --this.targetInterp.nestLevel;
            if (this.targetInterp.nestLevel == 0) {
                if (n == 2) {
                    n = this.targetInterp.updateReturnInfo();
                }
                if (n != 0 && n != 1) {
                    try {
                        this.targetInterp.processUnexpectedResult(n);
                    }
                    catch (TclException tclException) {
                        n = tclException.getCompletionCode();
                    }
                }
            }
            interp.transferResult(this.targetInterp, n);
        }
        finally {
            this.targetInterp.release();
        }
    }

    @Override
    public void disposeCmd() {
        if (this.aliasEntry != null) {
            this.slaveInterp.aliasTable.remove(this.aliasEntry);
        }
        if (this.slaveCmd != null) {
            this.targetInterp.targetTable.remove(this.slaveCmd);
        }
        this.name.release();
        this.prefix.release();
    }

    static void create(Interp interp, Interp interp2, Interp interp3, TclObject tclObject, TclObject tclObject2, int n, TclObject[] tclObjectArray) throws TclException {
        String string = tclObject.toString();
        WrappedCommand wrappedCommand = Namespace.findCommand(interp2, tclObject.toString(), null, 0);
        if (wrappedCommand != null && interp2 != null && wrappedCommand.cmd == interp3.slave) {
            interp2.deleteCommandFromToken(wrappedCommand);
            throw new TclException(interp, "cannot define or rename alias \"" + tclObject + "\": interpreter deleted");
        }
        InterpAliasCmd interpAliasCmd = new InterpAliasCmd();
        interpAliasCmd.name = tclObject;
        tclObject.preserve();
        interpAliasCmd.slaveInterp = interp2;
        interpAliasCmd.targetInterp = interp3;
        interpAliasCmd.prefix = TclList.newInstance();
        interpAliasCmd.prefix.preserve();
        TclList.append(interp, interpAliasCmd.prefix, tclObject2);
        TclList.insert(interp, interpAliasCmd.prefix, 1, tclObjectArray, n, tclObjectArray.length - 1);
        interp2.createCommand(string, interpAliasCmd);
        interpAliasCmd.slaveCmd = Namespace.findCommand(interp2, string, null, 0);
        try {
            interp.preventAliasLoop(interp2, interpAliasCmd.slaveCmd);
        }
        catch (TclException tclException) {
            interp2.deleteCommandFromToken(interpAliasCmd.slaveCmd);
            throw tclException;
        }
        if (interp2.aliasTable.containsKey(string)) {
            InterpAliasCmd interpAliasCmd2 = (InterpAliasCmd)interp2.aliasTable.get(string);
            interp2.deleteCommandFromToken(interpAliasCmd2.slaveCmd);
        }
        interpAliasCmd.aliasEntry = string;
        interp2.aliasTable.put(string, interpAliasCmd);
        interp3.targetTable.put(interpAliasCmd.slaveCmd, interp2);
        interp.setResult(tclObject);
    }

    static void delete(Interp interp, Interp interp2, TclObject tclObject) throws TclException {
        String string = tclObject.toString();
        if (!interp2.aliasTable.containsKey(string)) {
            throw new TclException(interp, "alias \"" + string + "\" not found");
        }
        InterpAliasCmd interpAliasCmd = (InterpAliasCmd)interp2.aliasTable.get(string);
        interp2.deleteCommandFromToken(interpAliasCmd.slaveCmd);
    }

    static void describe(Interp interp, Interp interp2, TclObject tclObject) throws TclException {
        String string = tclObject.toString();
        if (interp2.aliasTable.containsKey(string)) {
            InterpAliasCmd interpAliasCmd = (InterpAliasCmd)interp2.aliasTable.get(string);
            interp.setResult(interpAliasCmd.prefix);
        }
    }

    static void list(Interp interp, Interp interp2) throws TclException {
        TclObject tclObject = TclList.newInstance();
        for (Map.Entry entry : interp2.aliasTable.entrySet()) {
            InterpAliasCmd interpAliasCmd = (InterpAliasCmd)entry.getValue();
            TclList.append(interp, tclObject, interpAliasCmd.name);
        }
        interp.setResult(tclObject);
    }

    public WrappedCommand getTargetCmd(Interp interp) throws TclException {
        TclObject[] tclObjectArray = TclList.getElements(interp, this.prefix);
        String string = tclObjectArray[0].toString();
        return Namespace.findCommand(this.targetInterp, string, null, 0);
    }

    static Interp getTargetInterp(Interp interp, String string) {
        if (!interp.aliasTable.containsKey(string)) {
            return null;
        }
        InterpAliasCmd interpAliasCmd = (InterpAliasCmd)interp.aliasTable.get(string);
        return interpAliasCmd.targetInterp;
    }
}

