/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class LreplaceCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 4) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "list first last ?element element ...?");
        }
        int n = TclList.getLength(interp, tclObjectArray[1]);
        int n2 = Util.getIntForIndex(interp, tclObjectArray[2], n - 1);
        int n3 = Util.getIntForIndex(interp, tclObjectArray[3], n - 1);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= n && n > 0) {
            throw new TclException(interp, "list doesn't contain element " + tclObjectArray[2]);
        }
        if (n3 >= n) {
            n3 = n - 1;
        }
        int n4 = n2 <= n3 ? n3 - n2 + 1 : 0;
        TclObject tclObject = tclObjectArray[1];
        boolean bl = false;
        if (tclObject.isShared()) {
            tclObject = tclObject.duplicate();
            bl = true;
        }
        try {
            TclList.replace(interp, tclObject, n2, n4, tclObjectArray, 4, tclObjectArray.length - 1);
            interp.setResult(tclObject);
        }
        catch (TclException tclException) {
            if (bl) {
                tclObject.release();
            }
            throw tclException;
        }
    }
}

