/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class LsortCmd
implements Command {
    private static final String[] validOpts = new String[]{"-ascii", "-command", "-decreasing", "-dictionary", "-increasing", "-index", "-integer", "-real", "-unique"};
    static final int OPT_ASCII = 0;
    static final int OPT_COMMAND = 1;
    static final int OPT_DECREASING = 2;
    static final int OPT_DICTIONARY = 3;
    static final int OPT_INCREASING = 4;
    static final int OPT_INDEX = 5;
    static final int OPT_INTEGER = 6;
    static final int OPT_REAL = 7;
    static final int OPT_UNIQUE = 8;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?options? list");
        }
        String string = null;
        int n2 = 0;
        int n3 = -1;
        boolean bl = true;
        boolean bl2 = false;
        block13: for (int i = 1; i < tclObjectArray.length - 1; ++i) {
            n = TclIndex.get(interp, tclObjectArray[i], validOpts, "option", 0);
            switch (n) {
                case 0: {
                    n2 = 0;
                    continue block13;
                }
                case 1: {
                    if (i == tclObjectArray.length - 2) {
                        throw new TclException(interp, "\"-command\" option must be followed by comparison command");
                    }
                    n2 = 3;
                    string = tclObjectArray[i + 1].toString();
                    ++i;
                    continue block13;
                }
                case 2: {
                    bl = false;
                    continue block13;
                }
                case 3: {
                    n2 = 4;
                    continue block13;
                }
                case 4: {
                    bl = true;
                    continue block13;
                }
                case 5: {
                    if (i == tclObjectArray.length - 2) {
                        throw new TclException(interp, "\"-index\" option must be followed by list index");
                    }
                    n3 = Util.getIntForIndex(interp, tclObjectArray[i + 1], -2);
                    ++i;
                    continue block13;
                }
                case 6: {
                    n2 = 1;
                    continue block13;
                }
                case 7: {
                    n2 = 2;
                    continue block13;
                }
                case 8: {
                    bl2 = true;
                }
            }
        }
        TclObject tclObject = tclObjectArray[tclObjectArray.length - 1];
        n = 0;
        if (tclObject.isShared()) {
            tclObject = tclObject.duplicate();
            n = 1;
        }
        try {
            TclList.sort(interp, tclObject, n2, n3, bl, bl2, string);
            interp.setResult(tclObject);
        }
        catch (TclException tclException) {
            if (n != 0) {
                tclObject.release();
            }
            throw tclException;
        }
    }
}

