/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.File;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.channel.Channel;
import tcl.lang.channel.PipelineChannel;

public class PidCmd
implements Command {
    public static int getPid() {
        try {
            return Integer.parseInt(new File("/proc/self").getCanonicalFile().getName());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length == 1) {
            interp.setResult(PidCmd.getPid());
        } else if (tclObjectArray.length == 2) {
            Channel channel = TclIO.getChannel(interp, tclObjectArray[1].toString());
            if (channel == null) {
                throw new TclException(interp, "can not find channel named \"" + tclObjectArray[1].toString() + "\"");
            }
            if (channel instanceof PipelineChannel) {
                int[] nArray = ((PipelineChannel)channel).getPipeline().getProcessIdentifiers();
                TclObject tclObject = TclList.newInstance();
                for (int n : nArray) {
                    TclList.append(interp, tclObject, TclInteger.newInstance(n));
                }
                interp.setResult(tclObject);
            } else {
                interp.setResult("");
            }
        } else {
            throw new TclException(interp, "wrong # args: should be \"pid ?channelId?\"");
        }
    }
}

