/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.WrappedCommand;

public class ProcCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        WrappedCommand wrappedCommand;
        if (tclObjectArray.length != 4) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "name args body");
        }
        String string = tclObjectArray[1].toString();
        FindCommandNamespaceResult findCommandNamespaceResult = ProcCmd.FindCommandNamespace(interp, string);
        Procedure procedure = new Procedure(interp, findCommandNamespaceResult.ns, findCommandNamespaceResult.cmdName, tclObjectArray[2], tclObjectArray[3], interp.getScriptFile(), interp.getArgLineNumber(3));
        interp.createCommand(findCommandNamespaceResult.cmdFullName, procedure);
        procedure.wcmd = wrappedCommand = Namespace.findCommand(interp, findCommandNamespaceResult.cmdFullName, findCommandNamespaceResult.ns, 2);
    }

    public static FindCommandNamespaceResult FindCommandNamespace(Interp interp, String string) throws TclException {
        Namespace.GetNamespaceForQualNameResult getNamespaceForQualNameResult = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, string, null, 0, getNamespaceForQualNameResult);
        Namespace namespace = getNamespaceForQualNameResult.ns;
        Namespace namespace2 = getNamespaceForQualNameResult.altNs;
        Namespace namespace3 = getNamespaceForQualNameResult.actualCxt;
        String string2 = getNamespaceForQualNameResult.simpleName;
        if (namespace == null) {
            throw new TclException(interp, "can't create procedure \"" + string + "\": unknown namespace");
        }
        if (string2 == null) {
            throw new TclException(interp, "can't create procedure \"" + string + "\": bad procedure name");
        }
        if (namespace != Namespace.getGlobalNamespace(interp) && string2 != null && string2.length() > 0 && string2.charAt(0) == ':') {
            throw new TclException(interp, "can't create procedure \"" + string2 + "\" in non-global namespace with name starting with \":\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (namespace != Namespace.getGlobalNamespace(interp)) {
            stringBuffer.append(namespace.fullName);
            stringBuffer.append("::");
        }
        stringBuffer.append(string2);
        FindCommandNamespaceResult findCommandNamespaceResult = new FindCommandNamespaceResult();
        findCommandNamespaceResult.fullName = string;
        findCommandNamespaceResult.cmdName = string2;
        findCommandNamespaceResult.cmdFullName = stringBuffer.toString();
        findCommandNamespaceResult.ns = namespace;
        return findCommandNamespaceResult;
    }

    public static class FindCommandNamespaceResult {
        String fullName;
        public String cmdName;
        public String cmdFullName;
        public Namespace ns;
    }
}

