/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.StrtoulResult;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

public class ScanCmd
implements Command {
    private final int SCAN_NOSKIP = 1;
    private final int SCAN_SUPPRESS = 2;
    private final int SCAN_UNSIGNED = 4;
    private final int SCAN_WIDTH = 8;
    private final int SCAN_LONGER = 1024;
    private final int SCAN_BIG = 2048;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        char c;
        int n;
        int n2 = -1;
        int n3 = -1;
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "string format ?varName varName ...?");
        }
        String string = tclObjectArray[2].toString();
        n2 = tclObjectArray.length - 3;
        n3 = this.validateFormat(interp, string, n2);
        TclObject[] tclObjectArray2 = new TclObject[n3];
        for (int i = 0; i < n3; ++i) {
            tclObjectArray2[i] = null;
        }
        String string2 = tclObjectArray[1].toString();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        block27: while (n6 < string.length()) {
            int n8;
            char c2 = string.charAt(n6++);
            n = 0;
            if (Character.isWhitespace(c2)) {
                while (n7 < string2.length() && Character.isWhitespace(string2.charAt(n7))) {
                    ++n7;
                }
                if (n7 != string2.length()) continue;
                break;
            }
            boolean bl2 = c2 == '%' ? (c2 = string.charAt(n6++)) == '%' : true;
            if (bl2) {
                if (n7 == string2.length()) {
                    bl = true;
                    break;
                }
                if (c2 == (c = (char)string2.charAt(n7++))) continue;
                break;
            }
            if (c2 == '*') {
                n |= 2;
                c2 = string.charAt(n6++);
            } else if (c2 < '\u0080' && Character.isDigit(c2)) {
                Util.strtoul(string, n6 - 1, 10, interp.strtoulResult);
                long l = interp.strtoulResult.value;
                if (string.charAt(interp.strtoulResult.index) == '$') {
                    n6 = interp.strtoulResult.index + 1;
                    c2 = string.charAt(n6++);
                    n4 = (int)(l - 1L);
                }
            }
            if (c2 < '\u0080' && Character.isDigit(c2)) {
                Util.strtoul(string, n6 - 1, 10, interp.strtoulResult);
                n8 = (int)interp.strtoulResult.value;
                n6 = interp.strtoulResult.index;
                c2 = string.charAt(n6++);
            } else {
                n8 = 0;
            }
            switch (c2) {
                case 'L': 
                case 'l': {
                    n |= 0x400;
                }
                case 'h': {
                    c2 = string.charAt(n6++);
                    break;
                }
            }
            int n9 = 32;
            int n10 = 0;
            switch (c2) {
                case 'n': {
                    if ((n & 2) == 0) {
                        TclObject tclObject = TclInteger.newInstance(n7);
                        tclObjectArray2[n4++] = tclObject;
                    }
                    ++n5;
                    continue block27;
                }
                case 'd': {
                    n9 = 105;
                    n10 = 10;
                    break;
                }
                case 'i': {
                    n9 = 105;
                    n10 = 0;
                    break;
                }
                case 'o': {
                    n9 = 105;
                    n10 = 8;
                    break;
                }
                case 'x': {
                    n9 = 105;
                    n10 = 16;
                    break;
                }
                case 'b': {
                    n9 = 105;
                    n10 = 2;
                    break;
                }
                case 'u': {
                    n9 = 105;
                    n10 = 10;
                    n |= 4;
                    break;
                }
                case 'e': 
                case 'f': 
                case 'g': {
                    n9 = 102;
                    break;
                }
                case 's': {
                    n9 = 115;
                    break;
                }
                case 'c': {
                    n9 = 99;
                    n |= 1;
                    break;
                }
                case '[': {
                    n9 = 91;
                    n |= 1;
                    break;
                }
            }
            if (n7 >= string2.length()) {
                bl = true;
                break;
            }
            if ((n & 1) == 0) {
                while (n7 < string2.length() && Character.isWhitespace(string2.charAt(n7))) {
                    ++n7;
                }
                if (n7 == string2.length()) {
                    bl = true;
                    break;
                }
            }
            switch (n9) {
                case 115: {
                    int n11;
                    if (n8 == 0) {
                        n8 = Integer.MAX_VALUE;
                    }
                    for (n11 = n7; n11 < string2.length() && !Character.isWhitespace(c = string2.charAt(n11)); ++n11) {
                        if (--n8 != 0) continue;
                    }
                    if ((n & 2) == 0) {
                        TclObject tclObject = TclString.newInstance(string2.substring(n7, n11));
                        tclObjectArray2[n4++] = tclObject;
                    }
                    n7 = n11;
                    break;
                }
                case 91: {
                    int n12;
                    CharSet charSet = new CharSet(string, n6);
                    n6 = charSet.getEndOfFormat();
                    if (n8 == 0) {
                        n8 = Integer.MAX_VALUE;
                    }
                    for (n12 = n7; n12 < string2.length() && charSet.charInSet(c = string2.charAt(n12)); ++n12) {
                        if (--n8 != 0) continue;
                    }
                    if (n7 == n12) break block27;
                    if ((n & 2) == 0) {
                        TclObject tclObject = TclString.newInstance(string2.substring(n7, n12));
                        tclObjectArray2[n4++] = tclObject;
                    }
                    n7 = n12;
                    break;
                }
                case 99: {
                    c = string2.charAt(n7++);
                    if ((n & 2) != 0) break;
                    TclObject tclObject = TclInteger.newInstance(c);
                    tclObjectArray2[n4++] = tclObject;
                    break;
                }
                case 105: {
                    if (n8 == 0) {
                        Util.strtoul(string2, n7, n10, interp.strtoulResult);
                    } else {
                        if (n7 + n8 > string2.length()) {
                            bl = true;
                            break block27;
                        }
                        String string3 = string2.substring(0, n7 + n8);
                        Util.strtoul(string3, n7, n10, interp.strtoulResult);
                    }
                    if (interp.strtoulResult.errno != -1) {
                        long l = interp.strtoulResult.errno == -2 ? -1L : interp.strtoulResult.value;
                        n7 = interp.strtoulResult.index;
                        if ((n & 2) != 0) break;
                        tclObjectArray2[n4++] = TclInteger.newInstance(l);
                        break;
                    }
                    if (n8 != 1 && string2.length() != 1) break block27;
                    bl = string2.charAt(n7) == '-' || string2.charAt(n7) == '+';
                    break block27;
                }
                case 102: {
                    if (n8 == 0) {
                        Util.strtod(string2, n7, -1, interp.strtodResult);
                    } else {
                        if (n7 + n8 > string2.length()) {
                            bl = true;
                            break block27;
                        }
                        String string4 = string2.substring(0, n7 + n8);
                        Util.strtod(string4, n7, -1, interp.strtodResult);
                    }
                    if (interp.strtodResult.errno == 0) {
                        n7 = interp.strtodResult.index;
                        if ((n & 2) != 0) break;
                        tclObjectArray2[n4++] = TclDouble.newInstance(interp.strtodResult.value);
                        break;
                    }
                    if (n8 != 1 && string2.length() != 1) break block27;
                    bl = string2.charAt(n7) == '-' || string2.charAt(n7) == '+';
                    break block27;
                }
            }
            ++n5;
        }
        c = '\u0000';
        if (n2 > 0) {
            StringBuffer stringBuffer = null;
            for (n = 0; n < n3; ++n) {
                if (tclObjectArray2[n] == null) continue;
                ++c;
                try {
                    interp.setVar(tclObjectArray[n + 3].toString(), tclObjectArray2[n], 0);
                    continue;
                }
                catch (TclException tclException) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append("couldn't set variable \"").append(tclObjectArray[n + 3].toString()).append('\"');
                }
            }
            if (stringBuffer != null) {
                throw new TclException(interp, stringBuffer.toString());
            }
        } else {
            TclObject tclObject = TclList.newInstance();
            for (n = 0; n < n3; ++n) {
                if (tclObjectArray2[n] != null) {
                    TclList.append(interp, tclObject, tclObjectArray2[n]);
                    continue;
                }
                TclList.append(interp, tclObject, TclString.newInstance(""));
            }
            interp.setResult(tclObject);
        }
        if (bl && n5 == 0) {
            if (n2 > 0) {
                interp.setResult(-1L);
                return;
            }
            interp.setResult("");
            return;
        }
        if (n2 <= 0) return;
        interp.setResult(c);
    }

    private int validateFormat(Interp interp, String string, int n) throws TclException {
        char c;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[n == 0 ? 1 : n];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        n2 = 0;
        while (n2 < string.length()) {
            int n6;
            StrtoulResult strtoulResult;
            c = string.charAt(n2++);
            n5 = 0;
            if (c != '%' || (c = string.charAt(n2++)) == '%') continue;
            if (c == '*') {
                n5 |= 2;
                c = string.charAt(n2++);
            } else if (c < '\u0080' && Character.isDigit(c)) {
                strtoulResult = new StrtoulResult();
                Util.strtoul(string, n2 - 1, 10, strtoulResult);
                int n7 = strtoulResult.index;
                if (n7 >= string.length()) {
                    throw new TclException(interp, "bad scan conversion character \"\"");
                }
                if (string.charAt(n7) != '$') {
                    bl2 = true;
                    if (bl) {
                        ScanCmd.errorBadField(interp, '$');
                    }
                } else {
                    n2 = n7 + 1;
                    c = string.charAt(n2++);
                    bl = true;
                    if (bl2) {
                        ScanCmd.errorBadField(interp, '$');
                    }
                    if ((n4 = (n6 = (int)strtoulResult.value) - 1) < 0 || n != 0 && n4 >= n) {
                        ScanCmd.errorDiffVars(interp, bl);
                    } else if (n == 0) {
                        n3 = n3 > (int)strtoulResult.value ? n3 : (int)strtoulResult.value;
                    }
                }
            } else {
                bl2 = true;
                if (bl) {
                    ScanCmd.errorCannotMix(interp, '$');
                }
            }
            if (c < '\u0080' && Character.isDigit(c)) {
                strtoulResult = new StrtoulResult();
                Util.strtoul(string, n2 - 1, 10, strtoulResult);
                n6 = strtoulResult.errno != 0 ? 0 : (int)strtoulResult.value;
                n2 = strtoulResult.index;
                n5 |= 8;
                c = string.charAt(n2++);
            }
            switch (c) {
                case 'L': 
                case 'l': {
                    n5 |= 0x400;
                }
                case 'h': {
                    c = string.charAt(n2++);
                }
            }
            if ((n5 & 2) == 0 && n > 0 && n4 >= n) {
                ScanCmd.errorDiffVars(interp, bl);
            }
            switch (c) {
                case 'c': {
                    if ((n5 & 8) != 0) {
                        ScanCmd.errorCharFieldWidth(interp);
                    }
                }
                case 'n': 
                case 's': {
                    if ((n5 & 0xC00) != 0) {
                        ScanCmd.errorLonger(interp, c);
                    }
                }
                case 'b': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'i': 
                case 'o': 
                case 'x': {
                    break;
                }
                case 'u': {
                    if ((n5 & 0x800) == 0) break;
                    throw new TclException(interp, "unsigned bignum scans are invalid");
                }
                case '[': {
                    if ((n5 & 0xC00) != 0) {
                        ScanCmd.errorLonger(interp, c);
                    }
                    if (n2 >= string.length()) {
                        ScanCmd.errorBadSet(interp);
                    }
                    if ((c = string.charAt(n2++)) == '^') {
                        if (n2 >= string.length()) {
                            ScanCmd.errorBadSet(interp);
                        }
                        c = string.charAt(n2++);
                    }
                    if (c == ']') {
                        if (n2 >= string.length()) {
                            ScanCmd.errorBadSet(interp);
                        }
                        c = string.charAt(n2++);
                    }
                    while (c != ']') {
                        if (n2 >= string.length()) {
                            ScanCmd.errorBadSet(interp);
                        }
                        c = string.charAt(n2++);
                    }
                    break;
                }
                default: {
                    ScanCmd.errorBadConvChar(interp, c);
                }
            }
            if ((n5 & 2) != 0) continue;
            if (n4 >= nArray.length) {
                int n8 = n3 > 0 ? n3 : nArray.length + 16;
                int[] nArray2 = new int[n8];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                for (int i = nArray.length; i < nArray2.length; ++i) {
                    nArray2[i] = 0;
                }
                nArray = nArray2;
            }
            int n9 = n4++;
            nArray[n9] = nArray[n9] + 1;
        }
        if (n == 0) {
            n = n3 != 0 ? n3 : n4;
        }
        for (c = '\u0000'; c < n; ++c) {
            if (nArray[c] > 1) {
                ScanCmd.errorMultipleAssignments(interp);
                continue;
            }
            if (n3 != 0 || nArray[c] != 0) continue;
            ScanCmd.errorNotAssigned(interp);
        }
        return n;
    }

    private static final void errorDiffVars(Interp interp, boolean bl) throws TclException {
        if (bl) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
        throw new TclException(interp, "different numbers of variable names and field specifiers");
    }

    private static final void errorCannotMix(Interp interp, char c) throws TclException {
        throw new TclException(interp, "cannot mix \"%\" and \"%n" + c + "\" conversion specifiers");
    }

    private static final void errorBadField(Interp interp, char c) throws TclException {
        throw new TclException(interp, "cannot mix \"%\" and \"%n" + c + "\" conversion specifiers");
    }

    private static final void errorCharFieldWidth(Interp interp) throws TclException {
        throw new TclException(interp, "field width may not be specified in %c conversion");
    }

    private static final void errorLonger(Interp interp, char c) throws TclException {
        throw new TclException(interp, "'l' modifier may not be specified in " + c + " conversion");
    }

    private static final void errorBadSet(Interp interp) throws TclException {
        throw new TclException(interp, "unmatched [ in format string");
    }

    private static final void errorBadConvChar(Interp interp, char c) throws TclException {
        throw new TclException(interp, "bad scan conversion character \"" + c + "\"");
    }

    private static final void errorMultipleAssignments(Interp interp) throws TclException {
        throw new TclException(interp, "variable is assigned by multiple \"%n$\" conversion specifiers");
    }

    private static final void errorNotAssigned(Interp interp) throws TclException {
        throw new TclException(interp, "variable is not assigned by any conversion specifiers");
    }

    private static class Range {
        char start;
        char end;

        Range(char c, char c2) {
            if (c < c2) {
                this.start = c;
                this.end = c2;
            } else {
                this.start = c2;
                this.end = c;
            }
        }

        final boolean isInRange(char c) {
            return c >= this.start && c <= this.end;
        }
    }

    private static class CharSet {
        boolean exclude = false;
        String chars = null;
        Range[] ranges = null;
        int endOfFormat;

        CharSet(String string, int n) {
            int n2 = 0;
            int n3 = 0;
            char c = string.charAt(n);
            n2 = 1;
            if (c == '^') {
                this.exclude = true;
                c = string.charAt(n += n2);
                n2 = 1;
            }
            n3 = n + n2;
            if (c == ']') {
                c = string.charAt(n3++);
            }
            int n4 = 0;
            while (c != ']' && n3 < string.length()) {
                if (c == '-') {
                    ++n4;
                }
                c = string.charAt(n3++);
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.ranges = n4 > 0 ? new Range[n4] : null;
            n4 = 0;
            char c2 = c = string.charAt(n++);
            if (c == ']' || c == '-') {
                stringBuffer.append(c);
                c = string.charAt(n++);
            }
            while (c != ']') {
                char c3;
                char c4 = c3 = n < string.length() ? string.charAt(n) : (char)'\u0000';
                if (c3 == '-') {
                    c2 = c;
                } else if (c == '-') {
                    if (c3 == ']') {
                        stringBuffer.append(c2);
                        stringBuffer.append(c);
                    } else {
                        c = string.charAt(n++);
                        this.ranges[n4] = new Range(c2, c);
                        ++n4;
                    }
                } else {
                    stringBuffer.append(c);
                }
                c = string.charAt(n++);
            }
            this.endOfFormat = n;
            this.chars = stringBuffer.toString();
        }

        int getEndOfFormat() {
            return this.endOfFormat;
        }

        private boolean charInSet(char c) {
            boolean bl = false;
            if (this.chars.indexOf(c) >= 0) {
                bl = true;
            } else if (this.ranges != null) {
                for (int i = 0; i < this.ranges.length; ++i) {
                    if (this.ranges[i] == null || !this.ranges[i].isInRange(c)) continue;
                    bl = true;
                    break;
                }
            }
            return this.exclude ? !bl : bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            if (this.exclude) {
                stringBuffer.append('^');
            }
            if (this.chars != null) {
                stringBuffer.append(this.chars);
            }
            if (this.ranges != null) {
                for (Range range : this.ranges) {
                    if (range == null) continue;
                    stringBuffer.append(range.start).append('-').append(range.end);
                }
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

