/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class SwitchCmd
implements Command {
    private static final String[] validCmds = new String[]{"-exact", "-glob", "-regexp", "--"};
    private static final int EXACT = 0;
    private static final int GLOB = 1;
    private static final int REGEXP = 2;
    private static final int LAST = 3;

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        int n2;
        int n3;
        TclObject[] tclObjectArray2 = null;
        int n4 = 0;
        boolean bl = false;
        for (n3 = 1; n3 < tclObjectArray.length && tclObjectArray[n3].toString().startsWith("-"); ++n3) {
            n2 = TclIndex.get(interp, tclObjectArray[n3], validCmds, "option", 0);
            if (n2 == 3) {
                ++n3;
                break;
            }
            if (n2 > 3) {
                throw new TclException(interp, "SwitchCmd.cmdProc: bad option " + n2 + " index to validCmds");
            }
            if (bl) {
                throw new TclException(interp, "bad option \"" + tclObjectArray[n3] + "\": " + validCmds[n4] + " option already found");
            }
            bl = true;
            n4 = n2;
        }
        if (tclObjectArray.length - n3 < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? string pattern body ... ?default body?");
        }
        String string = tclObjectArray[n3].toString();
        boolean bl2 = false;
        if (tclObjectArray.length - ++n3 == 1) {
            tclObjectArray2 = TclList.getElements(interp, tclObjectArray[n3]);
            if (tclObjectArray2.length == 0) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? string {pattern body ... ?default body?}");
            }
            n = 0;
            bl2 = true;
        } else {
            tclObjectArray2 = tclObjectArray;
            n = n3;
        }
        if ((tclObjectArray2.length - n) % 2 != 0) {
            interp.resetResult();
            if (bl2) {
                for (n2 = n; n2 < tclObjectArray2.length; n2 += 2) {
                    if (!tclObjectArray2[n2].toString().startsWith("#")) continue;
                    throw new TclException(interp, "extra switch pattern with no body, this may be due to a comment incorrectly placed outside of a switch body - see the \"switch\" documentation");
                }
            }
            throw new TclException(interp, "extra switch pattern with no body");
        }
        int n5 = SwitchCmd.getBodyOffset(interp, tclObjectArray2, n, string, n4);
        if (n5 != -1) {
            try {
                interp.eval(tclObjectArray2[n + n5], 0);
                return;
            }
            catch (TclException tclException) {
                int n6;
                for (n6 = n + n5 - 1; n6 >= n && tclObjectArray2[n6].toString().equals("-"); n6 -= 2) {
                }
                if (tclException.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (\"" + tclObjectArray2[n6] + "\" arm line " + interp.errorLine + ")");
                }
                throw tclException;
            }
        }
    }

    public static int getBodyOffset(Interp interp, TclObject[] tclObjectArray, int n, String string, int n2) throws TclException {
        int n3 = tclObjectArray.length;
        if (tclObjectArray[n3 - 1] != null && tclObjectArray[n3 - 1].toString().equals("-")) {
            interp.resetResult();
            throw new TclException(interp, "no body specified for pattern \"" + tclObjectArray[n3 - 2].toString() + "\"");
        }
        for (int i = n; i < n3; i += 2) {
            boolean bl = false;
            String string2 = tclObjectArray[i].toString();
            if (i == n3 - 2 && string2.equals("default")) {
                bl = true;
            } else {
                switch (n2) {
                    case 0: {
                        bl = string.equals(string2);
                        break;
                    }
                    case 1: {
                        bl = Util.stringMatch(string, string2);
                        break;
                    }
                    case 2: {
                        bl = Util.regExpMatch(interp, string, tclObjectArray[i]);
                    }
                }
            }
            if (!bl) continue;
            int n4 = i + 1;
            while (true) {
                if (n4 >= n3) {
                    throw new TclRuntimeError("fall-out when searching for body to match pattern");
                }
                if (tclObjectArray[n4] == null || !tclObjectArray[n4].toString().equals("-")) break;
                n4 += 2;
            }
            return n4 - n;
        }
        return -1;
    }
}

