/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class WhileCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "test command");
        }
        String string = tclObjectArray[1].toString();
        TclObject tclObject = tclObjectArray[2];
        block9: while (true) {
            try {
                boolean bl = interp.expr.evalBoolean(interp, string);
                if (!bl) {
                    break;
                }
            }
            catch (TclException tclException) {
                if (tclException.getCompletionCode() == 1 && interp.errInProgress) {
                    interp.addErrorInfo("\n    (\"while\" test expression)");
                }
                throw tclException;
            }
            try {
                interp.eval(tclObject, 0);
                continue;
            }
            catch (TclException tclException) {
                switch (tclException.getCompletionCode()) {
                    case 3: {
                        break block9;
                    }
                    case 4: {
                        continue block9;
                    }
                    case 1: {
                        interp.addErrorInfo("\n    (\"while\" body line " + interp.errorLine + ")");
                        throw tclException;
                    }
                    default: {
                        throw tclException;
                    }
                }
            }
            break;
        }
        interp.resetResult();
    }
}

