/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.embed.jsr223;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.embed.jsr223.JtclScriptEngineFactory;
import tcl.pkg.java.ReflectObject;

public class JtclScriptEngine
extends AbstractScriptEngine {
    private ScriptEngineFactory factory;
    private static ThreadLocal<Interp> interpreters = new ThreadLocal();
    private static final String CONTEXT = "javax.script.ScriptContext";

    private static TclObject java2tcl(Interp interp, Object object) throws TclException {
        Class clazz;
        Class clazz2 = clazz = object == null ? Object.class : object.getClass();
        if (clazz == Integer.class) {
            return TclInteger.newInstance(((Integer)object).intValue());
        }
        if (clazz == Long.class) {
            return TclString.newInstance(object.toString());
        }
        if (clazz == Short.class) {
            return TclInteger.newInstance(((Short)object).intValue());
        }
        if (clazz == Byte.class) {
            return TclInteger.newInstance(((Byte)object).intValue());
        }
        if (clazz == Double.class) {
            return TclDouble.newInstance((Double)object);
        }
        if (clazz == Float.class) {
            return TclDouble.newInstance(((Float)object).doubleValue());
        }
        if (clazz == Boolean.class) {
            return TclBoolean.newInstance((Boolean)object);
        }
        if (clazz == Character.class) {
            return TclString.newInstance(((Character)object).toString());
        }
        if (clazz == String.class) {
            return TclString.newInstance((String)object);
        }
        return ReflectObject.newInstance(interp, clazz, object);
    }

    private static Object tcl2java(Interp interp, TclObject tclObject) throws TclException {
        Object object = null;
        boolean bl = false;
        try {
            object = ReflectObject.get(interp, tclObject);
            bl = true;
        }
        catch (TclException tclException) {
            interp.resetResult();
        }
        if (bl) {
            return object;
        }
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof TclBoolean) {
            return new Boolean(TclBoolean.get(interp, tclObject));
        }
        if (internalRep instanceof TclInteger) {
            return new Integer(TclInteger.get(interp, tclObject));
        }
        if (internalRep instanceof TclDouble) {
            return new Double(TclDouble.get(interp, tclObject));
        }
        if (internalRep instanceof TclString) {
            return tclObject.toString();
        }
        return tclObject;
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        Interp interp = this.getInterp();
        AssocData assocData = interp.getAssocData(CONTEXT);
        try {
            interp.setAssocData(CONTEXT, new ContextData(scriptContext));
            scriptContext.setAttribute("context", scriptContext, 100);
            interp.eval(string);
            TclObject tclObject = interp.getResult();
            return tclObject;
        }
        catch (TclException tclException) {
            String string2 = interp.getResult().toString();
            ScriptException scriptException = new ScriptException(string2);
            scriptException.initCause(tclException);
            throw scriptException;
        }
        finally {
            if (assocData != null) {
                interp.setAssocData(CONTEXT, assocData);
            }
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.eval(this.readFully(reader), scriptContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JtclScriptEngine jtclScriptEngine = this;
        synchronized (jtclScriptEngine) {
            if (this.factory == null) {
                this.factory = new JtclScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory scriptEngineFactory) {
        this.factory = scriptEngineFactory;
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] cArray = new char[8192];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        return stringBuilder.toString();
    }

    private Interp getInterp() {
        Interp interp = interpreters.get();
        if (interp == null) {
            interp = new Interp();
            ContextCommand contextCommand = new ContextCommand();
            interp.createCommand("context", contextCommand);
            interp.createCommand("var", contextCommand);
            interp.createCommand("echo", new EchoCommand());
            interpreters.set(interp);
        }
        return interp;
    }

    private static class EchoCommand
    implements Command {
        private EchoCommand() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Writer writer;
            AssocData assocData = interp.getAssocData(JtclScriptEngine.CONTEXT);
            if (assocData != null && assocData instanceof ContextData) {
                ScriptContext scriptContext = ((ContextData)assocData).getContext();
                writer = scriptContext.getWriter();
            } else {
                writer = new PrintWriter(System.out);
            }
            try {
                for (int i = 1; i < tclObjectArray.length; ++i) {
                    writer.write(tclObjectArray[i].toString());
                    writer.write(32);
                }
                writer.flush();
            }
            catch (IOException iOException) {
                throw new TclException(interp, "I/O error: " + iOException.getMessage());
            }
        }
    }

    private static class ContextCommand
    implements Command {
        private ContextCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getVariable(Interp interp, ScriptContext scriptContext, String string) throws TclException {
            ScriptContext scriptContext2 = scriptContext;
            synchronized (scriptContext2) {
                int n = scriptContext.getAttributesScope(string);
                if (n == -1) {
                    throw new TclException(interp, "can't read \"" + string + "\": no such context variable");
                }
                Object object = scriptContext.getAttribute(string, n);
                interp.setResult(JtclScriptEngine.java2tcl(interp, object));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setVariable(Interp interp, ScriptContext scriptContext, String string, TclObject tclObject) throws TclException {
            ScriptContext scriptContext2 = scriptContext;
            synchronized (scriptContext2) {
                int n = scriptContext.getAttributesScope(string);
                if (n == -1) {
                    n = 100;
                }
                scriptContext.setAttribute(string, JtclScriptEngine.tcl2java(interp, tclObject), n);
                interp.setResult(tclObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteVariable(Interp interp, ScriptContext scriptContext, String string) throws TclException {
            ScriptContext scriptContext2 = scriptContext;
            synchronized (scriptContext2) {
                int n = scriptContext.getAttributesScope(string);
                if (n == -1) {
                    interp.setResult(false);
                } else {
                    scriptContext.removeAttribute(string, n);
                    interp.setResult(true);
                }
            }
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            AssocData assocData = interp.getAssocData(JtclScriptEngine.CONTEXT);
            if (assocData != null && assocData instanceof ContextData) {
                ScriptContext scriptContext = ((ContextData)assocData).getContext();
                switch (tclObjectArray.length) {
                    case 1: {
                        this.getVariable(interp, scriptContext, "context");
                        break;
                    }
                    case 2: {
                        this.getVariable(interp, scriptContext, tclObjectArray[1].toString());
                        break;
                    }
                    case 3: {
                        String string = tclObjectArray[1].toString();
                        if (string.equals("-del")) {
                            String string2 = tclObjectArray[2].toString();
                            this.deleteVariable(interp, scriptContext, string2);
                            break;
                        }
                        this.setVariable(interp, scriptContext, tclObjectArray[1].toString(), tclObjectArray[2]);
                        break;
                    }
                    default: {
                        throw new TclNumArgsException(interp, 1, tclObjectArray, "?varName? ?-del? ?newValue?");
                    }
                }
            } else {
                throw new TclException(interp, "invalid script context");
            }
        }
    }

    private static class ContextData
    implements AssocData {
        private ScriptContext context;

        ContextData(ScriptContext scriptContext) {
            this.context = scriptContext;
        }

        ScriptContext getContext() {
            return this.context;
        }

        @Override
        public void disposeAssocData(Interp interp) {
        }
    }
}

