/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.process;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.process.JavaProcess;
import tcl.lang.process.Redirect;

public abstract class TclProcess {
    protected Redirect stdinRedirect = null;
    protected Redirect stdoutRedirect = null;
    protected Redirect stderrRedirect = null;
    protected List<String> command = null;
    protected Interp interp;
    protected IOException savedException = null;

    public static TclProcess newInstance(Interp interp) {
        JavaProcess javaProcess = new JavaProcess();
        javaProcess.interp = interp;
        return javaProcess;
    }

    public void setCommand(List<String> list) {
        this.command = list;
    }

    public List<String> command() {
        return this.command;
    }

    protected Map<String, String> getenv() {
        return this.interp.getenv();
    }

    public abstract void start() throws IOException;

    public abstract int exitValue() throws IllegalThreadStateException;

    public int waitFor() throws IllegalThreadStateException, InterruptedException, IOException {
        if (!this.isStarted()) {
            throw new IllegalThreadStateException("Process not yet started");
        }
        int n = this.implWaitFor();
        if (this.stdoutRedirect != null && this.stdoutRedirect.type == Redirect.Type.TCL_CHANNEL && this.stdoutRedirect.closeChannel) {
            TclIO.unregisterChannel(this.interp, this.stdoutRedirect.channel);
        }
        if (this.stderrRedirect != null && this.stderrRedirect.type == Redirect.Type.TCL_CHANNEL && this.stderrRedirect.closeChannel) {
            TclIO.unregisterChannel(this.interp, this.stderrRedirect.channel);
        }
        this.throwAnyExceptions();
        return n;
    }

    protected abstract int implWaitFor() throws InterruptedException, IOException;

    public abstract int getPid() throws IllegalThreadStateException;

    public abstract boolean isStarted();

    public abstract void setWorkingDir(File var1);

    public abstract void destroy();

    public abstract boolean canInheritFileDescriptors();

    public Redirect getStdinRedirect() {
        return this.stdinRedirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveIOException(IOException iOException) {
        TclProcess tclProcess = this;
        synchronized (tclProcess) {
            if (this.savedException == null) {
                this.savedException = iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throwAnyExceptions() throws IOException {
        TclProcess tclProcess = this;
        synchronized (tclProcess) {
            if (this.savedException != null) {
                throw this.savedException;
            }
        }
    }

    public void setStdinRedirect(Redirect redirect) throws TclException {
        if (redirect == null) {
            this.stdinRedirect = null;
            return;
        }
        if (redirect.type == Redirect.Type.MERGE_ERROR) {
            throw new TclRuntimeError("Output redirects cannot be attached to process stdin");
        }
        if (redirect.type == Redirect.Type.TCL_CHANNEL && redirect.channel.isWriteOnly()) {
            throw new TclException(this.interp, "channel \"" + redirect.channel.getChanName() + "\" wasn't opened for reading");
        }
        if (redirect.type == Redirect.Type.FILE && !redirect.file.exists()) {
            throw new TclPosixException(this.interp, 2, true, "couldn't read file \"" + redirect.specifiedFilePath + "\"");
        }
        this.stdinRedirect = redirect.type == Redirect.Type.TCL_CHANNEL && "stdin".equals(redirect.channel.getChanName()) ? Redirect.inherit() : redirect;
    }

    public Redirect getStdoutRedirect() {
        return this.stdoutRedirect;
    }

    public void setStdoutRedirect(Redirect redirect) throws TclException {
        if (redirect.type == Redirect.Type.MERGE_ERROR) {
            throw new TclRuntimeError("Stdout  cannot be attached to MERGE_ERROR");
        }
        if (redirect.type == Redirect.Type.TCL_CHANNEL) {
            if (redirect.channel.isReadOnly()) {
                throw new TclException(this.interp, "channel \"" + redirect.channel.getChanName() + "\" wasn't opened for writing");
            }
            try {
                redirect.channel.flush(this.interp);
            }
            catch (IOException iOException) {
                throw new TclException(this.interp, iOException.getMessage());
            }
        }
        if (redirect.type == Redirect.Type.FILE) {
            File file = redirect.file;
            if (!redirect.appendToFile) {
                file = file.getAbsoluteFile().getParentFile();
            }
            if (!file.exists()) {
                throw new TclPosixException(this.interp, 2, true, "couldn't write file \"" + redirect.specifiedFilePath + "\"");
            }
        }
        this.stdoutRedirect = redirect.type == Redirect.Type.TCL_CHANNEL && "stdout".equals(redirect.channel.getChanName()) ? Redirect.inherit() : redirect;
    }

    public Redirect getStderrRedirect() {
        return this.stderrRedirect;
    }

    public void setStderrRedirect(Redirect redirect) throws TclException {
        if (redirect.type == Redirect.Type.PIPE) {
            throw new TclRuntimeError("Stderr cannot be attached to Pipe, use MERGE_ERROR");
        }
        if (redirect.type == Redirect.Type.TCL_CHANNEL) {
            if (redirect.channel.isReadOnly()) {
                throw new TclException(this.interp, "channel \"" + redirect.channel.getChanName() + "\" wasn't opened for writing");
            }
            try {
                redirect.channel.flush(this.interp);
            }
            catch (IOException iOException) {
                throw new TclException(this.interp, iOException.getMessage());
            }
        }
        if (redirect.type == Redirect.Type.FILE) {
            File file = redirect.file;
            if (!redirect.appendToFile) {
                file = file.getAbsoluteFile().getParentFile();
            }
            if (!file.exists()) {
                throw new TclPosixException(this.interp, 2, true, "couldn't write file \"" + redirect.specifiedFilePath + "\"");
            }
        }
        this.stderrRedirect = redirect.type == Redirect.Type.TCL_CHANNEL && "stderr".equals(redirect.channel.getChanName()) ? Redirect.inherit() : redirect;
    }
}

