/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.fleet;

import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class ArgOptions {
    private final Interp interp;
    private final TclObject[] argv;
    private final int start;
    private final boolean[] used;

    public ArgOptions(Interp interp, TclObject[] tclObjectArray, int n) {
        this.interp = interp;
        this.argv = tclObjectArray;
        this.start = n;
        this.used = new boolean[tclObjectArray.length];
    }

    public String get(String string, String string2) throws TclException {
        for (int i = this.start; i < this.argv.length && i < this.used.length; ++i) {
            String string3;
            if (this.used[i] || !string.startsWith(string3 = this.argv[i].toString())) continue;
            this.used[i] = true;
            if (++i >= this.argv.length || i >= this.used.length) {
                throw new TclException(this.interp, "No value for argument \"" + string + "\"");
            }
            this.used[i] = true;
            string2 = this.argv[i].toString();
            break;
        }
        return string2;
    }

    public double get(String string, double d) throws TclException {
        for (int i = this.start; i < this.argv.length && i < this.used.length; ++i) {
            String string2;
            if (this.used[i] || !string.startsWith(string2 = this.argv[i].toString())) continue;
            this.used[i] = true;
            if (++i >= this.argv.length || i >= this.used.length) {
                throw new TclException(this.interp, "No value for argument \"" + string + "\"");
            }
            this.used[i] = true;
            d = TclDouble.get(this.interp, this.argv[i]);
            break;
        }
        return d;
    }

    public int get(String string, int n) throws TclException {
        for (int i = this.start; i < this.argv.length && i < this.used.length; ++i) {
            String string2;
            if (this.used[i] || !string.startsWith(string2 = this.argv[i].toString())) continue;
            this.used[i] = true;
            if (++i >= this.argv.length || i >= this.used.length) {
                throw new TclException(this.interp, "No value for argument \"" + string + "\"");
            }
            this.used[i] = true;
            n = TclInteger.get(this.interp, this.argv[i]);
            break;
        }
        return n;
    }

    public boolean get(String string) throws TclException {
        boolean bl = false;
        for (int i = this.start; i < this.argv.length && i < this.used.length; ++i) {
            String string2;
            if (this.used[i] || !string.startsWith(string2 = this.argv[i].toString())) continue;
            this.used[i] = true;
            return true;
        }
        return bl;
    }

    public boolean getOptDoubleList(String string, ArrayList<Double> arrayList) throws TclException {
        for (int i = this.start; i < this.argv.length && i < this.used.length; ++i) {
            TclObject[] tclObjectArray;
            String string2;
            if (this.used[i] || !string.startsWith(string2 = this.argv[i].toString())) continue;
            this.used[i] = true;
            if (++i >= this.argv.length || i >= this.used.length) {
                throw new TclException(this.interp, "No value for argument \"" + string + "\"");
            }
            this.used[i] = true;
            for (TclObject tclObject : tclObjectArray = TclList.getElements(this.interp, this.argv[i])) {
                arrayList.add(TclDouble.get(this.interp, tclObject));
            }
            break;
        }
        return arrayList.size() > 0;
    }

    public double[] get(String string, double[] dArray) throws TclException {
        for (int i = this.start; i < this.argv.length && i < this.used.length; ++i) {
            String string2;
            if (this.used[i] || !string.startsWith(string2 = this.argv[i].toString())) continue;
            this.used[i] = true;
            if (++i >= this.argv.length || i >= this.used.length) {
                throw new TclException(this.interp, "No value for argument \"" + string + "\"");
            }
            this.used[i] = true;
            TclObject[] tclObjectArray = TclList.getElements(this.interp, this.argv[i]);
            dArray = new double[tclObjectArray.length];
            int n = 0;
            for (TclObject tclObject : tclObjectArray) {
                dArray[n++] = TclDouble.get(this.interp, tclObject);
            }
            break;
        }
        return dArray;
    }
}

