/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.fleet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclDict;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.fleet.ArgOptions;
import tcl.pkg.fleet.FleetMember;
import tcl.pkg.fleet.Message;

public class FleetCmd
implements Command {
    private static long fleetCount = 0L;
    private long memberCount = 0L;
    Namespace ns;
    String fleetName;
    private static final HashMap<String, FleetMember> fleetMembers = new HashMap();
    private static HashMap<String, SubCmds> aliasMap = new HashMap();

    SubCmds getSubCmd(Interp interp, String string) throws TclException {
        SubCmds subCmds;
        block10: {
            try {
                subCmds = SubCmds.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                subCmds = aliasMap.get(string);
                if (subCmds != null) break block10;
                int n = 0;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (SubCmds object : SubCmds.values()) {
                    if (!object.name().startsWith(string)) continue;
                    arrayList.add(object.name());
                    subCmds = object;
                    ++n;
                }
                if (n == 1) {
                    aliasMap.put(string, subCmds);
                }
                if (n == 0) {
                    arrayList.clear();
                    for (SubCmds subCmds2 : SubCmds.values()) {
                        arrayList.add(subCmds2.name());
                    }
                }
                Collections.sort(arrayList);
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = 0;
                for (String string2 : arrayList) {
                    if (n2 != arrayList.size() - 1) {
                        stringBuilder.append(string2);
                        stringBuilder.append(", ");
                    } else {
                        stringBuilder.append("or ");
                        stringBuilder.append(string2);
                    }
                    ++n2;
                }
                if (n == 0) {
                    throw new TclException(interp, "bad option \"" + string + "\": must be " + stringBuilder);
                }
                throw new TclException(interp, "ambiguous option \"" + string + "\": must be " + stringBuilder);
            }
        }
        return subCmds;
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "opt");
        }
        try {
            SubCmds subCmds = this.getSubCmd(interp, tclObjectArray[1].toString());
            subCmds.eval(interp, tclObjectArray, this);
        }
        catch (TclException tclException) {
            throw tclException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TclException(interp, tclObjectArray[0] + " " + tclObjectArray[1] + " " + exception.getMessage());
        }
    }

    static void sendCommand(Interp interp, FleetMember fleetMember, TclObject tclObject, String string, String string2) throws TclException {
        Message message = new Message(interp, tclObject, string, string2);
        fleetMember.execCommand(message);
    }

    private static enum SubCmds {
        create{

            @Override
            void eval(Interp interp, TclObject[] tclObjectArray, FleetCmd fleetCmd) throws TclException {
                Namespace namespace;
                ArgOptions argOptions = new ArgOptions(interp, tclObjectArray, 2);
                String string = argOptions.get("-name", "fleet" + fleetCount);
                fleetCount++;
                FleetCmd fleetCmd2 = new FleetCmd();
                interp.createCommand(string, fleetCmd2);
                fleetCmd2.fleetName = string;
                interp.setResult(string);
                fleetCmd2.ns = namespace = Namespace.createNamespace(interp, "::fleet::" + string, null);
            }
        }
        ,
        member{

            @Override
            void eval(Interp interp, TclObject[] tclObjectArray, FleetCmd fleetCmd) throws TclException {
                ArgOptions argOptions = new ArgOptions(interp, tclObjectArray, 2);
                String string = argOptions.get("-name", "member" + fleetCmd.memberCount);
                fleetCmd.memberCount++;
                FleetMember fleetMember = new FleetMember(fleetCmd, string);
                fleetMembers.put(string, fleetMember);
                interp.setResult(string);
            }
        }
        ,
        tell{

            @Override
            void eval(Interp interp, TclObject[] tclObjectArray, FleetCmd fleetCmd) throws TclException {
                ArgOptions argOptions = new ArgOptions(interp, tclObjectArray, 4);
                if (tclObjectArray.length < 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "memberName msg ?-reply reply? ?-var varName?");
                }
                String string = argOptions.get("-reply", (String)null);
                String string2 = argOptions.get("-var", (String)null);
                String string3 = tclObjectArray[2].toString();
                TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObjectArray[3]);
                if (string3.equals("*")) {
                    for (FleetMember fleetMember : fleetMembers.values()) {
                        TclObject tclObject = TclList.newInstance();
                        tclObject.preserve();
                        for (TclObject tclObject2 : tclObjectArray2) {
                            tclObject2.preserve();
                            TclList.append(interp, tclObject, tclObject2);
                        }
                        FleetCmd.sendCommand(interp, fleetMember, tclObject, string, string2);
                    }
                } else {
                    TclObject tclObject = TclList.newInstance();
                    tclObject.preserve();
                    for (TclObject tclObject3 : tclObjectArray2) {
                        tclObject3.preserve();
                        TclList.append(interp, tclObject, tclObject3);
                    }
                    FleetMember fleetMember = (FleetMember)fleetMembers.get(string3);
                    if (fleetMember == null) {
                        throw new TclException(interp, "Can't find member \"" + string3 + "\" in fleet \"" + fleetCmd.fleetName + "\"");
                    }
                    FleetCmd.sendCommand(interp, fleetMember, tclObject, string, string2);
                }
            }
        }
        ,
        forget{

            @Override
            void eval(Interp interp, TclObject[] tclObjectArray, FleetCmd fleetCmd) throws TclException {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "memberName");
                }
                String string = tclObjectArray[2].toString();
                FleetMember fleetMember = (FleetMember)fleetMembers.get(string);
                if (fleetMember == null) {
                    throw new TclException(interp, "Can't find member \"" + string + "\" in fleet \"" + fleetCmd.fleetName + "\"");
                }
                int n = fleetMember.forget();
                interp.setResult(n);
            }
        }
        ,
        count{

            @Override
            void eval(Interp interp, TclObject[] tclObjectArray, FleetCmd fleetCmd) throws TclException {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "-messages memberName");
                }
                ArgOptions argOptions = new ArgOptions(interp, tclObjectArray, 2);
                String string = argOptions.get("-messages", "");
                if (!string.equals("")) {
                    FleetMember fleetMember = (FleetMember)fleetMembers.get(string);
                    if (fleetMember == null) {
                        throw new TclException(interp, "Can't find member \"" + string + "\" in fleet \"" + fleetCmd.fleetName + "\"");
                    }
                    int n = fleetMember.messageCount();
                    interp.setResult(n);
                }
            }
        }
        ,
        stats{

            @Override
            void eval(Interp interp, TclObject[] tclObjectArray, FleetCmd fleetCmd) throws TclException {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "-member memberName");
                }
                ArgOptions argOptions = new ArgOptions(interp, tclObjectArray, 2);
                String string = argOptions.get("-member", "");
                if (!string.equals("")) {
                    FleetMember fleetMember = (FleetMember)fleetMembers.get(string);
                    if (fleetMember == null) {
                        throw new TclException(interp, "Can't find member \"" + string + "\" in fleet \"" + fleetCmd.fleetName + "\"");
                    }
                    TclObject tclObject = TclDict.newInstance();
                    double d = fleetMember.getProcessingTime();
                    double d2 = fleetMember.getWaitingTime();
                    TclDict.put(interp, tclObject, TclString.newInstance("processing"), TclDouble.newInstance(d));
                    TclDict.put(interp, tclObject, TclString.newInstance("waiting"), TclDouble.newInstance(d2));
                    interp.setResult(tclObject);
                }
            }
        }
        ,
        destroy{

            @Override
            void eval(Interp interp, TclObject[] tclObjectArray, FleetCmd fleetCmd) throws TclException {
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?memberName?");
                }
                if (tclObjectArray.length == 3) {
                    String string = tclObjectArray[2].toString();
                    FleetMember fleetMember = (FleetMember)fleetMembers.get(string);
                    if (fleetMember == null) {
                        throw new TclException(interp, "Can't find member \"" + string + "\" in fleet \"" + fleetCmd.fleetName + "\"");
                    }
                    fleetMember.execCommand(null);
                    fleetMembers.remove(string);
                } else {
                    Namespace.deleteNamespace(fleetCmd.ns);
                    int n = interp.deleteCommand(fleetCmd.fleetName);
                    interp.setResult(n);
                }
            }
        };


        abstract void eval(Interp var1, TclObject[] var2, FleetCmd var3) throws TclException;
    }
}

