/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.Cmds;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclHierIter;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclMember;
import tcl.pkg.itcl.ItclMemberCode;
import tcl.pkg.itcl.ItclMemberFunc;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclVarDefn;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_List;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Itcl_Stack;
import tcl.pkg.itcl.Methods;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Objects;
import tcl.pkg.itcl.Util;

class Class {
    static int itclCompatFlags = Cmds.itclCompatFlags;

    Class() {
    }

    static ItclClass CreateClass(Interp interp, String string, ItclObjectInfo itclObjectInfo) throws TclException {
        ItclVarDefn itclVarDefn;
        Namespace namespace = Namespace.findNamespace(interp, string, null, 0);
        if (namespace != null && Class.IsClassNamespace(namespace)) {
            throw new TclException(interp, "class \"" + string + "\" already exists");
        }
        WrappedCommand wrappedCommand = Namespace.findCommand(interp, string, null, 2);
        if (wrappedCommand != null && !Cmds.IsStub(wrappedCommand)) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("command \"" + string + "\" already exists");
            if (string.indexOf("::") == -1) {
                stringBuffer.append(" in namespace \"" + Namespace.getCurrentNamespace((Interp)interp).fullName + "\"");
            }
            throw new TclException(interp, stringBuffer.toString());
        }
        Util.ParseNamespPathResult parseNamespPathResult = Util.ParseNamespPath(string);
        String string2 = parseNamespPathResult.head;
        String string3 = parseNamespPathResult.tail;
        if (string3.indexOf(".") != -1) {
            throw new TclException(interp, "bad class name \"" + string3 + "\"");
        }
        ItclClass itclClass = new ItclClass();
        itclClass.name = null;
        itclClass.fullname = null;
        itclClass.interp = interp;
        itclClass.info = itclObjectInfo;
        Util.PreserveData(itclObjectInfo);
        itclClass.namesp = null;
        itclClass.accessCmd = null;
        itclClass.w_accessCmd = null;
        itclClass.variables = new HashMap();
        itclClass.functions = new HashMap();
        itclClass.numInstanceVars = 0;
        itclClass.resolveVars = new HashMap();
        itclClass.resolveCmds = new HashMap();
        itclClass.bases = new Itcl_List();
        Util.InitList(itclClass.bases);
        itclClass.derived = new Itcl_List();
        Util.InitList(itclClass.derived);
        itclClass.initCode = null;
        itclClass.unique = 0;
        itclClass.flags = 0;
        itclClass.heritage = new HashMap();
        itclClass.heritage.put(itclClass, "");
        Util.PreserveData(itclClass);
        if (namespace == null) {
            namespace = Namespace.createNamespace(interp, string, new DestroyClassNamespImpl(itclClass));
        } else {
            if (namespace.deleteProc != null) {
                namespace.deleteProc.delete();
            }
            namespace.deleteProc = new DestroyClassNamespImpl(itclClass);
        }
        if (namespace == null) {
            Util.ReleaseData(itclClass);
            throw new TclException(interp, interp.getResult().toString());
        }
        itclClass.namesp = namespace;
        itclClass.name = namespace.name;
        itclClass.fullname = namespace.fullName;
        ClassResolverImpl classResolverImpl = new ClassResolverImpl();
        Namespace.setNamespaceResolver(namespace, classResolverImpl);
        try {
            itclVarDefn = Class.CreateVarDefn(interp, itclClass, "this", null, null);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException");
        }
        itclVarDefn.member.protection = 2;
        itclVarDefn.member.flags |= ItclInt.THIS_VAR;
        itclClass.variables.put("this", itclVarDefn);
        Util.PreserveData(itclClass);
        interp.createCommand(itclClass.fullname, new HandleClassCmd(itclClass));
        itclClass.w_accessCmd = Namespace.findCommand(interp, itclClass.fullname, null, 2);
        itclClass.accessCmd = itclClass.w_accessCmd.cmd;
        return itclClass;
    }

    static void DeleteClass(Interp interp, ItclClass itclClass) throws TclException {
        ItclClass itclClass2 = null;
        Itcl_ListElem itcl_ListElem = Util.FirstListElem(itclClass.derived);
        while (itcl_ListElem != null) {
            itclClass2 = (ItclClass)Util.GetListValue(itcl_ListElem);
            itcl_ListElem = Util.NextListElem(itcl_ListElem);
            try {
                Class.DeleteClass(interp, itclClass2);
            }
            catch (TclException tclException) {
                Class.DeleteClassFailed(interp, itclClass2.namesp.fullName, tclException);
            }
        }
        Iterator iterator = itclClass.info.objects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ItclObject itclObject = (ItclObject)entry.getValue();
            if (itclObject.classDefn != itclClass) continue;
            try {
                Objects.DeleteObject(interp, itclObject);
            }
            catch (TclException tclException) {
                itclClass2 = itclClass;
                Class.DeleteClassFailed(interp, itclClass2.namesp.fullName, tclException);
            }
            iterator = itclClass.info.objects.entrySet().iterator();
        }
        Namespace.deleteNamespace(itclClass.namesp);
    }

    static void DeleteClassFailed(Interp interp, String string, TclException tclException) throws TclException {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("\n    (while deleting class \"");
        stringBuffer.append(string);
        stringBuffer.append("\")");
        interp.addErrorInfo(stringBuffer.toString());
        throw tclException;
    }

    static void DestroyClass(ItclClass itclClass) {
        itclClass.accessCmd = null;
        itclClass.w_accessCmd = null;
        Namespace.deleteNamespace(itclClass.namesp);
        Util.ReleaseData(itclClass);
    }

    static void DestroyClassNamesp(ItclClass itclClass) {
        Itcl_ListElem itcl_ListElem = Util.FirstListElem(itclClass.derived);
        while (itcl_ListElem != null) {
            ItclClass itclClass2 = (ItclClass)Util.GetListValue(itcl_ListElem);
            Namespace.deleteNamespace(itclClass2.namesp);
            itcl_ListElem = Util.FirstListElem(itclClass.derived);
        }
        Iterator iterator = itclClass.info.objects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ItclObject itclObject = (ItclObject)entry.getValue();
            if (itclObject.classDefn != itclClass) continue;
            itclClass.interp.deleteCommandFromToken(itclObject.w_accessCmd);
            iterator = itclClass.info.objects.entrySet().iterator();
        }
        Itcl_ListElem itcl_ListElem2 = Util.FirstListElem(itclClass.bases);
        while (itcl_ListElem2 != null) {
            ItclClass itclClass3 = (ItclClass)Util.GetListValue(itcl_ListElem2);
            itcl_ListElem = Util.FirstListElem(itclClass3.derived);
            while (itcl_ListElem != null) {
                ItclClass itclClass4 = (ItclClass)Util.GetListValue(itcl_ListElem);
                if (itclClass4 == itclClass) {
                    Util.ReleaseData((ItclClass)Util.GetListValue(itcl_ListElem));
                    itcl_ListElem = Util.DeleteListElem(itcl_ListElem);
                    continue;
                }
                itcl_ListElem = Util.NextListElem(itcl_ListElem);
            }
            itcl_ListElem2 = Util.NextListElem(itcl_ListElem2);
        }
        if (itclClass.accessCmd != null) {
            iterator = (HandleClassCmd)itclClass.accessCmd;
            ((HandleClassCmd)((Object)iterator)).release = true;
            itclClass.interp.deleteCommandFromToken(itclClass.w_accessCmd);
        }
        Util.ReleaseData(itclClass);
    }

    static void FreeClass(ItclClass itclClass) {
        Itcl_ListElem itcl_ListElem = Util.FirstListElem(itclClass.derived);
        while (itcl_ListElem != null) {
            Util.ReleaseData((ItclClass)Util.GetListValue(itcl_ListElem));
            itcl_ListElem = Util.NextListElem(itcl_ListElem);
        }
        Util.DeleteList(itclClass.derived);
        itclClass.derived = null;
        HashMap<String, Var> hashMap = new HashMap<String, Var>();
        for (Map.Entry entry : itclClass.resolveVars.entrySet()) {
            Var var;
            ItclVarLookup itclVarLookup = (ItclVarLookup)entry.getValue();
            if (--itclVarLookup.usage != 0 || (itclVarLookup.vdefn.member.flags & ItclInt.COMMON) == 0 || itclVarLookup.vdefn.member.classDefn != itclClass || ItclAccess.decrVarRefCount(var = itclVarLookup.common) != 0) continue;
            hashMap.put(itclVarLookup.vdefn.member.fullname, var);
        }
        ItclAccess.deleteVars(itclClass.interp, hashMap);
        itclClass.resolveVars = null;
        itclClass.resolveCmds.clear();
        itclClass.resolveCmds = null;
        for (Map.Entry entry : itclClass.variables.entrySet()) {
            ItclVarDefn itclVarDefn = (ItclVarDefn)entry.getValue();
            Class.DeleteVarDefn(itclVarDefn);
        }
        itclClass.variables.clear();
        itclClass.variables = null;
        for (Map.Entry entry : itclClass.functions.entrySet()) {
            ItclMemberFunc itclMemberFunc = (ItclMemberFunc)entry.getValue();
            Util.ReleaseData(itclMemberFunc);
        }
        itclClass.functions.clear();
        itclClass.functions = null;
        itcl_ListElem = Util.FirstListElem(itclClass.bases);
        while (itcl_ListElem != null) {
            Util.ReleaseData((ItclClass)Util.GetListValue(itcl_ListElem));
            itcl_ListElem = Util.NextListElem(itcl_ListElem);
        }
        Util.DeleteList(itclClass.bases);
        itclClass.bases = null;
        itclClass.heritage.clear();
        itclClass.heritage = null;
        if (itclClass.initCode != null) {
            itclClass.initCode.release();
        }
        Util.ReleaseData(itclClass.info);
        itclClass.name = null;
        itclClass.fullname = null;
    }

    static boolean IsClassNamespace(Namespace namespace) {
        if (namespace != null) {
            return namespace.deleteProc instanceof DestroyClassNamespImpl;
        }
        return false;
    }

    static ItclClass GetClassFromNamespace(Namespace namespace) {
        if (namespace == null || !(namespace.deleteProc instanceof DestroyClassNamespImpl)) {
            throw new TclRuntimeError("namespace is not a class namespace");
        }
        return ((DestroyClassNamespImpl)namespace.deleteProc).cdefn;
    }

    static boolean IsClass(WrappedCommand wrappedCommand) {
        HandleClassCmd handleClassCmd = null;
        if (wrappedCommand.cmd instanceof HandleClassCmd) {
            handleClassCmd = (HandleClassCmd)wrappedCommand.cmd;
        } else {
            WrappedCommand wrappedCommand2 = Namespace.getOriginalCommand(wrappedCommand);
            if (wrappedCommand2 != null && wrappedCommand2.cmd instanceof HandleClassCmd) {
                handleClassCmd = (HandleClassCmd)wrappedCommand2.cmd;
            }
        }
        return handleClassCmd != null && !handleClassCmd.release;
    }

    static ItclClass FindClass(Interp interp, String string, boolean bl) {
        Namespace namespace = Class.FindClassNamespace(interp, string);
        if (namespace != null && Class.IsClassNamespace(namespace)) {
            return Class.GetClassFromNamespace(namespace);
        }
        if (bl) {
            try {
                interp.eval("::auto_load \"" + string + "\"");
            }
            catch (TclException tclException) {
                interp.addErrorInfo("\n    (while attempting to autoload class \"" + string + "\")");
                return null;
            }
            interp.resetResult();
            namespace = Class.FindClassNamespace(interp, string);
            if (namespace != null && Class.IsClassNamespace(namespace)) {
                return Class.GetClassFromNamespace(namespace);
            }
        }
        String string2 = interp.getResult().toString();
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(string2);
        stringBuffer.append("class \"");
        stringBuffer.append(string);
        stringBuffer.append("\" not found in context \"");
        stringBuffer.append(Namespace.getCurrentNamespace((Interp)interp).fullName);
        stringBuffer.append("\"");
        interp.setResult(stringBuffer.toString());
        return null;
    }

    static Namespace FindClassNamespace(Interp interp, String string) {
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        Namespace namespace2 = Namespace.findNamespace(interp, string, null, 0);
        if (namespace2 == null && namespace.parent != null && !string.startsWith("::")) {
            if (namespace.name.equals(string)) {
                namespace2 = namespace;
            } else {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("::");
                stringBuffer.append(string);
                namespace2 = Namespace.findNamespace(interp, stringBuffer.toString(), null, 0);
            }
        }
        return namespace2;
    }

    static WrappedCommand ClassCmdResolver(Interp interp, String string, Namespace namespace, int n) throws TclException {
        ItclClass itclClass = Class.GetClassFromNamespace(namespace);
        ItclMemberFunc itclMemberFunc = (ItclMemberFunc)itclClass.resolveCmds.get(string);
        if (itclMemberFunc == null) {
            return null;
        }
        if (itclMemberFunc.member.protection != 1 && !Util.CanAccessFunc(itclMemberFunc, namespace = Util.GetTrueNamespace(interp, itclClass.info))) {
            throw new TclException(interp, "can't access \"" + string + "\": " + Util.ProtectionStr(itclMemberFunc.member.protection) + " variable");
        }
        WrappedCommand wrappedCommand = itclMemberFunc.w_accessCmd;
        boolean bl = wrappedCommand.deleted;
        if (bl) {
            itclMemberFunc.accessCmd = null;
            itclMemberFunc.w_accessCmd = null;
            throw new TclException(interp, "can't access \"" + string + "\": deleted or redefined\n(use the \"body\" command to redefine methods/procs)");
        }
        return itclMemberFunc.w_accessCmd;
    }

    static Var ClassVarResolver(Interp interp, String string, Namespace namespace, int n) throws TclException {
        ItclVarLookup itclVarLookup;
        Var var;
        HashMap hashMap;
        CallFrame callFrame = ItclAccess.getVarFrame(interp);
        Util.Assert(Class.IsClassNamespace(namespace), "IsClassNamespace(context)");
        ItclClass itclClass = Class.GetClassFromNamespace(namespace);
        if ((n & 1) != 0) {
            return null;
        }
        if (callFrame != null && ItclAccess.isProcCallFrame(callFrame) && string.indexOf("::") == -1 && (hashMap = ItclAccess.getVarTable(callFrame)) != null && (var = (Var)hashMap.get(string)) != null) {
            return var;
        }
        ItclVarLookup itclVarLookup2 = (ItclVarLookup)itclClass.resolveVars.get(string);
        if (itclVarLookup2 == null) {
            return null;
        }
        if (!itclVarLookup2.accessible) {
            return null;
        }
        if ((itclVarLookup2.vdefn.member.flags & ItclInt.COMMON) != 0) {
            return itclVarLookup2.common;
        }
        CallFrame callFrame2 = Migrate.GetCallFrame(interp, 0);
        ItclObject itclObject = (ItclObject)itclClass.info.contextFrames.get(callFrame2);
        if (itclObject == null) {
            return null;
        }
        if (itclObject.classDefn != itclVarLookup2.vdefn.member.classDefn && (itclVarLookup = (ItclVarLookup)itclObject.classDefn.resolveVars.get(itclVarLookup2.vdefn.member.fullname)) != null) {
            itclVarLookup2 = itclVarLookup;
        }
        return itclObject.data[itclVarLookup2.index];
    }

    static void BuildVirtualTables(ItclClass itclClass) {
        boolean bl;
        Namespace namespace;
        String string;
        ItclVarLookup itclVarLookup;
        StringBuffer stringBuffer = new StringBuffer(64);
        StringBuffer stringBuffer2 = new StringBuffer(64);
        for (Map.Entry entry : itclClass.resolveVars.entrySet()) {
            itclVarLookup = (ItclVarLookup)entry.getValue();
            if (--itclVarLookup.usage != 0) continue;
        }
        itclClass.resolveVars.clear();
        itclClass.resolveVars = new HashMap();
        itclClass.numInstanceVars = 0;
        ++itclClass.numInstanceVars;
        ItclHierIter itclHierIter = new ItclHierIter();
        Class.InitHierIter(itclHierIter, itclClass);
        ItclClass itclClass2 = Class.AdvanceHierIter(itclHierIter);
        while (itclClass2 != null) {
            for (Map.Entry entry : itclClass2.variables.entrySet()) {
                string = (String)entry.getKey();
                ItclVarDefn itclVarDefn = (ItclVarDefn)entry.getValue();
                itclVarLookup = new ItclVarLookup();
                itclVarLookup.vdefn = itclVarDefn;
                itclVarLookup.usage = 0;
                itclVarLookup.leastQualName = null;
                boolean bl2 = itclVarLookup.accessible = itclVarDefn.member.protection != 3 || itclVarDefn.member.classDefn == itclClass;
                if ((itclVarDefn.member.flags & ItclInt.COMMON) != 0) {
                    namespace = itclClass2.namesp;
                    itclVarLookup.common = namespace.varTable.get(itclVarDefn.member.name);
                    Util.Assert(itclVarLookup.common != null, "vlookup.common != null");
                } else if ((itclVarDefn.member.flags & ItclInt.THIS_VAR) != 0) {
                    itclVarLookup.index = 0;
                } else {
                    ++itclClass.numInstanceVars;
                    itclVarLookup.index = itclVarLookup.index;
                }
                stringBuffer.setLength(0);
                stringBuffer.append(itclVarDefn.member.name);
                namespace = itclClass2.namesp;
                while (true) {
                    boolean bl3 = bl = itclClass.resolveVars.get(string = stringBuffer.toString()) == null;
                    if (bl) {
                        itclClass.resolveVars.put(string, itclVarLookup);
                        ++itclVarLookup.usage;
                        if (itclVarLookup.leastQualName == null) {
                            itclVarLookup.leastQualName = string;
                        }
                    }
                    if (namespace == null) break;
                    stringBuffer2.setLength(0);
                    stringBuffer2.append(string);
                    stringBuffer.setLength(0);
                    stringBuffer.append(namespace.name);
                    stringBuffer.append("::");
                    stringBuffer.append(stringBuffer2.toString());
                    namespace = namespace.parent;
                }
                if (itclVarLookup.usage != 0) continue;
            }
            itclClass2 = Class.AdvanceHierIter(itclHierIter);
        }
        Class.DeleteHierIter(itclHierIter);
        itclClass.resolveCmds.clear();
        itclClass.resolveCmds = new HashMap();
        Class.InitHierIter(itclHierIter, itclClass);
        itclClass2 = Class.AdvanceHierIter(itclHierIter);
        while (itclClass2 != null) {
            block5: for (Map.Entry entry : itclClass2.functions.entrySet()) {
                string = (String)entry.getKey();
                ItclMemberFunc itclMemberFunc = (ItclMemberFunc)entry.getValue();
                stringBuffer.setLength(0);
                stringBuffer.append(itclMemberFunc.member.name);
                namespace = itclClass2.namesp;
                while (true) {
                    boolean bl4 = bl = itclClass.resolveCmds.get(string = stringBuffer.toString()) == null;
                    if (bl) {
                        itclClass.resolveCmds.put(string, itclMemberFunc);
                    }
                    if (namespace == null) continue block5;
                    stringBuffer2.setLength(0);
                    stringBuffer2.append(string);
                    stringBuffer.setLength(0);
                    stringBuffer.append(namespace.name);
                    stringBuffer.append("::");
                    stringBuffer.append(stringBuffer2.toString());
                    namespace = namespace.parent;
                }
            }
            itclClass2 = Class.AdvanceHierIter(itclHierIter);
        }
        Class.DeleteHierIter(itclHierIter);
    }

    static ItclVarDefn CreateVarDefn(Interp interp, ItclClass itclClass, String string, String string2, String string3) throws TclException {
        ItclMemberCode itclMemberCode;
        boolean bl;
        boolean bl2 = bl = !itclClass.variables.containsKey(string);
        if (!bl) {
            throw new TclException(interp, "variable name \"" + string + "\" already defined in class \"" + itclClass.fullname + "\"");
        }
        if (string3 != null) {
            itclMemberCode = Methods.CreateMemberCode(interp, itclClass, null, string3);
            Util.PreserveData(itclMemberCode);
        } else {
            itclMemberCode = null;
        }
        ItclVarDefn itclVarDefn = new ItclVarDefn();
        itclVarDefn.member = Class.CreateMember(interp, itclClass, string);
        itclVarDefn.member.code = itclMemberCode;
        if (itclVarDefn.member.protection == 4) {
            itclVarDefn.member.protection = 2;
        }
        itclVarDefn.init = string2;
        itclClass.variables.put(string, itclVarDefn);
        return itclVarDefn;
    }

    static void DeleteVarDefn(ItclVarDefn itclVarDefn) {
        Class.DeleteMember(itclVarDefn.member);
        itclVarDefn.init = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String GetCommonVar(Interp interp, String string, ItclClass itclClass) {
        CallFrame callFrame = ItclAccess.newCallFrame(interp);
        Namespace.pushCallFrame(interp, callFrame, itclClass.namesp, false);
        try {
            TclObject tclObject = interp.getVar(string, 0);
            if (tclObject == null) {
                String string2 = null;
                return string2;
            }
            String string3 = tclObject.toString();
            return string3;
        }
        catch (TclException tclException) {
            String string4 = null;
            return string4;
        }
        finally {
            Namespace.popCallFrame(interp);
        }
    }

    static ItclMember CreateMember(Interp interp, ItclClass itclClass, String string) {
        ItclMember itclMember = new ItclMember();
        itclMember.interp = interp;
        itclMember.classDefn = itclClass;
        itclMember.flags = 0;
        itclMember.protection = Util.Protection(interp, 0);
        itclMember.code = null;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(itclClass.fullname);
        stringBuffer.append("::");
        stringBuffer.append(string);
        itclMember.fullname = stringBuffer.toString();
        itclMember.name = string;
        return itclMember;
    }

    static void DeleteMember(ItclMember itclMember) {
        if (itclMember != null) {
            itclMember.name = null;
            itclMember.fullname = null;
            if (itclMember.code != null) {
                Util.ReleaseData(itclMember.code);
            }
            itclMember.code = null;
        }
    }

    static void InitHierIter(ItclHierIter itclHierIter, ItclClass itclClass) {
        itclHierIter.stack = new Itcl_Stack();
        Util.InitStack(itclHierIter.stack);
        Util.PushStack(itclClass, itclHierIter.stack);
        itclHierIter.current = itclClass;
    }

    static void DeleteHierIter(ItclHierIter itclHierIter) {
        Util.DeleteStack(itclHierIter.stack);
        itclHierIter.current = null;
    }

    static ItclClass AdvanceHierIter(ItclHierIter itclHierIter) {
        itclHierIter.current = (ItclClass)Util.PopStack(itclHierIter.stack);
        if (itclHierIter.current != null) {
            ItclClass itclClass = itclHierIter.current;
            Itcl_ListElem itcl_ListElem = Util.LastListElem(itclClass.bases);
            while (itcl_ListElem != null) {
                Util.PushStack(Util.GetListValue(itcl_ListElem), itclHierIter.stack);
                itcl_ListElem = Util.PrevListElem(itcl_ListElem);
            }
        }
        return itclHierIter.current;
    }

    static class ClassResolverImpl
    implements Resolver {
        ClassResolverImpl() {
        }

        @Override
        public WrappedCommand resolveCmd(Interp interp, String string, Namespace namespace, int n) throws TclException {
            return Class.ClassCmdResolver(interp, string, namespace, n);
        }

        @Override
        public Var resolveVar(Interp interp, String string, Namespace namespace, int n) throws TclException {
            return Class.ClassVarResolver(interp, string, namespace, n);
        }
    }

    static class HandleClassCmd
    implements CommandWithDispose {
        ItclClass cdefn;
        boolean release = false;

        HandleClassCmd(ItclClass itclClass) {
            this.cdefn = itclClass;
        }

        @Override
        public void disposeCmd() {
            if (!this.release) {
                Class.DestroyClass(this.cdefn);
            } else {
                Util.ReleaseData(this.cdefn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length == 1) {
                return;
            }
            String string = tclObjectArray[1].toString();
            if (string.equals("::") && tclObjectArray.length > 2) {
                if ((this.cdefn.flags & ItclInt.OLD_STYLE) != 0) {
                    CallFrame callFrame = ItclAccess.newCallFrame(interp);
                    Namespace.pushCallFrame(interp, callFrame, this.cdefn.namesp, false);
                    TclObject tclObject = Util.CreateArgs(interp, null, tclObjectArray, 2);
                    TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObject);
                    try {
                        Util.EvalArgs(interp, tclObjectArray2);
                        return;
                    }
                    finally {
                        Namespace.popCallFrame(interp);
                    }
                }
                throw new TclException(interp, "syntax \"class :: proc\" is an anachronism\n[incr Tcl] no longer supports this syntax.\nInstead, remove the spaces from your procedure invocations:\n  " + tclObjectArray[0] + "::" + tclObjectArray[2] + " ?args?");
            }
            StringBuffer stringBuffer = new StringBuffer(64);
            String string2 = null;
            String string3 = string;
            if (string3.indexOf("#auto") != -1) {
                String string4;
                String string5;
                if (string3.equals("#auto")) {
                    string5 = null;
                    string4 = null;
                } else if (string3.startsWith("#auto")) {
                    string5 = null;
                    string4 = string3.substring(5);
                } else if (string3.endsWith("#auto")) {
                    string5 = string3.substring(0, string3.length() - 5);
                    string4 = null;
                } else {
                    int n = string3.indexOf("#auto");
                    string5 = string3.substring(0, n);
                    string4 = string3.substring(n + 5);
                }
                StringBuffer stringBuffer2 = new StringBuffer(64);
                do {
                    String string6 = this.cdefn.name.substring(0, 1).toLowerCase();
                    stringBuffer2.setLength(0);
                    stringBuffer2.append(string6);
                    stringBuffer2.append(this.cdefn.name.substring(1));
                    stringBuffer2.append(this.cdefn.unique++);
                    stringBuffer.setLength(0);
                    if (string5 != null) {
                        stringBuffer.append(string5);
                    }
                    stringBuffer.append(stringBuffer2);
                    if (string4 == null) continue;
                    stringBuffer.append(string4);
                } while (interp.getCommand(string2 = stringBuffer.toString()) != null);
            }
            if (string2 == null) {
                string2 = string;
            }
            TclObject tclObject = Util.CreateArgs(interp, null, tclObjectArray, 2);
            TclObject[] tclObjectArray3 = TclList.getElements(interp, tclObject);
            ItclObject itclObject = Objects.CreateObject(interp, string2, this.cdefn, tclObjectArray3);
            interp.setResult(string2);
        }
    }

    static class DestroyClassNamespImpl
    implements Namespace.DeleteProc {
        ItclClass cdefn;

        DestroyClassNamespImpl(ItclClass itclClass) {
            this.cdefn = itclClass;
        }

        @Override
        public void delete() {
            Class.DestroyClassNamesp(this.cdefn);
        }
    }
}

