/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.HashMap;
import tcl.lang.CallFrame;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class ItclAccess {
    public static boolean isProcCallFrame(CallFrame callFrame) {
        return callFrame.isProcCallFrame;
    }

    public static void setProcCallFrameFalse(CallFrame callFrame) {
        callFrame.isProcCallFrame = false;
    }

    public static TclObject[] getCallFrameObjv(CallFrame callFrame) {
        return callFrame.objv;
    }

    public static Namespace getCallFrameNamespace(CallFrame callFrame) {
        return callFrame.ns;
    }

    public static void setCallFrameObjv(CallFrame callFrame, TclObject[] tclObjectArray) {
        callFrame.objv = tclObjectArray;
    }

    public static CallFrame getCallFrame(Interp interp, int n) {
        CallFrame callFrame = interp.varFrame;
        while (callFrame != null && n > 0) {
            callFrame = callFrame.callerVar;
            --n;
        }
        return callFrame;
    }

    public static CallFrame activateCallFrame(Interp interp, CallFrame callFrame) {
        CallFrame callFrame2 = interp.varFrame;
        interp.varFrame = callFrame;
        return callFrame2;
    }

    public static CallFrame newCallFrame(Interp interp) {
        return new CallFrame(interp);
    }

    public static CallFrame getVarFrame(Interp interp) {
        return interp.varFrame;
    }

    public static HashMap getVarTable(CallFrame callFrame) {
        return callFrame.varTable;
    }

    public static void setVarTable(CallFrame callFrame, HashMap hashMap) {
        callFrame.varTable = hashMap;
    }

    public static Var newVar() {
        return new Var();
    }

    public static void deleteVars(Interp interp, HashMap hashMap) {
        Var.deleteVars(interp, hashMap);
    }

    public static int decrVarRefCount(Var var) {
        --var.refCount;
        return var.refCount;
    }

    public static Procedure newProcedure(Interp interp, Namespace namespace, String string, TclObject tclObject, TclObject tclObject2, String string2, int n) throws TclException {
        return new Procedure(interp, namespace, string, tclObject, tclObject2, string2, n);
    }

    public static TclObject[][] getArgList(Procedure procedure) {
        return procedure.argList;
    }

    public static void setWrappedCommand(Procedure procedure, WrappedCommand wrappedCommand) {
        procedure.wcmd = wrappedCommand;
    }

    public static void assignLocalVar(Interp interp, String string, TclObject tclObject, CallFrame callFrame) throws TclException {
        if (callFrame.varTable == null) {
            callFrame.varTable = new HashMap();
        }
        Var var = new Var();
        var.clearVarInHashtable();
        var.table = callFrame.varTable;
        callFrame.varTable.put(string, var);
        interp.setVar(string, null, tclObject, 0);
    }

    public static void createObjVar(Var var, String string, Namespace namespace, HashMap hashMap) {
        var.hashKey = string;
        var.ns = namespace;
        var.table = hashMap;
        var.refCount = 1;
    }

    public static void createCommonVar(Var var, String string, Namespace namespace, HashMap hashMap) {
        var.table = hashMap;
        var.hashKey = string;
        var.ns = namespace;
        var.setVarNamespace();
        ++var.refCount;
        ++var.refCount;
    }

    public static Object FirstHashEntry(HashMap hashMap) {
        return Namespace.FirstHashEntry(hashMap);
    }
}

