/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.CompiledLocal;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclContext;
import tcl.pkg.itcl.ItclEventuallyFreed;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclJavafunc;
import tcl.pkg.itcl.ItclMember;
import tcl.pkg.itcl.ItclMemberCode;
import tcl.pkg.itcl.ItclMemberFunc;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclVarDefn;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Linkage;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Util;

public class Methods {
    static void CreateMethod(Interp interp, ItclClass itclClass, String string, String string2, String string3) throws TclException {
        if (string.indexOf("::") != -1) {
            throw new TclException(interp, "bad method name \"" + string + "\"");
        }
        ItclMemberFunc itclMemberFunc = Methods.CreateMemberFunc(interp, itclClass, string, string2, string3);
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(itclClass.namesp.fullName);
        stringBuffer.append("::");
        stringBuffer.append(string);
        String string4 = stringBuffer.toString();
        Util.PreserveData(itclMemberFunc);
        interp.createCommand(string4, new ExecMethod(itclMemberFunc));
        itclMemberFunc.w_accessCmd = Namespace.findCommand(interp, string4, null, 2);
        itclMemberFunc.accessCmd = itclMemberFunc.w_accessCmd.cmd;
    }

    static void CreateProc(Interp interp, ItclClass itclClass, String string, String string2, String string3) throws TclException {
        if (string.indexOf("::") != -1) {
            throw new TclException(interp, "bad proc name \"" + string + "\"");
        }
        ItclMemberFunc itclMemberFunc = Methods.CreateMemberFunc(interp, itclClass, string, string2, string3);
        itclMemberFunc.member.flags |= ItclInt.COMMON;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(itclClass.namesp.fullName);
        stringBuffer.append("::");
        stringBuffer.append(string);
        String string4 = stringBuffer.toString();
        Util.PreserveData(itclMemberFunc);
        interp.createCommand(string4, new ExecProc(itclMemberFunc));
        itclMemberFunc.w_accessCmd = Namespace.findCommand(interp, string4, null, 2);
        itclMemberFunc.accessCmd = itclMemberFunc.w_accessCmd.cmd;
    }

    static ItclMemberFunc CreateMemberFunc(Interp interp, ItclClass itclClass, String string, String string2, String string3) throws TclException {
        ItclMemberCode itclMemberCode;
        boolean bl;
        boolean bl2 = bl = itclClass.functions.get(string) == null;
        if (!bl) {
            throw new TclException(interp, "\"" + string + "\" already defined in class \"" + itclClass.fullname + "\"");
        }
        try {
            itclMemberCode = Methods.CreateMemberCode(interp, itclClass, string2, string3);
        }
        catch (TclException tclException) {
            itclClass.functions.remove(string);
            throw tclException;
        }
        Util.PreserveData(itclMemberCode);
        ItclMemberFunc itclMemberFunc = new ItclMemberFunc();
        itclMemberFunc.member = Class.CreateMember(interp, itclClass, string);
        itclMemberFunc.member.code = itclMemberCode;
        if (itclMemberFunc.member.protection == 4) {
            itclMemberFunc.member.protection = 1;
        }
        itclMemberFunc.arglist = null;
        itclMemberFunc.argcount = 0;
        itclMemberFunc.accessCmd = null;
        if (string2 != null) {
            itclMemberFunc.member.flags |= ItclInt.ARG_SPEC;
        }
        if (itclMemberCode.arglist != null) {
            CreateArgListResult createArgListResult = Methods.CreateArgList(interp, string2);
            itclMemberFunc.arglist = createArgListResult.arglist;
            itclMemberFunc.argcount = createArgListResult.argcount;
        }
        if (string.equals("constructor")) {
            itclMemberFunc.member.flags |= ItclInt.CONSTRUCTOR;
        }
        if (string.equals("destructor")) {
            itclMemberFunc.member.flags |= ItclInt.DESTRUCTOR;
        }
        itclClass.functions.put(string, itclMemberFunc);
        Util.PreserveData(itclMemberFunc);
        return itclMemberFunc;
    }

    static void ChangeMemberFunc(Interp interp, ItclMemberFunc itclMemberFunc, String string, String string2) throws TclException {
        ItclMemberCode itclMemberCode = null;
        itclMemberCode = Methods.CreateMemberCode(interp, itclMemberFunc.member.classDefn, string, string2);
        if ((itclMemberFunc.member.flags & ItclInt.ARG_SPEC) != 0 && !Methods.EquivArgLists(itclMemberFunc.arglist, itclMemberFunc.argcount, itclMemberCode.arglist, itclMemberCode.argcount)) {
            TclObject tclObject = Methods.ArgList(itclMemberFunc.argcount, itclMemberFunc.arglist);
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("argument list changed for function \"");
            stringBuffer.append(itclMemberFunc.member.fullname);
            stringBuffer.append("\": should be \"");
            stringBuffer.append(tclObject.toString());
            stringBuffer.append("\"");
            Methods.DeleteMemberCode(itclMemberCode);
            throw new TclException(interp, stringBuffer.toString());
        }
        Util.PreserveData(itclMemberCode);
        Util.ReleaseData(itclMemberFunc.member.code);
        itclMemberFunc.member.code = itclMemberCode;
    }

    static void DeleteMemberFunc(ItclMemberFunc itclMemberFunc) {
        if (itclMemberFunc != null) {
            Class.DeleteMember(itclMemberFunc.member);
            if (itclMemberFunc.arglist != null) {
                Methods.DeleteArgList(itclMemberFunc.arglist);
            }
        }
    }

    static ItclMemberCode CreateMemberCode(Interp interp, ItclClass itclClass, String string, String string2) throws TclException {
        Object object;
        ItclMemberCode itclMemberCode = new ItclMemberCode();
        itclMemberCode.flags = 0;
        itclMemberCode.argcount = 0;
        itclMemberCode.arglist = null;
        itclMemberCode.proc = null;
        itclMemberCode.objCmd = null;
        if (string != null) {
            try {
                object = Methods.CreateArgList(interp, string);
            }
            catch (TclException tclException) {
                Methods.DeleteMemberCode(itclMemberCode);
                throw tclException;
            }
            itclMemberCode.argcount = ((CreateArgListResult)object).argcount;
            itclMemberCode.arglist = ((CreateArgListResult)object).arglist;
            itclMemberCode.flags |= ItclInt.ARG_SPEC;
        }
        itclMemberCode.body = string2 != null ? string2 : null;
        itclMemberCode.proc = null;
        if (string2 == null) {
            itclMemberCode.flags |= ItclInt.IMPLEMENT_NONE;
        } else if (string2.length() >= 2 && string2.charAt(0) == '@') {
            object = string2.substring(1);
            ItclJavafunc itclJavafunc = Linkage.FindC(interp, (String)object);
            if (itclJavafunc == null) {
                Methods.DeleteMemberCode(itclMemberCode);
                throw new TclException(interp, "no registered C procedure with name \"" + (String)object + "\"");
            }
            itclMemberCode.flags = ItclInt.IMPLEMENT_OBJCMD;
            itclMemberCode.objCmd = itclJavafunc.objCmdProc;
        } else {
            itclMemberCode.flags |= ItclInt.IMPLEMENT_TCL;
        }
        return itclMemberCode;
    }

    static boolean IsMemberCodeImplemented(ItclMemberCode itclMemberCode) {
        return (itclMemberCode.flags & ItclInt.IMPLEMENT_NONE) == 0;
    }

    static void DeleteMemberCode(ItclMemberCode itclMemberCode) {
        if (itclMemberCode.arglist != null) {
            Methods.DeleteArgList(itclMemberCode.arglist);
        }
        if (itclMemberCode.proc != null) {
            itclMemberCode.proc = null;
        }
    }

    static void GetMemberCode(Interp interp, ItclMember itclMember) throws TclException {
        ItclMemberCode itclMemberCode = itclMember.code;
        if (!Methods.IsMemberCodeImplemented(itclMemberCode)) {
            try {
                interp.eval("::auto_load " + itclMember.fullname);
            }
            catch (TclException tclException) {
                interp.addErrorInfo("\n    (while autoloading code for \"" + itclMember.fullname + "\")");
                throw tclException;
            }
            interp.resetResult();
        }
        if (!Methods.IsMemberCodeImplemented(itclMemberCode = itclMember.code)) {
            throw new TclException(interp, "member function \"" + itclMember.fullname + "\" is not defined and cannot be autoloaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void EvalMemberCode(Interp interp, ItclMemberFunc itclMemberFunc, ItclMember itclMember, ItclObject itclObject, TclObject[] tclObjectArray) throws TclException {
        CallFrame callFrame = null;
        Methods.GetMemberCode(interp, itclMember);
        ItclMemberCode itclMemberCode = itclMember.code;
        Util.PreserveData(itclMemberCode);
        boolean bl = false;
        ItclObjectInfo itclObjectInfo = itclMember.classDefn.info;
        CallFrame callFrame2 = Migrate.GetCallFrame(interp, 0);
        for (int i = Util.GetStackSize(itclObjectInfo.transparentFrames) - 1; i >= 0; --i) {
            CallFrame callFrame3 = (CallFrame)Util.GetStackValue(itclObjectInfo.transparentFrames, i);
            if (callFrame2 != callFrame3) continue;
            bl = true;
            break;
        }
        if (bl) {
            callFrame2 = Migrate.GetCallFrame(interp, 1);
            callFrame = Migrate.ActivateCallFrame(interp, callFrame2);
        }
        ItclContext itclContext = new ItclContext(interp);
        Methods.PushContext(interp, itclMember, itclMember.classDefn, itclObject, itclContext);
        try {
            if (itclMemberFunc != null && tclObjectArray.length > 0 && ((itclMemberCode.flags & ItclInt.IMPLEMENT_TCL) != 0 || (itclMember.flags & ItclInt.CONSTRUCTOR) != 0 && itclMember.classDefn.initCode != null)) {
                Methods.AssignArgs(interp, tclObjectArray, itclMemberFunc);
            }
            if ((itclMember.flags & ItclInt.CONSTRUCTOR) != 0 && itclObject != null && itclObject.constructed != null) {
                Methods.ConstructBase(interp, itclObject, itclMember.classDefn);
            }
            if ((itclMemberCode.flags & ItclInt.IMPLEMENT_OBJCMD) != 0) {
                itclMemberCode.objCmd.cmdProc(interp, tclObjectArray);
            } else {
                if ((itclMemberCode.flags & ItclInt.IMPLEMENT_ARGCMD) != 0) {
                    throw new TclRuntimeError("unexpected IMPLEMENT_ARGCMD");
                }
                if ((itclMemberCode.flags & ItclInt.IMPLEMENT_TCL) != 0) {
                    interp.eval(itclMemberCode.body);
                } else {
                    throw new TclRuntimeError("bad implementation flag for " + itclMember.fullname);
                }
            }
            if ((itclMember.flags & ItclInt.DESTRUCTOR) != 0 && itclObject != null && itclObject.destructed != null) {
                itclObject.destructed.put(itclMember.classDefn.name, "");
            }
            if ((itclMember.flags & ItclInt.CONSTRUCTOR) != 0 && itclObject != null && itclObject.constructed != null) {
                itclObject.constructed.put(itclMember.classDefn.name, "");
            }
        }
        finally {
            Methods.PopContext(interp, itclContext);
            if (bl) {
                Migrate.ActivateCallFrame(interp, callFrame);
            }
            Util.ReleaseData(itclMemberCode);
        }
    }

    static CreateArgListResult CreateArgList(Interp interp, String string) throws TclException {
        int n = 0;
        CompiledLocal compiledLocal = null;
        CompiledLocal compiledLocal2 = null;
        try {
            if (string != null) {
                TclObject[] tclObjectArray = TclList.getElements(interp, TclString.newInstance(string));
                n = tclObjectArray.length;
                for (int i = 0; i < tclObjectArray.length; ++i) {
                    TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObjectArray[i]);
                    CompiledLocal compiledLocal3 = null;
                    if (tclObjectArray2.length == 0 || tclObjectArray2[0].toString().length() == 0) {
                        throw new TclException(interp, "argument #" + i + " has no name");
                    }
                    if (tclObjectArray2.length > 2) {
                        throw new TclException(interp, "too many fields in argument specifier \"" + tclObjectArray[i] + "\"");
                    }
                    if (tclObjectArray2[0].toString().indexOf("::") != -1) {
                        throw new TclException(interp, "bad argument name \"" + tclObjectArray2[0] + "\"");
                    }
                    compiledLocal3 = tclObjectArray2.length == 1 ? Methods.CreateArg(tclObjectArray2[0].toString(), null) : Methods.CreateArg(tclObjectArray2[0].toString(), tclObjectArray2[1].toString());
                    if (compiledLocal3 == null) continue;
                    if (compiledLocal2 == null) {
                        compiledLocal2 = compiledLocal = compiledLocal3;
                        continue;
                    }
                    compiledLocal.next = compiledLocal3;
                    compiledLocal = compiledLocal3;
                }
            }
        }
        catch (TclException tclException) {
            Methods.DeleteArgList(compiledLocal2);
            throw tclException;
        }
        CreateArgListResult createArgListResult = new CreateArgListResult();
        createArgListResult.arglist = compiledLocal2;
        createArgListResult.argcount = n;
        return createArgListResult;
    }

    static CompiledLocal CreateArg(String string, String string2) {
        CompiledLocal compiledLocal = null;
        compiledLocal = new CompiledLocal();
        compiledLocal.next = null;
        if (string2 != null) {
            compiledLocal.defValue = TclString.newInstance(string2);
            compiledLocal.defValue.preserve();
        } else {
            compiledLocal.defValue = null;
        }
        compiledLocal.name = string;
        return compiledLocal;
    }

    static void DeleteArgList(CompiledLocal compiledLocal) {
        CompiledLocal compiledLocal2 = compiledLocal;
        while (compiledLocal2 != null) {
            if (compiledLocal2.defValue != null) {
                compiledLocal2.defValue.release();
                compiledLocal2.defValue = null;
            }
            compiledLocal2.name = null;
            CompiledLocal compiledLocal3 = compiledLocal2.next;
            compiledLocal2.next = null;
            compiledLocal2 = compiledLocal3;
        }
    }

    static TclObject ArgList(int n, CompiledLocal compiledLocal) {
        StringBuffer stringBuffer = new StringBuffer(64);
        while (compiledLocal != null && n-- > 0) {
            if (compiledLocal.defValue != null) {
                String string = compiledLocal.defValue.toString();
                Util.StartSublist(stringBuffer);
                Util.AppendElement(stringBuffer, compiledLocal.name);
                Util.AppendElement(stringBuffer, string);
                Util.EndSublist(stringBuffer);
            } else {
                Util.AppendElement(stringBuffer, compiledLocal.name);
            }
            compiledLocal = compiledLocal.next;
        }
        TclObject tclObject = TclString.newInstance(stringBuffer.toString());
        return tclObject;
    }

    static boolean EquivArgLists(CompiledLocal compiledLocal, int n, CompiledLocal compiledLocal2, int n2) {
        while (compiledLocal != null && n > 0 && compiledLocal2 != null && n2 > 0) {
            if (n == 1 && compiledLocal.name.equals("args")) {
                return true;
            }
            if (compiledLocal.defValue != null) {
                String string;
                if (compiledLocal2.defValue == null) {
                    return false;
                }
                String string2 = compiledLocal.defValue.toString();
                if (!string2.equals(string = compiledLocal2.defValue.toString())) {
                    return false;
                }
            } else if (compiledLocal2.defValue != null) {
                return false;
            }
            compiledLocal = compiledLocal.next;
            --n;
            compiledLocal2 = compiledLocal2.next;
            --n2;
        }
        if (n == 1 && compiledLocal.name.equals("args")) {
            return true;
        }
        return n == 0 && n2 == 0;
    }

    static void GetMemberFuncUsage(ItclMemberFunc itclMemberFunc, ItclObject itclObject, StringBuffer stringBuffer) {
        int n;
        CompiledLocal compiledLocal;
        if ((itclMemberFunc.member.flags & ItclInt.COMMON) == 0) {
            String string;
            if ((itclMemberFunc.member.flags & ItclInt.CONSTRUCTOR) != 0 && itclObject.constructed != null) {
                ItclClass itclClass = itclObject.classDefn;
                ItclMemberFunc itclMemberFunc2 = (ItclMemberFunc)itclClass.resolveCmds.get("constructor");
                if (itclMemberFunc2 == itclMemberFunc) {
                    String string2 = itclObject.classDefn.interp.getCommandFullName(itclObject.classDefn.w_accessCmd);
                    stringBuffer.append(string2);
                    stringBuffer.append(" ");
                    string = itclObject.classDefn.interp.getCommandName(itclObject.w_accessCmd);
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append(itclMemberFunc.member.fullname);
                }
            } else if (itclObject != null && itclObject.accessCmd != null) {
                string = itclObject.classDefn.interp.getCommandName(itclObject.w_accessCmd);
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(itclMemberFunc.member.name);
            } else {
                stringBuffer.append("<object> ");
                stringBuffer.append(itclMemberFunc.member.name);
            }
        } else {
            stringBuffer.append(itclMemberFunc.member.fullname);
        }
        if (itclMemberFunc.member.code != null) {
            compiledLocal = itclMemberFunc.member.code.arglist;
            n = itclMemberFunc.member.code.argcount;
        } else if (itclMemberFunc.arglist != null) {
            compiledLocal = itclMemberFunc.arglist;
            n = itclMemberFunc.argcount;
        } else {
            compiledLocal = null;
            n = 0;
        }
        if (compiledLocal != null) {
            CompiledLocal compiledLocal2 = compiledLocal;
            while (compiledLocal2 != null && n > 0) {
                if (n == 1 && compiledLocal2.name.equals("args")) {
                    stringBuffer.append(" ?arg arg ...?");
                } else if (compiledLocal2.defValue != null) {
                    stringBuffer.append(" ?");
                    stringBuffer.append(compiledLocal2.name);
                    stringBuffer.append("?");
                } else {
                    stringBuffer.append(" ");
                    stringBuffer.append(compiledLocal2.name);
                }
                compiledLocal2 = compiledLocal2.next;
                --n;
            }
        }
    }

    static void PushContext(Interp interp, ItclMember itclMember, ItclClass itclClass, ItclObject itclObject, ItclContext itclContext) throws TclException {
        CallFrame callFrame = itclContext.frame;
        Namespace.pushCallFrame(interp, callFrame, itclClass.namesp, true);
        itclContext.classDefn = itclClass;
        if (itclObject != null) {
            itclClass.info.contextFrames.put(callFrame, itclObject);
            Util.PreserveData(itclObject);
        }
        if (itclMember != null) {
            // empty if block
        }
    }

    static void PopContext(Interp interp, ItclContext itclContext) {
        CallFrame callFrame = Migrate.GetCallFrame(interp, 0);
        ItclObjectInfo itclObjectInfo = itclContext.classDefn.info;
        ItclObject itclObject = (ItclObject)itclObjectInfo.contextFrames.get(callFrame);
        if (itclObject != null) {
            Util.ReleaseData(itclObject);
            itclObjectInfo.contextFrames.remove(callFrame);
        }
        Namespace.popCallFrame(interp);
    }

    static GetContextResult GetContext(Interp interp) throws TclException {
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        ItclClass itclClass = null;
        ItclObject itclObject = null;
        if (Class.IsClassNamespace(namespace)) {
            itclClass = Class.GetClassFromNamespace(namespace);
            CallFrame callFrame = Migrate.GetCallFrame(interp, 0);
            ItclObjectInfo itclObjectInfo = itclClass.info;
            itclObject = (ItclObject)itclObjectInfo.contextFrames.get(callFrame);
            return new GetContextResult(itclClass, itclObject);
        }
        throw new TclException(interp, "namespace \"" + namespace.fullName + "\" is not a class namespace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void AssignArgs(Interp interp, TclObject[] tclObjectArray, ItclMemberFunc itclMemberFunc) throws TclException {
        int n;
        ItclObject itclObject;
        ItclClass itclClass;
        Object object;
        ItclMemberCode itclMemberCode = itclMemberFunc.member.code;
        Object var5_4 = null;
        TclObject[] tclObjectArray2 = null;
        int n2 = 0;
        ItclVarDefn[] itclVarDefnArray = null;
        String[] stringArray = null;
        ParseConfigResult parseConfigResult = null;
        CallFrame callFrame = Migrate.GetCallFrame(interp, 0);
        ItclAccess.setCallFrameObjv(callFrame, tclObjectArray);
        try {
            object = Methods.GetContext(interp);
            itclClass = ((GetContextResult)object).cdefn;
            itclObject = ((GetContextResult)object).odefn;
        }
        catch (TclException tclException) {
            itclClass = null;
            itclObject = null;
        }
        interp.resetResult();
        try {
            int n3 = itclMemberCode.argcount;
            CompiledLocal compiledLocal = itclMemberCode.arglist;
            int n4 = 1;
            int n5 = tclObjectArray.length - 1;
            while (n3 > 0) {
                TclObject tclObject;
                TclObject tclObject2;
                if (n3 == 1 && compiledLocal.name.equals("args")) {
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    tclObject2 = TclList.newInstance();
                    for (int i = n4; i < n4 + n5; ++i) {
                        TclList.append(interp, tclObject2, tclObjectArray[i]);
                    }
                    Methods.AssignLocal(interp, "args", tclObject2, callFrame);
                    n5 = 0;
                    break;
                }
                if (n3 == 1 && compiledLocal.name.equals("config") && itclObject != null) {
                    if ((itclMemberFunc.member.flags & ItclInt.OLD_STYLE) == 0) {
                        throw new TclException(interp, "\"config\" argument is an anachronism\n[incr Tcl] no longer supports the \"config\" argument.\nInstead, use the \"args\" argument and then use the\nbuilt-in configure method to handle args like this:\n  eval configure $args");
                    }
                    if (n5 > 0) {
                        parseConfigResult = Methods.ParseConfig(interp, n5, tclObjectArray, n4, itclObject);
                        n2 = parseConfigResult.num_variables;
                        itclVarDefnArray = parseConfigResult.variables;
                        stringArray = parseConfigResult.values;
                        tclObject2 = TclList.newInstance();
                        for (n = 0; n < n2; ++n) {
                            object = new StringBuffer(64);
                            ((StringBuffer)object).append(itclVarDefnArray[n].member.classDefn.name);
                            ((StringBuffer)object).append("::");
                            ((StringBuffer)object).append(itclVarDefnArray[n].member.name);
                            tclObject = TclString.newInstance(((StringBuffer)object).toString());
                            TclList.append(interp, tclObject2, tclObject);
                        }
                        Methods.AssignLocal(interp, compiledLocal.name, tclObject2, callFrame);
                        n5 = 0;
                    } else if (compiledLocal.defValue != null) {
                        tclObjectArray2 = TclList.getElements(interp, compiledLocal.defValue);
                        int n6 = tclObjectArray2.length;
                        for (n = 0; n < n6; ++n) {
                            tclObjectArray2[n].preserve();
                        }
                        parseConfigResult = Methods.ParseConfig(interp, n6, tclObjectArray2, 0, itclObject);
                        n2 = parseConfigResult.num_variables;
                        itclVarDefnArray = parseConfigResult.variables;
                        stringArray = parseConfigResult.values;
                        tclObject2 = TclList.newInstance();
                        for (n = 0; n < n2; ++n) {
                            object = new StringBuffer(64);
                            ((StringBuffer)object).append(itclVarDefnArray[n].member.classDefn.name);
                            ((StringBuffer)object).append("::");
                            ((StringBuffer)object).append(itclVarDefnArray[n].member.name);
                            tclObject = TclString.newInstance(((StringBuffer)object).toString());
                            TclList.append(interp, tclObject2, tclObject);
                        }
                        Methods.AssignLocal(interp, compiledLocal.name, tclObject2, callFrame);
                    } else {
                        tclObject = TclString.newInstance("");
                        Methods.AssignLocal(interp, compiledLocal.name, tclObject, callFrame);
                    }
                } else if (n5 > 0) {
                    tclObject = tclObjectArray[n4];
                    Methods.AssignLocal(interp, compiledLocal.name, tclObject, callFrame);
                } else if (compiledLocal.defValue != null) {
                    tclObject = compiledLocal.defValue;
                    Methods.AssignLocal(interp, compiledLocal.name, tclObject, callFrame);
                } else {
                    if (itclMemberFunc != null) {
                        object = new StringBuffer(64);
                        ((StringBuffer)object).append("wrong # args: should be \"");
                        Methods.GetMemberFuncUsage(itclMemberFunc, itclObject, (StringBuffer)object);
                        ((StringBuffer)object).append("\"");
                        throw new TclException(interp, ((StringBuffer)object).toString());
                    }
                    throw new TclException(interp, "no value given for parameter \"" + compiledLocal.name + "\"");
                }
                compiledLocal = compiledLocal.next;
                --n3;
                ++n4;
                --n5;
            }
            if (n5 > 0) {
                if (itclMemberFunc != null) {
                    StringBuffer stringBuffer = new StringBuffer(64);
                    stringBuffer.append("wrong # args: should be \"");
                    Methods.GetMemberFuncUsage(itclMemberFunc, itclObject, stringBuffer);
                    stringBuffer.append("\"");
                    throw new TclException(interp, stringBuffer.toString());
                }
                throw new TclException(interp, "too many arguments");
            }
            if (n2 > 0) {
                Methods.HandleConfig(interp, parseConfigResult, itclObject);
            }
        }
        finally {
            if (tclObjectArray2 != null) {
                for (n = 0; n < tclObjectArray2.length; ++n) {
                    tclObjectArray2[n].release();
                }
            }
        }
    }

    static void AssignLocal(Interp interp, String string, TclObject tclObject, CallFrame callFrame) throws TclException {
        ItclAccess.assignLocalVar(interp, string, tclObject, callFrame);
    }

    static ParseConfigResult ParseConfig(Interp interp, int n, TclObject[] tclObjectArray, int n2, ItclObject itclObject) throws TclException {
        if (n < 0) {
            n = 0;
        }
        int n3 = 0;
        ItclVarDefn[] itclVarDefnArray = new ItclVarDefn[n];
        String[] stringArray = new String[n];
        while (n-- > 0) {
            String string = tclObjectArray[n2].toString();
            if (string.length() < 2 || string.charAt(0) != '-') {
                throw new TclException(interp, "syntax error in config assignment \"" + string + "\": should be \"-variable value\"");
            }
            if (n-- <= 0) {
                throw new TclException(interp, "syntax error in config assignment \"" + string + "\": should be \"-variable value\" (missing value)");
            }
            ItclVarLookup itclVarLookup = (ItclVarLookup)itclObject.classDefn.resolveVars.get(string.substring(1));
            if (itclVarLookup != null) {
                String string2 = tclObjectArray[n2 + 1].toString();
                itclVarDefnArray[n3] = itclVarLookup.vdefn;
                stringArray[n3] = string2;
                ++n3;
                n2 += 2;
                continue;
            }
            throw new TclException(interp, "syntax error in config assignment \"" + string + "\": unrecognized variable");
        }
        ParseConfigResult parseConfigResult = new ParseConfigResult();
        parseConfigResult.num_variables = n3;
        parseConfigResult.variables = itclVarDefnArray;
        parseConfigResult.values = stringArray;
        return parseConfigResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void HandleConfig(Interp interp, ParseConfigResult parseConfigResult, ItclObject itclObject) throws TclException {
        int n = parseConfigResult.num_variables;
        ItclVarDefn[] itclVarDefnArray = parseConfigResult.variables;
        String[] stringArray = parseConfigResult.values;
        StringBuffer stringBuffer = new StringBuffer(64);
        ItclContext itclContext = new ItclContext(interp);
        Methods.PushContext(interp, null, itclObject.classDefn, itclObject, itclContext);
        try {
            for (int i = 0; i < n; ++i) {
                TclObject tclObject = interp.getVar(itclVarDefnArray[i].member.fullname, 0);
                String string = tclObject == null ? "" : tclObject.toString();
                stringBuffer.setLength(0);
                stringBuffer.append(string);
                try {
                    interp.setVar(itclVarDefnArray[i].member.fullname, TclString.newInstance(stringArray[i]), 0);
                }
                catch (TclException tclException) {
                    interp.addErrorInfo("\n    (while configuring public variable \"" + itclVarDefnArray[i].member.fullname + "\")");
                    throw tclException;
                }
                if (itclVarDefnArray[i].member.code == null) continue;
                CallFrame callFrame = Migrate.GetCallFrame(interp, 1);
                CallFrame callFrame2 = Migrate.ActivateCallFrame(interp, callFrame);
                TclException tclException = null;
                try {
                    Methods.EvalMemberCode(interp, null, itclVarDefnArray[i].member, itclObject, null);
                }
                catch (TclException tclException2) {
                    tclException = tclException2;
                }
                finally {
                    Migrate.ActivateCallFrame(interp, callFrame2);
                }
                if (tclException == null) continue;
                interp.addErrorInfo("\n    (while configuring public variable \"" + itclVarDefnArray[i].member.fullname + "\")");
                interp.setVar(itclVarDefnArray[i].member.fullname, TclString.newInstance(stringBuffer.toString()), 0);
                throw tclException;
            }
        }
        finally {
            Methods.PopContext(interp, itclContext);
        }
    }

    static void ConstructBase(Interp interp, ItclObject itclObject, ItclClass itclClass) throws TclException {
        if (itclClass.initCode != null) {
            interp.eval(itclClass.initCode.toString());
        }
        Itcl_ListElem itcl_ListElem = Util.LastListElem(itclClass.bases);
        while (itcl_ListElem != null) {
            ItclClass itclClass2 = (ItclClass)Util.GetListValue(itcl_ListElem);
            if (itclObject.constructed.get(itclClass2.name) == null) {
                Methods.InvokeMethodIfExists(interp, "constructor", itclClass2, itclObject, null);
                if (itclClass2.functions.get("constructor") == null) {
                    Methods.ConstructBase(interp, itclObject, itclClass2);
                }
            }
            itcl_ListElem = Util.PrevListElem(itcl_ListElem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void InvokeMethodIfExists(Interp interp, String string, ItclClass itclClass, ItclObject itclObject, TclObject[] tclObjectArray) throws TclException {
        ItclMemberFunc itclMemberFunc = (ItclMemberFunc)itclClass.functions.get(string);
        if (itclMemberFunc != null) {
            ItclMember itclMember = itclMemberFunc.member;
            TclObject tclObject = Util.CreateArgs(interp, string, tclObjectArray, 0);
            TclObject[] tclObjectArray2 = TclList.getElements(interp, tclObject);
            Util.PreserveData(itclMemberFunc);
            try {
                Methods.EvalMemberCode(interp, itclMemberFunc, itclMember, itclObject, tclObjectArray2);
            }
            catch (TclException tclException) {
                Methods.ReportFuncErrors(interp, itclMemberFunc, itclObject, tclException);
            }
            finally {
                Util.ReleaseData(itclMemberFunc);
            }
        }
    }

    static void ReportFuncErrors(Interp interp, ItclMemberFunc itclMemberFunc, ItclObject itclObject, TclException tclException) throws TclException {
        if (tclException != null) {
            int n = tclException.getCompletionCode();
            if (n == 2) {
                n = interp.updateReturnInfo();
                if (n != 0 && n != 1) {
                    interp.processUnexpectedResult(n);
                } else {
                    if (n != 0) {
                        tclException.setCompletionCode(n);
                        throw tclException;
                    }
                    if (n == 0) {
                        return;
                    }
                }
            } else if (n != 1) {
                tclException.printStackTrace(System.out);
                throw new TclRuntimeError("unexpected TclException completion code : " + n);
            }
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("\n    ");
            if ((itclMemberFunc.member.flags & ItclInt.CONSTRUCTOR) != 0) {
                stringBuffer.append("while constructing object \"");
                stringBuffer.append(itclObject.classDefn.interp.getCommandFullName(itclObject.w_accessCmd));
                stringBuffer.append("\" in ");
                stringBuffer.append(itclMemberFunc.member.fullname);
                if ((itclMemberFunc.member.code.flags & ItclInt.IMPLEMENT_TCL) != 0) {
                    stringBuffer.append(" (");
                }
            } else if ((itclMemberFunc.member.flags & ItclInt.DESTRUCTOR) != 0) {
                stringBuffer.append("while deleting object \"");
                stringBuffer.append(itclObject.classDefn.interp.getCommandFullName(itclObject.w_accessCmd));
                stringBuffer.append("\" in ");
                stringBuffer.append(itclMemberFunc.member.fullname);
                if ((itclMemberFunc.member.code.flags & ItclInt.IMPLEMENT_TCL) != 0) {
                    stringBuffer.append(" (");
                }
            } else {
                stringBuffer.append("(");
                if (itclObject != null && itclObject.accessCmd != null) {
                    stringBuffer.append("object \"");
                    stringBuffer.append(itclObject.classDefn.interp.getCommandFullName(itclObject.w_accessCmd));
                    stringBuffer.append("\" ");
                }
                if ((itclMemberFunc.member.flags & ItclInt.COMMON) != 0) {
                    stringBuffer.append("procedure");
                } else {
                    stringBuffer.append("method");
                }
                stringBuffer.append(" \"");
                stringBuffer.append(itclMemberFunc.member.fullname);
                stringBuffer.append("\" ");
            }
            if ((itclMemberFunc.member.code.flags & ItclInt.IMPLEMENT_TCL) != 0) {
                stringBuffer.append("body line ");
                stringBuffer.append(interp.getErrorLine());
                stringBuffer.append(")");
            } else {
                stringBuffer.append(")");
            }
            interp.addErrorInfo(stringBuffer.toString());
            throw tclException;
        }
    }

    public static class ParseConfigResult {
        int num_variables;
        ItclVarDefn[] variables;
        String[] values;
    }

    public static class GetContextResult {
        ItclClass cdefn;
        ItclObject odefn;

        public GetContextResult(ItclClass itclClass, ItclObject itclObject) {
            this.cdefn = itclClass;
            this.odefn = itclObject;
        }
    }

    public static class ExecProc
    implements CommandWithDispose {
        ItclMemberFunc mfunc;

        ExecProc(ItclMemberFunc itclMemberFunc) {
            this.mfunc = itclMemberFunc;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.mfunc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Namespace namespace;
            ItclMember itclMember = this.mfunc.member;
            if (this.mfunc.member.protection != 1 && !Util.CanAccessFunc(this.mfunc, namespace = Util.GetTrueNamespace(interp, this.mfunc.member.classDefn.info))) {
                throw new TclException(interp, "can't access \"" + itclMember.fullname + "\": " + Util.ProtectionStr(itclMember.protection) + " function");
            }
            Util.PreserveData(this.mfunc);
            try {
                Methods.EvalMemberCode(interp, this.mfunc, itclMember, null, tclObjectArray);
            }
            catch (TclException tclException) {
                Methods.ReportFuncErrors(interp, this.mfunc, null, tclException);
            }
            finally {
                Util.ReleaseData(this.mfunc);
            }
        }
    }

    public static class ExecMethod
    implements CommandWithDispose {
        final ItclMemberFunc mfunc;

        ExecMethod(ItclMemberFunc itclMemberFunc) {
            if (itclMemberFunc == null) {
                throw new NullPointerException();
            }
            this.mfunc = itclMemberFunc;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.mfunc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            Object object;
            Object object2 = this.mfunc;
            ItclMember itclMember = ((ItclMemberFunc)object2).member;
            GetContextResult getContextResult = Methods.GetContext(interp);
            ItclClass itclClass = getContextResult.cdefn;
            ItclObject itclObject = getContextResult.odefn;
            if (itclObject == null) {
                throw new TclException(interp, "cannot access object-specific info without an object context");
            }
            if (((ItclMemberFunc)object2).member.protection != 1 && !Util.CanAccessFunc((ItclMemberFunc)object2, (Namespace)(object = Util.GetTrueNamespace(interp, itclClass.info)))) {
                throw new TclException(interp, "can't access \"" + itclMember.fullname + "\": " + Util.ProtectionStr(itclMember.protection) + " function");
            }
            String string = tclObjectArray[0].toString();
            if (string.indexOf("::") == -1 && (object = (ItclMemberFunc)itclObject.classDefn.resolveCmds.get(itclMember.name)) != null) {
                object2 = object;
                itclMember = ((ItclMemberFunc)object2).member;
            }
            Util.PreserveData((ItclEventuallyFreed)object2);
            try {
                Methods.EvalMemberCode(interp, (ItclMemberFunc)object2, itclMember, itclObject, tclObjectArray);
            }
            catch (TclException tclException) {
                Methods.ReportFuncErrors(interp, (ItclMemberFunc)object2, itclObject, tclException);
            }
            finally {
                Util.ReleaseData((ItclEventuallyFreed)object2);
            }
        }
    }

    public static class CreateArgListResult {
        int argcount;
        CompiledLocal arglist;
    }

    public static class ConfigBodyCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length != 3) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "class::option body");
            }
            String string = tclObjectArray[1].toString();
            Util.ParseNamespPathResult parseNamespPathResult = Util.ParseNamespPath(string);
            String string2 = parseNamespPathResult.head;
            String string3 = parseNamespPathResult.tail;
            if (string2 == null || string2.length() == 0) {
                throw new TclException(interp, "missing class specifier for body declaration \"" + string + "\"");
            }
            ItclClass itclClass = Class.FindClass(interp, string2, true);
            if (itclClass == null) {
                throw new TclException(interp, interp.getResult().toString());
            }
            ItclVarLookup itclVarLookup = (ItclVarLookup)itclClass.resolveVars.get(string3);
            if (itclVarLookup != null && itclVarLookup.vdefn.member.classDefn != itclClass) {
                itclVarLookup = null;
            }
            if (itclVarLookup == null) {
                throw new TclException(interp, "option \"" + string3 + "\" is not defined in class \"" + itclClass.fullname + "\"");
            }
            ItclMember itclMember = itclVarLookup.vdefn.member;
            if (itclMember.protection != 1) {
                throw new TclException(interp, "option \"" + itclMember.fullname + "\" is not a public configuration option");
            }
            string = tclObjectArray[2].toString();
            ItclMemberCode itclMemberCode = Methods.CreateMemberCode(interp, itclClass, null, string);
            Util.PreserveData(itclMemberCode);
            if (itclMember.code != null) {
                Util.ReleaseData(itclMember.code);
            }
            itclMember.code = itclMemberCode;
        }
    }

    public static class BodyCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
            if (tclObjectArray.length != 4) {
                throw new TclNumArgsException(interp, 1, tclObjectArray, "class::func arglist body");
            }
            String string = tclObjectArray[1].toString();
            Util.ParseNamespPathResult parseNamespPathResult = Util.ParseNamespPath(string);
            String string2 = parseNamespPathResult.head;
            String string3 = parseNamespPathResult.tail;
            if (string2 == null || string2.length() == 0) {
                throw new TclException(interp, "missing class specifier for body declaration \"" + string + "\"");
            }
            ItclClass itclClass = Class.FindClass(interp, string2, true);
            if (itclClass == null) {
                throw new TclException(interp, interp.getResult().toString());
            }
            ItclMemberFunc itclMemberFunc = (ItclMemberFunc)itclClass.resolveCmds.get(string3);
            if (itclMemberFunc != null && itclMemberFunc.member.classDefn != itclClass) {
                itclMemberFunc = null;
            }
            if (itclMemberFunc == null) {
                throw new TclException(interp, "function \"" + string3 + "\" is not defined in class \"" + itclClass.fullname + "\"");
            }
            String string4 = tclObjectArray[2].toString();
            String string5 = tclObjectArray[3].toString();
            Methods.ChangeMemberFunc(interp, itclMemberFunc, string4, string5);
        }
    }
}

