/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import java.beans.EventSetDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.TclRuntimeError;

class AdaptorGen {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_FieldRef = 9;
    private static final int CONSTANT_MethodRef = 10;
    private static final int CONSTANT_InterfaceMethodRef = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private static final int ALOAD = 25;
    private static final int ALOAD_0 = 42;
    private static final int ALOAD_1 = 43;
    private static final int ICONST_0 = 3;
    private static final int ICONST_1 = 4;
    private static final int ANEWARRAY = 189;
    private static final int DUP = 89;
    private static final int AASTORE = 83;
    private static final int RETURN = 177;
    private static final int ARETURN = 176;
    private static final int DRETURN = 175;
    private static final int FRETURN = 174;
    private static final int IRETURN = 172;
    private static final int LRETURN = 173;
    private static final int SIPUSH = 17;
    private static final int ASTORE = 58;
    private static final int NEW = 187;
    private static final int ILOAD = 21;
    private static final int LLOAD = 22;
    private static final int FLOAD = 23;
    private static final int DLOAD = 24;
    private static final int INVOKESP = 183;
    private static final int INVOKEVT = 182;
    private static final int WIDE = 196;
    private static final int LDC_W = 19;
    private static final int INSTNCOF = 193;
    private static final int CHKCAST = 192;
    private static final int IFEQ = 153;
    private static final int ATHROW = 191;
    private static final int GOTO_W = 200;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_SUPER = 32;
    private DataOutputStream ostream;
    private Class listenerCls;
    private Method[] methods;
    private String clsName;
    private Class superCls;
    int cpSize;
    Vector constPool;
    Hashtable utf8Tab;
    Hashtable allClasses;
    Hashtable primClasses;
    Hashtable returnTypes;
    Hashtable returnMethodRef;
    Hashtable wrapperConsRef;
    Hashtable clsRef;
    Hashtable stringRef;
    short cp_this_class;
    short cp_super_class;
    short cp_listener_interface;
    short cp_code;
    short cp_super_cons;
    short cp_processEvent;
    short cp_wrongException;
    MethodDesc[] cp_methodDesc;
    MethodDesc cp_consDesc;

    AdaptorGen() {
    }

    byte[] generate(EventSetDescriptor eventSetDescriptor, Class clazz, String string) {
        this.superCls = clazz;
        this.clsName = string;
        this.listenerCls = eventSetDescriptor.getListenerType();
        this.methods = this.listenerCls.getMethods();
        this.allClasses = new Hashtable();
        this.primClasses = new Hashtable();
        this.returnTypes = new Hashtable();
        this.returnMethodRef = new Hashtable();
        this.wrapperConsRef = new Hashtable();
        this.clsRef = new Hashtable();
        this.stringRef = new Hashtable();
        this.utf8Tab = new Hashtable();
        this.cp_methodDesc = new MethodDesc[this.methods.length];
        this.analyzeListener();
        this.cpSize = 1;
        try {
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.ostream = dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.generateByteCode();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new TclRuntimeError("Unexcepted IOException " + iOException);
        }
    }

    private void analyzeListener() {
        boolean bl = false;
        for (int i = 0; i < this.methods.length; ++i) {
            Object object;
            int n;
            Class<?>[] classArray = this.methods[i].getParameterTypes();
            for (n = 0; n < classArray.length; ++n) {
                if (classArray[n].isPrimitive()) {
                    if (classArray[n] == Void.TYPE) {
                        throw new ClassFormatError("Parameter type cannot be void");
                    }
                    object = AdaptorGen.getWrapperClass(classArray[n]);
                    this.allClasses.put(object, object);
                    this.primClasses.put(classArray[n], classArray[n]);
                } else {
                    this.allClasses.put(classArray[n], classArray[n]);
                }
                bl = true;
            }
            object = this.methods[i].getExceptionTypes();
            for (n = 0; n < ((Class<?>[])object).length; ++n) {
                this.allClasses.put(object[n], object[n]);
            }
            Class<?> clazz = this.methods[i].getReturnType();
            if (clazz == Void.TYPE) continue;
            if (!clazz.isPrimitive()) {
                this.allClasses.put(clazz, clazz);
            }
            this.returnTypes.put(clazz, clazz);
        }
        if (bl) {
            this.allClasses.put(Object.class, Object.class);
        }
        this.allClasses.put(Throwable.class, Throwable.class);
    }

    private void generateByteCode() throws IOException {
        this.ostream.writeInt(-889275714);
        this.ostream.writeShort(3);
        this.ostream.writeShort(45);
        this.generateConstantPool();
        this.ostream.writeShort(33);
        this.ostream.writeShort(this.cp_this_class);
        this.ostream.writeShort(this.cp_super_class);
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_listener_interface);
        this.ostream.writeShort(0);
        this.ostream.writeShort(1 + this.methods.length);
        this.generateConstructor();
        for (int i = 0; i < this.methods.length; ++i) {
            this.generateMethod(i);
        }
        this.ostream.writeShort(0);
    }

    private void generateConstantPool() throws IOException {
        short s;
        Class<Object> clazz;
        this.constPool = new Vector();
        this.cp_this_class = this.cp_putClass(this.clsName);
        this.cp_super_class = this.cp_putClass(this.superCls.getName());
        this.cp_listener_interface = this.cp_putClass(this.listenerCls.getName());
        this.cp_code = this.cp_putUtf8("Code");
        this.cp_super_cons = this.cp_putMethodRef(this.cp_super_class, "<init>", "()V");
        this.cp_processEvent = this.cp_putMethodRef(this.cp_super_class, "_processEvent", "([Ljava/lang/Object;Ljava/lang/String;)V");
        this.cp_wrongException = this.cp_putMethodRef(this.cp_super_class, "_wrongException", "()V");
        Enumeration enumeration = this.returnTypes.keys();
        while (enumeration.hasMoreElements()) {
            clazz = (Class)enumeration.nextElement();
            if (clazz.isPrimitive()) {
                s = this.cp_putMethodRef(this.cp_super_class, "_return_" + clazz.getName(), "()" + AdaptorGen.getTypeDesc(clazz));
            } else {
                this.cp_putString(clazz.getName());
                s = this.cp_putMethodRef(this.cp_super_class, "_return_Object", "(Ljava/lang/String;)" + AdaptorGen.getTypeDesc(clazz));
            }
            AdaptorGen.hashPutShort(this.returnMethodRef, clazz, s);
        }
        this.cp_consDesc = this.cp_putMethodDesc("<init>", "()V", false);
        for (int i = 0; i < this.methods.length; ++i) {
            this.cp_methodDesc[i] = this.cp_putMethodDesc(this.methods[i].getName(), AdaptorGen.getMethodDescriptor(this.methods[i]), true);
        }
        Enumeration enumeration2 = this.allClasses.keys();
        while (enumeration2.hasMoreElements()) {
            clazz = (Class)enumeration2.nextElement();
            s = this.cp_putClass(clazz.getName());
            AdaptorGen.hashPutShort(this.clsRef, clazz, s);
        }
        enumeration2 = this.primClasses.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration2.nextElement();
        }
        enumeration2 = this.primClasses.keys();
        while (enumeration2.hasMoreElements()) {
            clazz = (Class)enumeration2.nextElement();
            s = this.cp_getClass(AdaptorGen.getWrapperClass(clazz));
            short s2 = this.cp_putMethodRef(s, "<init>", "(" + AdaptorGen.getTypeDesc(clazz) + ")V");
            AdaptorGen.hashPutShort(this.wrapperConsRef, clazz, s2);
        }
        this.ostream.writeShort(this.constPool.size() + 1);
        for (int i = 0; i < this.constPool.size(); ++i) {
            Object object;
            clazz = this.constPool.elementAt(i);
            if (clazz instanceof ConstUtf) {
                object = (ConstUtf)((Object)clazz);
                this.ostream.writeByte(1);
                this.ostream.writeUTF(((ConstUtf)object).string);
                continue;
            }
            if (clazz instanceof ConstString) {
                object = (ConstString)((Object)clazz);
                this.ostream.writeByte(8);
                this.ostream.writeShort(((ConstString)object).string_index);
                continue;
            }
            if (clazz instanceof ConstClass) {
                object = (ConstClass)((Object)clazz);
                this.ostream.writeByte(7);
                this.ostream.writeShort(((ConstClass)object).name_index);
                continue;
            }
            if (clazz instanceof ConstMethodRef) {
                object = (ConstMethodRef)((Object)clazz);
                this.ostream.writeByte(10);
                this.ostream.writeShort(((ConstMethodRef)object).class_index);
                this.ostream.writeShort(((ConstMethodRef)object).name_and_type_index);
                continue;
            }
            object = (ConstNameAndType)((Object)clazz);
            this.ostream.writeByte(12);
            this.ostream.writeShort(((ConstNameAndType)object).name_index);
            this.ostream.writeShort(((ConstNameAndType)object).desc_index);
        }
    }

    void generateConstructor() throws IOException {
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_consDesc.name_index);
        this.ostream.writeShort(this.cp_consDesc.descriptor_index);
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_code);
        this.ostream.writeInt(17);
        this.ostream.writeShort(2);
        this.ostream.writeShort(1);
        this.ostream.writeInt(5);
        this.ostream.writeByte(42);
        this.ostream.writeByte(183);
        this.ostream.writeShort(this.cp_super_cons);
        this.ostream.writeByte(177);
        this.ostream.writeShort(0);
        this.ostream.writeShort(0);
    }

    void generateMethod(int n) throws IOException {
        int n2;
        int n3 = 0;
        int n4 = 6;
        Class<?>[] classArray = this.methods[n].getParameterTypes();
        int n5 = classArray.length;
        int n6 = 1;
        for (int i = 0; i < n5; ++i) {
            if (classArray[i] == Double.TYPE || classArray[i] == Long.TYPE) {
                n6 += 2;
                continue;
            }
            ++n6;
        }
        int n7 = (n6 += 2) - 2;
        int n8 = n6 - 1;
        this.ostream.writeShort(1);
        this.ostream.writeShort(this.cp_methodDesc[n].name_index);
        this.ostream.writeShort(this.cp_methodDesc[n].descriptor_index);
        this.ostream.writeShort(1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(17);
        dataOutputStream.writeShort(n5);
        dataOutputStream.writeByte(189);
        dataOutputStream.writeShort(this.cp_getClass(Object.class));
        this.writeLoadStore(dataOutputStream, 58, n7);
        int n9 = 1;
        for (int i = 0; i < n5; ++i) {
            this.writeLoadStore(dataOutputStream, 25, n7);
            dataOutputStream.writeByte(17);
            dataOutputStream.writeShort(i);
            if (classArray[i].isPrimitive()) {
                int n10;
                Class<?> clazz = classArray[i];
                Class clazz2 = AdaptorGen.getWrapperClass(classArray[i]);
                if (clazz == Double.TYPE) {
                    n2 = 24;
                    n10 = 2;
                } else if (clazz == Float.TYPE) {
                    n2 = 23;
                    n10 = 1;
                } else if (clazz == Long.TYPE) {
                    n2 = 22;
                    n10 = 2;
                } else {
                    n2 = 21;
                    n10 = 1;
                }
                dataOutputStream.writeByte(187);
                dataOutputStream.writeShort(this.cp_getClass(clazz2));
                dataOutputStream.writeByte(89);
                this.writeLoadStore(dataOutputStream, n2, n9);
                dataOutputStream.writeByte(183);
                dataOutputStream.writeShort(this.cp_getWrapperConstructor(clazz));
                n9 += n10;
            } else {
                this.writeLoadStore(dataOutputStream, 25, n9);
                ++n9;
            }
            dataOutputStream.writeByte(83);
        }
        int n11 = dataOutputStream.size();
        dataOutputStream.writeByte(42);
        this.writeLoadStore(dataOutputStream, 25, n7);
        dataOutputStream.writeByte(19);
        dataOutputStream.writeShort(this.cp_getString(this.methods[n].getName()));
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp_processEvent);
        int n12 = dataOutputStream.size();
        Class<?>[] classArray2 = this.methods[n].getExceptionTypes();
        int n13 = 9 + classArray2.length * 18 + 4;
        dataOutputStream.writeByte(200);
        dataOutputStream.writeInt(n13);
        n3 = dataOutputStream.size();
        dataOutputStream.writeByte(196);
        dataOutputStream.writeByte(58);
        dataOutputStream.writeShort(n8);
        for (int i = 0; i < classArray2.length; ++i) {
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(25);
            dataOutputStream.writeShort(n8);
            dataOutputStream.writeByte(193);
            dataOutputStream.writeShort(this.cp_getClass(classArray2[i]));
            dataOutputStream.writeByte(153);
            dataOutputStream.writeShort(11);
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(25);
            dataOutputStream.writeShort(n8);
            dataOutputStream.writeByte(192);
            dataOutputStream.writeShort(this.cp_getClass(classArray2[i]));
            dataOutputStream.writeByte(191);
        }
        dataOutputStream.writeByte(42);
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp_wrongException);
        Class<?> clazz = this.methods[n].getReturnType();
        if (clazz == Void.TYPE) {
            dataOutputStream.writeByte(177);
        } else if (clazz.isPrimitive()) {
            dataOutputStream.writeByte(42);
            dataOutputStream.writeByte(182);
            dataOutputStream.writeShort(this.cp_getReturnMethodRef(clazz));
            if (clazz == Double.TYPE) {
                dataOutputStream.writeByte(175);
            } else if (clazz == Float.TYPE) {
                dataOutputStream.writeByte(174);
            } else if (clazz == Long.TYPE) {
                dataOutputStream.writeByte(173);
            } else {
                dataOutputStream.writeByte(172);
            }
        } else {
            dataOutputStream.writeByte(42);
            dataOutputStream.writeByte(19);
            dataOutputStream.writeShort(this.cp_getString(clazz.getName()));
            dataOutputStream.writeByte(182);
            dataOutputStream.writeShort(this.cp_getReturnMethodRef(clazz));
            dataOutputStream.writeByte(192);
            dataOutputStream.writeShort(this.cp_getClass(clazz));
            dataOutputStream.writeByte(176);
        }
        n2 = dataOutputStream.size();
        dataOutputStream.writeShort(1);
        dataOutputStream.writeShort(n11);
        dataOutputStream.writeShort(n12);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(this.cp_getClass(Throwable.class));
        dataOutputStream.writeShort(0);
        dataOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.ostream.writeShort(this.cp_code);
        this.ostream.writeInt(byArray.length + 8);
        this.ostream.writeShort(n4);
        this.ostream.writeShort(n6);
        this.ostream.writeInt(n2);
        this.ostream.write(byArray);
    }

    private static final String internalClassName(String string) {
        return string.replace('.', '/');
    }

    private static final void hashPutShort(Hashtable hashtable, Object object, short s) {
        Short s2 = new Short(s);
        hashtable.put(object, s2);
    }

    private static final short hashGetShort(Hashtable hashtable, Object object) {
        return (Short)hashtable.get(object);
    }

    private static final Class getWrapperClass(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        return Short.class;
    }

    private static final String getTypeDesc(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            return "V";
        }
        if (clazz.isArray()) {
            return "[" + AdaptorGen.getTypeDesc(clazz.getComponentType());
        }
        String string = "L" + clazz.getName() + ";";
        return string.replace('.', '/');
    }

    private static final String getMethodDescriptor(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(AdaptorGen.getTypeDesc(classArray[i]));
        }
        stringBuffer.append(')');
        stringBuffer.append(AdaptorGen.getTypeDesc(method.getReturnType()));
        return stringBuffer.toString();
    }

    void writeLoadStore(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        if (n2 > 255) {
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(n);
            dataOutputStream.writeShort(n2);
        } else {
            dataOutputStream.writeByte(n);
            dataOutputStream.writeByte(n2);
        }
    }

    short cp_putUtf8(String string) {
        Short s = (Short)this.utf8Tab.get(string);
        if (s != null) {
            return s;
        }
        ConstUtf constUtf = new ConstUtf();
        constUtf.string = string;
        this.constPool.addElement(constUtf);
        short s2 = (short)this.cpSize++;
        AdaptorGen.hashPutShort(this.utf8Tab, string, s2);
        return s2;
    }

    private short cp_putString(String string) {
        ConstString constString = new ConstString();
        constString.string_index = this.cp_putUtf8(string);
        this.constPool.addElement(constString);
        short s = (short)this.cpSize++;
        AdaptorGen.hashPutShort(this.stringRef, string, s);
        return s;
    }

    private short cp_putClass(String string) {
        ConstClass constClass = new ConstClass();
        constClass.name_index = this.cp_putUtf8(AdaptorGen.internalClassName(string));
        this.constPool.addElement(constClass);
        return (short)this.cpSize++;
    }

    short cp_putNameAndType(String string, String string2) {
        ConstNameAndType constNameAndType = new ConstNameAndType();
        constNameAndType.name_index = this.cp_putUtf8(string);
        constNameAndType.desc_index = this.cp_putUtf8(string2);
        this.constPool.addElement(constNameAndType);
        return (short)this.cpSize++;
    }

    short cp_putMethodRef(short s, String string, String string2) {
        ConstMethodRef constMethodRef = new ConstMethodRef();
        constMethodRef.class_index = s;
        constMethodRef.name_and_type_index = this.cp_putNameAndType(string, string2);
        this.constPool.addElement(constMethodRef);
        return (short)this.cpSize++;
    }

    MethodDesc cp_putMethodDesc(String string, String string2, boolean bl) {
        MethodDesc methodDesc = new MethodDesc();
        methodDesc.name_index = this.cp_putUtf8(string);
        methodDesc.descriptor_index = this.cp_putUtf8(string2);
        if (bl) {
            this.cp_putString(string);
        }
        return methodDesc;
    }

    short cp_getClass(Class clazz) {
        return AdaptorGen.hashGetShort(this.clsRef, clazz);
    }

    short cp_getString(String string) {
        return AdaptorGen.hashGetShort(this.stringRef, string);
    }

    short cp_getWrapperConstructor(Class clazz) {
        return AdaptorGen.hashGetShort(this.wrapperConsRef, clazz);
    }

    short cp_getReturnMethodRef(Class clazz) {
        if (clazz.isPrimitive()) {
            return AdaptorGen.hashGetShort(this.returnMethodRef, clazz);
        }
        return AdaptorGen.hashGetShort(this.returnMethodRef, Object.class);
    }

    class MethodDesc {
        short name_index;
        short descriptor_index;

        MethodDesc() {
        }
    }

    class ConstMethodRef {
        short class_index;
        short name_and_type_index;

        ConstMethodRef() {
        }
    }

    class ConstNameAndType {
        short name_index;
        short desc_index;

        ConstNameAndType() {
        }
    }

    class ConstClass {
        short name_index;

        ConstClass() {
        }
    }

    class ConstString {
        short string_index;

        ConstString() {
        }
    }

    class ConstUtf {
        String string;

        ConstUtf() {
        }
    }
}

