/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class PkgInvoker {
    static Hashtable cachedInvokers = new Hashtable();
    static PkgInvoker defaultInvoker = new PkgInvoker();

    public Object invokeConstructor(Constructor constructor, Object[] objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return constructor.newInstance(objectArray);
    }

    public Object invokeMethod(Method method, Object object, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke(object, objectArray);
    }

    public Object getField(Field field, Object object) throws IllegalArgumentException, IllegalAccessException {
        return field.get(object);
    }

    public void setField(Field field, Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        field.set(object, object2);
    }

    public static final PkgInvoker getPkgInvoker(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        PkgInvoker pkgInvoker = (PkgInvoker)cachedInvokers.get(string2);
        if (pkgInvoker == null) {
            ClassLoader classLoader = clazz.getClassLoader();
            try {
                if (classLoader != null) {
                    Class<?> clazz2 = classLoader.loadClass(string2 + ".TclPkgInvoker");
                    pkgInvoker = (PkgInvoker)clazz2.newInstance();
                }
            }
            catch (Exception exception) {
                pkgInvoker = defaultInvoker;
            }
            if (pkgInvoker == null) {
                pkgInvoker = defaultInvoker;
            }
            cachedInvokers.put(string2, pkgInvoker);
        }
        return pkgInvoker;
    }

    public static boolean usesDefaultInvoker(Class clazz) {
        PkgInvoker pkgInvoker = PkgInvoker.getPkgInvoker(clazz);
        return pkgInvoker == defaultInvoker;
    }

    public static boolean isAccessible(Class clazz) {
        int n = clazz.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return !PkgInvoker.usesDefaultInvoker(clazz);
    }

    public static boolean isAccessible(Method method) {
        int n = method.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return !PkgInvoker.usesDefaultInvoker(method.getDeclaringClass());
    }

    public static boolean isAccessible(Constructor constructor) {
        int n = constructor.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return !PkgInvoker.usesDefaultInvoker(constructor.getDeclaringClass());
    }

    public static boolean isAccessible(Field field) {
        int n = field.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return !PkgInvoker.usesDefaultInvoker(field.getDeclaringClass());
    }
}

